/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.FeatureAutomaticallyEnabledByMetadata;
import org.apache.spark.sql.delta.PreDowngradeTableFeatureCommand;
import org.apache.spark.sql.delta.ReaderWriterFeature;
import org.apache.spark.sql.delta.RemovableFeature;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.TypeWideningMetadata$;
import org.apache.spark.sql.delta.TypeWideningPreDowngradeCommand;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import scala.runtime.BoxesRunTime;

public final class TypeWideningTableFeature$
extends ReaderWriterFeature
implements FeatureAutomaticallyEnabledByMetadata,
RemovableFeature {
    public static TypeWideningTableFeature$ MODULE$;

    static {
        new TypeWideningTableFeature$();
    }

    @Override
    public boolean historyContainsFeature(SparkSession spark, Snapshot downgradeTxnReadSnapshot) {
        return RemovableFeature.historyContainsFeature$(this, spark, downgradeTxnReadSnapshot);
    }

    @Override
    public boolean automaticallyUpdateProtocolOfExistingTables() {
        return true;
    }

    private boolean isTypeWideningSupportNeededByMetadata(Metadata metadata) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_TYPE_WIDENING().fromMetaData(metadata));
    }

    @Override
    public boolean metadataRequiresFeatureToBeEnabled(Metadata metadata, SparkSession spark) {
        return this.isTypeWideningSupportNeededByMetadata(metadata);
    }

    @Override
    public boolean validateRemoval(Snapshot snapshot) {
        return !this.isTypeWideningSupportNeededByMetadata(snapshot.metadata()) && !TypeWideningMetadata$.MODULE$.containsTypeWideningMetadata(snapshot.metadata().schema());
    }

    @Override
    public boolean actionUsesFeature(Action action) {
        Action action2 = action;
        if (action2 instanceof Metadata) {
            Metadata metadata = (Metadata)action2;
            return TypeWideningMetadata$.MODULE$.containsTypeWideningMetadata(metadata.schema());
        }
        return false;
    }

    @Override
    public PreDowngradeTableFeatureCommand preDowngradeCommand(DeltaTableV2 table) {
        return new TypeWideningPreDowngradeCommand(table);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TypeWideningTableFeature$() {
        super("typeWidening-preview");
        MODULE$ = this;
        FeatureAutomaticallyEnabledByMetadata.$init$(this);
        RemovableFeature.$init$(this);
    }
}

