/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.constraints;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaIllegalStateException;
import org.apache.spark.sql.delta.DeltaIllegalStateException$;
import org.apache.spark.sql.delta.constraints.CheckDeltaInvariant;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.constraints.Constraints;
import org.apache.spark.sql.delta.constraints.DeltaInvariantCheckerExec;
import org.apache.spark.sql.delta.constraints.DeltaInvariantCheckerExec$DeltaInvariantCheckerOptimizer$;
import org.apache.spark.sql.delta.constraints.ExpressionLogicalPlanWrapper;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class DeltaInvariantCheckerExec$
implements scala.Serializable {
    public static DeltaInvariantCheckerExec$ MODULE$;

    static {
        new DeltaInvariantCheckerExec$();
    }

    public Option<Expression> org$apache$spark$sql$delta$constraints$DeltaInvariantCheckerExec$$buildExtractor(Seq<Attribute> output, Seq<String> column) {
        Predef$.MODULE$.assert(column.nonEmpty());
        String topLevelColumn = (String)column.head();
        Option topLevelRefOpt = output.collectFirst((PartialFunction)new scala.Serializable(topLevelColumn){
            public static final long serialVersionUID = 0L;
            private final String topLevelColumn$1;

            public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    if (BoxesRunTime.unboxToBoolean((Object)SchemaUtils$.MODULE$.DELTA_COL_RESOLVER().apply((Object)attributeReference.name(), (Object)this.topLevelColumn$1))) {
                        return (B1)attributeReference;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Attribute x1) {
                Attribute attribute = x1;
                if (attribute instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute;
                    if (BoxesRunTime.unboxToBoolean((Object)SchemaUtils$.MODULE$.DELTA_COL_RESOLVER().apply((Object)attributeReference.name(), (Object)this.topLevelColumn$1))) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.topLevelColumn$1 = topLevelColumn$1;
            }
        });
        if (column.length() == 1) {
            return topLevelRefOpt;
        }
        return topLevelRefOpt.flatMap((Function1 & Serializable & scala.Serializable)topLevelRef -> {
            None$ none$;
            try {
                Expression nested = (Expression)((TraversableOnce)column.tail()).foldLeft(topLevelRef, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        Expression e = (Expression)tuple2._1();
                        String fieldName = (String)tuple2._2();
                        DataType dataType = e.dataType();
                        if (dataType instanceof StructType) {
                            StructType structType = (StructType)dataType;
                            StructField[] fields = structType.fields();
                            int ordinal = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).indexWhere((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaInvariantCheckerExec$.$anonfun$buildExtractor$3(fieldName, f)));
                            if (ordinal == -1) {
                                throw DeltaErrors$.MODULE$.notNullColumnNotFoundInStruct(String.valueOf(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")));
                            }
                            return new GetStructField(e, ordinal, (Option)new Some((Object)fieldName));
                        }
                        throw DeltaErrors$.MODULE$.unSupportedInvariantNonStructType();
                    }
                    throw new MatchError((Object)tuple2);
                });
                none$ = new Some((Object)nested);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public Seq<CheckDeltaInvariant> buildInvariantChecks(Seq<Attribute> output, Seq<Constraint> constraints, SparkSession spark) {
        return (Seq)constraints.map((Function1 & Serializable & scala.Serializable)constraint -> {
            Expression expression;
            Map columnExtractors = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            Constraint constraint2 = constraint;
            if (constraint2 instanceof Constraints.NotNull) {
                Constraints.NotNull notNull = (Constraints.NotNull)constraint2;
                Seq<String> column = notNull.column();
                expression = (Expression)MODULE$.org$apache$spark$sql$delta$constraints$DeltaInvariantCheckerExec$$buildExtractor(output, column).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw DeltaErrors$.MODULE$.notNullColumnMissingException(notNull);
                });
            } else {
                Expression e;
                if (!(constraint2 instanceof Constraints.Check)) throw new MatchError((Object)constraint2);
                Constraints.Check check = (Constraints.Check)constraint2;
                Expression expr = check.expression();
                Expression attributesExtracted = (Expression)expr.transformUp((PartialFunction)new scala.Serializable(output, columnExtractors){
                    public static final long serialVersionUID = 0L;
                    private final Seq output$1;
                    private final Map columnExtractors$1;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof UnresolvedAttribute) {
                            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)A1;
                            Expression ex = (Expression)DeltaInvariantCheckerExec$.MODULE$.org$apache$spark$sql$delta$constraints$DeltaInvariantCheckerExec$$buildExtractor((Seq<Attribute>)this.output$1, (Seq<String>)unresolvedAttribute.nameParts()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply(null));
                            this.columnExtractors$1.update((Object)unresolvedAttribute.name(), (Object)ex);
                            return (B1)ex;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Expression x1) {
                        Expression expression = x1;
                        return expression instanceof UnresolvedAttribute;
                    }
                    {
                        this.output$1 = output$1;
                        this.columnExtractors$1 = columnExtractors$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
                    }
                });
                ExpressionLogicalPlanWrapper wrappedPlan = new ExpressionLogicalPlanWrapper(attributesExtracted);
                LogicalPlan analyzedLogicalPlan = spark.sessionState().analyzer().execute((LogicalPlan)wrappedPlan);
                LogicalPlan optimizedLogicalPlan = (LogicalPlan)DeltaInvariantCheckerExec$DeltaInvariantCheckerOptimizer$.MODULE$.execute((TreeNode)analyzedLogicalPlan);
                LogicalPlan logicalPlan = optimizedLogicalPlan;
                if (!(logicalPlan instanceof ExpressionLogicalPlanWrapper)) throw new DeltaIllegalStateException("INTERNAL_ERROR", (String[])((Object[])new String[]{new StringBuilder(84).append("Applying type casting resulted in a bad plan rather than a simple expression.\n").append("Plan:").append(logicalPlan.prettyJson()).append("\n").toString()}), DeltaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
                ExpressionLogicalPlanWrapper expressionLogicalPlanWrapper = (ExpressionLogicalPlanWrapper)logicalPlan;
                expression = e = expressionLogicalPlanWrapper.e();
            }
            Expression executableExpr = expression;
            return new CheckDeltaInvariant(executableExpr, (scala.collection.immutable.Map<String, Expression>)columnExtractors.toMap(Predef$.MODULE$.$conforms()), (Constraint)constraint);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public DeltaInvariantCheckerExec apply(SparkPlan child, Seq<Constraint> constraints) {
        return new DeltaInvariantCheckerExec(child, constraints);
    }

    public Option<Tuple2<SparkPlan, Seq<Constraint>>> unapply(DeltaInvariantCheckerExec x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.child(), x$0.constraints()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$buildExtractor$3(String fieldName$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)SchemaUtils$.MODULE$.DELTA_COL_RESOLVER().apply((Object)f.name(), (Object)fieldName$1));
    }

    private DeltaInvariantCheckerExec$() {
        MODULE$ = this;
    }
}

