/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.expressions.InterleaveBits;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public final class InterleaveBits$
implements Serializable {
    public static InterleaveBits$ MODULE$;

    static {
        new InterleaveBits$();
    }

    public byte[] interleaveBits(int[] inputs, boolean fastInterleaveBitsEnabled) {
        if (fastInterleaveBitsEnabled) {
            int n = inputs.length;
            switch (n) {
                case 0: {
                    return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                }
                case 1: {
                    return this.intToByte(inputs[0]);
                }
                case 2: {
                    return this.interleave2Ints(inputs[1], inputs[0]);
                }
                case 3: {
                    return this.interleave3Ints(inputs[2], inputs[1], inputs[0]);
                }
                case 4: {
                    return this.interleave4Ints(inputs[3], inputs[2], inputs[1], inputs[0]);
                }
                case 5: {
                    return this.interleave5Ints(inputs[4], inputs[3], inputs[2], inputs[1], inputs[0]);
                }
                case 6: {
                    return this.interleave6Ints(inputs[5], inputs[4], inputs[3], inputs[2], inputs[1], inputs[0]);
                }
                case 7: {
                    return this.interleave7Ints(inputs[6], inputs[5], inputs[4], inputs[3], inputs[2], inputs[1], inputs[0]);
                }
                case 8: {
                    return this.interleave8Ints(inputs[7], inputs[6], inputs[5], inputs[4], inputs[3], inputs[2], inputs[1], inputs[0]);
                }
            }
            return this.defaultInterleaveBits(inputs, inputs.length);
        }
        return this.defaultInterleaveBits(inputs, inputs.length);
    }

    private byte[] defaultInterleaveBits(int[] inputs, int numCols) {
        byte[] ret = new byte[numCols * 4];
        int ret_idx = 0;
        int ret_bit = 7;
        int ret_byte = 0;
        for (int bit = 31; bit >= 0; --bit) {
            for (int idx = 0; idx < numCols; ++idx) {
                ret_byte = (byte)(ret_byte | (inputs[idx] >> bit & 1) << ret_bit);
                if (--ret_bit != -1) continue;
                ret[ret_idx] = ret_byte;
                ret_byte = 0;
                ++ret_idx;
                ret_bit = 7;
            }
        }
        Predef$.MODULE$.assert(ret_idx == numCols * 4);
        Predef$.MODULE$.assert(ret_bit == 7);
        return ret;
    }

    private byte[] interleave2Ints(int i1, int i2) {
        byte[] result = new byte[8];
        for (int i = 0; i < 4; ++i) {
            byte tmp1 = (byte)(i1 >> i * 8 & 0xFF);
            byte tmp2 = (byte)(i2 >> i * 8 & 0xFF);
            int z = 0;
            for (int j = 0; j < 8; ++j) {
                int x_masked = tmp1 & 1 << j;
                int y_masked = tmp2 & 1 << j;
                z |= x_masked << j;
                z |= y_masked << j + 1;
            }
            result[(3 - i) * 2 + 1] = (byte)(z & 0xFF);
            result[(3 - i) * 2] = (byte)(z >> 8 & 0xFF);
        }
        return result;
    }

    private byte[] intToByte(int input) {
        byte[] result = new byte[4];
        for (int i = 0; i <= 3; ++i) {
            int offset = i * 8;
            result[3 - i] = (byte)(input >> offset & 0xFF);
        }
        return result;
    }

    private byte[] interleave3Ints(int i1, int i2, int i3) {
        byte[] result = new byte[12];
        for (int i = 0; i < 4; ++i) {
            byte tmp1 = (byte)(i1 >> i * 8 & 0xFF);
            byte tmp2 = (byte)(i2 >> i * 8 & 0xFF);
            byte tmp3 = (byte)(i3 >> i * 8 & 0xFF);
            int z = 0;
            for (int j = 0; j < 8; ++j) {
                int r1_mask = tmp1 & 1 << j;
                int r2_mask = tmp2 & 1 << j;
                int r3_mask = tmp3 & 1 << j;
                z |= r1_mask << 2 * j | r2_mask << 2 * j + 1 | r3_mask << 2 * j + 2;
            }
            result[(3 - i) * 3 + 2] = (byte)(z & 0xFF);
            result[(3 - i) * 3 + 1] = (byte)(z >> 8 & 0xFF);
            result[(3 - i) * 3] = (byte)(z >> 16 & 0xFF);
        }
        return result;
    }

    private byte[] interleave4Ints(int i1, int i2, int i3, int i4) {
        byte[] result = new byte[16];
        for (int i = 0; i < 4; ++i) {
            byte tmp1 = (byte)(i1 >> i * 8 & 0xFF);
            byte tmp2 = (byte)(i2 >> i * 8 & 0xFF);
            byte tmp3 = (byte)(i3 >> i * 8 & 0xFF);
            byte tmp4 = (byte)(i4 >> i * 8 & 0xFF);
            int z = 0;
            for (int j = 0; j < 8; ++j) {
                int r1_mask = tmp1 & 1 << j;
                int r2_mask = tmp2 & 1 << j;
                int r3_mask = tmp3 & 1 << j;
                int r4_mask = tmp4 & 1 << j;
                z |= r1_mask << 3 * j | r2_mask << 3 * j + 1 | r3_mask << 3 * j + 2 | r4_mask << 3 * j + 3;
            }
            result[(3 - i) * 4 + 3] = (byte)(z & 0xFF);
            result[(3 - i) * 4 + 2] = (byte)(z >> 8 & 0xFF);
            result[(3 - i) * 4 + 1] = (byte)(z >> 16 & 0xFF);
            result[(3 - i) * 4] = (byte)(z >> 24 & 0xFF);
        }
        return result;
    }

    private byte[] interleave5Ints(int i1, int i2, int i3, int i4, int i5) {
        byte[] result = new byte[20];
        for (int i = 0; i < 4; ++i) {
            byte tmp1 = (byte)(i1 >> i * 8 & 0xFF);
            byte tmp2 = (byte)(i2 >> i * 8 & 0xFF);
            byte tmp3 = (byte)(i3 >> i * 8 & 0xFF);
            byte tmp4 = (byte)(i4 >> i * 8 & 0xFF);
            byte tmp5 = (byte)(i5 >> i * 8 & 0xFF);
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = (long)tmp1 & (long)(1 << j);
                long r2_mask = (long)tmp2 & (long)(1 << j);
                long r3_mask = (long)tmp3 & (long)(1 << j);
                long r4_mask = (long)tmp4 & (long)(1 << j);
                long r5_mask = (long)tmp5 & (long)(1 << j);
                z |= r1_mask << 4 * j | r2_mask << 4 * j + 1 | r3_mask << 4 * j + 2 | r4_mask << 4 * j + 3 | r5_mask << 4 * j + 4;
            }
            result[(3 - i) * 5 + 4] = (byte)(z & 0xFFL);
            result[(3 - i) * 5 + 3] = (byte)(z >> 8 & 0xFFL);
            result[(3 - i) * 5 + 2] = (byte)(z >> 16 & 0xFFL);
            result[(3 - i) * 5 + 1] = (byte)(z >> 24 & 0xFFL);
            result[(3 - i) * 5] = (byte)(z >> 32 & 0xFFL);
        }
        return result;
    }

    private byte[] interleave6Ints(int i1, int i2, int i3, int i4, int i5, int i6) {
        byte[] result = new byte[24];
        for (int i = 0; i < 4; ++i) {
            byte tmp1 = (byte)(i1 >> i * 8 & 0xFF);
            byte tmp2 = (byte)(i2 >> i * 8 & 0xFF);
            byte tmp3 = (byte)(i3 >> i * 8 & 0xFF);
            byte tmp4 = (byte)(i4 >> i * 8 & 0xFF);
            byte tmp5 = (byte)(i5 >> i * 8 & 0xFF);
            byte tmp6 = (byte)(i6 >> i * 8 & 0xFF);
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = (long)tmp1 & (long)(1 << j);
                long r2_mask = (long)tmp2 & (long)(1 << j);
                long r3_mask = (long)tmp3 & (long)(1 << j);
                long r4_mask = (long)tmp4 & (long)(1 << j);
                long r5_mask = (long)tmp5 & (long)(1 << j);
                long r6_mask = (long)tmp6 & (long)(1 << j);
                z |= r1_mask << 5 * j | r2_mask << 5 * j + 1 | r3_mask << 5 * j + 2 | r4_mask << 5 * j + 3 | r5_mask << 5 * j + 4 | r6_mask << 5 * j + 5;
            }
            result[(3 - i) * 6 + 5] = (byte)(z & 0xFFL);
            result[(3 - i) * 6 + 4] = (byte)(z >> 8 & 0xFFL);
            result[(3 - i) * 6 + 3] = (byte)(z >> 16 & 0xFFL);
            result[(3 - i) * 6 + 2] = (byte)(z >> 24 & 0xFFL);
            result[(3 - i) * 6 + 1] = (byte)(z >> 32 & 0xFFL);
            result[(3 - i) * 6] = (byte)(z >> 40 & 0xFFL);
        }
        return result;
    }

    private byte[] interleave7Ints(int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        byte[] result = new byte[28];
        for (int i = 0; i < 4; ++i) {
            byte tmp1 = (byte)(i1 >> i * 8 & 0xFF);
            byte tmp2 = (byte)(i2 >> i * 8 & 0xFF);
            byte tmp3 = (byte)(i3 >> i * 8 & 0xFF);
            byte tmp4 = (byte)(i4 >> i * 8 & 0xFF);
            byte tmp5 = (byte)(i5 >> i * 8 & 0xFF);
            byte tmp6 = (byte)(i6 >> i * 8 & 0xFF);
            byte tmp7 = (byte)(i7 >> i * 8 & 0xFF);
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = (long)tmp1 & (long)(1 << j);
                long r2_mask = (long)tmp2 & (long)(1 << j);
                long r3_mask = (long)tmp3 & (long)(1 << j);
                long r4_mask = (long)tmp4 & (long)(1 << j);
                long r5_mask = (long)tmp5 & (long)(1 << j);
                long r6_mask = (long)tmp6 & (long)(1 << j);
                long r7_mask = (long)tmp7 & (long)(1 << j);
                z |= r1_mask << 6 * j | r2_mask << 6 * j + 1 | r3_mask << 6 * j + 2 | r4_mask << 6 * j + 3 | r5_mask << 6 * j + 4 | r6_mask << 6 * j + 5 | r7_mask << 6 * j + 6;
            }
            result[(3 - i) * 7 + 6] = (byte)(z & 0xFFL);
            result[(3 - i) * 7 + 5] = (byte)(z >> 8 & 0xFFL);
            result[(3 - i) * 7 + 4] = (byte)(z >> 16 & 0xFFL);
            result[(3 - i) * 7 + 3] = (byte)(z >> 24 & 0xFFL);
            result[(3 - i) * 7 + 2] = (byte)(z >> 32 & 0xFFL);
            result[(3 - i) * 7 + 1] = (byte)(z >> 40 & 0xFFL);
            result[(3 - i) * 7] = (byte)(z >> 48 & 0xFFL);
        }
        return result;
    }

    private byte[] interleave8Ints(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
        byte[] result = new byte[32];
        for (int i = 0; i < 4; ++i) {
            byte tmp1 = (byte)(i1 >> i * 8 & 0xFF);
            byte tmp2 = (byte)(i2 >> i * 8 & 0xFF);
            byte tmp3 = (byte)(i3 >> i * 8 & 0xFF);
            byte tmp4 = (byte)(i4 >> i * 8 & 0xFF);
            byte tmp5 = (byte)(i5 >> i * 8 & 0xFF);
            byte tmp6 = (byte)(i6 >> i * 8 & 0xFF);
            byte tmp7 = (byte)(i7 >> i * 8 & 0xFF);
            byte tmp8 = (byte)(i8 >> i * 8 & 0xFF);
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = (long)tmp1 & (long)(1 << j);
                long r2_mask = (long)tmp2 & (long)(1 << j);
                long r3_mask = (long)tmp3 & (long)(1 << j);
                long r4_mask = (long)tmp4 & (long)(1 << j);
                long r5_mask = (long)tmp5 & (long)(1 << j);
                long r6_mask = (long)tmp6 & (long)(1 << j);
                long r7_mask = (long)tmp7 & (long)(1 << j);
                long r8_mask = (long)tmp8 & (long)(1 << j);
                z |= r1_mask << 7 * j | r2_mask << 7 * j + 1 | r3_mask << 7 * j + 2 | r4_mask << 7 * j + 3 | r5_mask << 7 * j + 4 | r6_mask << 7 * j + 5 | r7_mask << 7 * j + 6 | r8_mask << 7 * j + 7;
            }
            result[(3 - i) * 8 + 7] = (byte)(z & 0xFFL);
            result[(3 - i) * 8 + 6] = (byte)(z >> 8 & 0xFFL);
            result[(3 - i) * 8 + 5] = (byte)(z >> 16 & 0xFFL);
            result[(3 - i) * 8 + 4] = (byte)(z >> 24 & 0xFFL);
            result[(3 - i) * 8 + 3] = (byte)(z >> 32 & 0xFFL);
            result[(3 - i) * 8 + 2] = (byte)(z >> 40 & 0xFFL);
            result[(3 - i) * 8 + 1] = (byte)(z >> 48 & 0xFFL);
            result[(3 - i) * 8] = (byte)(z >> 56 & 0xFFL);
        }
        return result;
    }

    public InterleaveBits apply(Seq<Expression> children) {
        return new InterleaveBits(children);
    }

    public Option<Seq<Expression>> unapply(InterleaveBits x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some(x$0.children());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private InterleaveBits$() {
        MODULE$ = this;
    }
}

