/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.streaming;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.delta.streaming.PartitionAndDataSchema;
import org.apache.spark.sql.delta.streaming.SchemaSerializer;
import org.apache.spark.sql.delta.streaming.SchemaTrackingExceptions$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import scala.collection.Iterator;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A4AAC\u0006\u00011!Aq\u0006\u0001BC\u0002\u0013\u0005\u0003\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00032\u0011!)\u0004AaA!\u0002\u00171\u0004\u0002\u0003\u001f\u0001\u0005\u0007\u0005\u000b1B\u001f\t\u000b!\u0003A\u0011A%\t\u000f=\u0003!\u0019!C\u0001!\"1\u0011\f\u0001Q\u0001\nECQA\u0017\u0001\u0005BmCQ\u0001\u001a\u0001\u0005B\u0015\u0014ACS:p]N\u001b\u0007.Z7b'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u0007\u000e\u0003%\u0019HO]3b[&twM\u0003\u0002\u000f\u001f\u0005)A-\u001a7uC*\u0011\u0001#E\u0001\u0004gFd'B\u0001\n\u0014\u0003\u0015\u0019\b/\u0019:l\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001U\u0011\u0011DJ\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\rE\u0002\"E\u0011j\u0011aC\u0005\u0003G-\u0011\u0001cU2iK6\f7+\u001a:jC2L'0\u001a:\u0011\u0005\u00152C\u0002\u0001\u0003\u0006O\u0001\u0011\r\u0001\u000b\u0002\u0002)F\u0011\u0011\u0006\f\t\u00037)J!a\u000b\u000f\u0003\u000f9{G\u000f[5oOB\u0011\u0011%L\u0005\u0003]-\u0011a\u0003U1si&$\u0018n\u001c8B]\u0012$\u0015\r^1TG\",W.Y\u0001\rg\u0016\u0014H-\u001a,feNLwN\\\u000b\u0002cA\u00111DM\u0005\u0003gq\u00111!\u00138u\u00035\u0019XM\u001d3f-\u0016\u00148/[8oA\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007]RD%D\u00019\u0015\tID$A\u0004sK\u001adWm\u0019;\n\u0005mB$\u0001C\"mCN\u001cH+Y4\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002?\u000b\u0012r!aP\"\u0011\u0005\u0001cR\"A!\u000b\u0005\t;\u0012A\u0002\u001fs_>$h(\u0003\u0002E9\u00051\u0001K]3eK\u001aL!AR$\u0003\u00115\u000bg.\u001b4fgRT!\u0001\u0012\u000f\u0002\rqJg.\u001b;?)\tQe\nF\u0002L\u00196\u00032!\t\u0001%\u0011\u0015)T\u0001q\u00017\u0011\u0015aT\u0001q\u0001>\u0011\u0015yS\u00011\u00012\u0003))U\n\u0015+Z?*\u001bvJT\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005Y\u0006twMC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&AB*ue&tw-A\u0006F\u001bB#\u0016l\u0018&T\u001f:\u0003\u0013a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$\"\u0001\n/\t\u000buC\u0001\u0019\u00010\u0002\u0005%t\u0007CA0c\u001b\u0005\u0001'BA1V\u0003\tIw.\u0003\u0002dA\nY\u0011J\u001c9viN#(/Z1n\u0003%\u0019XM]5bY&TX\rF\u0002gS.\u0004\"aG4\n\u0005!d\"\u0001B+oSRDQA[\u0005A\u0002\u0011\n\u0001\"\\3uC\u0012\fG/\u0019\u0005\u0006Y&\u0001\r!\\\u0001\u0004_V$\bCA0o\u0013\ty\u0007M\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000e")
public class JsonSchemaSerializer<T extends PartitionAndDataSchema>
implements SchemaSerializer<T> {
    private final int serdeVersion;
    private final Manifest<T> evidence$2;
    private final String EMPTY_JSON;

    @Override
    public int serdeVersion() {
        return this.serdeVersion;
    }

    public String EMPTY_JSON() {
        return this.EMPTY_JSON;
    }

    @Override
    public T deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw SchemaTrackingExceptions$.MODULE$.FailedToDeserializeException();
        }
        MetadataVersionUtil$.MODULE$.validateVersion((String)lines.next(), this.serdeVersion());
        String schemaJson = lines.hasNext() ? (String)lines.next() : this.EMPTY_JSON();
        return (T)((PartitionAndDataSchema)JsonUtils$.MODULE$.fromJson(schemaJson, this.evidence$2));
    }

    @Override
    public void serialize(T metadata, OutputStream out) {
        out.write(new StringBuilder(1).append("v").append(this.serdeVersion()).toString().getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(JsonUtils$.MODULE$.toJson(metadata, this.evidence$2).getBytes(StandardCharsets.UTF_8));
    }

    public JsonSchemaSerializer(int serdeVersion, ClassTag<T> evidence$1, Manifest<T> evidence$2) {
        this.serdeVersion = serdeVersion;
        this.evidence$2 = evidence$2;
        this.EMPTY_JSON = "{}";
    }
}

