/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaAnalysisException;
import org.apache.spark.sql.delta.DeltaAnalysisException$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateFormatter$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.PartitionPath;
import org.apache.spark.sql.delta.util.PartitionPath$;
import org.apache.spark.sql.delta.util.PartitionSpec;
import org.apache.spark.sql.delta.util.PartitionSpec$;
import org.apache.spark.sql.delta.util.PartitionUtils;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class PartitionUtils$ {
    public static PartitionUtils$ MODULE$;
    private final String timestampPartitionPattern;
    private final Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn;

    static {
        new PartitionUtils$();
    }

    public String timestampPartitionPattern() {
        return this.timestampPartitionPattern;
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths, Option<StructType> userSpecifiedSchema, boolean caseSensitive, boolean validatePartitionColumns, String timeZoneId) {
        return this.parsePartitions(paths, typeInference, basePaths, userSpecifiedSchema, caseSensitive, validatePartitionColumns, DateTimeUtils$.MODULE$.getTimeZone(timeZoneId));
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths, Option<StructType> userSpecifiedSchema, boolean caseSensitive, boolean validatePartitionColumns, TimeZone timeZone) {
        Object object;
        if (userSpecifiedSchema.isDefined()) {
            scala.collection.immutable.Map nameToDataType = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            object = !caseSensitive ? CaseInsensitiveMap$.MODULE$.apply(nameToDataType) : nameToDataType;
        } else {
            object = Predef$.MODULE$.Map().empty();
        }
        scala.collection.immutable.Map userSpecifiedDataTypes = object;
        scala.collection.immutable.Map userSpecifiedNames = userSpecifiedSchema.isDefined() && !caseSensitive ? CaseInsensitiveMap$.MODULE$.apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())) : Predef$.MODULE$.Map().empty();
        DateFormatter dateFormatter = DateFormatter$.MODULE$.apply();
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), timeZone);
        Tuple2 tuple2 = ((GenericTraversableTemplate)paths.map((Function1 & Serializable & scala.Serializable)path -> MODULE$.parsePartition((Path)path, typeInference, basePaths, (scala.collection.immutable.Map<String, DataType>)userSpecifiedDataTypes, validatePartitionColumns, timeZone, dateFormatter, timestampFormatter), Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionValues = (Seq)tuple2._1();
        Seq optDiscoveredBasePaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionValues, (Object)optDiscoveredBasePaths);
        Seq partitionValues2 = (Seq)tuple22._1();
        Seq optDiscoveredBasePaths2 = (Seq)tuple22._2();
        Seq pathsWithPartitionValues = (Seq)((TraversableLike)paths.zip((GenIterable)partitionValues2, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x -> Option$.MODULE$.option2Iterable(((Option)x._2()).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), x$2))), Seq$.MODULE$.canBuildFrom());
        if (pathsWithPartitionValues.isEmpty()) {
            return PartitionSpec$.MODULE$.emptySpec();
        }
        Seq discoveredBasePaths = (Seq)((TraversableLike)optDiscoveredBasePaths2.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString().toLowerCase(), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(((SeqLike)discoveredBasePaths.distinct()).size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(294).append("Conflicting directory structures detected. Suspicious paths:\b").append(((TraversableOnce)discoveredBasePaths.distinct()).mkString("\n\t", "\n\t", "\n\n")).append("If provided paths are partition directories, please set ").append("\"basePath\" in the options of the data source to specify the ").append("root directory of the table. If there are multiple root directories, ").append("please load them separately and then union them.").toString());
        Seq<PartitionUtils.PartitionValues> resolvedPartitionValues = this.resolvePartitions((Seq<Tuple2<Path, PartitionUtils.PartitionValues>>)pathsWithPartitionValues, caseSensitive, timeZone);
        PartitionUtils.PartitionValues partitionValues3 = (PartitionUtils.PartitionValues)resolvedPartitionValues.head();
        if (partitionValues3 == null) {
            throw new MatchError((Object)partitionValues3);
        }
        Seq<String> columnNames = partitionValues3.columnNames();
        Seq<Literal> literals = partitionValues3.literals();
        Tuple2 tuple23 = new Tuple2(columnNames, literals);
        Seq columnNames2 = (Seq)tuple23._1();
        Seq literals2 = (Seq)tuple23._2();
        Seq fields = (Seq)((TraversableLike)columnNames2.zip((GenIterable)literals2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Literal literal = (Literal)tuple2._2();
                if (literal != null) {
                    DataType dataType = literal.dataType();
                    String resultName = (String)userSpecifiedNames.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> name);
                    DataType resultDataType = (DataType)userSpecifiedDataTypes.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> dataType);
                    return new StructField(resultName, resultDataType, true, StructField$.MODULE$.apply$default$4());
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Seq partitions = (Seq)((TraversableLike)resolvedPartitionValues.zip((GenIterable)pathsWithPartitionValues, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                PartitionUtils.PartitionValues partitionValues = (PartitionUtils.PartitionValues)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (partitionValues != null) {
                    Seq<Literal> literals = partitionValues.literals();
                    if (tuple22 != null) {
                        Path path = (Path)tuple22._1();
                        return PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.fromSeq((Seq)literals.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.value(), Seq$.MODULE$.canBuildFrom())), path);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return new PartitionSpec(StructType$.MODULE$.apply(fields), (Seq<PartitionPath>)partitions);
    }

    public Tuple2<Option<PartitionUtils.PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths, scala.collection.immutable.Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, TimeZone timeZone, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        ArrayBuffer columns = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (!finished) {
            String string = currentPath.getName().toLowerCase(Locale.ROOT);
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, Literal>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference, userSpecifiedDataTypes, validatePartitionColumns, timeZone, dateFormatter, timestampFormatter);
            maybeColumn.foreach((Function1 & Serializable & scala.Serializable)x$6 -> columns.$plus$eq(x$6));
            finished = maybeColumn.isEmpty() && columns.nonEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
        if (columns.isEmpty()) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
        }
        Tuple2 tuple2 = ((GenericTraversableTemplate)columns.reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrayBuffer columnNames = (ArrayBuffer)tuple2._1();
        ArrayBuffer values = (ArrayBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)columnNames, (Object)values);
        ArrayBuffer columnNames2 = (ArrayBuffer)tuple22._1();
        ArrayBuffer values2 = (ArrayBuffer)tuple22._2();
        return new Tuple2((Object)new Some((Object)new PartitionUtils.PartitionValues((Seq<String>)columnNames2.toSeq(), (Seq<Literal>)values2.toSeq())), (Object)new Some((Object)currentPath));
    }

    private Option<Tuple2<String, Literal>> parsePartitionColumn(String columnSpec, boolean typeInference, scala.collection.immutable.Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, TimeZone timeZone, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Literal literal;
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            return None$.MODULE$;
        }
        String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName((String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).take(equalSignIndex));
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(columnName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Empty partition column name in '").append(columnSpec).append("'").toString());
        String rawColumnValue = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).drop(equalSignIndex + 1);
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(rawColumnValue)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Empty partition column value in '").append(columnSpec).append("'").toString());
        if (userSpecifiedDataTypes.contains((Object)columnName)) {
            DataType dataType = (DataType)userSpecifiedDataTypes.apply((Object)columnName);
            Literal columnValueLiteral = this.inferPartitionColumnValue(rawColumnValue, false, timeZone, dateFormatter, timestampFormatter);
            Object columnValue = columnValueLiteral.eval(columnValueLiteral.eval$default$1());
            Cast qual$1 = new Cast((Expression)columnValueLiteral, dataType, Option$.MODULE$.apply((Object)timeZone.getID()), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            Object castedValue = qual$1.eval(x$1);
            if (validatePartitionColumns && columnValue != null && castedValue == null) {
                throw DeltaErrors$.MODULE$.partitionColumnCastFailed(columnValue.toString(), dataType.toString(), columnName);
            }
            literal = Literal$.MODULE$.create(castedValue, dataType);
        } else {
            literal = this.inferPartitionColumnValue(rawColumnValue, typeInference, timeZone, dateFormatter, timestampFormatter);
        }
        Literal literal2 = literal;
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)literal2));
    }

    public scala.collection.immutable.Map<String, String> parsePathFragment(String pathFragment) {
        return this.parsePathFragmentAsSeq(pathFragment).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<String, String>> parsePathFragmentAsSeq(String pathFragment) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(pathFragment)).stripPrefix("data/").split("/"))).map((Function1 & Serializable & scala.Serializable)kv -> {
            String[] pair = kv.split("=", 2);
            return new Tuple2((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[0]), (Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[1]));
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String getPathFragment(scala.collection.immutable.Map<String, String> spec, StructType partitionSchema) {
        return ((TraversableOnce)partitionSchema.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName(field.name())).append("=").append(ExternalCatalogUtils$.MODULE$.escapePathName((String)spec.apply((Object)field.name()))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public String getPathFragment(scala.collection.immutable.Map<String, String> spec, Seq<Attribute> partitionColumns) {
        return this.getPathFragment(spec, DataTypeUtils$.MODULE$.fromAttributes(partitionColumns));
    }

    public <T> scala.collection.immutable.Map<String, T> normalizePartitionSpec(scala.collection.immutable.Map<String, T> partitionSpec, Seq<String> partColNames, String tblName, Function2<String, String, Object> resolver) {
        Seq normalizedPartSpec = (Seq)partitionSpec.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                String normalizedKey = (String)partColNames.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PartitionUtils$.$anonfun$normalizePartitionSpec$2(resolver, key, x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw DeltaErrors$.MODULE$.invalidPartitionColumn(key, tblName);
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)normalizedKey), value);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        this.checkColumnNameDuplication((Seq<String>)((Seq)normalizedPartSpec.map((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9._1(), Seq$.MODULE$.canBuildFrom())), "in the partition schema", resolver);
        return normalizedPartSpec.toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<PartitionUtils.PartitionValues> resolvePartitions(Seq<Tuple2<Path, PartitionUtils.PartitionValues>> pathsWithPartitionValues, boolean caseSensitive, TimeZone timeZone) {
        if (pathsWithPartitionValues.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Seq partColNames = caseSensitive ? (Seq)pathsWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$10 -> ((PartitionUtils.PartitionValues)x$10._2()).columnNames(), Seq$.MODULE$.canBuildFrom()) : (Seq)pathsWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$11 -> (Seq)((PartitionUtils.PartitionValues)x$11._2()).columnNames().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toLowerCase(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(((SeqLike)partColNames.distinct()).size() == 1, (Function0 & Serializable & scala.Serializable)() -> MODULE$.listConflictingPartitionColumns(pathsWithPartitionValues));
        Seq values = (Seq)pathsWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$13 -> (PartitionUtils.PartitionValues)x$13._2(), Seq$.MODULE$.canBuildFrom());
        int columnCount = ((PartitionUtils.PartitionValues)values.head()).columnNames().size();
        IndexedSeq resolvedValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1 & Serializable & scala.Serializable)i -> PartitionUtils$.MODULE$.resolveTypeConflicts((Seq<Literal>)((Seq)values.map((Function1 & Serializable & scala.Serializable)x$14 -> (Literal)x$14.literals().apply(i), Seq$.MODULE$.canBuildFrom())), timeZone), IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PartitionUtils.PartitionValues d = (PartitionUtils.PartitionValues)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Seq x$1 = (Seq)resolvedValues.map((Function1 & Serializable & scala.Serializable)x$15 -> (Literal)x$15.apply(index), IndexedSeq$.MODULE$.canBuildFrom());
                Seq<String> x$2 = d.copy$default$1();
                return d.copy(x$2, (Seq<Literal>)x$1);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String listConflictingPartitionColumns(Seq<Tuple2<Path, PartitionUtils.PartitionValues>> pathWithPartitionValues) {
        Seq distinctPartColNames = (Seq)((SeqLike)pathWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x$16 -> ((PartitionUtils.PartitionValues)x$16._2()).columnNames(), Seq$.MODULE$.canBuildFrom())).distinct();
        scala.collection.immutable.Map partColNamesToPaths = PartitionUtils$.groupByKey$1((Seq)pathWithPartitionValues.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                PartitionUtils.PartitionValues partValues = (PartitionUtils.PartitionValues)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partValues.columnNames()), (Object)path);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom()));
        Seq distinctPartColLists = (Seq)((TraversableLike)((IterableLike)distinctPartColNames.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.mkString(", "), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String names = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new StringBuilder(30).append("Partition column name list #").append(index).append(": ").append(names).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Seq suspiciousPaths = (Seq)((TraversableLike)distinctPartColNames.sortBy((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.length()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)partColNamesToPaths, Seq$.MODULE$.canBuildFrom());
        return new StringBuilder(307).append("Conflicting partition column names detected:\n").append(distinctPartColLists.mkString("\n\t", "\n\t", "\n\n")).append("For partitioned table directories, data files should only live in leaf directories.\n").append("And directories at the same level should have the same partition column name.\n").append("Please check the following directories for unexpected files or ").append("inconsistent partition column names:\n").append(((TraversableOnce)suspiciousPaths.map((Function1 & Serializable & scala.Serializable)x$20 -> new StringBuilder(1).append("\t").append(x$20).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "")).toString();
    }

    public Literal inferPartitionColumnValue(String raw, boolean typeInference, TimeZone timeZone, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Try decimalTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = new BigDecimal(raw);
            Predef$.MODULE$.require(bigDecimal.scale() <= 0);
            return Literal$.MODULE$.apply((Object)bigDecimal);
        });
        Try dateTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            dateFormatter.parse(raw);
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)raw), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            Object dateValue = qual$1.eval(x$1);
            Predef$.MODULE$.require(dateValue != null);
            return Literal$.MODULE$.create(dateValue, (DataType)DateType$.MODULE$);
        });
        Try timestampTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String unescapedRaw = ExternalCatalogUtils$.MODULE$.unescapePathName(raw);
            timestampFormatter.parse(unescapedRaw);
            Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)unescapedRaw), (DataType)TimestampType$.MODULE$, (Option)new Some((Object)timeZone.getID()), Cast$.MODULE$.apply$default$4());
            InternalRow x$2 = qual$2.eval$default$1();
            Object timestampValue = qual$2.eval(x$2);
            Predef$.MODULE$.require(timestampValue != null);
            return Literal$.MODULE$.create(timestampValue, (DataType)TimestampType$.MODULE$);
        });
        if (typeInference) {
            return (Literal)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(raw)), (DataType)IntegerType$.MODULE$)).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)Long.parseLong(raw)), (DataType)LongType$.MODULE$))).orElse((Function0 & Serializable & scala.Serializable)() -> decimalTry).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)Double.parseDouble(raw)), (DataType)DoubleType$.MODULE$))).orElse((Function0 & Serializable & scala.Serializable)() -> timestampTry).orElse((Function0 & Serializable & scala.Serializable)() -> dateTry).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String string = raw;
                String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return Literal$.MODULE$.default((DataType)NullType$.MODULE$);
                }
                return Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(raw), (DataType)StringType$.MODULE$);
            });
        }
        String string = raw;
        String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Literal$.MODULE$.default((DataType)NullType$.MODULE$);
        }
        return Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(raw), (DataType)StringType$.MODULE$);
    }

    public void validatePartitionColumn(StructType schema, Seq<String> partitionColumns, boolean caseSensitive) {
        this.checkColumnNameDuplication(partitionColumns, "in the partition columns", caseSensitive);
        this.partitionColumnsSchema(schema, partitionColumns, caseSensitive).foreach((Function1 & Serializable & scala.Serializable)field -> {
            PartitionUtils$.$anonfun$validatePartitionColumn$1(field);
            return BoxedUnit.UNIT;
        });
        if (partitionColumns.nonEmpty() && partitionColumns.size() == schema.fields().length) {
            throw new DeltaAnalysisException("DELTA_CANNOT_USE_ALL_COLUMNS_FOR_PARTITION", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
    }

    public StructType partitionColumnsSchema(StructType schema, Seq<String> partitionColumns, boolean caseSensitive) {
        Function2<String, String, Object> equality = this.columnNameEquality(caseSensitive);
        return StructType$.MODULE$.apply((Seq)partitionColumns.map((Function1 & Serializable & scala.Serializable)col -> (StructField)schema.find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitionUtils$.$anonfun$partitionColumnsSchema$2(equality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String schemaCatalog = schema.catalogString();
            throw DeltaErrors$.MODULE$.missingPartitionColumn((String)col, schemaCatalog);
        }), Seq$.MODULE$.canBuildFrom())).asNullable();
    }

    public Tuple2<StructType, scala.collection.immutable.Map<String, StructField>> mergeDataAndPartitionSchema(StructType dataSchema, StructType partitionSchema, boolean caseSensitive) {
        Map overlappedPartCols = Map$.MODULE$.empty();
        partitionSchema.foreach((Function1 & Serializable & scala.Serializable)partitionField -> {
            String partitionFieldName = MODULE$.getColName((StructField)partitionField, caseSensitive);
            if (dataSchema.exists((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)PartitionUtils$.$anonfun$mergeDataAndPartitionSchema$2(caseSensitive, partitionFieldName, x$21)))) {
                return overlappedPartCols.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionFieldName), partitionField));
            }
            return BoxedUnit.UNIT;
        });
        StructType fullSchema = StructType$.MODULE$.apply((Seq)((TraversableLike)dataSchema.map((Function1 & Serializable & scala.Serializable)f -> (StructField)overlappedPartCols.getOrElse((Object)MODULE$.getColName((StructField)f, caseSensitive), (Function0 & Serializable & scala.Serializable)() -> f), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionSchema.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)overlappedPartCols.contains((Object)PartitionUtils$.MODULE$.getColName(f, caseSensitive)))), Seq$.MODULE$.canBuildFrom()));
        return new Tuple2((Object)fullSchema, (Object)overlappedPartCols.toMap(Predef$.MODULE$.$conforms()));
    }

    public String getColName(StructField f, boolean caseSensitive) {
        if (caseSensitive) {
            return f.name();
        }
        return f.name().toLowerCase(Locale.ROOT);
    }

    private Function2<String, String, Object> columnNameEquality(boolean caseSensitive) {
        if (caseSensitive) {
            return package$.MODULE$.caseSensitiveResolution();
        }
        return package$.MODULE$.caseInsensitiveResolution();
    }

    private Seq<Literal> resolveTypeConflicts(Seq<Literal> literals, TimeZone timeZone) {
        Seq litTypes = (Seq)literals.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.dataType(), Seq$.MODULE$.canBuildFrom());
        DataType desiredType = (DataType)litTypes.reduce(this.findWiderTypeForPartitionColumn());
        return (Seq)literals.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Literal literal = x0$1;
            if (literal != null) {
                Cast qual$1 = new Cast((Expression)literal, desiredType, (Option)new Some((Object)timeZone.getID()), Cast$.MODULE$.apply$default$4());
                InternalRow x$1 = qual$1.eval$default$1();
                return Literal$.MODULE$.create(qual$1.eval(x$1), desiredType);
            }
            throw new MatchError((Object)literal);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn() {
        return this.findWiderTypeForPartitionColumn;
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, String colType, Function2<String, String, Object> resolver) {
        this.checkColumnNameDuplication(columnNames, colType, this.isCaseSensitiveAnalysis(resolver));
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, String colType, boolean caseSensitiveAnalysis) {
        Seq names;
        Seq seq = names = caseSensitiveAnalysis ? columnNames : (Seq)columnNames.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.toLowerCase(), Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)names.distinct()).length() != names.length()) {
            Iterable duplicateColumns = (Iterable)names.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            return (B1)new StringBuilder(2).append("`").append(x).append("`").toString();
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    return tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw DeltaErrors$.MODULE$.foundDuplicateColumnsException(colType, duplicateColumns.mkString(", "));
        }
    }

    private boolean isCaseSensitiveAnalysis(Function2<String, String, Object> resolver) {
        Function2<String, String, Object> function2 = resolver;
        Function2 function22 = package$.MODULE$.caseSensitiveResolution();
        if (!(function2 != null ? !function2.equals((Object)function22) : function22 != null)) {
            return true;
        }
        Function2<String, String, Object> function23 = resolver;
        Function2 function24 = package$.MODULE$.caseInsensitiveResolution();
        if (!(function23 != null ? !function23.equals((Object)function24) : function24 != null)) {
            return false;
        }
        throw scala.sys.package$.MODULE$.error("A resolver to check if two identifiers are equal must be `caseSensitiveResolution` or `caseInsensitiveResolution` in o.a.s.sql.catalyst.");
    }

    public static final /* synthetic */ boolean $anonfun$normalizePartitionSpec$2(Function2 resolver$1, String key$1, String x$8) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$8, (Object)key$1));
    }

    private static final scala.collection.immutable.Map groupByKey$1(Seq seq) {
        return seq.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                return key;
            }
            throw new MatchError((Object)tuple2);
        }).mapValues((Function1 & Serializable & scala.Serializable)x$17 -> (Seq)x$17.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object value = tuple2._2();
                return value;
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$validatePartitionColumn$1(StructField field) {
        DataType dataType = field.dataType();
        if (dataType instanceof AtomicType) {
            return;
        }
        throw DeltaErrors$.MODULE$.cannotUseDataTypeForPartitionColumnError(field);
    }

    public static final /* synthetic */ boolean $anonfun$partitionColumnsSchema$2(Function2 equality$1, String col$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)equality$1.apply((Object)f.name(), (Object)col$1));
    }

    public static final /* synthetic */ boolean $anonfun$mergeDataAndPartitionSchema$2(boolean caseSensitive$1, String partitionFieldName$1, StructField x$21) {
        String string = MODULE$.getColName(x$21, caseSensitive$1);
        String string2 = partitionFieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StringType$ $anonfun$findWiderTypeForPartitionColumn$2() {
        return StringType$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ DataType $anonfun$findWiderTypeForPartitionColumn$1(DataType x0$1, DataType x1$1) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        var5_2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (var5_2 == null || !DoubleType$.MODULE$.equals(var6_3 = (DataType)var5_2._1()) || !(var5_2._2() instanceof DecimalType)) break block7;
                        v0 = true;
                        break block8;
                    }
                    if (var5_2 == null) ** GOTO lbl-1000
                    var7_4 = (DataType)var5_2._2();
                    if (var5_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var7_4)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                if (v0) {
                    return StringType$.MODULE$;
                }
                if (var5_2 == null) break block9;
                var8_5 = (DataType)var5_2._1();
                var9_6 = (DataType)var5_2._2();
                if (!DoubleType$.MODULE$.equals(var8_5) || !LongType$.MODULE$.equals(var9_6)) break block9;
                v1 = true;
                break block10;
            }
            if (var5_2 == null) ** GOTO lbl-1000
            var10_7 = (DataType)var5_2._1();
            var11_8 = (DataType)var5_2._2();
            if (LongType$.MODULE$.equals(var10_7) && DoubleType$.MODULE$.equals(var11_8)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v1) {
            return StringType$.MODULE$;
        }
        if (var5_2 != null) {
            t1 = (DataType)var5_2._1();
            t2 = (DataType)var5_2._2();
            return (DataType)TypeCoercion$.MODULE$.findWiderTypeForTwo(t1, t2).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$findWiderTypeForPartitionColumn$2(), ()Lorg/apache/spark/sql/types/StringType$;)());
        }
        throw new MatchError((Object)var5_2);
    }

    private PartitionUtils$() {
        MODULE$ = this;
        this.timestampPartitionPattern = "yyyy-MM-dd HH:mm:ss[.S]";
        this.findWiderTypeForPartitionColumn = PartitionUtils$::$anonfun$findWiderTypeForPartitionColumn$1;
    }
}

