/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.streaming.sources.TextSocketTable;
import org.apache.spark.sql.internal.connector.SimpleTableProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0002\u0004\u0001+!)\u0001\u0007\u0001C\u0001c!)A\u0007\u0001C\u0005k!)A\t\u0001C!\u000b\")q\n\u0001C!!\nAB+\u001a=u'>\u001c7.\u001a;T_V\u00148-\u001a)s_ZLG-\u001a:\u000b\u0005\u001dA\u0011aB:pkJ\u001cWm\u001d\u0006\u0003\u0013)\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005-a\u0011!C3yK\u000e,H/[8o\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\u0015\u0001aC\b\u0014,!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003mC:<'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011aa\u00142kK\u000e$\bCA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002$\u0019\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002&A\t\u00192+[7qY\u0016$\u0016M\u00197f!J|g/\u001b3feB\u0011q%K\u0007\u0002Q)\u0011q\u0001D\u0005\u0003U!\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011AFL\u0007\u0002[)\u00111ED\u0005\u0003_5\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002\r\u0005y1\r[3dWB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u00027yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t!QK\\5u\u0011\u0015i$\u00011\u0001?\u0003\u0019\u0001\u0018M]1ngB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tD\u0001\u0005kRLG.\u0003\u0002D\u0001\nA2)Y:f\u0013:\u001cXM\\:ji&4Xm\u0015;sS:<W*\u00199\u0002\u0011\u001d,G\u000fV1cY\u0016$\"AR'\u0011\u0005\u001d[U\"\u0001%\u000b\u0005%S\u0015aB2bi\u0006dwn\u001a\u0006\u0003C1I!\u0001\u0014%\u0003\u000bQ\u000b'\r\\3\t\u000b9\u001b\u0001\u0019\u0001 \u0002\u000f=\u0004H/[8og\u0006I1\u000f[8si:\u000bW.\u001a\u000b\u0002#B\u0011!+\u0017\b\u0003'^\u0003\"\u0001\u0016\u001d\u000e\u0003US!A\u0016\u000b\u0002\rq\u0012xn\u001c;?\u0013\tA\u0006(\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-9\u0001")
public class TextSocketSourceProvider
implements SimpleTableProvider,
DataSourceRegister,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private Table org$apache$spark$sql$internal$connector$SimpleTableProvider$$loadedTable;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return SimpleTableProvider.inferSchema$((SimpleTableProvider)this, (CaseInsensitiveStringMap)options);
    }

    public Table getTable(StructType schema, Transform[] partitioning2, Map<String, String> properties) {
        return SimpleTableProvider.getTable$((SimpleTableProvider)this, (StructType)schema, (Transform[])partitioning2, properties);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Table org$apache$spark$sql$internal$connector$SimpleTableProvider$$loadedTable() {
        return this.org$apache$spark$sql$internal$connector$SimpleTableProvider$$loadedTable;
    }

    public void org$apache$spark$sql$internal$connector$SimpleTableProvider$$loadedTable_$eq(Table x$1) {
        this.org$apache$spark$sql$internal$connector$SimpleTableProvider$$loadedTable = x$1;
    }

    private void checkParameters(CaseInsensitiveStringMap params) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The socket source should not be used for production applications! It does not support recovery.");
        if (!params.containsKey((Object)"host")) {
            throw QueryCompilationErrors$.MODULE$.hostOptionNotSetError();
        }
        if (!params.containsKey((Object)"port")) {
            throw QueryCompilationErrors$.MODULE$.portOptionNotSetError();
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> params.getBoolean("includeTimestamp", false));
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            throw QueryCompilationErrors$.MODULE$.invalidIncludeTimestampValueError();
        }
        throw new MatchError((Object)try_);
    }

    public Table getTable(CaseInsensitiveStringMap options) {
        this.checkParameters(options);
        return new TextSocketTable(options.get((Object)"host"), options.getInt("port", -1), options.getInt("numPartitions", SparkSession$.MODULE$.active().sparkContext().defaultParallelism()), options.getBoolean("includeTimestamp", false));
    }

    @Override
    public String shortName() {
        return "socket";
    }

    public TextSocketSourceProvider() {
        SimpleTableProvider.$init$((SimpleTableProvider)this);
        Logging.$init$((Logging)this);
    }
}

