/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.commons.compress.archivers.zip;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.Charsets;
import org.python.apache.commons.compress.archivers.zip.NioZipEncoding;
import org.python.apache.commons.compress.archivers.zip.ZipEncoding;
import org.python.apache.commons.compress.utils.CharsetNames;

public abstract class ZipEncodingHelper {
    static final ZipEncoding ZIP_ENCODING_UTF_8 = ZipEncodingHelper.getZipEncoding(CharsetNames.UTF_8);

    public static ZipEncoding getZipEncoding(Charset charset2) {
        Charset actual = Charsets.toCharset((Charset)charset2);
        boolean useReplacement = ZipEncodingHelper.isUTF8(actual);
        return new NioZipEncoding(actual, useReplacement);
    }

    public static ZipEncoding getZipEncoding(String name) {
        Charset charset2 = Charset.defaultCharset();
        try {
            charset2 = Charsets.toCharset((String)name);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        boolean useReplacement = ZipEncodingHelper.isUTF8(charset2.name());
        return new NioZipEncoding(charset2, useReplacement);
    }

    static ByteBuffer growBufferBy(ByteBuffer buffer, int increment) {
        buffer.limit(buffer.position());
        buffer.rewind();
        ByteBuffer on = ByteBuffer.allocate(buffer.capacity() + increment);
        on.put(buffer);
        return on;
    }

    static boolean isUTF8(Charset charset2) {
        return ZipEncodingHelper.isUTF8Alias(Charsets.toCharset((Charset)charset2).name());
    }

    static boolean isUTF8(String charsetName) {
        return ZipEncodingHelper.isUTF8Alias(charsetName != null ? charsetName : Charset.defaultCharset().name());
    }

    private static boolean isUTF8Alias(String actual) {
        return StandardCharsets.UTF_8.name().equalsIgnoreCase(actual) || StandardCharsets.UTF_8.aliases().stream().anyMatch(alias2 -> alias2.equalsIgnoreCase(actual));
    }
}

