/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ReflectedEventEvent;
import com.dataiku.dip.server.services.IPubSubService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.DebounceExecutor;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.exceptions.WebSocketException;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class DkuPubSubService
implements IPubSubService {
    final Map<Integer, DebounceExecutor> debounceExecutors = new HashMap<Integer, DebounceExecutor>();
    final Map<String, List<DSSEventListener<? extends DSSEvent>>> listeners = new HashMap<String, List<DSSEventListener<? extends DSSEvent>>>();
    final ExecutorService dispatcherThread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("NotificationDispatcher-%d").build());
    static final DKULogger logger = DKULogger.getLogger((String)"dku.pubsub");
    static final DKULogger loggedEventLogger = DKULogger.getLogger((String)"dku.pubsub.loggedEvent");

    public DkuPubSubService() {
        DSSMetrics.registry().register("dku.notifications.dispatcher.alive", (Metric)((Gauge)() -> !this.dispatcherThread.isShutdown() && !this.dispatcherThread.isTerminated()));
    }

    @Override
    public synchronized boolean subscribe(String notificationType, DSSEventListener<? extends DSSEvent> listener) {
        List<DSSEventListener<? extends DSSEvent>> listeners = this.getListeners(notificationType);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
            return true;
        }
        return false;
    }

    public synchronized boolean unsubscribe(String notificationType, DSSEventListener<? extends DSSEvent> listener) {
        List<DSSEventListener<? extends DSSEvent>> listeners = this.getListeners(notificationType);
        return listeners.remove(listener);
    }

    public synchronized void publishAfterTransaction(DSSEvent evt) {
        if (TransactionContext.hasAttachedRWTransaction()) {
            RWTransactionRef ref = TransactionContext.retrieveWrite();
            ref.onPostCommit(() -> {
                logger.trace((Object)("Deferred event publication after transaction: " + evt.getName()));
                this.publish(evt);
            });
        } else {
            this.publish(evt);
        }
    }

    public synchronized void publishAfterTransactionWithDebounce(String key, DSSEvent evt, int interval) {
        if (TransactionContext.hasAttachedRWTransaction()) {
            RWTransactionRef ref = TransactionContext.retrieveWrite();
            ref.onPostCommit(() -> {
                logger.trace((Object)("Deferred event publication after transaction (with debounce): " + evt.getName()));
                this.publishWithDebounce(key, evt, interval);
            });
        } else {
            this.publishWithDebounce(key, evt, interval);
        }
    }

    public synchronized void publishWithDebounce(String key, DSSEvent evt, int interval) {
        if (!this.debounceExecutors.containsKey(interval)) {
            this.debounceExecutors.put(interval, new DebounceExecutor("PubSubService." + interval, interval));
        }
        this.debounceExecutors.get(interval).addAction(key, () -> this.publish(evt));
    }

    @Override
    public synchronized void publish(DSSEvent evt) {
        DSSMetrics.registry().meter("dku.notifications.publish").mark();
        DSSMetrics.registry().meter("dku.notifications.publish." + evt.getName()).mark();
        try {
            for (DSSEventListener<? extends DSSEvent> listener : this.getListeners(evt.getName())) {
                DSSMetrics.registry().counter("dku.notifications.queue.size").inc();
                DSSMetrics.registry().counter("dku.notifications.queue." + evt.getName() + ".size").inc();
                this.dispatcherThread.submit(() -> {
                    block27: {
                        DSSMetrics.registry().counter("dku.notifications.queue.size").dec();
                        DSSMetrics.registry().counter("dku.notifications.queue." + evt.getName() + ".size").dec();
                        String listenerName = listener.getClass().getName().replace('.', '_').replace('$', '_');
                        try (DSSMetrics.TimeCtx ctx0 = DSSMetrics.timeCtx("dku.notifications.process.overall");
                             DSSMetrics.TimeCtx ctx1 = DSSMetrics.timeCtx("dku.notifications.process." + evt.getName());
                             DSSMetrics.TimeCtx ctx2 = DSSMetrics.timeCtx("dku.notifications.process." + evt.getName() + ".by." + listenerName);){
                            if (evt.shouldLog() && logger.isTraceEnabled()) {
                                logger.trace((Object)("Async dispatch of " + evt.getName() + " to " + listenerName));
                            }
                            DSSEventListener l = listener;
                            DKULogger.startCurrentCall();
                            try {
                                l.on(evt);
                            }
                            catch (Throwable throwable) {
                                long dispatchTime = DKULogger.endCurrentCall();
                                if (evt.shouldLog() && dispatchTime > 30L) {
                                    logger.debugV("Long dispatch evt=%s listener=%s time=%s", new Object[]{evt.getName(), listenerName, dispatchTime});
                                }
                                throw throwable;
                            }
                            long dispatchTime = DKULogger.endCurrentCall();
                            if (evt.shouldLog() && dispatchTime > 30L) {
                                logger.debugV("Long dispatch evt=%s listener=%s time=%s", new Object[]{evt.getName(), listenerName, dispatchTime});
                            }
                            if (TransactionContext.hasAttachedTransaction()) {
                                String msg = "Transaction leak in notification handler " + listener.getClass().getCanonicalName() + " for event " + evt.getName();
                                logger.error((Object)msg);
                                this.publish(new ReflectedEventEvent(new IReflectedEventsService.ReflectedEvent(msg)));
                            }
                        }
                        catch (WebSocketException t) {
                            logger.warn((Object)("Notification handling failure (Websocket) " + ExceptionUtils.getMessageWithCauses((Throwable)t)));
                        }
                        catch (Throwable t) {
                            logger.error((Object)"Notification handling failure", t);
                            if ("reflected-event".equals(evt.getName())) break block27;
                            this.publish(new ReflectedEventEvent(new IReflectedEventsService.ReflectedEvent("Notification handling failure", t)));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to publish notification", (Throwable)e);
        }
    }

    List<DSSEventListener<? extends DSSEvent>> getListeners(String notificationType) {
        return this.listeners.computeIfAbsent(notificationType, k -> new ArrayList());
    }

    void logNotification(String notificationType) {
        this.subscribe(notificationType, evt -> loggedEventLogger.info((Object)("Event: " + notificationType + ":" + JSON.json((Object)evt))));
    }
}

