/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public abstract class FileContentCompressor {
    public static final FileContentCompressor DEFLATE_COMPRESSOR = new FileContentCompressor(){

        @Override
        public InputStream uncompressStream(InputStream is) {
            return new InflaterInputStream(is);
        }

        @Override
        public OutputStream compressStream(OutputStream os) {
            Deflater deflater = new Deflater(1);
            return new DeflaterOutputStream(os, deflater);
        }

        @Override
        public String name() {
            return "deflate";
        }
    };
    public static final FileContentCompressor NOOP_COMPRESSOR = new FileContentCompressor(){

        @Override
        public InputStream uncompressStream(InputStream is) {
            return is;
        }

        @Override
        public OutputStream compressStream(OutputStream os) {
            return os;
        }

        @Override
        public String name() {
            return "noop";
        }
    };

    public abstract InputStream uncompressStream(InputStream var1) throws IOException;

    public abstract OutputStream compressStream(OutputStream var1) throws IOException;

    public abstract String name();

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] compressBytes(byte[] bytes) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                try (OutputStream os = this.compressStream(baos);){
                    IOUtils.copy((InputStream)bais, (OutputStream)os);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to compress data", e);
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] uncompressBytes(byte[] bytes, long expectedLength) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

