/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.coremodel.InfoMessage;
import org.springframework.http.HttpStatus;

public enum GitCodes implements InfoMessage.MessageCode
{
    ERR_REMOTE_GIT_FAILED_UNSPECIFIED("An error happened with the remote Git repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_LOCAL_GIT_FAILED_UNSPECIFIED("An error happened with the local Git repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_REVERT_FAILED_CONFLICT("Can't revert: conflict", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_REVERT_FAILED_MERGE_COMMIT("Can't revert merge commit", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_RESET_FAILED("Local repository could not be reset", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_CLEAN_FAILED("Local repository could not be cleaned", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_COMMIT_FAILED("Changes could not be committed", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_NO_HEAD("No HEAD exists on the Git repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_LIST_REFS_FAILED("Remote references can't be fetched", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_FETCH_FAILED("An error happened while fetching the repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_FAILED("An error happened while fetching the repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_CLONE_FAILED("An error happened while cloning the repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_PATH_INVALID("The given repository path is invalid", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_CHECKOUT_FAILED("An error happened while checking out the specified reference", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_PULL_FAILED("An error happened while pulling from the repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_BRANCH_CREATION_FAILED("An error happened while creating the specified branch", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_REV_PARSE_FAILED("An error happened while running rev-parse", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_REV_LIST_FAILED("An error happened while running rev-list", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_LOG_FAILED("An error happened while running log", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_BRANCH_UPSTREAM_FAILED("An error happened while setting upstream the specified branch", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_DELETE_UNMERGED_BRANCH_FAILED("The specified branch cannot be deleted as it contains unmerged changes.", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_ADD_REMOTE_FAILED("An error happened while adding a remote", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_REMOTE_SET_URL_FAILED("An error happened while setting the URL on a remote", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_RM_REMOTE_FAILED("An error happened while removing a remote", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_BRANCH_FAILED("An error happened with the git branching", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_PUSH_FAILED("An error happened while pushing", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_URL_DOES_NOT_MATCH_WHITELIST("The URL you are trying to clone does not match the instance whitelist", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_REBASE_FAILED("An error happened while rebasing", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PUSH_OK("Git push succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PUSH_CONFLICTING_FILE("File in conflict", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PULL_OK("Git pull succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_FETCH_OK("Git fetch succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_MERGED_OK("Git merge succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_RESET_OK("Git reset succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_CHECKOUT_BRANCH_OK("Git checkout succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_ALREADY_UP_TO_DATE("Already up to date", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_LIBRARY_STILL_HAVE_CONFLICT("Library still have conflict", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PULL_ABORT_OK("Git pull abort succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_INVALID_GIT_REF_PATH("Invalid Git reference path", InfoMessage.FixabilityCategory.USER_CONFIG),
    ERR_MALFORMED_EXT_LIBS_JSON("Malformed external libraries JSON file", InfoMessage.FixabilityCategory.DATA),
    ERR_MALFORMED_MERGE_REQUESTS_JSON("Malformed merge requests JSON file", InfoMessage.FixabilityCategory.DATA),
    INFO_GIT_REF_UPDATE_OK("Git reference update succeeded", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_REF_UPDATE_FAILED("Git reference update failed", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_LIST_FILES_FAILED("Git files cannot be listed", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PUSH_NOTEBOOK_OK("Successfully pushed the notebook", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PUSH_NOTEBOOK_NO_MODIFICATION("No modification were detected compared to the remote version, did not push the notebook", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PUSH_NOTEBOOK_ERROR("Failed to push the notebook", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PULL_NOTEBOOK_OK("Successfully pulled the notebook", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PULL_NOTEBOOK_NO_MODIFICATION("No modification were detected compared to the remote version, did not pull the notebook", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_PULL_NOTEBOOK_ERROR("Failed to pull the notebook", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_PROJECT_CHECKOUT_INVALID_PARAMS("Target branch does not contain a valid project configuration", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_MERGE_OK("Successfully merged", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_MERGE_UPDATE_OK("Successfully updated merge request", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_MERGE_REVERT_OK("Successfully reverted the merge", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_MERGE_REFRESH_MERGED_BRANCH_OK("Successfully refreshed the merged branch", InfoMessage.FixabilityCategory.IRRELEVANT),
    WARNING_GIT_MERGE_MERGING_BASE_CONFLICTS(HttpStatus.CONFLICT, "The final integration of the main branch encountered an issue, conflicting with the ongoing resolution of merge conflicts", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_CREATE_MERGE_REQUEST_NO_CHANGES(HttpStatus.FORBIDDEN, "Could not create merge request. No change to merge", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_MERGE_REQUEST_NOT_FOUND(HttpStatus.NOT_FOUND, "Could not find merge request", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_INIT_MERGE_REQUEST_DIRECTORY("Couldn't initialise the working directory", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_UNCOMMON_HISTORY("Couldn't initialise merge request as the two branches have no common history", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_INVALID_FILES("Couldn't initialise merge request as the branch to merge contains invalid file(s)", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_MERGING_STILL_CONFLICTS_UNRESOLVED("Some files still contain conflicts to resolve", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_PUSH_TO_ORIGIN_FAILED("The branch used during the merge request could not be pushed back to the base repository", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_MERGE_BRANCH_TO_BASE("The branch used during the merge request could not be merged to base branch", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_MERGE_BRANCH_DELETE_FAILED("The branch used during the merge request could not be deleted", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_REFRESH_MERGED_BRANCH_PUSHED_FAILED("The refresh of the branch to merged failed", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_SCENARIO_PERMISSION_ISSUE("Some scenarios are updating the 'run as' settings", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_WEBAPP_PERMISSION_ISSUE("Some webapps are updating the 'run as' settings", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_ADD_FILE_INVALID_FORMAT("File format is invalid", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_MERGE_ADD_FILE_INVALID_PARAMS_FORMAT("params.json file format is invalid", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_GIT_LOCAL_BRANCH_ALREADY_EXIST("A local branch already exists", InfoMessage.FixabilityCategory.IRRELEVANT),
    INFO_GIT_DUPLICATE_PROJECT_OK("Project duplicated with success", InfoMessage.FixabilityCategory.IRRELEVANT);

    private HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
    private final String title;
    private final InfoMessage.FixabilityCategory fixability;

    private GitCodes(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    private GitCodes(HttpStatus status, String title, InfoMessage.FixabilityCategory fixability) {
        this.status = status;
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }

    public HttpStatus getHttpStatus() {
        return this.status;
    }

    public void setStatus(HttpStatus status) {
        this.status = status;
    }
}

