/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt.devserver;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.engine.AsyncCloser;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.lambda.mgmt.IPackagesMgmtService;
import com.dataiku.dip.lambda.mgmt.LambdaServicesCRUDService;
import com.dataiku.dip.lambda.mgmt.devserver.LambdaDevServerKernel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LambdaDevServerService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LambdaServicesCRUDService crudService;
    @Autowired
    private IPackagesMgmtService packagerService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private IImpersonationResolverService impersonationService;
    private static final int KERNEL_CACHE_CLEANUP_PERIOD_SEC = 60;
    public static final String KERNEL_CACHE_IDLE_TIMEOUT_KEY = "dku.devLambdaServer.cache.idle.timeout.seconds";
    private static final int KERNEL_CACHE_IDLE_TIMEOUT_IN_SECONDS = 120;
    public static final String KERNEL_CACHE_ACCESS_TIMEOUT_KEY = "dku.devLambdaServer.cache.access.timeout.seconds";
    private static final int KERNEL_CACHE_ACCESS_TIMEOUT_IN_SECONDS = 1800;
    private final int kernelCacheIdleTimeout = DKUApp.getParams().getIntParam("dku.devLambdaServer.cache.idle.timeout.seconds", Integer.valueOf(120));
    private final int kernelCacheAccessTimeout = DKUApp.getParams().getIntParam("dku.devLambdaServer.cache.access.timeout.seconds", Integer.valueOf(1800));
    private final ConcurrentHashMap<String, LambdaDevServerKernel> kernelCache = new ConcurrentHashMap();
    private AsyncCloser asyncCloser = new AsyncCloser();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.devserver");

    @PostConstruct
    public void postConstruct() {
        logger.infoV("Scheduling periodic cleanup of Lambda dev servers every %d seconds", new Object[]{60});
        DKUExecutors.newNamedSingleDaemonThreadExecutor((String)"LambdaDevServers-cleanup").scheduleWithFixedDelay(this::cleanup, 60L, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        try {
            LambdaDevServerService lambdaDevServerService = this;
            synchronized (lambdaDevServerService) {
                int cleaned = 0;
                if (this.kernelCache.size() == 0) {
                    return;
                }
                logger.infoV("Running cache cleanup on Lambda dev servers. Existing kernels=%d, idle ttl=%d ms, access ttl=%d ms", new Object[]{this.kernelCache.size(), this.kernelCacheIdleTimeout * 1000, this.kernelCacheAccessTimeout * 1000});
                for (Map.Entry<String, LambdaDevServerKernel> entry : this.kernelCache.entrySet()) {
                    String key = entry.getKey();
                    LambdaDevServerKernel kernel = entry.getValue();
                    boolean shallRemove = false;
                    LambdaDevServerKernel lambdaDevServerKernel = kernel;
                    synchronized (lambdaDevServerKernel) {
                        if (LambdaDevServerKernel.KernelState.STOPPED.equals((Object)kernel.getState())) {
                            logger.infoV("Removing stopped dev lambda server kernel %s alive for %d ms", new Object[]{key, kernel.getAliveTimeMs()});
                            shallRemove = true;
                        } else if (kernel.unusedAndExpired(this.kernelCacheIdleTimeout * 1000)) {
                            logger.infoV("Removing dev lambda server kernel %s alive for %d ms, released since %d ms", new Object[]{key, kernel.getAliveTimeMs(), kernel.getTimeSinceLastAccessMs()});
                            shallRemove = true;
                        } else if (kernel.reachedAccessTimeout(this.kernelCacheAccessTimeout * 1000)) {
                            logger.warnV("Removing dev lambda server kernel %s alive for %d ms, last accessed %s ms ago, that has reached the access timeout %s ms. It is %s", new Object[]{key, kernel.getAliveTimeMs(), kernel.getTimeSinceLastAccessMs(), this.kernelCacheAccessTimeout * 1000, LambdaDevServerService.getCurrentlyUsedMessage(kernel)});
                            shallRemove = true;
                        } else if (kernel.getUsageCount() == 0) {
                            logger.infoV("Keeping dev lambda server kernel %s alive for %d ms, idle for %s ms", new Object[]{key, kernel.getAliveTimeMs(), kernel.getTimeSinceLastAccessMs()});
                        } else {
                            logger.infoV("Keeping dev lambda server kernel %s alive for %d ms, last accessed %s ms ago. It is %s", new Object[]{key, kernel.getAliveTimeMs(), kernel.getTimeSinceLastAccessMs(), LambdaDevServerService.getCurrentlyUsedMessage(kernel)});
                        }
                    }
                    if (!shallRemove) continue;
                    this.kernelCache.remove(key);
                    this.asyncCloser.close((AutoCloseable)((Object)kernel));
                    ++cleaned;
                }
                logger.infoV("Cache cleanup done on lambda dev servers. Cleaned kernels=%d, remaining kernels=%d", new Object[]{cleaned, this.kernelCache.size()});
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"Cleanup on dev lambda server cache manager failed", t);
        }
    }

    public void setAsyncCloser(AsyncCloser asyncCloser) {
        this.asyncCloser = asyncCloser;
    }

    private static String getCurrentlyUsedMessage(LambdaDevServerKernel kernel) {
        int usageCount = kernel.getUsageCount();
        if (usageCount == 1) {
            return "currently used by 1 process";
        }
        return String.format("currently used by %d processes", usageCount);
    }

    @Nonnull
    private String getKernelKey(AuthCtx authCtx, String projectKey, String targetUnixUser) {
        return new StringJoiner("__").add(authCtx.toString()).add(projectKey).add(targetUnixUser).toString();
    }

    @Nonnull
    public DevServerState getState(AuthCtx user, String projectKey) throws DKUSecurityException {
        DevServerState state = new DevServerState();
        String key = this.getKernelKey(user, projectKey, this.getTargetUnixUser(user, projectKey));
        LambdaDevServerKernel kernel = this.kernelCache.get(key);
        if (null != kernel) {
            state.status = kernel.getState();
            state.logTail = kernel.getLogTail();
            if (kernel.isStartingOrRunning()) {
                state.port = kernel.getPort();
            }
        } else {
            state.status = LambdaDevServerKernel.KernelState.STOPPED;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public LambdaDevServerKernel getOrCreateKernel(AuthCtx user, String projectKey) throws Exception {
        LambdaDevServerKernel kernel;
        String targetUnixUser = this.getTargetUnixUser(user, projectKey);
        String key = this.getKernelKey(user, projectKey, targetUnixUser);
        LambdaDevServerService lambdaDevServerService = this;
        synchronized (lambdaDevServerService) {
            kernel = this.kernelCache.get(key);
            if (kernel != null && !kernel.isAlive()) {
                logger.warnV("Found an existing dev lambda server kernel %s, but the API node is stopped. Recreating it", new Object[]{key});
                kernel.close();
                kernel = null;
            }
            if (kernel == null) {
                logger.infoV("Creating dev lambda server kernel %s", new Object[]{key});
                kernel = new LambdaDevServerKernel(user, projectKey, targetUnixUser);
                this.kernelCache.put(key, kernel);
                this.futureService.registerAndStartNoWait((FutureThreadBase)kernel.getLambdaDevServerFutureThread());
            }
        }
        kernel.waitStartedFixedPort();
        return kernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKernel(AuthCtx user, String projectKey) throws DKUSecurityException {
        String key = this.getKernelKey(user, projectKey, this.getTargetUnixUser(user, projectKey));
        LambdaDevServerService lambdaDevServerService = this;
        synchronized (lambdaDevServerService) {
            LambdaDevServerKernel kernel = this.kernelCache.get(key);
            if (null != kernel) {
                logger.infoV("Removing dev lambda server kernel %s", new Object[]{key});
                this.kernelCache.remove(key);
                kernel.stop();
            }
        }
    }

    @Nullable
    public String getTargetUnixUser(AuthCtx user, String projectKey) throws DKUSecurityException {
        UserImpersonationTarget targetUser;
        if (this.impersonationService.isEnabled() && null != (targetUser = this.impersonationService.getTargetUser(projectKey, user))) {
            return targetUser.unixUser;
        }
        return null;
    }

    public DeploymentResponse deployService_NT(String projectKey, String id, AuthCtx liu) throws Exception {
        LambdaService config;
        logger.info((Object)"Starting Lambda service deployment to dev");
        try (Transaction t = this.transactionService.beginRead();){
            config = this.crudService.getOrNull(projectKey, id);
            logger.info((Object)"Performing security checks");
            if (!((DSSAuthCtx)liu).getPermissions().mayWriteSafeCode()) {
                for (DSSLambdaEndpointConfig epConfig : config.endpoints) {
                    switch (epConfig.type) {
                        case CUSTOM_PREDICTION: 
                        case CUSTOM_R_PREDICTION: 
                        case PY_FUNCTION: 
                        case R_FUNCTION: {
                            throw new UnauthorizedException("This API service contains code-based endpoints. You are not authorized to test them in the development server. Use the API deployer to deploy them to a testing infrastructure", "apidesigner-forbidden-endpoint");
                        }
                    }
                }
            }
        }
        logger.info((Object)"Generating the API service package");
        AutoDelete destdir = DSSTempUtils.getTempFolder((String)"apinode-devserver-package", (String)(projectKey + "-" + liu.getIdentifier() + "-"));
        try {
            FutureResponse response;
            try (Transaction t = this.transactionService.beginRead();){
                response = this.packagerService.startGeneratingPackage((File)destdir, projectKey, config, List.of(), liu, true);
            }
            logger.info((Object)"Waiting for package");
            try {
                if (!response.hasResult) {
                    response = this.futureService.waitForFinalResponse(response.jobId);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to generate package", (Throwable)ex);
                DeploymentResponse ret = new DeploymentResponse();
                ret.error = new SerializedError((Throwable)ex, true);
                DeploymentResponse deploymentResponse = ret;
                if (destdir != null) {
                    destdir.close();
                }
                return deploymentResponse;
            }
            if (((InfoMessage.InfoMessages)response.result).anyFatal()) {
                DeploymentResponse ret = new DeploymentResponse();
                ret.error = new SerializedError((Throwable)((InfoMessage.InfoMessages)response.result).firstFatal().asCodedException(), true);
                DeploymentResponse deploymentResponse = ret;
                return deploymentResponse;
            }
            logger.info((Object)"Have package, deploying it");
            DeploymentResponse deploymentResponse = this.deployPackage(id, (File)destdir, liu, projectKey);
            return deploymentResponse;
        }
        finally {
            if (destdir != null) {
                try {
                    destdir.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentResponse deployPackage(String serviceId, File packageDir, AuthCtx user, String projectKey) throws Exception {
        DeploymentResponse ret = new DeploymentResponse();
        try {
            LambdaDevServerKernel kernel = this.getOrCreateKernel(user, projectKey);
            try (LambdaDevServerKernel.KernelHandle kernelHandle = kernel.startUsing();){
                LambdaDevServerKernel.LambdaDevServerAdminClient client = kernel.getAdminAPIClient();
                logger.info((Object)("Deploying package for " + serviceId + " from " + String.valueOf(packageDir)));
                logger.info((Object)"Destroying service if exists");
                client.deleteServiceIfExists(serviceId);
                logger.info((Object)"Creating service");
                client.createService(serviceId);
                logger.info((Object)"Importing generation");
                client.importGeneration(serviceId, packageDir);
                logger.info((Object)"Switch to it");
                client.switchToNewestGeneration(serviceId);
            }
        }
        catch (Exception e) {
            ret.error = new SerializedError((Throwable)e, true);
        }
        finally {
            ret.devServerState = this.getState(user, projectKey);
        }
        return ret;
    }

    public static class DevServerState {
        public LambdaDevServerKernel.KernelState status;
        public Integer port;
        SmartLogTail logTail;
    }

    public static class DeploymentResponse {
        public DevServerState devServerState;
        public SerializedError error;
    }
}

