/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.datadirectories.DataDirectoriesFootprintHierarchy;
import com.dataiku.dip.datadirectories.DataDirectoriesFootprintListingWalker;
import com.dataiku.dip.datadirectories.DataDirectoriesFootprintService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/directories-footprint"})
public class PublicAPIDataDirectoriesFootprintController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DataDirectoriesFootprintService dataDirectoriesFootprintService;
    @Autowired
    private ProjectsService projectsService;
    private static final String NEED_ADMIN_RIGHT = "You need admin rights to get directories footprints";

    @AuditedCall(value={"msgType", "project-directories-footprint-compute", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/projects/{projectKey}"}, method={RequestMethod.GET})
    @ResponseBody
    public void getProjectDataDirectoriesFootprint(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        DSSAuthCtx authCtx;
        if (!ProjectsService.isValidProjectKey((String)projectKey)) {
            throw new IllegalArgumentException("Invalid project key: " + projectKey);
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIDataDirectoriesFootprintController.writeJSON((HttpServletResponse)resp, (Object)this.dataDirectoriesFootprintService.getProjectFootprint(authCtx, projectKey));
    }

    @AuditedCall(value={"msgType", "projects-directories-footprint-compute", "summaryOnly", "${summaryOnly}"})
    @RequestMapping(value={"/projects"}, method={RequestMethod.GET})
    @ResponseBody
    public void getAllProjectsDataDirectoriesFootprint(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean summaryOnly) throws Exception {
        List projects;
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin((AuthCtx)authCtx, NEED_ADMIN_RIGHT);
            projects = this.projectsService.listProjectKeys();
        }
        PublicAPIDataDirectoriesFootprintController.writeJSON((HttpServletResponse)resp, (Object)this.dataDirectoriesFootprintService.getAllProjectsFootprint(authCtx, projects, summaryOnly));
    }

    @AuditedCall(value={"msgType", "orphan-projects-directories-footprint-compute", "summaryOnly", "${summaryOnly}"})
    @RequestMapping(value={"/orphan-projects"}, method={RequestMethod.GET})
    @ResponseBody
    public void getOrphanProjectsDataDirectoriesFootprint(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean summaryOnly) throws Exception {
        List projects;
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin((AuthCtx)authCtx, NEED_ADMIN_RIGHT);
            projects = this.projectsService.listProjectKeys();
        }
        PublicAPIDataDirectoriesFootprintController.writeJSON((HttpServletResponse)resp, (Object)this.dataDirectoriesFootprintService.getOrphanProjectsFootprint(authCtx, projects, summaryOnly));
    }

    @AuditedCall(value={"msgType", "unknown-directories-footprint-compute", "summaryOnly", "${summaryOnly}"})
    @RequestMapping(value={"/unknown"}, method={RequestMethod.GET})
    @ResponseBody
    public void getUnknownDataDirectoriesFootprint(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean summaryOnly) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin((AuthCtx)authCtx, NEED_ADMIN_RIGHT);
        }
        PublicAPIDataDirectoriesFootprintController.writeJSON((HttpServletResponse)resp, (Object)this.dataDirectoriesFootprintService.getUnknownFootprint(authCtx, summaryOnly));
    }

    @AuditedCall(value={"msgType", "all-dss-directories-footprint-compute"})
    @RequestMapping(value={"/all-dss"}, method={RequestMethod.GET})
    @ResponseBody
    public void getAllDSSDataDirectoriesFootprint(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List projects;
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin((AuthCtx)authCtx, NEED_ADMIN_RIGHT);
            projects = this.projectsService.listProjectKeys();
        }
        PublicAPIDataDirectoriesFootprintController.writeJSON((HttpServletResponse)resp, (Object)this.dataDirectoriesFootprintService.getAllDSSFootprint(authCtx, projects));
    }

    @AuditedCall(value={"msgType", "global-directories-footprint-compute"})
    @RequestMapping(value={"/global"}, method={RequestMethod.GET})
    @ResponseBody
    public void getGlobalDataDirectoriesFootprint(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin((AuthCtx)authCtx, NEED_ADMIN_RIGHT);
        }
        PublicAPIDataDirectoriesFootprintController.writeJSON((HttpServletResponse)resp, (Object)this.dataDirectoriesFootprintService.getGlobalFootprint(authCtx));
    }

    @AuditedCall(value={"msgType", "fake-directories-footprint-setup"})
    @RequestMapping(value={"/fake-fs-walk-with-datadir-listing"}, method={RequestMethod.POST})
    public void fakeFSWalk(HttpServletRequest req, @RequestParam String datadirListing, @RequestParam String datadirRoot) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin((AuthCtx)authCtx, "not-admin");
        }
        File datadirListingFile = new File(datadirListing);
        if (!datadirListingFile.exists() || !datadirListingFile.canRead()) {
            throw new IOException("Datadir listing " + datadirListing + " doesn't exist or can't be read");
        }
        DataDirectoriesFootprintHierarchy.forceDefaultWalker((DataDirectoriesFootprintHierarchy.Walker)new DataDirectoriesFootprintListingWalker(datadirListingFile, datadirRoot, DKUApp.getBaseFolder()));
    }

    @AuditedCall(value={"msgType", "fake-directories-footprint-teardown"})
    @RequestMapping(value={"/unfake-fs-walk-with-datadir-listing"}, method={RequestMethod.POST})
    public void unfakeFSWalk(HttpServletRequest req) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin((AuthCtx)authCtx, "not-admin");
        }
        DataDirectoriesFootprintHierarchy.forceDefaultWalker(null);
    }
}

