/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.licensing.MultiInstancesLicenseStatusComputer;
import com.dataiku.dip.server.services.licensing.RegistrationService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPILicensingController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private RegistrationService registrationService;

    @AuditedCall(value={"msgType", "admin-licensing-status-get"})
    @RequestMapping(value={"/publicapi/admin/licensing/status"}, method={RequestMethod.GET})
    public void getLicensingStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        LicensingFullStatus ret = new LicensingFullStatus();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ret.base = this.licenseStatusService.getLicensingStatus();
            ret.base.properties = null;
            ret.limits = this.licenseEnforcementService.getLimitsStatus();
            ret.features = this.licenseEnforcementService.getFeaturesStatus();
        }
        PublicAPILicensingController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "admin-licensing-set-license"})
    @RequestMapping(value={"/publicapi/admin/licensing/license"}, method={RequestMethod.POST})
    public void setLicense(HttpServletRequest req, HttpServletResponse resp, @RequestBody String license) throws Exception {
        logger.debugV("Setting DSS licence", new Object[0]);
        try (RWTransaction rw = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            License lic = (License)JSON.parse((String)RegistrationService.parseLicense((String)license), License.class);
            this.registrationService.setOfflineLicense(lic);
            rw.commit("Installed license");
        }
    }

    @AuditedCall(value={"msgType", "admin-licensing-status-get"})
    @RequestMapping(value={"/publicapi/admin/licensing/status-from-users"}, method={RequestMethod.POST})
    @ResponseBody
    public MultiInstancesLicenseStatusComputer.GlobalLicensingStatus getLicenseStatusFromUsersLists(HttpServletRequest req, HttpServletResponse resp, @RequestBody String query) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        logger.info((Object)"Computing license status for multiple instances");
        MultiInstancesLicenseStatusComputer.LicenseUsageComputeQuery queryObj = (MultiInstancesLicenseStatusComputer.LicenseUsageComputeQuery)JSON.parse((String)query, MultiInstancesLicenseStatusComputer.LicenseUsageComputeQuery.class);
        return new MultiInstancesLicenseStatusComputer().compute(queryObj);
    }

    static class LicensingFullStatus {
        LicenseStatusService.LicensingStatus base;
        LimitsStatusComputer.LicenseLimitsStatus limits;
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus features;

        LicensingFullStatus() {
        }
    }
}

