/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AnthropicConnection;
import com.dataiku.dip.connections.AzureAISearchConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.AzureLLMConnection;
import com.dataiku.dip.connections.AzureMLConnection;
import com.dataiku.dip.connections.AzureOpenAIConnection;
import com.dataiku.dip.connections.BedrockConnection;
import com.dataiku.dip.connections.CassandraConnection;
import com.dataiku.dip.connections.CohereConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.CustomLLMConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksLLMConnection;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.DynamoDBConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.HuggingFaceInferenceAPIConnection;
import com.dataiku.dip.connections.HuggingFaceLocalConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.connections.MistralAIConnection;
import com.dataiku.dip.connections.MongoDBConnection;
import com.dataiku.dip.connections.MosaicMLConnection;
import com.dataiku.dip.connections.NvidiaNimConnection;
import com.dataiku.dip.connections.OpenAIConnection;
import com.dataiku.dip.connections.PineconeConnection;
import com.dataiku.dip.connections.PostgreSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.connections.SageMakerConnection;
import com.dataiku.dip.connections.SageMakerGenericLLMConnection;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.connections.SnowflakeCortexLLMConnection;
import com.dataiku.dip.connections.TeradataConnection;
import com.dataiku.dip.connections.TwitterConnection;
import com.dataiku.dip.connections.VertexAILLMConnection;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsSynchronizer;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.llm.local.HuggingFaceKernelPool;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.connections.ConnectionsIndexingService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConnectionUsagesService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.TwitterConnectorsService;
import com.dataiku.dip.server.services.catalog.CatalogCodes;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ConnectionsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ConnectionsTestService connectionsTestService;
    @Autowired
    private ConnectionsIndexingService indexingService;
    @Autowired
    private TwitterConnectorsService twitterConnectorsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private ConnectionUsagesService connectionUsagesService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private HuggingFaceKernelPool hfKernelPool;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.controller");

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/connections/get-names"})
    public void listNames(HttpServletRequest req, HttpServletResponse resp, String type, @RequestParam(defaultValue="false", required=false) boolean checkAllowManagedFolders) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            List ret = this.connectionsDAO.getConnectionNames(type, liu, checkAllowManagedFolders);
            Collections.sort(ret);
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/connections/get-type-and-names"})
    public void listTypeAndNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionType, @RequestParam(defaultValue="false", required=false) boolean checkAllowManagedFolders) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            List ret = this.connectionsDAO.getConnectionTypesAndNames(connectionType, liu, checkAllowManagedFolders);
            Collections.sort(ret, new Comparator<ConnectionsDAO.ConnectionTypeAndName>(){

                @Override
                public int compare(ConnectionsDAO.ConnectionTypeAndName a, ConnectionsDAO.ConnectionTypeAndName b) {
                    int cmpType = a.type.compareTo(b.type);
                    if (cmpType != 0) {
                        return cmpType;
                    }
                    return a.name.compareTo(b.name);
                }
            });
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/connections/get-hive-names"})
    public void listHiveNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        ArrayList ret = Lists.newArrayList();
        if (HadoopLoader.hadoopEnabled()) {
            String clusterId = projectKey == null ? new ClusterSelector().selectGlobal().getClusterId() : new ClusterSelector().selectForProject(authCtx, projectKey).getClusterId();
            ret.addAll(this.metastoreInspectionService.newInspector(authCtx, projectKey).listHiveDatabase(clusterId, "default", authCtx, projectKey));
        }
        Collections.sort(ret);
        ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "connection-sql-list-tables", "connectionName", "${connectionName}", "catalog", "${catalog}", "schema", "${schema}"})
    @RequestMapping(value={"/api/connections/list-sql-tables"})
    public void listSQLTables(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String connectionName, @RequestParam(required=false) String catalog, @RequestParam(required=false) String schema) throws Exception {
        DSSConnection conn;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            conn = this.connectionsDAO.getMandatoryConnection(liu, connectionName);
            if (!conn.isFreelyUsableBy(liu)) {
                throw new SecurityException("You may not list tables on connection " + connectionName);
            }
        }
        catalog = StringUtils.defaultIfBlank((String)catalog, null);
        schema = StringUtils.defaultIfBlank((String)schema, null);
        List res = this.connectionsService.listSQLTableForConnection(conn, liu, projectKey, catalog, schema);
        ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "connection-sql-list-tables", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/api/connections/list-sql-tables-from-project"})
    public void listSQLTablesFromProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionName, @RequestParam String projectKey) throws Exception {
        ErrorContext.checkNotEmpty((String)connectionName, (String)"connection name");
        ErrorContext.checkNotEmpty((String)projectKey, (String)"projectKey");
        ArrayList<ConnectionsService.SQLTableWithQuotedNameAndDataset> tables = new ArrayList<ConnectionsService.SQLTableWithQuotedNameAndDataset>();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            AuthCtx liu = this.authService.getMandatoryUser(req);
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(liu, connectionName);
            if (!conn.isFreelyUsableBy(liu)) {
                throw new SecurityException("You may not list tables on connection " + connectionName);
            }
            if (conn instanceof MetastoreDBBasedConnection) {
                MetastoreDBBasedConnection hconn = (MetastoreDBBasedConnection)conn;
                HiveSQLDialect dialect = new HiveSQLDialect();
                String connectionHiveDb = HiveSchemaHandler.getHiveDatabaseFromVirtualConnection((MetastoreDBBasedConnection)hconn);
                logger.infoV("Listing datasets of project %s in virtual connection %s (hive db: %s)", new Object[]{projectKey, connectionName, connectionHiveDb});
                for (SerializedDataset sds : this.datasetsDAO.listUnsafe(projectKey)) {
                    if (!DatasetInspector.canHiveTable((SerializedDataset)sds)) continue;
                    try {
                        SQLUtils.SQLTable datasetHiveTable = HiveSchemaHandler.getResolvedHiveTableRefFromDataset((Dataset)Dataset.fromSerializedUnsafe((SerializedDataset)sds));
                        logger.infoV(" dataset %s database %s", new Object[]{sds.name, datasetHiveTable.getSchemaNullIfBlank()});
                        if (!connectionHiveDb.equals(datasetHiveTable.getSchemaNullIfBlank())) continue;
                        tables.add(new ConnectionsService.SQLTableWithQuotedNameAndDataset(null, connectionHiveDb, datasetHiveTable.getTable(), sds.name, (SQLDialect)dialect, true));
                    }
                    catch (IllegalArgumentException e) {
                        logger.infoV(" did not find Hive table for " + sds.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
                    }
                }
            } else {
                AbstractSQLConnection sqlConnection = SQLConnectionProvider.getDSSConnection((AuthCtx)liu, (String)connectionName);
                SQLDialect dialect = sqlConnection.getDialect();
                for (SerializedDataset sds : this.datasetsDAO.listUnsafe(projectKey)) {
                    if (!(sds.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig)) continue;
                    AbstractSQLDatasetHandler.AbstractSQLConfig config = ((AbstractSQLDatasetHandler.AbstractSQLConfig)sds.getParams()).getResolved(projectKey);
                    if (config.connection == null || !config.connection.equals(connectionName) || StringUtils.isBlank((String)config.table)) continue;
                    try {
                        String catalog = null;
                        if (StringUtils.isNotBlank((String)config.schema)) {
                            catalog = StringUtils.isNotBlank((String)config.catalog) ? config.catalog : sqlConnection.getDefaultCatalog();
                        }
                        tables.add(new ConnectionsService.SQLTableWithQuotedNameAndDataset(catalog, config.schema, config.table, sds.name, dialect, true));
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn((Object)e);
                    }
                }
            }
        }
        ConnectionsController.writeJSON((HttpServletResponse)resp, tables);
    }

    @AuditedCall(value={"msgType", "connection-sql-list-tables", "connectionName", "${connection}"})
    @RequestMapping(value={"/api/connections/get-sql-table-mapping"})
    public void tableDatasetMapping(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connection) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)this.connectionsService.getTableDatasetMapping(authCtx, connection));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/connections/get-twitter-config"})
    public void getActiveTwitterConnection(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)this.twitterConnectorsService.getConfig());
        }
    }

    @AuditedCall(value={"msgType", "get-default-assumed-timezone", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/api/connections/get-default-assumed-timezone"})
    public void getDefaultAssumedTimezone(HttpServletRequest req, HttpServletResponse resp, String connectionName) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(liu, connectionName);
            HashMap<String, String> output = new HashMap<String, String>();
            if (conn instanceof AbstractSQLConnection) {
                AbstractSQLConnection sqlConnection = (AbstractSQLConnection)conn;
                output.put("defaultAssumedTzForUnknownTz", sqlConnection.getParams().defaultAssumedTzForUnknownTz);
                if (sqlConnection instanceof TeradataConnection) {
                    output.put("defaultAssumedDbTzForUnknownTz", ((TeradataConnection)conn).params.defaultAssumedDbTzForUnknownTz);
                }
            }
            ConnectionsController.writeJSON((HttpServletResponse)resp, output);
        }
    }

    @AuditedCall(value={"msgType", "connection-twitter-set-active", "connectionName", "${name}"})
    @RequestMapping(value={"/api/admin/connections/set-active-twitter-connection"})
    public void setActiveTwitterConnection(HttpServletRequest req, HttpServletResponse resp, String name) throws IOException, DKUSecurityException {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            String connName = this.twitterConnectorsService.getConfig().connection;
            if (name.equals(connName)) {
                ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)true);
                return;
            }
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(liu, name);
            if (conn instanceof TwitterConnection) {
                this.twitterConnectorsService.setActiveConnection(name);
                ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)true);
            } else {
                ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)false);
            }
            t.commit("Set active Twitter connection to " + name);
        }
    }

    @AuditedCall(value={"msgType", "connection-sql-list-fields", "connectionName", "${name}"})
    @RequestMapping(value={"/api/connections/list-sql-fields"})
    public void listSQLFields(HttpServletRequest req, HttpServletResponse resp, String projectKey, String name, String tables) throws Exception {
        DSSConnection conn;
        AuthCtx liu;
        ConnectionsService.FieldsRequest fr = (ConnectionsService.FieldsRequest)JSON.parse((String)tables, ConnectionsService.FieldsRequest.class);
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            conn = this.connectionsDAO.getMandatoryConnection(liu, name);
            if (!conn.isFreelyUsableBy(liu)) {
                throw new SecurityException("You may not list tables on connection " + name);
            }
        }
        List res = this.connectionsService.listSQLFields(conn, fr, liu, projectKey);
        ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/connections/list-connections-for-thirdparty-logging"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ConnectionsDAO.CloudStorageConnectionWithPredictionLogsRoot> listCloudStorageConnectionWithPredictionLogsRoot(HttpServletRequest req, @RequestParam String type, @RequestParam(defaultValue="false", required=false) boolean checkAllowManagedFolders) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            List list = this.connectionsDAO.listCloudStorageConnectionWithPredictionLogsRoot(type, liu, checkAllowManagedFolders);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "admin-connections-list"})
    @RequestMapping(value={"/api/admin/connections/list"})
    public void adminList(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Map<String, DSSConnection> connections;
        block10: {
            connections = new HashMap();
            try (Transaction t = this.transactionService.beginRead();){
                DSSAuthCtx liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                if (this.permissionsService.isAdmin((AuthCtx)liu)) {
                    connections = this.connectionsDAO.list();
                    break block10;
                }
                if (liu.getPermissions().mayCreateAuthenticatedConnections()) {
                    for (Map.Entry c : this.connectionsDAO.list().entrySet()) {
                        DSSConnection connection = (DSSConnection)c.getValue();
                        if (connection.owner == null || !connection.owner.equals(liu.getIdentifier())) continue;
                        connections.put((String)c.getKey(), connection);
                    }
                    break block10;
                }
                throw new SecurityException("You do not have required privileges");
            }
        }
        Map<String, ConnectionMetadataDAO.ConnectionMetadataWithState> cmws = this.indexingService.getAllMetadataWithState();
        for (Map.Entry e : connections.entrySet()) {
            ((DSSConnection)e.getValue()).indexingMetadata = cmws.get(e.getKey());
        }
        ConnectionsController.writeJSON((HttpServletResponse)resp, connections);
    }

    @AuditedCall(value={"msgType", "admin-connections-list"})
    @RequestMapping(value={"/api/admin/connections/list-hive-virtual"})
    public void adminListVirtualHive(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Map<String, ConnectionMetadataDAO.ConnectionMetadataWithState> cmws = this.indexingService.getAllMetadataWithState();
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        HashMap<CallSite, DSSConnection> result = new HashMap<CallSite, DSSConnection>();
        for (String db : this.indexingService.getHiveDatabases_NT(authCtx)) {
            String name = "@virtual(hive-jdbc):" + db;
            DSSConnection connection = this.connectionsDAO.getConnection(authCtx, name);
            connection.indexingMetadata = cmws.get(name);
            result.put((CallSite)((Object)name), connection);
        }
        ConnectionsController.writeJSON((HttpServletResponse)resp, result);
    }

    @AuditedCall(value={"msgType", "admin-connections-metadata"})
    @RequestMapping(value={"/api/admin/connections/metadata"})
    public void getConnectionsMetadata(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        ConnectionsController.writeJSON((HttpServletResponse)resp, this.indexingService.getAllMetadataWithState());
    }

    @AuditedCall(value={"msgType", "admin-connections-scan"})
    @RequestMapping(value={"/api/admin/connections/scan"})
    public void startScan(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        AuthCtx liu;
        Set connections = (Set)JSON.parse((String)data, (TypeToken)new TypeToken<Set<String>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(liu);
        }
        ConnectionsController.writeJSON((HttpServletResponse)resp, this.indexingService.startScanAndIndex(connections, liu));
    }

    @AuditedCall(value={"msgType", "admin-connections-abort-indexation"})
    @RequestMapping(value={"/api/admin/connections/abort-indexation"})
    public void abortIndexation(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(liu);
        }
        this.indexingService.abortAllIndexation(liu);
        ConnectionsController.writeJSON((HttpServletResponse)resp, this.indexingService.getAllMetadataWithState());
    }

    @AuditedCall(value={"msgType", "admin-connections-index"})
    @RequestMapping(value={"/api/admin/connections/index"})
    public void index(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        AuthCtx user;
        HashSet<String> connections = StringUtils.isNotBlank((String)data) ? (Set)JSON.parse((String)data, (TypeToken)new TypeToken<Set<String>>(){}) : new HashSet<String>();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        ConnectionsController.writeJSON((HttpServletResponse)resp, this.indexingService.startIndex(connections, user));
    }

    @AuditedCall(value={"msgType", "admin-connections-list"})
    @RequestMapping(value={"/api/admin/connections/list-indexable-connections"})
    public void listIndexableConnections(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String data) throws Exception {
        HashSet selectedConnections;
        Set set = selectedConnections = StringUtils.isNotBlank((String)data) ? (Set)JSON.parse((String)data, (TypeToken)new TypeToken<Set<String>>(){}) : new HashSet();
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.catalog.enabled", true)) {
            ConnectionsIndexingService.ListIndexableConnectionsResponse ret = new ConnectionsIndexingService.ListIndexableConnectionsResponse();
            ret.messages.withWarning((InfoMessage.MessageCode)CatalogCodes.WARN_CATALOG_DISABLED, "Catalog indexing is disabled, check dku.catalog.enabled parameter in your configuration");
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        } else {
            AuthCtx user;
            try (Transaction t = this.transactionService.beginRead();){
                user = this.authService.getMandatoryUser(req);
                this.permissionsService.checkAdmin(user);
            }
            ConnectionsIndexingService.ListIndexableConnectionsResponse ret = this.indexingService.getIndexableConnections_NT(user);
            if (!selectedConnections.isEmpty()) {
                ret.scannableConnections = Sets.intersection(ret.scannableConnections, selectedConnections);
                ret.indexableConnections = Sets.intersection(ret.indexableConnections, selectedConnections);
            }
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "connections-list-names"})
    @RequestMapping(value={"/api/connections/count-indexed-and-unindexed"})
    public void countIndexedAndUnindexed(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)this.indexingService.countIndexedAndUnindexed_NT(user));
    }

    @AuditedCall(value={"msgType", "admin-connection-get", "connectionName", "${name}"})
    @RequestMapping(value={"/api/admin/connections/get"})
    public void adminGet(HttpServletRequest req, HttpServletResponse resp, String name) throws IOException, UnauthorizedException {
        block10: {
            this.checkNotBlank(name, "Connection name not specified", new Object[0]);
            try (Transaction t = this.transactionService.beginRead();){
                DSSAuthCtx liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                DSSConnection c = (DSSConnection)this.connectionsDAO.listUnsafe().get(name);
                if (c == null) {
                    throw new NotFoundException("Connection does not exist: " + name);
                }
                if (this.permissionsService.isAdmin((AuthCtx)liu)) {
                    ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)c);
                    break block10;
                }
                if (liu.getPermissions().mayCreateAuthenticatedConnections()) {
                    if (c.owner != null && c.owner.equals(liu.getIdentifier())) {
                        ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)c);
                        break block10;
                    }
                    throw new SecurityException("You do not have required privileges on this connection");
                }
                throw new SecurityException("You do not have required privileges");
            }
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/save"})
    public void adminSave(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(defaultValue="false") boolean creation) throws Exception {
        DSSConnection c = (DSSConnection)JSON.parse((String)data, DSSConnection.class);
        String name = c.name;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.connectionsService.save(liu, c, creation);
            t.commit("Saved connection: " + name);
            this.auditTrailService.generic("admin-connection-save").with("connectionName", name).with("connectionType", c.type).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-connection-save", (Throwable)e).with("connectionName", name).with("connectionType", c.type).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-connection-delete", "connectionName", "${name}"})
    @RequestMapping(value={"/api/admin/connections/delete"})
    public void adminDelete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        List connections = (List)JSON.parse((String)data, (TypeToken)new TypeToken<List<String>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.connectionsService.delete(connections, t.getUser());
            t.commit("Deleted a connection: " + data);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-sql"})
    @ResponseBody
    public ConnectionsTestService.SQLConnectionTestResult adminTestSQL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(required=false) String massImportTargetProjectKey) throws Exception {
        ConnectionsTestService.SQLConnectionTestResult res;
        try {
            AbstractSQLConnection connection = this.parseConnection(data, AbstractSQLConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testSQL_NOTRANSACTION(massImportTargetProjectKey, connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.SQLConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-sql").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-postgresql"})
    @ResponseBody
    public ConnectionsTestService.SQLConnectionTestResult adminTestPostgreSQL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        ConnectionsTestService.SQLConnectionTestResult res;
        try {
            PostgreSQLConnection connection = this.parseConnection(data, PostgreSQLConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testPostgreSQL(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.SQLConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-postgresql").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-ec2"})
    @ResponseBody
    public ConnectionsTestService.EC2LikeConnectionTestResult adminTestEC2(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.EC2LikeConnectionTestResult res;
        try {
            EC2Connection connection = this.parseConnection(data, EC2Connection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testEC2(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.EC2LikeConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-ec2").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-databricks-volume"})
    @ResponseBody
    public ConnectionsTestService.DatabricksLikeConnectionTestResult adminTestDatabricksVolume(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.DatabricksLikeConnectionTestResult res;
        try {
            DatabricksVolumeConnection connection = this.parseConnection(data, DatabricksVolumeConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testDatabricksVolume(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.DatabricksLikeConnectionTestResult.error((String)ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        this.auditTrailService.generic("connection-test-ec2").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-sagemaker"})
    @ResponseBody
    public ConnectionsTestService.EC2LikeConnectionTestResult adminTestSageMaker(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.EC2LikeConnectionTestResult res;
        try {
            SageMakerConnection connection = this.parseConnection(data, SageMakerConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testSageMaker_NT(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.EC2LikeConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-sagemaker").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-gcs"})
    @ResponseBody
    public ConnectionsTestService.GCSLikeConnectionTestResult adminTestGCS(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.GCSLikeConnectionTestResult res;
        try {
            GCSConnection connection = this.parseConnection(data, GCSConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testGCS(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.GCSLikeConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-gcs").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-sharepointonline"})
    @ResponseBody
    public ConnectionsTestService.SharePointOnlineLikeConnectionTestResult adminTestSharePointOnline(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.SharePointOnlineLikeConnectionTestResult res;
        try {
            SharePointOnlineConnection connection = this.parseConnection(data, SharePointOnlineConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testSharePointOnline(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.SharePointOnlineLikeConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-sharepointonline").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-vertexaimodeldeployment"})
    @ResponseBody
    public ConnectionsTestService.GCSLikeConnectionTestResult adminTestVertexAIModelDeployment(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.GCSLikeConnectionTestResult res;
        try {
            VertexAIModelDeploymentConnection connection = this.parseConnection(data, VertexAIModelDeploymentConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testVertexAIModelDeployment(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.GCSLikeConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-vertexai").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-databricksmodeldeployment"})
    @ResponseBody
    public ConnectionsTestService.DatabricksModelDeploymentConnectionTestResult adminTestDatabricksModelDeployment(HttpServletRequest req, String data) throws Exception {
        ConnectionsTestService.DatabricksModelDeploymentConnectionTestResult res;
        try {
            DatabricksModelDeploymentConnection connection = this.parseConnection(data, DatabricksModelDeploymentConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testDatabricksModelDeployment(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.DatabricksModelDeploymentConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-databricks").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-azure"})
    @ResponseBody
    public ConnectionsTestService.AzureLikeConnectionTestResult adminTestAzure(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.AzureLikeConnectionTestResult res;
        try {
            AzureConnection connection = this.parseConnection(data, AzureConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testAzure(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.AzureLikeConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-azure").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-azureml"})
    @ResponseBody
    public ConnectionsTestService.AzureLikeConnectionTestResult adminTestAzureML(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.AzureLikeConnectionTestResult res;
        try {
            AzureMLConnection connection = this.parseConnection(data, AzureMLConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testAzureML_NT(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.AzureLikeConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-azureml").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-twitter"})
    @ResponseBody
    public ConnectionsTestService.TwitterTestResult adminTestTwitter(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.TwitterTestResult res;
        try {
            TwitterConnection connection = this.parseConnection(data, TwitterConnection.class);
            this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testTwitter(connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.TwitterTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-twitter").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-pinecone"})
    @ResponseBody
    public ConnectionsTestService.VectorStoreConnectionTestResult adminTestPinecone(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.VectorStoreConnectionTestResult res;
        try {
            PineconeConnection connection = this.parseConnection(data, PineconeConnection.class);
            this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testPinecone(connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.VectorStoreConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-pinecone").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-azureaisearch"})
    @ResponseBody
    public ConnectionsTestService.VectorStoreConnectionTestResult adminTestAzureAISearch(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.VectorStoreConnectionTestResult res;
        try {
            AzureAISearchConnection connection = this.parseConnection(data, AzureAISearchConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testAzureAISearch(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.VectorStoreConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-azureaisearch").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-openai"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestOpenAI(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            OpenAIConnection connection = this.parseConnection(data, OpenAIConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testOpenAI(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-openai").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-azure-openai"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestAzureOpenAI(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            AzureOpenAIConnection connection = this.parseConnection(data, AzureOpenAIConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testAzureOpenAI(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-azure-openai").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-nvidia-nim"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestNvidiaNim(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            NvidiaNimConnection connection = this.parseConnection(data, NvidiaNimConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testNvidiaNim(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-nvidia-nim").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-cohere"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestCohere(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            CohereConnection connection = this.parseConnection(data, CohereConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testCohere(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-cohere").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-mistralai"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestMistralAI(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            MistralAIConnection connection = this.parseConnection(data, MistralAIConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testMistralAI(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-mistralai").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-anthropic"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestAnthropic(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            AnthropicConnection connection = this.parseConnection(data, AnthropicConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testAnthropic(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-anthropic").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-bedrock"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestBedrock(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            BedrockConnection connection = this.parseConnection(data, BedrockConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testBedrock(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-bedrock").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-sagemaker-generic-llm"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestSageMakerGenericLLM(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            SageMakerGenericLLMConnection connection = this.parseConnection(data, SageMakerGenericLLMConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testSageMakerGenericLLM(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-sagemaker-generic-llm").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-azure-llm"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestAzureLLM(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            AzureLLMConnection connection = this.parseConnection(data, AzureLLMConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testAzureLLM(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-azure-llm").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-mosaicml"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestMosaic(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            MosaicMLConnection connection = this.parseConnection(data, MosaicMLConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testMosaic(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-mosaicml").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-vertexaillm"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestVertexAILLM(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            VertexAILLMConnection connection = this.parseConnection(data, VertexAILLMConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testVertexAILLM(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-vertex").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-databricksllm"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestDatabricksLLM(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            DatabricksLLMConnection connection = this.parseConnection(data, DatabricksLLMConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testDatabricksLLM(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-databricksllm").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-snowflakecortex"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestSnowflakeCortex(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            SnowflakeCortexLLMConnection connection = this.parseConnection(data, SnowflakeCortexLLMConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testSnowflakeCortexLLM(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-snowflakecortex").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-customllm"})
    @ResponseBody
    public ConnectionsTestService.LLMConnectionTestResult adminTestCustomLLM(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.LLMConnectionTestResult res;
        try {
            CustomLLMConnection connection = this.parseConnection(data, CustomLLMConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testCustomLLM(connection, authCtx);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.LLMConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-customllm").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-hugging-face"})
    @ResponseBody
    public ConnectionsTestService.HuggingFaceTestResult adminTestHuggingFace(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.HuggingFaceTestResult res;
        try {
            HuggingFaceInferenceAPIConnection connection = this.parseConnection(data, HuggingFaceInferenceAPIConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testHuggingFace(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.HuggingFaceTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-hugging-face").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-kafka"})
    @ResponseBody
    public ConnectionsTestService.KafkaTestResult adminTestKafka(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.KafkaTestResult res;
        try {
            KafkaConnection connection = this.parseConnection(data, KafkaConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testKafka(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.KafkaTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-kafka").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-ksql"})
    @ResponseBody
    public ConnectionsTestService.KsqlTestResult adminTestKsql(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.KsqlTestResult res;
        try {
            KafkaConnection connection = this.parseConnection(data, KafkaConnection.class);
            this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testKsql(connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.KsqlTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-ksql").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-sqs"})
    @ResponseBody
    public ConnectionsTestService.SQSTestResult adminTestSQS(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        ConnectionsTestService.SQSTestResult res;
        try {
            SQSConnection connection = this.parseConnection(data, SQSConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testSQS(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.SQSTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-sqs").emit();
        return res;
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/connections/test-elasticsearch"})
    @ResponseBody
    public ConnectionsTestService.ElasticSearchConnectionTestResult adminTestElasticSearch(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        ConnectionsTestService.ElasticSearchConnectionTestResult res;
        try {
            ElasticSearchConnection connection = this.parseConnection(data, ElasticSearchConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testElasticSearch(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.ElasticSearchConnectionTestResult.error((Exception)e);
        }
        this.auditTrailService.generic("connection-test-elasticsearch").emit();
        return res;
    }

    @AuditedCall(value={"msgType", "connection-test-mongodb"})
    @RequestMapping(value={"/api/admin/connections/test-mongodb"})
    @ResponseBody
    public ConnectionsTestService.MongoDBConnectionTestResult adminTestMongoDB(HttpServletRequest req, HttpServletResponse resp, String data, Integer sequenceId) throws IOException {
        ConnectionsTestService.MongoDBConnectionTestResult res;
        try {
            MongoDBConnection connection = this.parseConnection(data, MongoDBConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testMongoDB(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.MongoDBConnectionTestResult.configError((String)ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        res.sequenceId = sequenceId;
        this.auditTrailService.generic("connection-test-mongodb").emit();
        return res;
    }

    @AuditedCall(value={"msgType", "connection-test-dynamodb"})
    @RequestMapping(value={"/api/admin/connections/test-dynamodb"})
    @ResponseBody
    public ConnectionsTestService.DynamoDBConnectionTestResult adminTestDynamoDB(HttpServletRequest req, HttpServletResponse resp, String data, Integer sequenceId) throws IOException {
        ConnectionsTestService.DynamoDBConnectionTestResult res;
        try {
            DynamoDBConnection connection = this.parseConnection(data, DynamoDBConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testDynamoDB(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.DynamoDBConnectionTestResult.configError((String)ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        res.sequenceId = sequenceId;
        this.auditTrailService.generic("connection-test-dynamodb").emit();
        return res;
    }

    @AuditedCall(value={"msgType", "connection-test-cassandra"})
    @RequestMapping(value={"/api/admin/connections/test-cassandra"})
    @ResponseBody
    public ConnectionsTestService.CassandraConnectionTestResult adminTestCassandra(HttpServletRequest req, HttpServletResponse resp, String data) throws IOException {
        ConnectionsTestService.CassandraConnectionTestResult res;
        try {
            CassandraConnection connection = this.parseConnection(data, CassandraConnection.class);
            AuthCtx authCtx = this.authenticateAndPrepareConnection(req, (DSSConnection)connection);
            res = this.connectionsTestService.testCassandra(authCtx, connection);
        }
        catch (RuntimeException e) {
            res = ConnectionsTestService.CassandraConnectionTestResult.configError((String)ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        this.auditTrailService.generic("connection-test-cassandra").emit();
        return res;
    }

    @AuditedCall(value={"msgType", "connection-list-presets-huggingface"})
    @RequestMapping(value={"/api/admin/connections/list-presets-huggingface"})
    public void listHuggingFaceModelPresets(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HuggingFaceLocalConnection.HFLocalPresetsConfig hfLocalPresetsConfig = HuggingFaceLocalConnection.HFLocalPresetsConfig.load();
        ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)hfLocalPresetsConfig);
    }

    @RequestMapping(value={"/api/admin/connections/huggingface-kernels-status"})
    @ResponseBody
    public HuggingFaceKernelPool.HFStatusDump getHfKernelStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.hfKernelPool.dumpConnection(connectionName);
    }

    @AuditedCall(value={"msgType", "huggingface-kernel-get-log", "kernelId", "${kernelId}"})
    @RequestMapping(value={"/api/admin/connections/huggingface-kernels-logs"})
    @ResponseBody
    public SmartLogTail dumpLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="") String kernelId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.hfKernelPool.getKernelLogs(kernelId);
    }

    @AuditedCall(value={"msgType", "huggingface-kernel-kill-kernel", "kernelId", "${kernelId}"})
    @RequestMapping(value={"/api/admin/connections/huggingface-kill-kernel"})
    public void killKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String kernelId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        this.hfKernelPool.killKernel(kernelId, KernelPool.DeathReason.USER_REQUEST);
    }

    @AuditedCall(value={"msgType", "admin-connection-hdfs-resync-permissions", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/api/admin/connections/hdfs/resync-permissions"})
    public void resyncHDFSPermissions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            HDFSPermissionsSynchronizer sync = new HDFSPermissionsSynchronizer();
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)sync.startSetPermissionsOnConnectionDatasets(authCtx, connectionName));
        }
    }

    @AuditedCall(value={"msgType", "admin-connection-hdfs-resync-permissions", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/api/admin/connections/hdfs/resync-root-permissions"})
    public void resyncHDFSRootPermissions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            HDFSPermissionsSynchronizer sync = new HDFSPermissionsSynchronizer();
            ConnectionsController.writeJSON((HttpServletResponse)resp, (Object)sync.startSetPermissionsOnConnectionRoot(authCtx, connectionName));
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/connections/list-usages"})
    public void listUsages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ConnectionsController.writeJSON((HttpServletResponse)resp, this.connectionUsagesService.listUsages(authCtx, projectKey, false).values());
        }
    }

    private <T extends DSSConnection> T parseConnection(String data, Class<T> expectedClass) {
        DSSConnection connection = (DSSConnection)JSON.parse((String)data, DSSConnection.class);
        this.checkNotNull(connection, "Connection not specified", new Object[0]);
        if (!expectedClass.isAssignableFrom(connection.getClass())) {
            throw ErrorContext.iaef((String)"Expected %s type, got: %s", (Object)expectedClass.getName(), (Object[])new Object[]{connection.getType()});
        }
        return (T)connection;
    }

    private AuthCtx authenticateAndPrepareConnection(HttpServletRequest req, DSSConnection connection) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            connection.name = StringUtils.isBlank((String)connection.name) ? "connection-being-tested" : connection.name;
            connection.expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(this.variablesService.getForGlobalAndUserLogin(authCtx));
            this.connectionsService.failIfCannotSaveConnection(authCtx, connection);
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }
}

