/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.internal;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.coremodel.Checklist;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionDataset;
import com.dataiku.dip.datacollections.DataCollectionsByItem;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.docportal.PythonDocPortalService;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelComparisonsCRUDService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.recipes.CodeRecipeParams;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DataStewardService;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.CatalogFlushRequestedEvent;
import com.dataiku.dip.server.notifications.backend.DataCollectionChangedEvent;
import com.dataiku.dip.server.notifications.backend.DatasetChangedEvent;
import com.dataiku.dip.server.notifications.backend.DatasetChartsChangedEvent;
import com.dataiku.dip.server.notifications.backend.DebugForceIndexProjectEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionClosedEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionDeletedEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionImportEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionReplyEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionUpdateEvent;
import com.dataiku.dip.server.notifications.backend.MeaningChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.LuceneDocBuilder;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.internal.InternalDataCatalogHelper;
import com.dataiku.dip.server.services.catalog.internal.InternalDataCatalogService;
import com.dataiku.dip.server.services.projects.ProjectFeaturesUsageService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.expr.CreateColumnWithGREL;
import com.dataiku.dip.shaker.processors.expr.FilterAndFlagOnCustomFormulaResult;
import com.dataiku.dip.shaker.processors.expr.GrokProcessor;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfDesc;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfRule;
import com.dataiku.dip.shaker.processors.udf.PythonParameter;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DebounceExecutor;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class InternalCatalogIndexingQueueHandler
extends AbstractIndexingQueueHandler {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private MeaningsService meaningsService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private ModelComparisonsCRUDService modelComparisonsCRUDService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private ProjectFeaturesUsageService projectFeaturesUsageService;
    @Autowired
    private DataCollectionsService dataCollectionService;
    @Autowired
    private DataStewardService dataStewardService;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    @Qualifier(value="internalMappingsAnalyzer")
    private LuceneMappingsAnalyzer internalLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="columnMappingsAnalyzer")
    private LuceneMappingsAnalyzer columnLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="internalIndexManager")
    private LuceneIndexManager internalIndexManager;
    @Autowired
    @Qualifier(value="columnIndexManager")
    private LuceneIndexManager columnIndexManager;
    private static final int INITIAL_DELAY = ApplicationConfigurator.getParams().getIntParam("dku.catalog.initialDelay", Integer.valueOf(15000));
    private static final int DEBOUNCE_DELAY = ApplicationConfigurator.getParams().getIntParam("dku.catalog.projectIndexingDebouncePeriod", Integer.valueOf(30000));
    private static final boolean INDEX_COLUMNS = ApplicationConfigurator.getParams().getBoolParam("dku.catalog.indexColumns", true);
    private static final boolean INDEX_TIMELINE = ApplicationConfigurator.getParams().getBoolParam("dku.catalog.timeline.enabled", true);
    private static final boolean INDEX_DISCUSSIONS = ApplicationConfigurator.getParams().getBoolParam("dku.catalog.discussions.enabled", true);
    private static final Set<String> ignoredProjects = new HashSet<String>(ApplicationConfigurator.getParams().getCSVParamAsList("dku.catalog.ignoredProjects"));
    private static final Set<ITaggingService.TaggableType> ignoredTaggableTypes = Sets.newHashSet((Object[])new ITaggingService.TaggableType[]{ITaggingService.TaggableType.LAMBDA_SERVICE, ITaggingService.TaggableType.API_DEPLOYER_INFRA, ITaggingService.TaggableType.API_DEPLOYER_SERVICE, ITaggingService.TaggableType.API_DEPLOYER_DEPLOYMENT, ITaggingService.TaggableType.PROJECT_DEPLOYER_INFRA, ITaggingService.TaggableType.PROJECT_DEPLOYER_PROJECT, ITaggingService.TaggableType.PROJECT_DEPLOYER_DEPLOYMENT, ITaggingService.TaggableType.CODE_STUDIO_TEMPLATE});
    private IndexationCache cache = new IndexationCache();
    private Map<String, Map<String, List<String>>> synonyms;
    private DebounceExecutor debounceExecutor = new DebounceExecutor("InternalCatalog", DEBOUNCE_DELAY);
    public static final Set<String> MULTIVALUED_FIELDS = Set.of("ancestors", "attachments", "code", "column", "discussionAuthor", "discussionAuthorName", "discussionReply", "successors", "type", "usedIn", "authorized_dashboard_groups", "authorized_dashboard_users", "authorized_discussion_groups", "authorized_discussion_users", "authorized_members", "dataCollection", "tag", "user");
    public static final Set<String> FACETS = Set.of("_type", "catalog.raw", "closed", "connection.raw", "dataset", "isQuicklyShareable", "language", "objectType", "owner", "partitioned", "projectKey.raw", "schema.raw", "tag.raw", "type_raw", "workspaceKey", "dataCollection", "dataSteward", "isInDataCollection", "user");
    public static final Map<IndexableType, Set<String>> JSON_FIELDS = Map.ofEntries(Map.entry(IndexableType.ANALYSIS, Set.of("discussions", "mlTasks")), Map.entry(IndexableType.ARTICLE, Set.of("attachments", "discussions")), Map.entry(IndexableType.DASHBOARD, Set.of("discussions")), Map.entry(IndexableType.DATASET, Set.of("columns", "discussions", "partitioning", "recursiveInputs", "recursiveOutputs")), Map.entry(IndexableType.FLOW_ZONE, Set.of("discussions")), Map.entry(IndexableType.INSIGHT, Set.of("discussions")), Map.entry(IndexableType.KNOWLEDGE_BANK, Set.of("discussions")), Map.entry(IndexableType.LABELING_TASK, Set.of("discussions", "inputs", "outputs")), Map.entry(IndexableType.MANAGED_FOLDER, Set.of("discussions", "partitioning")), Map.entry(IndexableType.MODEL_COMPARISON, Set.of("discussions")), Map.entry(IndexableType.MODEL_EVALUATION_STORE, Set.of("discussions")), Map.entry(IndexableType.NOTEBOOK, Set.of("discussions")), Map.entry(IndexableType.PROJECT, Set.of("discussions")), Map.entry(IndexableType.PROMPT_STUDIO, Set.of("discussions")), Map.entry(IndexableType.RECIPE, Set.of("discussions", "inputs", "outputs")), Map.entry(IndexableType.REPORT, Set.of("discussions")), Map.entry(IndexableType.SAVED_MODEL, Set.of("discussions")), Map.entry(IndexableType.SCENARIO, Set.of("discussions")), Map.entry(IndexableType.STATISTICS_WORKSHEET, Set.of("discussions")), Map.entry(IndexableType.WEB_APP, Set.of("discussions")));
    public static final Set<String> MULTIVALUED_FIELDS_COLUMNS = Set.of("authorized_members", "tag", "user");
    public static final Set<String> FACETS_COLUMNS = Set.of("_type", "dataset.raw", "dataset", "isQuicklyShareable", "meaning", "projectKey.raw", "storedAs", "tag.raw", "udm_type", "user");
    public static final Map<IndexableType, Set<String>> JSON_FIELDS_COLUMNS = Map.ofEntries(Map.entry(IndexableType.MEANING, Set.of("entries", "mappings")));

    InternalCatalogIndexingQueueHandler() {
        super("internal-catalog");
        SpringUtils.getInstance().autowire((Object)this);
        try (InputStream is = InternalDataCatalogService.class.getResourceAsStream("index-synonyms-internal.json");){
            this.synonyms = (Map)JSON.parse((InputStream)is, (TypeToken)new TypeToken<Map<String, Map<String, List<String>>>>(){});
        }
        catch (IOException e) {
            throw new Error("failed to load synonyms", e);
        }
    }

    @Override
    public void handleQueueEvent(BackendEvent event) throws Exception {
        switch (event.getName()) {
            case "lucene-init-index": {
                TimeUnit.MILLISECONDS.sleep(INITIAL_DELAY);
                boolean indexAllAtStartup = DKUApp.getParams().getBoolParam("dku.catalog.indexAtStartup", true);
                if (indexAllAtStartup) {
                    this.indexAll();
                    break;
                }
                logger.debug((Object)"Fake initial indexing");
                this.initialized = true;
                break;
            }
            case "debug-force-index-all": {
                logger.info((Object)"debug force index all");
                this.indexAll();
                break;
            }
            case "debug-force-index-project": {
                logger.info((Object)("debug force index project: " + ((DebugForceIndexProjectEvent)event).projectKey));
                this.indexWholeProject(((DebugForceIndexProjectEvent)event).projectKey);
                this.internalIndexManager.refreshIndexSearcherOrWait();
                this.columnIndexManager.refreshIndexSearcherOrWait();
                break;
            }
            case "flush-requested": {
                this.handleFlushRequest((CatalogFlushRequestedEvent)event);
                break;
            }
            case "object-change": {
                this.handleObjectChanged((TaggableObjectChangedEvent)event);
                break;
            }
            case "dataset-change": {
                AnyLoc loc = ((DatasetChangedEvent)event).fullDatasetName;
                try (Transaction t = this.transactionService.beginRead();){
                    SerializedProject sp = this.projectsService.getOrNullUnsafe(loc.getProjectKey());
                    if (sp == null || sp.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE) break;
                    this.handleDatasetChange(loc.getProjectKey(), loc.getId(), null, null);
                    break;
                }
            }
            case "data-collection-change": {
                this.handleDataCollectionChange((DataCollectionChangedEvent)event);
                break;
            }
            case "meaning-change": {
                this.handleMeaningChange((MeaningChangedEvent)event);
                break;
            }
            case "meanings-folder-change": {
                this.handleAllMeaningsChanged();
                break;
            }
            case "discussion-import": {
                DiscussionImportEvent impEvt = (DiscussionImportEvent)event;
                this.handleDiscussionReply(new TaggableObjectsService.TaggableObjectRef(impEvt.projectKey, impEvt.objectType, impEvt.objectId, impEvt.workspaceKey));
                break;
            }
            case "discussion-update": {
                DiscussionUpdateEvent upEvt = (DiscussionUpdateEvent)event;
                this.handleDiscussionReply(new TaggableObjectsService.TaggableObjectRef(upEvt.projectKey, upEvt.objectType, upEvt.objectId, upEvt.workspaceKey));
                break;
            }
            case "discussion-reply": {
                DiscussionReplyEvent replyEvt = (DiscussionReplyEvent)event;
                this.handleDiscussionReply(new TaggableObjectsService.TaggableObjectRef(replyEvt.projectKey, replyEvt.objectType, replyEvt.objectId, replyEvt.workspaceKey));
                break;
            }
            case "discussion-delete": {
                DiscussionDeletedEvent delEvt = (DiscussionDeletedEvent)event;
                this.handleDiscussionDeleted(new TaggableObjectsService.TaggableObjectRef(delEvt.projectKey, delEvt.objectType, delEvt.objectId, delEvt.workspaceKey));
                break;
            }
            case "discussion-close": {
                DiscussionClosedEvent closeEvt = (DiscussionClosedEvent)event;
                this.handleDiscussionReply(new TaggableObjectsService.TaggableObjectRef(closeEvt.projectKey, closeEvt.objectType, closeEvt.objectId, closeEvt.workspaceKey));
                break;
            }
            case "dataset-charts-change": {
                this.handleDatasetChartsChangedEvent((DatasetChartsChangedEvent)event);
            }
        }
    }

    private void handleProjectChange(TaggableObjectChangedEvent e) throws Exception {
        if (ignoredProjects.contains(e.projectKey)) {
            return;
        }
        logger.info((Object)("Indexer handling project change event project=" + e.projectKey + " action=" + String.valueOf(e.action) + " subtype=" + String.valueOf(e.projectEditSubtype)));
        if (PythonDocPortalService.isEventGitRelated(e)) {
            logger.info((Object)"Full-project re-indexing after git event");
            this.deleteObjectsForProject(e.projectKey);
            this.deleteColumnsForProject(e.projectKey);
            this.indexWholeProject(e.projectKey);
            for (String related : e.relatedProjectsBeforeAndAfter) {
                this.indexWholeProjectDebounced(related);
            }
            return;
        }
        switch (e.action) {
            case EDIT_COLLABORATIVE_METADATA: {
                if (e.metadataDiff.renamed) {
                    logger.info((Object)"Full project indexing (renamed)");
                    this.indexWholeProjectDebounced(e.projectKey);
                    break;
                }
                logger.info((Object)"Simple project-only indexing (metadata)");
                try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.handleObjectChanged.project.simple");
                     Transaction t = this.transactionService.beginRead();){
                    SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
                    if (project != null) {
                        this.indexProject(project);
                    }
                    break;
                }
            }
            case PROJECT_EDIT: {
                if (e.projectEditSubtype == TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY || e.projectEditSubtype == TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY) {
                    logger.info((Object)"Simple project-only indexing (edit)");
                    try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.handleObjectChanged.project.simple");
                         Transaction t = this.transactionService.beginRead();){
                        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
                        if (project != null) {
                            this.indexProject(project);
                        }
                        break;
                    }
                }
                logger.info((Object)"Full-project indexing (with related)");
                this.indexWholeProjectDebounced(e.projectKey);
                for (String related : e.relatedProjectsBeforeAndAfter) {
                    this.indexWholeProjectDebounced(related);
                }
                break;
            }
            case PROJECT_DELETE: {
                logger.info((Object)"Deleted project removal (with related)");
                this.deleteObjectsForProject(e.projectKey);
                this.deleteColumnsForProject(e.projectKey);
                for (String projectKey : e.relatedProjectsBeforeAndAfter) {
                    this.indexWholeProjectDebounced(projectKey);
                }
                break;
            }
            case PROJECT_CREATE: {
                logger.info((Object)"Simple project-only indexing (creation)");
                try (Transaction t = this.transactionService.beginRead();){
                    SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
                    if (project == null) break;
                    this.indexProject(project);
                    break;
                }
            }
            default: {
                logger.warn((Object)("Don't know how to handle project change type: " + String.valueOf(e.action)));
            }
        }
    }

    private void handleDiscussionDeleted(TaggableObjectsService.TaggableObjectRef tor) throws Exception {
        this.deleteDiscussionsForObject(tor);
        this.handleDiscussionReply(tor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDiscussionReply(TaggableObjectsService.TaggableObjectRef tor) throws Exception {
        if ((StringUtils.isBlank((String)tor.projectKey) || ignoredProjects.contains(tor.projectKey)) && StringUtils.isBlank((String)tor.workspaceKey)) {
            return;
        }
        if (!INDEX_DISCUSSIONS) {
            logger.trace((Object)"Discussions are disabled, skipping reindexation after discussion reply");
            return;
        }
        this.cache.fillForObject(tor);
        try (Transaction t = this.transactionService.beginRead();
             DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.handleObjectChanged.discussion");){
            SerializedProject project;
            SerializedProject serializedProject = project = StringUtils.isNotBlank((String)tor.projectKey) ? this.projectsService.getOrNullUnsafe(tor.projectKey) : null;
            if (StringUtils.isNotBlank((String)tor.workspaceKey)) {
                Workspace workspace = this.workspacesService.getRawWorkspaceUnsafe(tor.workspaceKey);
                this.indexWorkspaceObject(workspace, tor, project);
            } else if (project != null) {
                this.indexTaggableObject(project, tor);
            }
        }
        finally {
            this.cache.clear();
        }
    }

    private void handleDatasetChartsChangedEvent(DatasetChartsChangedEvent chartEvt) throws InterruptedException, IOException {
        String projectKey = chartEvt.getProjectKey();
        if (ignoredProjects.contains(projectKey)) {
            return;
        }
        String datasetName = chartEvt.getDatasetName();
        this.deleteChartsForObjectId(projectKey, chartEvt.getDatasetName());
        try (Transaction ignored = this.transactionService.beginRead();
             DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.handleObjectChanged.charts");){
            SerializedProject project = this.projectsService.getOrNullUnsafe(projectKey);
            SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, datasetName);
            Set<String> authorizedMembers = this.getObjectAuthorizedMembers(project, ITaggingService.TaggableType.DATASET, dataset.name);
            this.indexCharts(project, dataset, authorizedMembers, this.getTimeline((TaggableObjectsService.TaggableObject)dataset, project), chartEvt.getCharts());
        }
    }

    private void indexWorkspaceObject(Workspace workspace, TaggableObjectsService.TaggableObjectRef tor, SerializedProject project) {
        if (!INDEX_DISCUSSIONS || workspace == null) {
            return;
        }
        try {
            List discussions = this.discussionsService.getForObject(tor);
            for (Discussion discussion : discussions) {
                this.discussionsService.enrich(discussion);
                this.indexDiscussion(discussion, tor, project, workspace);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index discussion on workspace object " + String.valueOf(tor)), (Throwable)e);
        }
    }

    private void indexTaggableObject(SerializedProject project, TaggableObjectsService.TaggableObjectRef tor) throws IOException {
        switch (tor.type) {
            case PROJECT: {
                this.indexProject(project);
                break;
            }
            case DATASET: {
                SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(tor.projectKey, tor.id);
                if (dataset == null) break;
                this.indexDataset(dataset, project);
                break;
            }
            case RECIPE: {
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(tor.projectKey, tor.id);
                String payload = this.recipesDAO.getPayloadOrNull(tor.projectKey, tor.id);
                if (recipe == null) break;
                this.indexRecipe(recipe, project, payload);
                break;
            }
            case SQL_NOTEBOOK: {
                SQLNotebook notebook = (SQLNotebook)this.sqlNotebooksDAO.getOrNull(tor.projectKey, tor.id);
                if (notebook == null) break;
                this.indexSQLNotebook(notebook, project);
                break;
            }
            case SEARCH_NOTEBOOK: {
                SearchNotebook searchNotebook = (SearchNotebook)this.searchNotebooksDAO.getOrNull(tor.projectKey, tor.id);
                if (searchNotebook == null) break;
                this.indexSearchNotebook(searchNotebook, project);
                break;
            }
            case JUPYTER_NOTEBOOK: {
                JupyterUtils.JupyterNotebookListEntry jnle = this.jupyterService.getOrNullUnsafe(tor.projectKey, tor.id);
                if (jnle == null) break;
                this.indexJupyterNotebook(jnle, project);
                break;
            }
            case INSIGHT: {
                Insight insight = this.insightsService.getOrNullUnsafe(tor.projectKey, tor.id);
                if (insight == null) break;
                this.indexInsight(insight, project, null, null, null);
                break;
            }
            case DASHBOARD: {
                Dashboard dashboard = this.dashboardsService.getOrNullUnsafe(tor.projectKey, tor.id);
                if (dashboard == null) break;
                this.indexDashboard(dashboard, project, null, null, null);
                break;
            }
            case WEB_APP: {
                WebApp webapp = this.webAppsService.getOrNullUnsafe(tor.projectKey, tor.id);
                if (webapp == null) break;
                this.indexWebApp(webapp, project);
                break;
            }
            case REPORT: {
                Report report = this.reportsService.getOrNullUnsafe(tor.projectKey, tor.id);
                if (report == null) break;
                this.indexReport(report, project);
                break;
            }
            case ANALYSIS: {
                AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatoryUnsafe(tor.projectKey, tor.id);
                AnalysisCoreParams.AnalysisListItem analysis = this.analysisCRUDService.getHeadMandatoryUnsafe(tor.projectKey, tor.id, true);
                if (acp == null || analysis == null) break;
                this.indexAnalysis(analysis, acp, project);
                break;
            }
            case SAVED_MODEL: {
                SavedModel savedModel = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(tor.projectKey, tor.id);
                if (savedModel == null) break;
                this.indexSavedModel(savedModel, project);
                break;
            }
            case MODEL_EVALUATION_STORE: {
                ModelEvaluationStore modelEvaluationStore = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(tor.projectKey, tor.id);
                if (modelEvaluationStore == null) break;
                this.indexModelEvaluationStore(modelEvaluationStore, project);
                break;
            }
            case MANAGED_FOLDER: {
                ManagedFolder mf = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(tor.projectKey, tor.id);
                if (mf == null) break;
                this.indexManagedFolder(mf, project);
                break;
            }
            case SCENARIO: {
                Scenario scenario = this.scenariosService.getOrNullUnsafe(tor.projectKey, tor.id);
                if (scenario == null) break;
                this.indexScenario(scenario, project);
                break;
            }
            case ARTICLE: {
                Article article = this.wikisService.getArticleOrNullUnsafe(tor.projectKey, tor.id);
                if (article == null) break;
                String articlePayload = this.wikisService.getArticlePayloadOrNull(tor.projectKey, tor.id);
                this.indexArticle(article, project, articlePayload);
                break;
            }
            case STATISTICS_WORKSHEET: {
                Worksheet worksheet = this.worksheetsService.getWorksheetOrNull(tor.projectKey, tor.id);
                if (worksheet == null) break;
                this.indexWorksheet(worksheet, project);
                break;
            }
            case MODEL_COMPARISON: {
                ModelComparison modelComparison = this.modelComparisonsCRUDService.getOrNull(tor.projectKey, tor.id);
                if (modelComparison == null) break;
                this.indexModelComparison(modelComparison, project);
                break;
            }
            case FLOW_ZONE: {
                Zone zone = (Zone)this.zonesDAO.getOrNull(tor.projectKey, tor.id);
                if (zone == null) break;
                this.indexZone(zone, project);
                break;
            }
            case LABELING_TASK: {
                LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getOrNull(tor.projectKey, tor.id);
                if (labelingTask == null) break;
                this.indexLabelingTask(labelingTask, project);
                break;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                RetrievableKnowledge knowledgeBank = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNull(tor.projectKey, tor.id);
                if (knowledgeBank == null) break;
                this.indexKnowledgeBank(knowledgeBank, project);
                break;
            }
            case PROMPT_STUDIO: {
                PromptStudio promptStudio = (PromptStudio)this.promptStudioDAO.getOrNull(tor.projectKey, tor.id);
                if (promptStudio == null) break;
                this.indexPromptStudio(promptStudio, project);
                break;
            }
            case DATA_COLLECTION: {
                break;
            }
        }
    }

    private void finishIndexingTaggableObject(TaggableObjectsService.TaggableObject to, SerializedProject project, LuceneDocBuilder doc) throws Exception {
        this.indexTimeline(to, project, doc);
        this.indexObjectDiscussions(to.getRef(), project, doc);
        this.pushToIndex(doc, this.internalIndexManager);
    }

    private void indexObjectDiscussions(TaggableObjectsService.TaggableObjectRef tor, SerializedProject project, LuceneDocBuilder doc) {
        if (!INDEX_DISCUSSIONS) {
            return;
        }
        List<Discussion> discussions = this.cache.getDiscussions(tor);
        for (Discussion discussion : discussions) {
            this.discussionsService.enrich(discussion);
            this.indexDiscussion(discussion, tor, project, null);
        }
        this.addDataFromDiscussions(doc, discussions);
    }

    private String getIndexableType(ITaggingService.TaggableType taggableType) {
        return IndexableType.get((ITaggingService.TaggableType)taggableType).index();
    }

    private void indexDiscussion(Discussion discussion, TaggableObjectsService.TaggableObjectRef tor, @Nullable SerializedProject project, @Nullable Workspace workspace) {
        Preconditions.checkArgument((project != null || workspace != null ? 1 : 0) != 0, (Object)"A project or a workspace must be specified");
        if (workspace == null && ignoredProjects.contains(project.projectKey)) {
            return;
        }
        String objectKey = InternalDataCatalogHelper.objectKey(tor.projectKey, tor.id, discussion.id, discussion.workspaceKey);
        try {
            ArrayList<String> userLogins = new ArrayList<String>(discussion.users.size());
            ArrayList<String> userDisplayNames = new ArrayList<String>(discussion.users.size());
            ArrayList<String> replies = new ArrayList<String>(discussion.getReplies().size());
            ArrayList users = Lists.newArrayList(discussion.users.values());
            CollectionUtils.filter((Iterable)users, u -> u.lastReplyTime > 0L);
            users.sort((user1, user2) -> Long.compare(user2.lastReplyTime, user1.lastReplyTime));
            for (Discussion.User user : users) {
                userLogins.add(user.login);
                userDisplayNames.add(user.displayName);
            }
            for (Discussion.DiscussionReply r : discussion.getReplies()) {
                replies.add(r.text);
            }
            String torKey = InternalDataCatalogHelper.objectKey(tor);
            String docType = IndexableType.DISCUSSION.index();
            LuceneDocBuilder doc = LuceneDocBuilder.from((String)docType, (LuceneMappingsAnalyzer)this.internalLuceneMappingsAnalyzer, (String)objectKey);
            doc.addString("projectKey", project != null ? project.projectKey : "");
            doc.addString("projectName", project != null ? project.name : "");
            doc.addString("objectType", tor.type.name().toLowerCase());
            doc.addString("objectName", discussion.objectDisplayName);
            doc.addString("objectId", discussion.objectId);
            doc.addString("workspaceKey", workspace != null ? workspace.workspaceKey : "");
            doc.addString("workspaceName", workspace != null ? workspace.displayName : "");
            doc.addString("tor", torKey);
            doc.addString("discussionId", discussion.id);
            doc.addBoolean("closed", Boolean.valueOf(discussion.closedOn > 0L));
            doc.addStrings("discussionAuthor", userLogins);
            doc.addStrings("discussionAuthorName", userDisplayNames);
            doc.addStrings("discussionReply", replies);
            doc.addLong("lastReplyTime", Long.valueOf(discussion.lastReplyTime));
            JsonArray jsonDiscussions = new JsonArray();
            JsonObject jsonDiscussionElement = new JsonObject();
            jsonDiscussionElement.addProperty("topic", discussion.topic);
            jsonDiscussionElement.addProperty("id", discussion.id);
            jsonDiscussions.add((JsonElement)jsonDiscussionElement);
            doc.addString("discussions.topic", discussion.topic);
            doc.addJson("discussions", gson.toJson((JsonElement)jsonDiscussions));
            this.addAuthorizedMembersData(doc, project, workspace, tor.type, tor.id, null);
            if (project != null) {
                doc.addStrings("authorized_discussion_groups", this.getDashboardReaderGroups(project));
                doc.addStrings("authorized_discussion_users", this.getDashboardReaderUsers(project));
            }
            this.pushToIndex(doc, this.internalIndexManager);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index discussion " + objectKey), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFlushRequest(CatalogFlushRequestedEvent e) throws Exception {
        logger.info((Object)"Forcing the execution of all pending debounced actions.");
        this.debounceExecutor.executePending();
        this.internalIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
        this.columnIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
        Object object = e.lock;
        synchronized (object) {
            e.done = true;
            e.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleObjectChanged(TaggableObjectChangedEvent e) throws Exception {
        if (InternalCatalogIndexingQueueHandler.ignoredTaggableTypes.contains(e.objectType)) {
            return;
        }
        tor = e.getTaggableObjectRef();
        t = this.transactionService.beginRead();
        try {
            sp = this.projectsService.getOrNullUnsafe(tor.projectKey);
            if (sp != null && sp.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE) {
                return;
            }
            isOnDeletedProject = sp == null;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        if (isOnDeletedProject) {
            this.cache.clear();
        } else {
            this.cache.fillForObject(tor);
        }
        try {
            block56: {
                t = this.transactionService.beginRead();
                try {
                    tctx = DSSMetrics.timeCtx((String)("catalog.handleObjectChanged." + tor.type.toString().toLowerCase()));
                    try {
                        if (e.action != null && e.action.isDeletion()) {
                            InternalCatalogIndexingQueueHandler.logger.debugV("object deleted type=%s projectKey=%s id=%s", new Object[]{e.objectType, e.projectKey, e.objectId});
                            this.delete(e.objectType, e.projectKey, e.objectId);
                            break block56;
                        }
                        InternalCatalogIndexingQueueHandler.logger.debugV("object changed type=%s projectKey=%s id=%s", new Object[]{e.objectType, e.projectKey, e.objectId});
                        e.objectType.assertNotFakeType();
                        switch (2.$SwitchMap$com$dataiku$dip$server$services$ITaggingService$TaggableType[e.objectType.ordinal()]) {
                            case 2: {
                                datasetName = e.action != null && e.action.isRenaming() != false ? e.newObjectId : e.objectId;
                                this.handleDatasetChange(e.projectKey, datasetName, e.action, e.objectId);
                                ** break;
lbl36:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                this.handleRecipeChange(e);
                                ** break;
lbl40:
                                // 1 sources

                                break;
                            }
                            case 4: {
                                this.handleSQLNotebookChange(e);
                                ** break;
lbl44:
                                // 1 sources

                                break;
                            }
                            case 5: {
                                this.handleSearchNotebookChange(e);
                                ** break;
lbl48:
                                // 1 sources

                                break;
                            }
                            case 6: {
                                this.handleJupyterNotebookChange(e);
                                ** break;
lbl52:
                                // 1 sources

                                break;
                            }
                            case 7: {
                                this.handleInsightChange(e);
                                ** break;
lbl56:
                                // 1 sources

                                break;
                            }
                            case 8: {
                                this.handleDashboardChange(e);
                                ** break;
lbl60:
                                // 1 sources

                                break;
                            }
                            case 9: {
                                this.handleWebAppChange(e);
                                ** break;
lbl64:
                                // 1 sources

                                break;
                            }
                            case 10: {
                                this.handleReportChange(e);
                                ** break;
lbl68:
                                // 1 sources

                                break;
                            }
                            case 11: {
                                this.handleAnalysisChange(e);
                                ** break;
lbl72:
                                // 1 sources

                                break;
                            }
                            case 12: {
                                this.handleSavedModelChange(e);
                                ** break;
lbl76:
                                // 1 sources

                                break;
                            }
                            case 13: {
                                this.handleModelEvaluationStoreChange(e);
                                ** break;
lbl80:
                                // 1 sources

                                break;
                            }
                            case 14: {
                                this.handleManagedFolderChange(e);
                                ** break;
lbl84:
                                // 1 sources

                                break;
                            }
                            case 15: {
                                this.handleScenarioChange(e);
                                ** break;
lbl88:
                                // 1 sources

                                break;
                            }
                            case 16: {
                                this.handleArticleChange(e);
                                ** break;
lbl92:
                                // 1 sources

                                break;
                            }
                            case 17: {
                                this.handleWorksheetChange(e);
                                ** break;
lbl96:
                                // 1 sources

                                break;
                            }
                            case 18: {
                                this.handleModelEvaluationComparatorChange(e);
                                ** break;
lbl100:
                                // 1 sources

                                break;
                            }
                            case 19: {
                                this.handleFlowZoneChange(e);
                                ** break;
lbl104:
                                // 1 sources

                                break;
                            }
                            case 20: {
                                this.handleLabelingTaskChange(e);
                                ** break;
lbl108:
                                // 1 sources

                                break;
                            }
                            case 21: {
                                this.handleKnowledgeBankChange(e);
                                ** break;
lbl112:
                                // 1 sources

                                break;
                            }
                            case 22: {
                                this.handlePromptStudioChange(e);
                                ** break;
lbl116:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                ** break;
lbl119:
                                // 1 sources

                                break;
                            }
                            case 23: {
                                ** break;
lbl122:
                                // 1 sources

                                break;
                            }
                            case 24: 
                            case 25: {
                                ** break;
lbl125:
                                // 1 sources

                                break;
                            }
                            case 26: {
                                this.handleCodeStudioChange(e);
                                break;
                            }
                            ** default:
lbl130:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        if (tctx != null) {
                            tctx.close();
                        }
                    }
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            if (e.objectType == ITaggingService.TaggableType.PROJECT) {
                this.handleProjectChange(e);
            }
        }
        finally {
            this.cache.clear();
        }
    }

    private void handleDatasetChange(String projectKey, String datasetName, TaggableObjectChangedEvent.ActionType action, String datasetOldName) throws Exception {
        if (action != null && action.isCreation()) {
            this.indexWholeProjectDebounced(projectKey);
            return;
        }
        if (action != null && action.isRenaming()) {
            this.delete(ITaggingService.TaggableType.DATASET, projectKey, datasetOldName);
        }
        SerializedProject project = this.projectsService.getOrNullUnsafe(projectKey);
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, datasetName);
        if (dataset == null) {
            this.delete(ITaggingService.TaggableType.DATASET, projectKey, datasetOldName);
        } else {
            this.indexDataset(dataset, project);
        }
        if (action != null && action.isRenaming()) {
            for (String workspaceKey : this.workspacesService.listAllWorkspacesContainingObject(projectKey, ITaggingService.TaggableType.DATASET, datasetName)) {
                Workspace workspace = this.workspacesService.getRawWorkspaceUnsafe(workspaceKey);
                this.deleteDiscussionsForObject(new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.DATASET, datasetName, workspaceKey));
                this.indexWorkspaceObject(workspace, new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.DATASET, datasetName, workspaceKey), project);
            }
        }
    }

    private void handleDataCollectionChange(DataCollectionChangedEvent dataCollectionChangedEvent) throws Exception {
        logger.infoV("Indexing modified data collection [%s]", new Object[]{dataCollectionChangedEvent.dataCollection.getId()});
        if (dataCollectionChangedEvent.action.isDeletion()) {
            this.delete(ITaggingService.TaggableType.DATA_COLLECTION, "", dataCollectionChangedEvent.dataCollection.getId());
        } else {
            this.indexDataCollection(dataCollectionChangedEvent.dataCollection, dataCollectionChangedEvent.getTaggableObjectRef());
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            for (AbstractDataCollectionItem dataCollectionItem : dataCollectionChangedEvent.impactedItems) {
                String datasetName;
                if (!(dataCollectionItem instanceof DataCollectionDataset)) {
                    throw new IllegalStateException("Unhandled data collection item type " + String.valueOf(dataCollectionItem.getClass()));
                }
                DataCollectionDataset dataCollectionDataset = (DataCollectionDataset)dataCollectionItem;
                String projectKey = dataCollectionDataset.reference.getProjectKey();
                SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, datasetName = dataCollectionDataset.reference.getId());
                if (dataset == null) {
                    this.delete(ITaggingService.TaggableType.DATASET, projectKey, datasetName);
                    continue;
                }
                SerializedProject project = this.projectsService.getOrNullUnsafe(projectKey);
                this.indexDataset(dataset, project);
            }
        }
    }

    private void handleMeaningChange(MeaningChangedEvent e) throws Exception {
        if (e.action == MeaningChangedEvent.MeaningActionType.MEANING_DELETE) {
            this.deleteById(this.columnIndexManager, IndexableType.MEANING.index(), e.id);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                UserDefinedMeaning udm = this.meaningsService.getUnsafe(e.id);
                this.indexMeaning(udm);
            }
        }
    }

    private void handleAllMeaningsChanged() throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            for (UserDefinedMeaning udm : this.meaningsService.listUserDefinedUnsafe()) {
                this.indexMeaning(udm);
            }
        }
    }

    private void handleInsightChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        Insight insight = this.insightsService.getMandatoryUnsafe(e.projectKey, e.objectId);
        this.indexInsight(insight, project, null, null, null);
        this.indexProject(project);
    }

    private void handleJupyterNotebookChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        JupyterUtils.JupyterNotebookListEntry notebook = this.jupyterService.getOrNullUnsafe(e.projectKey, e.objectId);
        this.indexJupyterNotebook(notebook, project);
        this.indexProject(project);
    }

    private void handleSavedModelChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        SavedModel savedModel = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(e.projectKey, e.objectId);
        if (savedModel != null) {
            this.indexSavedModel(savedModel, project);
            this.indexProject(project);
        }
    }

    private void handleModelEvaluationStoreChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        ModelEvaluationStore modelEvaluationStore = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(e.projectKey, e.objectId);
        if (modelEvaluationStore != null) {
            this.indexModelEvaluationStore(modelEvaluationStore, project);
            this.indexProject(project);
        }
    }

    private void handleLabelingTaskChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getOrNullUnsafe(e.projectKey, e.objectId);
        if (labelingTask != null) {
            this.indexLabelingTask(labelingTask, project);
            this.indexProject(project);
        }
    }

    private void handleManagedFolderChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        ManagedFolder managedFolder = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(e.projectKey, e.objectId);
        this.indexManagedFolder(managedFolder, project);
        this.indexProject(project);
    }

    private void handleScenarioChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        Scenario scenario = this.scenariosService.getOrNullUnsafe(e.projectKey, e.objectId);
        this.indexScenario(scenario, project);
        this.indexProject(project);
    }

    private void handleArticleChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        String articleId = e.objectId;
        Article article = this.wikisService.getArticleOrNullUnsafe(e.projectKey, articleId);
        if (article == null) {
            this.delete(ITaggingService.TaggableType.ARTICLE, e.projectKey, articleId);
        } else {
            String payload = this.wikisService.getArticlePayloadOrNull(e.projectKey, articleId);
            this.indexArticle(article, project, payload);
        }
        this.indexProject(project);
    }

    private void handleRecipeChange(TaggableObjectChangedEvent e) throws Exception {
        if (ignoredProjects.contains(e.projectKey)) {
            return;
        }
        if (e.action != null && e.action.isCreation()) {
            this.indexWholeProjectDebounced(e.projectKey);
            return;
        }
        String recipeName = e.objectId;
        if (e.action != null && e.action.isRenaming()) {
            this.delete(ITaggingService.TaggableType.RECIPE, e.projectKey, e.objectId);
            recipeName = e.newObjectId;
        }
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(e.projectKey, recipeName);
        if (recipe == null) {
            this.delete(ITaggingService.TaggableType.RECIPE, e.projectKey, recipeName);
        } else {
            String payload = this.recipesDAO.getPayloadOrNull(e.projectKey, recipeName);
            this.indexRecipe(recipe, project, payload);
        }
    }

    private void handleSQLNotebookChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        SQLNotebook notebook = (SQLNotebook)this.sqlNotebooksDAO.getOrNullUnsafe(e.projectKey, e.objectId);
        if (notebook != null) {
            this.indexSQLNotebook(notebook, project);
            this.indexProject(project);
        }
    }

    private void handleSearchNotebookChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        SearchNotebook notebook = (SearchNotebook)this.searchNotebooksDAO.getOrNullUnsafe(e.projectKey, e.objectId);
        if (notebook != null) {
            this.indexSearchNotebook(notebook, project);
            this.indexProject(project);
        }
    }

    private void handleAnalysisChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatoryUnsafe(e.projectKey, e.objectId);
        AnalysisCoreParams.AnalysisListItem analysis = this.analysisCRUDService.getHeadMandatoryUnsafe(e.projectKey, e.objectId, true);
        this.deleteChartsForObjectId(project.projectKey, analysis.id);
        this.indexAnalysis(analysis, acp, project);
        this.indexProject(project);
    }

    private void handleWebAppChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        WebApp webApp = this.webAppsService.getMandatoryUnsafe_noCode(e.projectKey, e.objectId);
        this.indexWebApp(webApp, project);
        this.indexProject(project);
    }

    private void handleReportChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        Report report = this.reportsService.getMandatoryUnsafe(e.projectKey, e.objectId);
        this.indexReport(report, project);
        this.indexProject(project);
    }

    private void handleModelEvaluationComparatorChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        ModelComparison modelComparison = this.modelComparisonsCRUDService.getOrNull(e.projectKey, e.objectId);
        if (modelComparison == null) {
            this.delete(ITaggingService.TaggableType.MODEL_COMPARISON, e.projectKey, e.objectId);
        } else {
            this.indexModelComparison(modelComparison, project);
        }
        this.indexProject(project);
    }

    private void handleDashboardChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        Dashboard dashboard = this.dashboardsService.getMandatoryUnsafe(e.projectKey, e.objectId);
        this.indexDashboard(dashboard, project, null, null, null);
        this.indexProject(project);
    }

    private void handleWorksheetChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        Worksheet worksheet = this.worksheetsService.getWorksheetOrNull(e.projectKey, e.objectId);
        if (worksheet == null) {
            this.delete(ITaggingService.TaggableType.STATISTICS_WORKSHEET, e.projectKey, e.objectId);
        } else {
            this.indexWorksheet(worksheet, project);
        }
        this.indexProject(project);
    }

    private void handleFlowZoneChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        Zone zone = (Zone)this.zonesDAO.getOrNull(e.projectKey, e.objectId);
        if (zone == null) {
            this.delete(ITaggingService.TaggableType.FLOW_ZONE, e.projectKey, e.objectId);
        } else {
            this.indexZone(zone, project);
        }
        this.indexProject(project);
    }

    private void handleKnowledgeBankChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        RetrievableKnowledge knowledgeBank = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNullUnsafe(e.projectKey, e.objectId);
        if (knowledgeBank == null) {
            this.delete(ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, e.projectKey, e.objectId);
        } else {
            this.indexKnowledgeBank(knowledgeBank, project);
        }
        this.indexProject(project);
    }

    private void handleCodeStudioChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        CodeStudioObject codeStudioObject = this.codeStudioObjectsService.getOrNull(e.projectKey, e.objectId);
        if (codeStudioObject == null) {
            this.delete(ITaggingService.TaggableType.CODE_STUDIO, e.projectKey, e.objectId);
        } else {
            this.indexCodeStudioObject(codeStudioObject, project);
        }
    }

    private void handlePromptStudioChange(TaggableObjectChangedEvent e) throws Exception {
        SerializedProject project = this.projectsService.getOrNullUnsafe(e.projectKey);
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        PromptStudio promptStudio = (PromptStudio)this.promptStudioDAO.getOrNullUnsafe(e.projectKey, e.objectId);
        if (promptStudio == null) {
            this.delete(ITaggingService.TaggableType.PROMPT_STUDIO, e.projectKey, e.objectId);
        } else {
            this.indexPromptStudio(promptStudio, project);
        }
        this.indexProject(project);
    }

    private Query storedObjectsForProjectQuery(String projectKey) {
        return new TermQuery(new Term("projectKey.raw", projectKey));
    }

    private Query storedColumnsForDatasetQuery(String projectKey, String datasetName) {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add((Query)new TermQuery(new Term("projectKey.raw", projectKey)), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("dataset.raw", datasetName)), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("_type", IndexableType.COLUMN.index())), BooleanClause.Occur.FILTER);
        return booleanQueryBuilder.build();
    }

    private Query storedDiscussionsForObjectQuery(TaggableObjectsService.TaggableObjectRef tor) {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add((Query)new TermQuery(new Term("projectKey.raw", StringUtils.defaultString((String)tor.projectKey, (String)""))), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("objectType", this.getIndexableType(tor.type))), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("objectId", tor.id)), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("workspaceKey", StringUtils.defaultString((String)tor.workspaceKey, (String)""))), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("_type", IndexableType.DISCUSSION.index())), BooleanClause.Occur.FILTER);
        return booleanQueryBuilder.build();
    }

    private Query storedColumnsForProjectQuery(String projectKey) {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add((Query)new TermQuery(new Term("projectKey.raw", projectKey)), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("_type", IndexableType.COLUMN.index())), BooleanClause.Occur.FILTER);
        return booleanQueryBuilder.build();
    }

    private Query storedChartsForObjectIdQuery(String projectKey, String objectId) {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.add((Query)new TermQuery(new Term("projectKey.raw", projectKey)), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("objectId", objectId)), BooleanClause.Occur.FILTER);
        booleanQueryBuilder.add((Query)new TermQuery(new Term("_type", IndexableType.CHART.index())), BooleanClause.Occur.FILTER);
        return booleanQueryBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexAll() {
        try {
            Transaction t;
            DataCollectionsByItem dataCollectionsByItem;
            List workspaces;
            List projects;
            logger.debug((Object)"Starting complete reindexing");
            try (Transaction t2 = this.transactionService.beginRead();){
                projects = this.projectsService.listAllUnsafe();
                workspaces = this.workspacesService.listWorkspacesUnsafe();
                dataCollectionsByItem = this.dataCollectionService.listByItemUnsafe();
            }
            this.cache.fillForAllObjects(projects);
            logger.info((Object)"Indexing full configuration");
            for (SerializedProject project : projects) {
                t = this.transactionService.beginRead();
                try {
                    DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.indexWholeProject");
                    try {
                        try {
                            this.indexWholeProject(project, dataCollectionsByItem);
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Project indexing failed: " + project.projectKey), (Throwable)e);
                        }
                    }
                    finally {
                        if (tctx == null) continue;
                        tctx.close();
                    }
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            for (Workspace workspace : workspaces) {
                TaggableObjectsService.TaggableObjectRef workspaceRef = workspace.getRef();
                Transaction t3 = this.transactionService.beginRead();
                try {
                    DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.indexWorkspaceDiscussions");
                    try {
                        List discussions = this.discussionsService.getForObject(workspaceRef);
                        for (Discussion discussion : discussions) {
                            this.discussionsService.enrich(discussion);
                            this.indexDiscussion(discussion, workspaceRef, null, workspace);
                        }
                        for (Workspace.WorkspaceObject workspaceObject : workspace.workspaceObjects) {
                            if (workspaceObject.reference == null) continue;
                            SerializedProject project = projects.stream().filter(p -> p.projectKey.equals(workspaceObject.reference.projectKey)).findFirst().orElse(null);
                            this.indexWorkspaceObject(workspace, workspaceObject.reference, project);
                        }
                    }
                    finally {
                        if (tctx == null) continue;
                        tctx.close();
                    }
                }
                finally {
                    if (t3 == null) continue;
                    t3.close();
                }
            }
            for (DataCollection dataCollection : dataCollectionsByItem.allDataCollections) {
                t = this.transactionService.beginRead();
                try {
                    this.indexDataCollection(dataCollection, new TaggableObjectsService.TaggableObjectRef(null, ITaggingService.TaggableType.DATA_COLLECTION, dataCollection.id, null));
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            this.handleAllMeaningsChanged();
            logger.debug((Object)"Complete reindexing done");
            this.internalIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
            this.columnIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
            this.internalIndexManager.startRefreshThread();
            this.columnIndexManager.startRefreshThread();
            this.initialized = true;
        }
        catch (Exception e) {
            logger.error((Object)"Complete reindexing failed", (Throwable)e);
        }
        finally {
            this.cache.clear();
        }
    }

    private void indexWholeProjectDebounced(String projectKey) {
        this.debounceExecutor.addAction(projectKey, () -> {
            try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.indexWholeProject");){
                this.indexWholeProject(projectKey);
            }
        });
    }

    private void indexWholeProject(String projectKey) {
        try (Transaction t = this.transactionService.beginRead();){
            SerializedProject serializedProject = this.projectsService.getOrNullUnsafe(projectKey);
            if (serializedProject != null) {
                this.indexWholeProject(serializedProject, null);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Project reindexing failed: " + projectKey), (Throwable)e);
        }
    }

    private void indexWholeProject(SerializedProject project, @Nullable DataCollectionsByItem dataCollectionsByItem) throws Exception {
        String payload;
        long before = System.currentTimeMillis();
        if (ignoredProjects.contains(project.projectKey)) {
            logger.infoV("Skipping indexation of project %s", new Object[]{project.projectKey});
            return;
        }
        if (project.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE && project.isTemporaryAppInstance != null && project.isTemporaryAppInstance.booleanValue()) {
            logger.infoV("Skipping indexation of temporary application instance %s", new Object[]{project.projectKey});
            return;
        }
        if (project.projectType == SerializedProject.ProjectType.PROJECT_STANDARDS) {
            logger.infoV("Skipping indexation of temporary project created for Project Standards %s", new Object[]{project.projectKey});
            return;
        }
        logger.debug((Object)("Indexing whole project " + project.projectKey));
        DataCollectionsByItem dataCollectionsBI = dataCollectionsByItem == null ? this.dataCollectionService.listByItemUnsafe() : dataCollectionsByItem;
        InternalDataCatalogService.ProjectItemCounts counts = new InternalDataCatalogService.ProjectItemCounts();
        counts.numTasks = this.countTasks(project);
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.datasets");){
            for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(project.projectKey)) {
                List dataCollectionsOfDataset = dataCollectionsBI.getDataCollectionsOfDataset(project.projectKey, dataset.name);
                this.indexDataset(dataset, project, true, dataCollectionsOfDataset);
                ++counts.numDatasets;
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.recipes");
        try {
            for (SerializedRecipe recipe : this.recipesDAO.listUnsafe(project.projectKey)) {
                payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
                this.indexRecipe(recipe, project, payload);
                ++counts.numRecipes;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.jupyterNotebooks");
        try {
            for (JupyterUtils.JupyterNotebookListEntry jupyterNotebook : this.jupyterService.listSimple((AuthCtx)DSSAuthCtx.newNone(), project.projectKey)) {
                this.indexJupyterNotebook(jupyterNotebook, project);
                ++counts.numNotebooks;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.sqlNotebooks");
        try {
            for (SQLNotebook sqlNotebook : this.sqlNotebooksDAO.listUnsafe(project.projectKey)) {
                this.indexSQLNotebook(sqlNotebook, project);
                ++counts.numNotebooks;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.searchNotebooks");
        try {
            for (SearchNotebook searchNotebook : this.searchNotebooksDAO.listUnsafe(project.projectKey)) {
                this.indexSearchNotebook(searchNotebook, project);
                ++counts.numNotebooks;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.analyses");
        try {
            for (AnalysisCoreParams.AnalysisListItem analysis : this.analysisCRUDService.listHeadsUnsafe(project.projectKey, null, true)) {
                AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatoryUnsafe(analysis.projectKey, analysis.id);
                this.indexAnalysis(analysis, acp, project);
                ++counts.numAnalyses;
                counts.numModels += analysis.nbMLTasks;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.webApps");
        try {
            for (WebApp webApp : this.webAppsService.listUnsafe(project.projectKey)) {
                this.indexWebApp(webApp, project);
                ++counts.numWebApps;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.codeStudios");
        try {
            for (CodeStudioObject codeStudioObject : this.codeStudioObjectsService.listUnsafe(project.projectKey)) {
                this.indexCodeStudioObject(codeStudioObject, project);
                ++counts.numCodeStudios;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.reports");
        try {
            for (Report report : this.reportsService.listUnsafe(project.projectKey)) {
                this.indexReport(report, project);
                ++counts.numReports;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.savedModels");
        try {
            for (SavedModel savedModel : this.savedModelsDAO.listUnsafe(project.projectKey)) {
                this.indexSavedModel(savedModel, project);
                ++counts.numSavedModels;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.modelEvaluationStores");
        try {
            for (ModelEvaluationStore modelEvaluationStore : this.modelEvaluationStoresDAO.listUnsafe(project.projectKey)) {
                this.indexModelEvaluationStore(modelEvaluationStore, project);
                ++counts.numModelEvaluationStores;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.modelEvaluationComparators");
        try {
            for (ModelComparison modelComparison : this.modelComparisonsCRUDService.list(project.projectKey)) {
                this.indexModelComparison(modelComparison, project);
                ++counts.numModelEvaluationComparators;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.managedFolders");
        try {
            for (ManagedFolder managedFolder : this.managedFolderDAO.listUnsafe(project.projectKey)) {
                this.indexManagedFolder(managedFolder, project);
                ++counts.numManagedFolders;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.scenarios");
        try {
            for (Scenario scenario : this.scenariosService.listUnsafe(project.projectKey)) {
                this.indexScenario(scenario, project);
                ++counts.numScenarios;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.articles");
        try {
            for (Article article : this.wikisService.listArticlesUnsafe(project.projectKey)) {
                payload = this.wikisService.getArticlePayloadOrNull(article.projectKey, article.id);
                this.indexArticle(article, project, payload);
                ++counts.numWikiArticles;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.statisticsWorksheets");
        try {
            for (Worksheet worksheet : this.worksheetsService.listUnsafe(project.projectKey)) {
                this.indexWorksheet(worksheet, project);
                ++counts.numStatisticsWorksheets;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.zones");
        try {
            for (Zone zone : this.zonesDAO.listUnsafe(project.projectKey)) {
                this.indexZone(zone, project);
                ++counts.numFlowZones;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.labelingTasks");
        try {
            for (LabelingTask labelingTask : this.labelingTasksDAO.listUnsafe(project.projectKey)) {
                this.indexLabelingTask(labelingTask, project);
                ++counts.numLabelingTasks;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.knowledgeBanks");
        try {
            for (RetrievableKnowledge knowledgeBank : this.retrievableKnowledgeDAO.listUnsafe(project.projectKey)) {
                this.indexKnowledgeBank(knowledgeBank, project);
                ++counts.numKnowledgeBanks;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.promptStudios");
        try {
            for (PromptStudio promptStudio : this.promptStudioDAO.listUnsafe(project.projectKey)) {
                this.indexPromptStudio(promptStudio, project);
                ++counts.numPromptStudios;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        Set<String> dashboardAuthorizedMembers = this.getObjectAuthorizedMembers(project, ITaggingService.TaggableType.DASHBOARD, null);
        Set<String> dashboardReaderGroups = this.getDashboardReaderGroups(project);
        Set<String> dashboardReaderUsers = this.getDashboardReaderUsers(project);
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.insights");){
            for (Insight insight : this.insightsService.listUnsafe(project.projectKey)) {
                this.indexInsight(insight, project, dashboardAuthorizedMembers, dashboardReaderGroups, dashboardReaderUsers);
                ++counts.numInsights;
            }
        }
        tctx = DSSMetrics.timeCtx((String)"catalog.indexProject.dashboards");
        try {
            for (Dashboard dashboard : this.dashboardsService.listUnsafe(project.projectKey)) {
                this.indexDashboard(dashboard, project, dashboardAuthorizedMembers, dashboardReaderGroups, dashboardReaderUsers);
                ++counts.numDashboards;
            }
        }
        finally {
            if (tctx != null) {
                tctx.close();
            }
        }
        this.indexProject(project, counts);
        long after = System.currentTimeMillis();
        logger.debugV("Done indexing whole project %s (t=%dms)", new Object[]{project.projectKey, after - before});
    }

    private Set<String> getDashboardReaderUsers(SerializedProject project) {
        HashSet<String> projectDashboarUsers = new HashSet<String>();
        for (SerializedProject.AdditionalDashboardUser additionalDashboardUser : project.additionalDashboardUsers.users) {
            projectDashboarUsers.add(additionalDashboardUser.login);
        }
        for (SerializedProject.PermissionItem permissionItem : project.permissions) {
            if (permissionItem == null || permissionItem.user == null || !PermissionsService.permissionItemIncludes((SerializedProject.PermissionItem)permissionItem, (Privileges.ProjectLevelPrivilegeType)Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) continue;
            projectDashboarUsers.add(permissionItem.user);
        }
        return projectDashboarUsers;
    }

    private Set<String> getDashboardReaderGroups(SerializedProject project) {
        HashSet<String> projectDashboardReaders = new HashSet<String>();
        for (SerializedProject.PermissionItem permissionItem : project.permissions) {
            if (permissionItem == null || permissionItem.group == null || !PermissionsService.permissionItemIncludes((SerializedProject.PermissionItem)permissionItem, (Privileges.ProjectLevelPrivilegeType)Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) continue;
            projectDashboardReaders.add(permissionItem.group);
        }
        return projectDashboardReaders;
    }

    private void indexTimeline(TaggableObjectsService.TaggableObject taggableObject, SerializedProject project, LuceneDocBuilder doc) {
        InternalDataCatalogService.TimelineDigest timeline = this.getTimeline(taggableObject, project);
        String type = this.getIndexableType(taggableObject.getTaggableType());
        this.addEditionDataFromTimeline(doc, timeline, type);
    }

    private InternalDataCatalogService.TimelineDigest getTimeline(TaggableObjectsService.TaggableObject taggableObject, SerializedProject project) {
        if (!INDEX_TIMELINE) {
            return null;
        }
        return this.getTimelineDigest(taggableObject, project);
    }

    private boolean indexQuickShareableElement(TaggableObjectsService.TaggableObject taggableObject, LuceneDocBuilder doc) throws IOException {
        boolean isQuicklyShareable = this.exposedObjectsService.isQuickSharingEnabled(taggableObject.getProjectKey(), taggableObject.getTaggableType(), taggableObject.getId());
        doc.addBoolean("isQuicklyShareable", Boolean.valueOf(isQuicklyShareable));
        return isQuicklyShareable;
    }

    private void indexElementExpositions(TaggableObjectsService.TaggableObject taggableObject, SerializedProject project, LuceneDocBuilder doc) {
        HashSet<String> usedIn = new HashSet<String>();
        for (ExposedObject exposedObject : project.exposedObjects.objects) {
            if (!exposedObject.localName.equals(taggableObject.getId())) continue;
            for (ExposedObject.Rule rule : exposedObject.rules) {
                usedIn.add(rule.targetProject);
            }
        }
        doc.addStrings("usedIn", usedIn);
        doc.addInt("numUsedIn", Integer.valueOf(usedIn.size()));
    }

    private void indexSMSpecifics(SavedModel savedModel, LuceneDocBuilder doc) {
        if (savedModel.miniTask != null) {
            doc.addString("backendType", savedModel.miniTask.backendType.toString());
            doc.addString("taskType", savedModel.miniTask.taskType.toString());
            if (savedModel.miniTask.taskType == MLTask.MLTaskType.PREDICTION) {
                PredictionMLTask.PredictionType predictionType = ((PredictionMLTask)savedModel.miniTask).predictionType;
                doc.addString("predictionType", predictionType != null ? predictionType.toString() : null);
            }
        }
        doc.addString("savedModelType", savedModel.savedModelType.toString());
        if (savedModel.proxyModelConfiguration != null) {
            doc.addString("externalSavedModelType", savedModel.proxyModelConfiguration.protocol);
        }
    }

    private InternalDataCatalogService.TimelineDigest getTimelineDigest(TaggableObjectsService.TaggableObject taggableObject, SerializedProject project) {
        ITaggingService.TaggableType objectType = taggableObject.getTaggableType();
        String objectId = taggableObject.getId();
        String projectKey = project.projectKey;
        TaggableObjectsService.TaggableObjectRef tor = new TaggableObjectsService.TaggableObjectRef(projectKey, objectType, objectId);
        InternalDataCatalogService.TimelineDigest timeline = new InternalDataCatalogService.TimelineDigest();
        HeadWithVersioningInfo head = this.cache.getCreationAndUpdateInfo(tor);
        this.updateCreationData(timeline, head, objectType, projectKey, objectId);
        this.updateModificationData(timeline, head, objectType, projectKey, objectId);
        timeline.contributors = objectType == ITaggingService.TaggableType.PROJECT || head == null || this.cache.getContributors(tor) != null ? this.timelinesService.getContributors(projectKey) : this.cache.getContributors(tor);
        return timeline;
    }

    private void updateCreationData(InternalDataCatalogService.TimelineDigest timelineDigest, HeadWithVersioningInfo head, ITaggingService.TaggableType taggableType, String projectKey, String id) {
        if (head != null && head.createdOn != 0L) {
            timelineDigest.createdOn = head.createdOn;
            timelineDigest.createdBy = head.createdBy.login;
        } else {
            TimelineItem timelineItem = this.timelinesService.getFirstForObject(taggableType, projectKey, id);
            if (timelineItem != null && taggableType != ITaggingService.TaggableType.PROJECT) {
                timelineDigest.createdOn = timelineItem.time;
                timelineDigest.createdBy = timelineItem.user;
            }
        }
    }

    private void updateModificationData(InternalDataCatalogService.TimelineDigest timelineDigest, HeadWithVersioningInfo head, ITaggingService.TaggableType taggableType, String projectKey, String id) {
        if (head != null && head.lastModifiedOn != 0L) {
            timelineDigest.lastModifiedOn = head.lastModifiedOn;
            timelineDigest.lastModifiedBy = head.lastModifiedBy.login;
        } else {
            TimelineItem timelineItem = this.timelinesService.getLatestForObject(taggableType, projectKey, id);
            if (timelineItem != null) {
                timelineDigest.lastModifiedOn = timelineItem.time;
                timelineDigest.lastModifiedBy = timelineItem.user;
            }
        }
    }

    private void addSubtypeData(LuceneDocBuilder doc, IndexableType type, String subtype) {
        Map<String, List<String>> s = this.synonyms.get(type.index());
        if (s == null) {
            s = new HashMap<String, List<String>>();
        }
        List<String> forType = s.get(subtype);
        ArrayList<String> allTypes = new ArrayList<String>();
        if (forType != null) {
            allTypes.addAll(forType);
        }
        allTypes.add(subtype);
        allTypes.add(type.index());
        allTypes.add(subtype.toLowerCase());
        doc.addString("type_raw", subtype);
        doc.addStrings("type", allTypes);
    }

    private Set<String> getWorkspaceAuthorizedMembers(Workspace workspace) {
        HashSet<String> authorizedMembers = new HashSet<String>();
        for (BasePermissions.PermissionItem permission : workspace.permissions) {
            if (!permission.read) continue;
            if (StringUtils.isNotBlank((String)permission.user)) {
                authorizedMembers.add("u:" + permission.user);
            }
            if (!StringUtils.isNotBlank((String)permission.group)) continue;
            authorizedMembers.add("g:" + permission.group);
        }
        return authorizedMembers;
    }

    private Set<String> getObjectAuthorizedMembers(SerializedProject project, ITaggingService.TaggableType objectType, @Nullable String objectId) throws IOException {
        HashSet<String> authorizedMembers;
        block5: {
            block4: {
                authorizedMembers = new HashSet<String>();
                this.addProjectPermissions(authorizedMembers, project);
                if (objectType != ITaggingService.TaggableType.INSIGHT && objectType != ITaggingService.TaggableType.DASHBOARD) break block4;
                for (SerializedProject.PermissionItem permissionItem : project.permissions) {
                    if (!PermissionsService.permissionItemIncludes((SerializedProject.PermissionItem)permissionItem, (Privileges.ProjectLevelPrivilegeType)(project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY ? Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS : Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS))) continue;
                    if (permissionItem.group != null) {
                        authorizedMembers.add("g:" + permissionItem.group);
                    }
                    if (permissionItem.user == null) continue;
                    authorizedMembers.add("u:" + permissionItem.user);
                }
                break block5;
            }
            if (objectId == null) break block5;
            for (ExposedObject exposedObject : project.exposedObjects.objects) {
                if (!exposedObject.localName.equals(objectId) || !exposedObject.type.equals((Object)objectType)) continue;
                for (ExposedObject.Rule rule : exposedObject.rules) {
                    SerializedProject targetProject = this.projectsService.getOrNullUnsafe(rule.targetProject);
                    this.addProjectPermissions(authorizedMembers, targetProject);
                }
            }
        }
        return authorizedMembers;
    }

    private void addProjectPermissions(Set<String> authorizedMembers, SerializedProject project) {
        if (project == null || project.permissions == null) {
            return;
        }
        for (SerializedProject.PermissionItem permItem : project.permissions) {
            if (!PermissionsService.permissionItemIncludes((SerializedProject.PermissionItem)permItem, (Privileges.ProjectLevelPrivilegeType)Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
            if (permItem.group != null) {
                authorizedMembers.add("g:" + permItem.group);
            }
            if (permItem.user == null) continue;
            authorizedMembers.add("u:" + permItem.user);
        }
        authorizedMembers.add("u:" + project.owner);
    }

    private void addEditionDataFromTimelineColumns(LuceneDocBuilder doc, InternalDataCatalogService.TimelineDigest timeline, String type) {
        if (timeline == null) {
            return;
        }
        doc.addString("createdBy", timeline.createdBy);
        doc.addLong("createdOn", timeline.createdOn);
        doc.addString("lastModifiedBy", timeline.lastModifiedBy);
        doc.addLong("lastModifiedOn", timeline.lastModifiedOn);
        this.indexUserFromTimeline(doc, timeline);
    }

    private void addEditionDataFromTimeline(LuceneDocBuilder doc, InternalDataCatalogService.TimelineDigest timeline, String type) {
        if (timeline == null) {
            return;
        }
        if (doc.hasField("createdBy") && timeline.createdBy != null) {
            doc.remove("createdBy");
        }
        if (doc.hasField("createdOn") && timeline.createdOn != null) {
            doc.remove("createdOn");
        }
        if (doc.hasField("lastModifiedBy") && timeline.lastModifiedBy != null) {
            doc.remove("lastModifiedBy");
        }
        if (doc.hasField("lastModifiedOn") && timeline.lastModifiedOn != null) {
            doc.remove("lastModifiedOn");
        }
        if (doc.hasField("user") && timeline.contributors != null) {
            doc.remove("user");
        }
        doc.addString("createdBy", timeline.createdBy);
        doc.addLong("createdOn", timeline.createdOn);
        doc.addString("lastModifiedBy", timeline.lastModifiedBy);
        doc.addLong("lastModifiedOn", timeline.lastModifiedOn);
        this.indexUserFromTimeline(doc, timeline);
    }

    private void indexUserFromTimeline(LuceneDocBuilder doc, InternalDataCatalogService.TimelineDigest timeline) {
        doc.addStrings("user", timeline.contributors);
    }

    private void addDataFromDiscussions(LuceneDocBuilder doc, List<Discussion> discussions) {
        if (discussions == null) {
            return;
        }
        ArrayList<String> discussionAuthor = new ArrayList<String>();
        ArrayList<String> discussionAuthorName = new ArrayList<String>();
        ArrayList<String> discussionReply = new ArrayList<String>();
        JsonArray jsonDiscussions = new JsonArray();
        for (Discussion c : discussions) {
            JsonObject jsonDiscussionObject = new JsonObject();
            JsonUtils.addFieldIfNotNull((JsonObject)jsonDiscussionObject, (String)"id", (String)c.id);
            JsonUtils.addFieldIfNotNull((JsonObject)jsonDiscussionObject, (String)"topic", (String)c.topic);
            doc.addString("discussions.topic", c.topic);
            jsonDiscussions.add((JsonElement)jsonDiscussionObject);
            for (Discussion.User u : c.users.values()) {
                if (u.lastReplyTime <= 0L) continue;
                discussionAuthor.add(u.login);
                discussionAuthorName.add(u.displayName);
            }
            for (Discussion.DiscussionReply r : c.getReplies()) {
                discussionReply.add(r.text);
            }
        }
        doc.addStrings("discussionAuthor", discussionAuthor);
        doc.addStrings("discussionAuthorName", discussionAuthorName);
        doc.addStrings("discussionReply", discussionReply);
        doc.addJson("discussions", gson.toJson((JsonElement)jsonDiscussions));
    }

    private Set<String> getInputs(List<? extends GraphNode> nodes, Set<GraphNode> visited) {
        HashSet<String> results = new HashSet<String>();
        for (GraphNode graphNode : nodes) {
            if (!visited.add(graphNode)) continue;
            if (graphNode instanceof FlowComputable) {
                FlowComputable flowComputable = (FlowComputable)graphNode;
                if (flowComputable.getPredecessors().isEmpty()) {
                    results.add(flowComputable.getFullId());
                    continue;
                }
                results.addAll(this.getInputs(flowComputable.getPredecessors(), visited));
                continue;
            }
            if (!(graphNode instanceof FlowRunnable)) continue;
            results.addAll(this.getInputs(graphNode.getPredecessors(), visited));
        }
        return results;
    }

    private Set<String> getOutputs(List<? extends GraphNode> nodes, Set<GraphNode> visited) {
        HashSet<String> results = new HashSet<String>();
        for (GraphNode graphNode : nodes) {
            if (!visited.add(graphNode)) continue;
            if (graphNode instanceof FlowComputable) {
                FlowComputable flowComputable = (FlowComputable)graphNode;
                if (flowComputable.getSuccessors().isEmpty()) {
                    results.add(flowComputable.getFullId());
                    continue;
                }
                results.addAll(this.getOutputs(flowComputable.getSuccessors(), visited));
                continue;
            }
            if (!(graphNode instanceof FlowRunnable)) continue;
            results.addAll(this.getOutputs(graphNode.getSuccessors(), visited));
        }
        return results;
    }

    private void addAuthorizedMembersData(LuceneDocBuilder doc, @Nullable SerializedProject project, @Nullable Workspace workspace, @Nullable ITaggingService.TaggableType objectType, @Nullable String objectId, @Nullable Set<String> authorizedMembers) throws IOException {
        doc.addStrings("authorized_members", this.getAuthorizedMembers(project, workspace, objectType, objectId, authorizedMembers));
    }

    private void addAuthorizedMembersDataColumns(LuceneDocBuilder doc, @Nullable SerializedProject project, @Nullable ITaggingService.TaggableType objectType, @Nullable String objectId, @Nullable Set<String> authorizedMembers) throws IOException {
        doc.addStrings("authorized_members", this.getAuthorizedMembers(project, null, objectType, objectId, authorizedMembers));
    }

    private Set<String> getAuthorizedMembers(@Nullable SerializedProject project, @Nullable Workspace workspace, @Nullable ITaggingService.TaggableType objectType, @Nullable String objectId, @Nullable Set<String> authorizedMembers) throws IOException {
        Preconditions.checkArgument((project != null || workspace != null ? 1 : 0) != 0, (Object)"A project or a workspace must be specified");
        if (authorizedMembers == null) {
            if (workspace != null) {
                return this.getWorkspaceAuthorizedMembers(workspace);
            }
            return this.getObjectAuthorizedMembers(project, objectType, objectId);
        }
        return authorizedMembers;
    }

    private LuceneDocBuilder startIndexingTaggableObject(TaggableObjectsService.TaggableObject to, SerializedProject project) throws IOException {
        return this.startIndexingTaggableObject(to, project, null);
    }

    private LuceneDocBuilder startIndexingTaggableObject(TaggableObjectsService.TaggableObject to, SerializedProject project, @Nullable Set<String> authorizedMembers) throws IOException {
        String type = this.getIndexableType(to.getTaggableType());
        LuceneDocBuilder doc = LuceneDocBuilder.from((String)type, (LuceneMappingsAnalyzer)this.internalLuceneMappingsAnalyzer, (String)InternalDataCatalogHelper.objectKey(to));
        doc.addString("id", to.getId());
        doc.addString("name", to.getDisplayName());
        doc.addString("description", to.description);
        doc.addString("shortDesc", to.shortDesc);
        doc.addStrings("tag", (Collection)to.tags);
        doc.addString("projectKey", project.projectKey);
        doc.addString("projectName", project.name);
        if (to.creationTag != null) {
            doc.addString("createdBy", to.creationTag.getLastAuthor());
            doc.addLong("createdOn", Long.valueOf(to.creationTag.getLastModifiedOn()));
        }
        if (to.versionTag != null) {
            doc.addString("lastModifiedBy", to.versionTag.getLastAuthor());
            doc.addLong("lastModifiedOn", Long.valueOf(to.versionTag.getLastModifiedOn()));
        }
        this.addAuthorizedMembersData(doc, project, null, to.getTaggableType(), to.getId(), authorizedMembers);
        return doc;
    }

    private LuceneDocBuilder startIndexingTaggableListItem(TaggableObjectsService.TaggableListItem tli, TaggableObjectsService.TaggableObject to, SerializedProject project) {
        String docType = this.getIndexableType(to.getTaggableType());
        LuceneDocBuilder doc = LuceneDocBuilder.from((String)docType, (LuceneMappingsAnalyzer)this.internalLuceneMappingsAnalyzer, (String)InternalDataCatalogHelper.objectKey(to));
        doc.addString("id", tli.id);
        doc.addString("name", tli.name);
        doc.addString("description", tli.shortDesc);
        doc.addString("shortDesc", tli.shortDesc);
        doc.addStrings("tag", (Collection)tli.tags);
        doc.addString("projectKey", project.projectKey);
        doc.addString("projectName", project.name);
        return doc;
    }

    private void addDatasetParamsData(LuceneDocBuilder doc, DatasetHandler.DatasetParams datasetParams) {
        JsonObject params = JSON.toJsonObject((Object)datasetParams);
        if (params == null) {
            return;
        }
        JsonObject jsonParams = new JsonObject();
        for (String param : InternalDataCatalogService.DATASET_PARAMS) {
            if (params.get(param) == null) continue;
            jsonParams.addProperty(param, params.get(param).getAsString());
            doc.addString("params." + param, params.get(param).getAsString());
        }
        doc.addJson("params", gson.toJson((JsonElement)jsonParams));
    }

    private Set<String> getComputableSuccessors(FlowDataset flowDataset) {
        HashSet<String> results = new HashSet<String>();
        if (flowDataset == null || flowDataset.getSuccessors().isEmpty()) {
            return results;
        }
        for (GraphNode node : flowDataset.getSuccessors()) {
            FlowRecipe recipe;
            if (node instanceof FlowRecipe) {
                recipe = (FlowRecipe)node;
                for (FlowComputable target : recipe.getTargets()) {
                    results.add(target.getFullId());
                }
                continue;
            }
            if (!(node instanceof FlowImplicitRecipe)) continue;
            recipe = (FlowImplicitRecipe)node;
            for (FlowComputable target : recipe.getTargets()) {
                results.add(target.getFullId());
            }
        }
        return results;
    }

    private Set<String> getComputableAncestors(FlowDataset flowDataset) {
        HashSet<String> results = new HashSet<String>();
        if (flowDataset == null || flowDataset.getPredecessors().isEmpty()) {
            return results;
        }
        for (GraphNode node : flowDataset.getPredecessors()) {
            FlowRecipe recipe;
            if (node instanceof FlowRecipe) {
                recipe = (FlowRecipe)node;
                for (FlowComputable src : recipe.getSources()) {
                    results.add(src.getFullId());
                }
                continue;
            }
            if (!(node instanceof FlowImplicitRecipe)) continue;
            recipe = (FlowImplicitRecipe)node;
            for (FlowComputable src : recipe.getSources()) {
                results.add(src.getFullId());
            }
        }
        return results;
    }

    public void indexProject(SerializedProject project) {
        logger.debugV("indexing project data: %s", new Object[]{project.projectKey});
        try {
            InternalDataCatalogService.ProjectItemCounts projectItemCounts = this.getProjectItemCounts(project);
            this.indexProject(project, projectItemCounts);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index project " + project.projectKey), (Throwable)e);
        }
        logger.debugV("done indexing project data: %s", new Object[]{project.projectKey});
    }

    private void indexProject(SerializedProject project, InternalDataCatalogService.ProjectItemCounts counts) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)project, project, this.getObjectAuthorizedMembers(project, ITaggingService.TaggableType.PROJECT, project.projectKey));
            doc.addString("owner", project.owner);
            doc.addString("limitedVisibilityEnabled", project.settings.limitedVisibilityEnabled.name());
            doc.addInt("numDatasets", Integer.valueOf(counts.numDatasets));
            doc.addInt("numRecipes", Integer.valueOf(counts.numRecipes));
            doc.addInt("numManagedFolders", Integer.valueOf(counts.numManagedFolders));
            doc.addInt("numScenarios", Integer.valueOf(counts.numScenarios));
            doc.addInt("numModels", Integer.valueOf(counts.numModels));
            doc.addInt("numNotebooks", Integer.valueOf(counts.numNotebooks));
            doc.addInt("numAnalyses", Integer.valueOf(counts.numAnalyses));
            doc.addInt("numDashboards", Integer.valueOf(counts.numDashboards));
            doc.addInt("numInsights", Integer.valueOf(counts.numInsights));
            doc.addInt("numCodeStudios", Integer.valueOf(counts.numCodeStudios));
            doc.addInt("numWebApps", Integer.valueOf(counts.numWebApps));
            doc.addInt("numReports", Integer.valueOf(counts.numReports));
            doc.addInt("numTasks", Integer.valueOf(counts.numTasks));
            doc.addInt("numWikiArticles", Integer.valueOf(counts.numWikiArticles));
            doc.addInt("numStatisticsWorksheets", Integer.valueOf(counts.numStatisticsWorksheets));
            doc.addInt("numFlowZones", Integer.valueOf(counts.numFlowZones));
            doc.addInt("numLabelingTasks", Integer.valueOf(counts.numLabelingTasks));
            doc.addInt("numKnowledgeBanks", Integer.valueOf(counts.numKnowledgeBanks));
            doc.addInt("numPromptStudios", Integer.valueOf(counts.numPromptStudios));
            doc.addString("type", IndexableType.PROJECT.index());
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)project, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index project " + project.projectKey), (Throwable)e);
        }
    }

    public void indexDataset(SerializedDataset sd, SerializedProject project) {
        this.indexDataset(sd, project, false, null);
    }

    public void indexDataset(SerializedDataset sd, SerializedProject project, boolean firstIndexing, @Nullable List<DataCollection> dataCollectionsOfDataset) {
        try {
            if (ignoredProjects.contains(project.projectKey)) {
                return;
            }
            this.projectFeaturesUsageService.update(project.projectKey, sd);
            Set<String> authorizedMembers = this.getObjectAuthorizedMembers(project, ITaggingService.TaggableType.DATASET, sd.name);
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)sd, project, authorizedMembers);
            this.addDatasetParamsData(doc, sd.getParams());
            this.addSubtypeData(doc, IndexableType.DATASET, sd.type);
            doc.addBoolean("partitioned", Boolean.valueOf(sd.isPartitioned()));
            if (sd.partitioning != null && !sd.partitioning.getDimensionNames().isEmpty()) {
                JsonArray jsonPartitioning = new JsonArray();
                for (String dimensionName : sd.partitioning.getDimensionNames()) {
                    Dimension dimension = sd.partitioning.getDimension(dimensionName);
                    JsonObject jsonPartitioningElement = new JsonObject();
                    jsonPartitioningElement.addProperty("name", dimension.getName());
                    jsonPartitioningElement.addProperty("type", dimension.getType());
                    jsonPartitioning.add((JsonElement)jsonPartitioningElement);
                }
                doc.addJson("partitioning", gson.toJson((JsonElement)jsonPartitioning));
            }
            this.indexElementExpositions((TaggableObjectsService.TaggableObject)sd, project, doc);
            boolean isQuicklyShareable = this.indexQuickShareableElement((TaggableObjectsService.TaggableObject)sd, doc);
            ProjectFlowGraph flowGraph = this.flowGraphService.getProjectGraphUnsafe(sd.projectKey);
            FlowDataset flowDataset = flowGraph.getDataset(sd.projectKey, sd.name);
            Set<Object> successors = new HashSet();
            Set<Object> ancestors = new HashSet();
            Set<Object> inputs = new HashSet();
            Set<Object> outputs = new HashSet();
            if (flowDataset != null) {
                successors = this.getComputableSuccessors(flowDataset);
                ancestors = this.getComputableAncestors(flowDataset);
                inputs = this.getInputs(flowDataset.getPredecessors(), new HashSet<GraphNode>());
                outputs = this.getOutputs(flowDataset.getSuccessors(), new HashSet<GraphNode>());
            }
            doc.addStrings("successors", successors);
            doc.addInt("numSuccessors", Integer.valueOf(successors.size()));
            doc.addStrings("ancestors", ancestors);
            doc.addInt("numAncestors", Integer.valueOf(ancestors.size()));
            JsonArray jsonRecursiveInputs = new JsonArray();
            for (Object input : inputs) {
                JsonObject jsonObject = new JsonObject();
                try {
                    FlowComputable flowComputable = flowGraph.getComputable(AnyLoc.resolveSmart((String)sd.projectKey, (String)input).getFullName());
                    jsonObject.addProperty("type", flowComputable.getType().name());
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Unable to find a dataset input type for computable %s", new Object[]{input});
                }
                jsonObject.addProperty("name", (String)input);
                jsonRecursiveInputs.add((JsonElement)jsonObject);
            }
            doc.addJson("recursiveInputs", gson.toJson((JsonElement)jsonRecursiveInputs));
            JsonArray jsonRecursiveOutputs = new JsonArray();
            for (String string : outputs) {
                JsonObject jsonRecursiveOutputElement = new JsonObject();
                try {
                    FlowComputable flowComputable = flowGraph.getComputable(AnyLoc.resolveSmart((String)sd.projectKey, (String)string).getFullName());
                    jsonRecursiveOutputElement.addProperty("type", flowComputable.getType().name());
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Unable to find a dataset output type for computable %s", new Object[]{string});
                }
                jsonRecursiveOutputElement.addProperty("name", string);
                jsonRecursiveOutputs.add((JsonElement)jsonRecursiveOutputElement);
            }
            doc.addJson("recursiveOutputs", gson.toJson((JsonElement)jsonRecursiveOutputs));
            doc.addInt("numInputs", Integer.valueOf(inputs.size()));
            doc.addInt("numOutputs", Integer.valueOf(outputs.size()));
            if (!firstIndexing) {
                this.deleteColumnsForDataset(sd.projectKey, sd.name);
            }
            InternalDataCatalogService.TimelineDigest timeline = null;
            if (INDEX_TIMELINE) {
                timeline = this.getTimelineDigest((TaggableObjectsService.TaggableObject)sd, project);
            }
            if (sd.getSchema() != null) {
                doc.addInt("numColumns", Integer.valueOf(sd.getSchema().getColumns().size()));
                JsonArray jsonArray = new JsonArray();
                ArrayList<String> columnNames = new ArrayList<String>(sd.getSchema().getColumns().size());
                for (SchemaColumn column : sd.getSchema().getColumns()) {
                    JsonObject jsonColumnsElement = new JsonObject();
                    jsonColumnsElement.addProperty("name", column.getName());
                    jsonColumnsElement.addProperty("type", column.getType().toString());
                    jsonColumnsElement.addProperty("comment", column.comment);
                    jsonColumnsElement.addProperty("meaning", column.getMeaning());
                    jsonArray.add((JsonElement)jsonColumnsElement);
                    doc.addString("columns.name", column.getName());
                    doc.addString("columns.comment", column.comment);
                    this.indexColumn(column, project, sd, timeline, isQuicklyShareable);
                    columnNames.add(column.getName());
                }
                doc.addJson("columns", gson.toJson((JsonElement)jsonArray));
                doc.addStrings("column", columnNames);
            }
            doc.addBoolean("featureGroup", Boolean.valueOf(sd.featureGroup));
            String string = this.dataStewardService.getDataStewardLoginOrDefault(sd);
            if (string != null) {
                doc.addString("dataSteward", string);
            }
            List dataCollections = dataCollectionsOfDataset == null ? this.dataCollectionService.listForItemUnsafe((AbstractDataCollectionItemRef)new AbstractDataCollectionItemRef.DatasetRef(sd.projectKey, sd.name)) : dataCollectionsOfDataset;
            doc.addStrings("dataCollection", (Collection)dataCollections.stream().map(DataCollection::getId).collect(Collectors.toList()));
            doc.addBoolean("isInDataCollection", Boolean.valueOf(!dataCollections.isEmpty()));
            doc.addInt("numDataCollections", Integer.valueOf(dataCollections.size()));
            this.indexCharts(project, sd, authorizedMembers, this.getTimeline((TaggableObjectsService.TaggableObject)sd, project));
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)sd, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index dataset " + sd.getFullId()), (Throwable)e);
        }
    }

    private void indexCharts(SerializedProject project, SerializedDataset ds, @Nullable Set<String> authorizedMembers, @Nullable InternalDataCatalogService.TimelineDigest parentTimeline) throws InterruptedException {
        try {
            DatasetExploreSettings datasetExploreSettings = this.exploresService.get(project.projectKey, ds.name);
            this.indexCharts(project, ds, authorizedMembers, parentTimeline, datasetExploreSettings.charts);
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to explore dataset chart : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void indexCharts(SerializedProject project, SerializedDataset ds, @Nullable Set<String> authorizedMembers, @Nullable InternalDataCatalogService.TimelineDigest parentTimeline, List<DatasetExploreSettings.DatasetChart> charts) throws InterruptedException, IOException {
        int index = 0;
        for (DatasetExploreSettings.DatasetChart chart : charts) {
            this.indexChart(chart.def, project, ds.name, ds.getId(), ds.getTaggableType(), ds.name, authorizedMembers, parentTimeline, index++);
        }
    }

    private void indexCharts(SerializedProject project, AnalysisCoreParams.AnalysisListItem analysis, List<AnalysisCoreParams.AnalysisChart> analysisChartList, @Nullable InternalDataCatalogService.TimelineDigest parentTimeline) throws InterruptedException, IOException {
        int index = 0;
        for (AnalysisCoreParams.AnalysisChart chart : analysisChartList) {
            this.indexChart(chart.def, project, analysis.name, analysis.id, analysis.getTaggableType(), analysis.inputDatasetSmartName, null, parentTimeline, index++);
        }
    }

    private void indexRecipe(SerializedRecipe recipe, SerializedProject project, String payload) {
        if (ignoredProjects.contains(project.projectKey)) {
            return;
        }
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)recipe, project);
            ArrayList<String> listCodeScripts = new ArrayList<String>();
            if (recipe.params instanceof CodeRecipeParams) {
                if (StringUtils.isNotBlank((String)payload)) {
                    listCodeScripts.add(payload);
                }
            } else if (recipe.params instanceof ShakerRecipeParams) {
                params = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
                listCodeScripts.addAll(this.getScriptStepsCodeExpressions(params.steps));
            } else if (recipe.type.equals("grouping")) {
                params = (GroupingRecipePayloadParams)JSON.parse((String)payload, GroupingRecipePayloadParams.class);
                listCodeScripts.addAll(this.getFilterExpressions(params.preFilter));
                listCodeScripts.addAll(this.getFilterExpressions(params.postFilter));
                listCodeScripts.addAll(this.getComputedColumnsExpressions(params.computedColumns));
                listCodeScripts.addAll(this.getCustomExpressionsForGroupingRecipe(params.values));
            } else if (recipe.type.equals("topn")) {
                params = (TopNRecipePayloadParams)JSON.parse((String)payload, TopNRecipePayloadParams.class);
                listCodeScripts.addAll(this.getFilterExpressions(params.preFilter));
                listCodeScripts.addAll(this.getComputedColumnsExpressions(params.computedColumns));
            } else if (recipe.type.equals("pivot")) {
                params = (PivotRecipePayloadParams)JSON.parse((String)payload, PivotRecipePayloadParams.class);
                listCodeScripts.addAll(this.getFilterExpressions(params.preFilter));
                listCodeScripts.addAll(this.getComputedColumnsExpressions(params.computedColumns));
            } else if (recipe.type.equals("vstack")) {
                params = (VStackRecipePayloadParams)JSON.parse((String)payload, VStackRecipePayloadParams.class);
                for (VStackRecipePayloadParams.InputDesc vInput : params.virtualInputs) {
                    listCodeScripts.addAll(this.getFilterExpressions(vInput.preFilter));
                }
                listCodeScripts.addAll(this.getFilterExpressions(params.postFilter));
            } else if (recipe.type.equals("window")) {
                params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
                listCodeScripts.addAll(this.getFilterExpressions(params.preFilter));
                listCodeScripts.addAll(this.getFilterExpressions(params.postFilter));
                listCodeScripts.addAll(this.getComputedColumnsExpressions(params.computedColumns));
                listCodeScripts.addAll(this.getCustomExpressionsForWindowRecipe(params.values));
            } else if (recipe.type.equals("split")) {
                params = (SplitRecipePayloadParams)JSON.parse((String)payload, SplitRecipePayloadParams.class);
                listCodeScripts.addAll(this.getFilterExpressions(params.preFilter));
                listCodeScripts.addAll(this.getComputedColumnsExpressions(params.computedColumns));
                for (SplitRecipePayloadParams.FilterSplitDesc filterSplit : params.filterSplits) {
                    listCodeScripts.addAll(this.getFilterExpressions(filterSplit.filter));
                }
            } else if (recipe.type.equals("sort")) {
                params = (SortRecipePayloadParams)JSON.parse((String)payload, SortRecipePayloadParams.class);
                listCodeScripts.addAll(this.getFilterExpressions(params.preFilter));
                listCodeScripts.addAll(this.getComputedColumnsExpressions(params.computedColumns));
            } else if (recipe.type.equals("join")) {
                params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
                for (JoinInputDescBase virtualInput : params.virtualInputs) {
                    listCodeScripts.addAll(this.getFilterExpressions(virtualInput.preFilter));
                    listCodeScripts.addAll(this.getComputedColumnsExpressions(virtualInput.computedColumns));
                }
                listCodeScripts.addAll(this.getFilterExpressions(params.postFilter));
                listCodeScripts.addAll(this.getComputedColumnsExpressions(params.computedColumns));
            } else if (recipe.type.equals("geojoin")) {
                params = (GeoJoinRecipePayloadParams)JSON.parse((String)payload, GeoJoinRecipePayloadParams.class);
                for (JoinInputDescBase virtualInput : params.virtualInputs) {
                    listCodeScripts.addAll(this.getFilterExpressions(virtualInput.preFilter));
                    listCodeScripts.addAll(this.getComputedColumnsExpressions(virtualInput.computedColumns));
                }
                listCodeScripts.addAll(this.getFilterExpressions(params.postFilter));
            }
            if (!listCodeScripts.isEmpty()) {
                doc.addStrings("code", listCodeScripts);
            }
            JsonArray jsonInputs = new JsonArray();
            for (Map.Entry role : recipe.getInputsUnsafe().entrySet()) {
                for (SerializedRecipe.RecipeInput recipeInput : ((SerializedRecipe.InputRole)role.getValue()).items) {
                    JsonObject jsonInputElement = new JsonObject();
                    jsonInputElement.addProperty("role", (String)role.getKey());
                    jsonInputElement.addProperty("name", recipeInput.ref);
                    doc.addString("inputs.role", (String)role.getKey());
                    doc.addString("inputs.name", recipeInput.ref);
                    try {
                        FlowComputable flowComputable = this.computableFromRefService.get(recipe.getProjectKey(), recipeInput.ref);
                        jsonInputElement.addProperty("type", flowComputable.getType().name());
                        doc.addString("inputs.type", flowComputable.getType().name());
                    }
                    catch (Exception e) {
                        logger.warnV("Unable to find a recipe input type for computable %s: %s", new Object[]{recipeInput.ref, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    jsonInputs.add((JsonElement)jsonInputElement);
                }
            }
            doc.addJson("inputs", gson.toJson((JsonElement)jsonInputs));
            JsonArray jsonOutputs = new JsonArray();
            for (Map.Entry role : recipe.getOutputsUnsafe().entrySet()) {
                for (SerializedRecipe.RecipeOutput recipeOutput : ((SerializedRecipe.OutputRole)role.getValue()).items) {
                    String name = recipeOutput.ref;
                    String type = null;
                    String id = null;
                    try {
                        FlowComputable flowComputable = this.computableFromRefService.get(recipe.getProjectKey(), recipeOutput.ref);
                        type = flowComputable.getType().name();
                        if (flowComputable instanceof FlowModelEvaluationStore) {
                            FlowModelEvaluationStore flowComputableMES = (FlowModelEvaluationStore)flowComputable;
                            name = flowComputableMES.getModelEvaluationStore().name;
                            id = flowComputableMES.getModelEvaluationStore().id;
                        }
                    }
                    catch (Exception e) {
                        logger.warnV("Unable to find a recipe output type for computable %s: %s", new Object[]{recipeOutput.ref, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    doc.addString("outputs.role", (String)role.getKey());
                    JsonObject jsonOutputElement = new JsonObject();
                    jsonOutputElement.addProperty("role", (String)role.getKey());
                    doc.addString("outputs.name", name);
                    jsonOutputElement.addProperty("name", name);
                    if (type != null) {
                        jsonOutputElement.addProperty("type", type);
                        doc.addString("outputs.type", type);
                    }
                    if (id != null) {
                        jsonOutputElement.addProperty("id", id);
                        doc.addString("outputs.id", id);
                    }
                    jsonOutputs.add((JsonElement)jsonOutputElement);
                }
            }
            doc.addJson("outputs", gson.toJson((JsonElement)jsonOutputs));
            this.addSubtypeData(doc, IndexableType.RECIPE, recipe.getType());
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)recipe, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index recipe " + recipe.getFullId()), (Throwable)e);
        }
    }

    private List<String> getScriptStepsCodeExpressions(List<ScriptStep> scriptStepList) {
        ArrayList<String> codeExpressions = new ArrayList<String>();
        for (ScriptStep step : scriptStepList) {
            if (step instanceof GroupScriptStep) {
                GroupScriptStep groupScriptStep = (GroupScriptStep)step;
                for (ProcessorScriptStep processorScriptStep : groupScriptStep.steps) {
                    codeExpressions.addAll(this.getProcessorScriptStepCodeExpressions(processorScriptStep));
                }
                continue;
            }
            if (!(step instanceof ProcessorScriptStep)) continue;
            ProcessorScriptStep processorScriptStep = (ProcessorScriptStep)step;
            codeExpressions.addAll(this.getProcessorScriptStepCodeExpressions(processorScriptStep));
        }
        return codeExpressions;
    }

    private List<String> getProcessorScriptStepCodeExpressions(ProcessorScriptStep processorScriptStep) {
        ArrayList<String> codeExpressions = new ArrayList<String>();
        if (processorScriptStep.params instanceof FilterAndFlagOnCustomFormulaResult.Parameter) {
            String expression = ((FilterAndFlagOnCustomFormulaResult.Parameter)processorScriptStep.params).expression;
            InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(expression, codeExpressions);
        } else if (processorScriptStep.params instanceof CreateColumnWithGREL.Parameter) {
            String expression = ((CreateColumnWithGREL.Parameter)processorScriptStep.params).expression;
            InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(expression, codeExpressions);
        } else if (processorScriptStep.params instanceof PythonParameter) {
            String expression = ((PythonParameter)processorScriptStep.params).pythonSourceCode;
            InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(expression, codeExpressions);
        } else if (processorScriptStep.params instanceof GrokProcessor.Parameter) {
            String expression = ((GrokProcessor.Parameter)processorScriptStep.params).grokPattern;
            InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(expression, codeExpressions);
        } else if (processorScriptStep.params instanceof VisualIfRule.Parameter) {
            VisualIfDesc visualIfDesc = ((VisualIfRule.Parameter)processorScriptStep.params).visualIfDesc;
            for (VisualIfDesc.Action action : visualIfDesc.ifThen.actions) {
                InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(action.formula, codeExpressions);
            }
            for (VisualIfDesc.Action action : visualIfDesc.elseIfThens.stream().map(e -> e.actions).flatMap(Collection::stream).toList()) {
                InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(action.formula, codeExpressions);
            }
            for (VisualIfDesc.Action action : visualIfDesc.elseActions) {
                InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(action.formula, codeExpressions);
            }
        }
        return codeExpressions;
    }

    List<String> getFilterExpressions(FilterDesc filterDesc) {
        String preFilterExpression = FilterDescUtils.getRawExpression((FilterDesc)filterDesc);
        if (StringUtils.isNotBlank((String)preFilterExpression)) {
            return Arrays.asList(preFilterExpression);
        }
        return new ArrayList<String>();
    }

    private List<String> getCustomExpressionsForGroupingRecipe(List<GroupingRecipePayloadParams.GroupingValue> groupingValues) {
        ArrayList<String> listCustomExpressions = new ArrayList<String>();
        if (groupingValues != null) {
            for (GroupingRecipePayloadParams.GroupingValue colValue : groupingValues) {
                InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(colValue.customExpr, listCustomExpressions);
            }
        }
        return listCustomExpressions;
    }

    private List<String> getCustomExpressionsForWindowRecipe(List<WindowRecipePayloadParams.WindowValue> groupingValues) {
        ArrayList<String> listCustomExpressions = new ArrayList<String>();
        if (groupingValues != null) {
            for (WindowRecipePayloadParams.WindowValue colValue : groupingValues) {
                InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(colValue.customExpr, listCustomExpressions);
            }
        }
        return listCustomExpressions;
    }

    private List<String> getComputedColumnsExpressions(List<ComputedColumn> computedColumns) {
        ArrayList<String> listComputedColExpr = new ArrayList<String>();
        if (computedColumns != null) {
            for (ComputedColumn computedCol : computedColumns) {
                InternalCatalogIndexingQueueHandler.addValueInListIfNotBlank(computedCol.expr, listComputedColExpr);
            }
        }
        return listComputedColExpr;
    }

    private static void addValueInListIfNotBlank(String newValue, List<String> list) {
        if (StringUtils.isNotBlank((String)newValue)) {
            list.add(newValue);
        }
    }

    private void indexJupyterNotebook(JupyterUtils.JupyterNotebookListEntry notebook, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)notebook, project);
            doc.addString("language", notebook.language);
            doc.addString("dataset", notebook.analyzedDataset);
            doc.addString("recipe", notebook.associatedRecipe);
            this.addSubtypeData(doc, IndexableType.NOTEBOOK, ITaggingService.TaggableType.JUPYTER_NOTEBOOK.toString());
            if ("Python".equals(notebook.language)) {
                doc.appendString("type", "python");
            } else if ("R".equals(notebook.language)) {
                doc.appendString("type", "r");
            } else {
                doc.appendString("type", notebook.language);
            }
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)notebook, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index Jupyter notebook " + notebook.getFullId()), (Throwable)e);
        }
    }

    private void indexDataCollection(DataCollection dataCollection, TaggableObjectsService.TaggableObjectRef tor) {
        try {
            String objectKey = InternalDataCatalogHelper.objectKey(tor);
            LuceneDocBuilder doc = LuceneDocBuilder.from((String)IndexableType.DATA_COLLECTION.index(), (LuceneMappingsAnalyzer)this.internalLuceneMappingsAnalyzer, (String)objectKey);
            doc.addString("name", dataCollection.displayName);
            doc.addString("description", dataCollection.description);
            doc.addStrings("tag", (Collection)dataCollection.tags);
            doc.addString("id", dataCollection.id);
            doc.addStrings("authorized_members", this.getDataCollectionAuthorizedMembers(dataCollection));
            this.pushToIndex(doc, this.internalIndexManager);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index Data Collection " + dataCollection.getId()), (Throwable)e);
        }
    }

    private Set<String> getDataCollectionAuthorizedMembers(DataCollection dataCollection) {
        HashSet<String> authorizedMembers = new HashSet<String>();
        for (BasePermissions.PermissionItem permissionItem : dataCollection.permissions) {
            if (permissionItem.group != null) {
                authorizedMembers.add("g:" + permissionItem.group);
            }
            if (permissionItem.user == null) continue;
            authorizedMembers.add("u:" + permissionItem.user);
        }
        return authorizedMembers;
    }

    private void indexSQLNotebook(SQLNotebook notebook, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)notebook, project);
            doc.addString("language", "SQL");
            this.addSubtypeData(doc, IndexableType.NOTEBOOK, ITaggingService.TaggableType.SQL_NOTEBOOK.toString());
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)notebook, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index SQL notebook " + notebook.getFullId()), (Throwable)e);
        }
    }

    private void indexSearchNotebook(SearchNotebook notebook, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)notebook, project);
            doc.addString("language", "ES_QUERY_STRING");
            this.addSubtypeData(doc, IndexableType.NOTEBOOK, ITaggingService.TaggableType.SEARCH_NOTEBOOK.toString());
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)notebook, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index Search notebook " + notebook.getFullId()), (Throwable)e);
        }
    }

    private void indexSavedModel(SavedModel sm, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)sm, project);
            this.addSubtypeData(doc, IndexableType.SAVED_MODEL, sm.getType().toString());
            this.indexElementExpositions((TaggableObjectsService.TaggableObject)sm, project, doc);
            this.indexQuickShareableElement((TaggableObjectsService.TaggableObject)sm, doc);
            this.indexSMSpecifics(sm, doc);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)sm, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index saved model " + sm.getFullId()), (Throwable)e);
        }
    }

    private void indexModelEvaluationStore(ModelEvaluationStore mes, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)mes, project);
            this.addSubtypeData(doc, IndexableType.MODEL_EVALUATION_STORE, mes.getSubtype());
            this.indexElementExpositions((TaggableObjectsService.TaggableObject)mes, project, doc);
            this.indexQuickShareableElement((TaggableObjectsService.TaggableObject)mes, doc);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)mes, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index model evaluation store " + mes.getFullId()), (Throwable)e);
        }
    }

    private void indexManagedFolder(ManagedFolder mf, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)mf, project);
            doc.addBoolean("partitioned", Boolean.valueOf(mf.isPartitioned()));
            if (mf.isPartitioned() && !mf.partitioning.getDimensionNames().isEmpty()) {
                JsonArray jsonPartitioning = new JsonArray();
                for (String dimensionName : mf.partitioning.getDimensionNames()) {
                    Dimension dimension = mf.partitioning.getDimension(dimensionName);
                    JsonObject jsonPartitioningElement = new JsonObject();
                    jsonPartitioningElement.addProperty("name", dimension.getName());
                    jsonPartitioningElement.addProperty("type", dimension.getType());
                    jsonPartitioning.add((JsonElement)jsonPartitioningElement);
                }
                doc.addJson("partitioning", gson.toJson((JsonElement)jsonPartitioning));
            }
            this.indexElementExpositions((TaggableObjectsService.TaggableObject)mf, project, doc);
            this.indexQuickShareableElement((TaggableObjectsService.TaggableObject)mf, doc);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)mf, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index managed folder " + mf.getFullId()), (Throwable)e);
        }
    }

    private void indexScenario(Scenario sc, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)sc, project);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)sc, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index scenario " + sc.getFullId()), (Throwable)e);
        }
    }

    private void indexArticle(Article article, SerializedProject project, String payload) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)article, project);
            doc.addString("text", payload);
            if (article.attachments != null) {
                JsonArray jsonAttachments = new JsonArray();
                for (Article.ArticleAttachment attachment : article.attachments) {
                    if (attachment.attachmentType == Article.ArticleAttachmentType.DSS_OBJECT) {
                        AnyLoc loc = AnyLoc.resolveSmart((String)project.projectKey, (String)attachment.smartId).resolved();
                        this.enrichmentService.enrich((EnrichmentService.EnrichableSmartId)attachment, project.projectKey);
                        JsonObject jsonAttachmentElement = new JsonObject();
                        jsonAttachmentElement.addProperty("projectKey", loc.getProjectKey());
                        jsonAttachmentElement.addProperty("type", attachment.taggableType.name());
                        jsonAttachmentElement.addProperty("id", loc.getId());
                        jsonAttachmentElement.addProperty("displayName", attachment.details.has("objectDisplayName") ? attachment.details.get("objectDisplayName").getAsString() : "");
                        jsonAttachments.add((JsonElement)jsonAttachmentElement);
                        doc.addString("attachments.projectKey", loc.getProjectKey());
                        doc.addString("attachments.type", attachment.taggableType.name());
                        doc.addString("attachments.displayName", attachment.details.has("objectDisplayName") ? attachment.details.get("objectDisplayName").getAsString() : "");
                        continue;
                    }
                    if (attachment.attachmentType != Article.ArticleAttachmentType.FILE) continue;
                    JsonObject jsonAttachmentElement = new JsonObject();
                    jsonAttachmentElement.addProperty("displayName", attachment.details.has("objectDisplayName") ? attachment.details.get("objectDisplayName").getAsString() : "");
                    jsonAttachmentElement.addProperty("size", (Number)(attachment.details.has("size") ? attachment.details.get("size").getAsLong() : 0L));
                    if (attachment.details.has("mimeType")) {
                        jsonAttachmentElement.addProperty("mimeType", attachment.details.get("mimeType").getAsString());
                    }
                    jsonAttachments.add((JsonElement)jsonAttachmentElement);
                    doc.addString("attachments.displayName", attachment.details.has("objectDisplayName") ? attachment.details.get("objectDisplayName").getAsString() : "");
                    doc.addLong("attachments.size", Long.valueOf(attachment.details.has("size") ? attachment.details.get("size").getAsLong() : 0L));
                    if (!attachment.details.has("mimeType")) continue;
                    doc.addString("attachments.mimeType", attachment.details.get("mimeType").getAsString());
                }
                doc.addJson("attachments", gson.toJson((JsonElement)jsonAttachments));
            }
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)article, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index article " + article.getFullId()), (Throwable)e);
        }
    }

    private void indexAnalysis(AnalysisCoreParams.AnalysisListItem analysis, AnalysisCoreParams acp, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableListItem((TaggableObjectsService.TaggableListItem)analysis, (TaggableObjectsService.TaggableObject)acp, project);
            doc.addString("dataset", analysis.inputDatasetSmartName);
            doc.addInt("numCharts", Integer.valueOf(analysis.nbCharts));
            doc.addInt("numMLTasks", Integer.valueOf(analysis.nbMLTasks));
            doc.addInt("numSteps", Integer.valueOf(analysis.nbSteps));
            JsonArray jsonMlTasks = new JsonArray();
            if (analysis.mlTasks != null) {
                for (AnalysisCRUDService.MLTaskHead mlTask : analysis.mlTasks) {
                    JsonObject jsonMlTaskElement = new JsonObject();
                    jsonMlTaskElement.addProperty("name", mlTask.name);
                    jsonMlTaskElement.addProperty("id", mlTask.mlTaskId);
                    if (mlTask.taskType == MLTask.MLTaskType.PREDICTION && mlTask.predictionType != null) {
                        jsonMlTaskElement.addProperty("type", mlTask.predictionType.toString());
                    } else {
                        jsonMlTaskElement.addProperty("type", mlTask.taskType.toString());
                    }
                    if (mlTask.backendType != null) {
                        jsonMlTaskElement.addProperty("backendType", mlTask.backendType.toString());
                    }
                    jsonMlTasks.add((JsonElement)jsonMlTaskElement);
                }
            }
            doc.addJson("mlTasks", gson.toJson((JsonElement)jsonMlTasks));
            this.indexCharts(project, analysis, acp.charts, this.getTimeline((TaggableObjectsService.TaggableObject)acp, project));
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)acp, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index analysis " + acp.getFullId()), (Throwable)e);
        }
    }

    private void indexInsight(Insight insight, SerializedProject project, @Nullable Set<String> authorizedMembers, @Nullable Set<String> dashboardReaderGroups, @Nullable Set<String> dashboardReaderUsers) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)insight, project, authorizedMembers);
            doc.addString("owner", insight.owner);
            doc.addBoolean("listed", Boolean.valueOf(insight.listed));
            doc.addString("type_raw", insight.type);
            doc.addStrings("authorized_dashboard_groups", dashboardReaderGroups != null ? dashboardReaderGroups : this.getDashboardReaderGroups(project));
            doc.addStrings("authorized_dashboard_users", dashboardReaderUsers != null ? dashboardReaderUsers : this.getDashboardReaderUsers(project));
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)insight, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index insight " + insight.getFullId()), (Throwable)e);
        }
    }

    private void indexChart(ChartDef def, SerializedProject project, String objectOwnerName, String objectOwnerId, ITaggingService.TaggableType objectOwnerType, String datasetName, @Nullable Set<String> authorizedMembers, @Nullable InternalDataCatalogService.TimelineDigest parentTimeline, int index) throws IOException, InterruptedException {
        if (def.isNewChartEmpty()) {
            return;
        }
        String docType = IndexableType.CHART.index();
        String objectId = objectOwnerId + "_" + index;
        String objectKey = InternalDataCatalogHelper.objectKey(project.projectKey, "CHART", objectId, null);
        LuceneDocBuilder doc = LuceneDocBuilder.from((String)docType, (LuceneMappingsAnalyzer)this.internalLuceneMappingsAnalyzer, (String)objectKey);
        doc.addString("projectKey", project.projectKey);
        doc.addString("projectName", project.name);
        doc.addString("name", def.name);
        doc.addString("dataset", datasetName);
        doc.addInt("index", Integer.valueOf(index));
        doc.addString("objectType", objectOwnerType.name().toLowerCase());
        doc.addString("objectName", objectOwnerName);
        doc.addString("objectId", objectOwnerId);
        doc.addString("type_raw", def.getChartDisplayName());
        if (parentTimeline != null) {
            this.indexUserFromTimeline(doc, parentTimeline);
        }
        this.addAuthorizedMembersData(doc, project, null, objectOwnerType, objectOwnerId, authorizedMembers);
        this.pushToIndex(doc, this.internalIndexManager);
    }

    private void indexDashboard(Dashboard dashboard, SerializedProject project, @Nullable Set<String> authorizedMembers, @Nullable Set<String> dashboardReaderGroups, @Nullable Set<String> dashboardReaderUsers) {
        try {
            boolean listed = project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY && dashboard.listed;
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)dashboard, project, authorizedMembers);
            doc.addString("owner", dashboard.owner);
            doc.addBoolean("listed", Boolean.valueOf(listed));
            doc.addInt("numPages", Integer.valueOf(dashboard.pages.size()));
            int numTiles = 0;
            for (DashboardPage page : dashboard.pages) {
                numTiles += page.grid.tiles.size();
            }
            ArrayList<Tile.Box> miniatureBoxes = new ArrayList<Tile.Box>();
            ArrayList<String> insightTypes = new ArrayList<String>();
            for (Tile tile : ((DashboardPage)dashboard.pages.get((int)0)).grid.tiles) {
                miniatureBoxes.add(tile.box);
                if (tile.insightType == null) continue;
                insightTypes.add(tile.insightType);
            }
            doc.addInt("numTiles", Integer.valueOf(numTiles));
            Gson gson = new Gson();
            doc.addString("miniatureBoxes", "{\"boxes\": " + gson.toJson(miniatureBoxes) + ", \"insightTypes\": " + gson.toJson(insightTypes) + "}");
            doc.addStrings("authorized_dashboard_groups", dashboardReaderGroups != null ? dashboardReaderGroups : this.getDashboardReaderGroups(project));
            doc.addStrings("authorized_dashboard_users", dashboardReaderUsers != null ? dashboardReaderUsers : this.getDashboardReaderUsers(project));
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)dashboard, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index dashboard " + dashboard.getFullId()), (Throwable)e);
        }
    }

    private void indexReport(Report report, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)report, project);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)report, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index report " + report.getFullId()), (Throwable)e);
        }
    }

    private void indexWebApp(WebApp webApp, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)webApp, project);
            this.addSubtypeData(doc, IndexableType.WEB_APP, webApp.type);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)webApp, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index web app " + webApp.getFullId()), (Throwable)e);
        }
    }

    private void indexCodeStudioObject(CodeStudioObject codeStudioObject, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)codeStudioObject, project);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)codeStudioObject, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index code studio " + codeStudioObject.getFullId()), (Throwable)e);
        }
    }

    private void indexColumn(SchemaColumn column, SerializedProject project, SerializedDataset dataset, InternalDataCatalogService.TimelineDigest timeline, boolean isQuicklyShareable) {
        if (!INDEX_COLUMNS) {
            return;
        }
        String objectKey = InternalDataCatalogHelper.objectKey(dataset.projectKey, dataset.name, column.getName(), null);
        try {
            String type = IndexableType.COLUMN.index();
            LuceneDocBuilder mainDocument = LuceneDocBuilder.from((String)type, (LuceneMappingsAnalyzer)this.columnLuceneMappingsAnalyzer, (String)objectKey);
            Set<String> authorizedMembers = this.getObjectAuthorizedMembers(project, ITaggingService.TaggableType.DATASET, dataset.name);
            this.addAuthorizedMembersDataColumns(mainDocument, project, ITaggingService.TaggableType.DATASET, dataset.getId(), authorizedMembers);
            this.addEditionDataFromTimelineColumns(mainDocument, timeline, type);
            mainDocument.addString("name", column.getName());
            mainDocument.addString("storedAs", column.getType().toString());
            mainDocument.addString("dataset", dataset.name);
            mainDocument.addBoolean("fromFeatureGroup", Boolean.valueOf(dataset.featureGroup));
            mainDocument.addString("description", column.comment);
            mainDocument.addString("shortDesc", dataset.shortDesc);
            mainDocument.addString("meaning", column.getMeaning());
            mainDocument.addString("projectKey", project.projectKey);
            mainDocument.addString("projectName", project.name);
            mainDocument.addStrings("tag", (Collection)dataset.tags);
            mainDocument.addBoolean("isQuicklyShareable", Boolean.valueOf(isQuicklyShareable));
            mainDocument.addString("type", column.getTypeString());
            mainDocument.addString("type_raw", column.getTypeString());
            this.columnIndexManager.addDocument(mainDocument);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index column " + objectKey), (Throwable)e);
        }
    }

    private void indexMeaning(UserDefinedMeaning meaning) {
        try {
            String type = IndexableType.MEANING.index();
            LuceneDocBuilder doc = LuceneDocBuilder.from((String)type, (LuceneMappingsAnalyzer)this.columnLuceneMappingsAnalyzer, (String)meaning.id);
            doc.addString("id", meaning.id);
            doc.addString("udm_type", meaning.type.name());
            doc.addString("description", meaning.description);
            doc.addString("label", meaning.label);
            doc.addString("pattern", meaning.pattern);
            if (meaning.entries != null) {
                JsonArray jsonEntries = new JsonArray();
                for (UserDefinedMeaning.Entry entry : meaning.entries) {
                    JsonObject jsonEntryElement = new JsonObject();
                    jsonEntryElement.addProperty("value", entry.value);
                    jsonEntryElement.addProperty("color", entry.color);
                    jsonEntries.add((JsonElement)jsonEntryElement);
                }
                doc.addJson("entries", gson.toJson((JsonElement)jsonEntries));
            }
            if (meaning.mappings != null) {
                JsonArray jsonMappings = new JsonArray();
                for (UserDefinedMeaning.Mapping mapping : meaning.mappings) {
                    JsonObject jsonMappingsElement = new JsonObject();
                    jsonMappingsElement.addProperty("from", mapping.from);
                    JsonObject jsonMappingsToElement = new JsonObject();
                    jsonMappingsToElement.addProperty("value", mapping.to.value);
                    jsonMappingsToElement.addProperty("color", mapping.to.color);
                    jsonMappingsElement.add("to", (JsonElement)jsonMappingsToElement);
                    jsonMappings.add((JsonElement)jsonMappingsElement);
                }
                doc.addJson("mappings", gson.toJson((JsonElement)jsonMappings));
            }
            this.columnIndexManager.addDocument(doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index meaning " + meaning.id), (Throwable)e);
        }
    }

    private void indexModelComparison(ModelComparison modelComparison, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)modelComparison, project);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)modelComparison, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index model comparison " + modelComparison.getFullId()), (Throwable)e);
        }
    }

    private void indexWorksheet(Worksheet worksheet, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)worksheet, project);
            doc.addString("dataset", worksheet.getDataSpec().inputDatasetSmartName);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)worksheet, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index worksheet " + worksheet.getFullId()), (Throwable)e);
        }
    }

    private void indexZone(Zone zone, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)zone, project);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)zone, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index zone " + zone.getFullId()), (Throwable)e);
        }
    }

    private void indexLabelingTask(LabelingTask task, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)task, project);
            JsonArray jsonInputs = new JsonArray();
            for (Map.Entry role : task.inputs.entrySet()) {
                for (LabelingTask.LabelingTaskInput labelingTaskInput : ((LabelingTask.InputRole)role.getValue()).items) {
                    JsonObject jsonInputElement = new JsonObject();
                    jsonInputElement.addProperty("role", (String)role.getKey());
                    jsonInputElement.addProperty("name", labelingTaskInput.ref);
                    try {
                        FlowComputable flowComputable = this.computableFromRefService.get(task.getProjectKey(), labelingTaskInput.ref);
                        jsonInputElement.addProperty("type", flowComputable.getType().name());
                    }
                    catch (Exception e) {
                        logger.warnV("Unable to find a labeling task input type for computable %s: %s", new Object[]{labelingTaskInput.ref, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    jsonInputs.add((JsonElement)jsonInputElement);
                }
            }
            doc.addJson("inputs", gson.toJson((JsonElement)jsonInputs));
            JsonArray jsonOutputs = new JsonArray();
            for (Map.Entry role : task.outputs.entrySet()) {
                for (LabelingTask.LabelingTaskOutput recipeOutput : ((LabelingTask.OutputRole)role.getValue()).items) {
                    String name = recipeOutput.ref;
                    String type = null;
                    try {
                        FlowComputable flowComputable = this.computableFromRefService.get(task.getProjectKey(), recipeOutput.ref);
                        type = flowComputable.getType().name();
                    }
                    catch (Exception e) {
                        logger.warnV("Unable to find a labeling task output type for computable %s: %s", new Object[]{recipeOutput.ref, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    JsonObject jsonOutputElement = new JsonObject();
                    jsonOutputElement.addProperty("role", (String)role.getKey());
                    jsonOutputElement.addProperty("name", name);
                    if (type != null) {
                        jsonOutputElement.addProperty("type", type);
                    }
                    jsonOutputs.add((JsonElement)jsonOutputElement);
                }
            }
            doc.addJson("outputs", gson.toJson((JsonElement)jsonOutputs));
            this.addSubtypeData(doc, IndexableType.LABELING_TASK, task.getSubtype());
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)task, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index labeling task " + task.getFullId()));
        }
    }

    private void indexKnowledgeBank(RetrievableKnowledge knowledgeBank, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)knowledgeBank, project);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)knowledgeBank, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index knowledge bank " + knowledgeBank.getFullId()));
        }
    }

    private void indexPromptStudio(PromptStudio promptStudio, SerializedProject project) {
        try {
            LuceneDocBuilder doc = this.startIndexingTaggableObject((TaggableObjectsService.TaggableObject)promptStudio, project);
            this.finishIndexingTaggableObject((TaggableObjectsService.TaggableObject)promptStudio, project, doc);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to index prompt studio " + promptStudio.getFullId()));
        }
    }

    public InternalDataCatalogService.ProjectItemCounts getProjectItemCounts(SerializedProject project) throws Exception {
        InternalDataCatalogService.ProjectItemCounts counts = new InternalDataCatalogService.ProjectItemCounts();
        counts.numDatasets = this.datasetsDAO.approximateCount(project.projectKey);
        counts.numRecipes = this.recipesDAO.approximateCount(project.projectKey);
        counts.numNotebooks = this.jupyterService.approximateCount(project.projectKey) + this.sqlNotebooksDAO.approximateCount(project.projectKey) + this.searchNotebooksDAO.approximateCount(project.projectKey);
        counts.numInsights = this.insightsService.approximateCount(project.projectKey);
        counts.numDashboards = this.dashboardsService.approximateCount(project.projectKey);
        counts.numCodeStudios = this.codeStudioObjectsService.approximateCount(project.projectKey);
        counts.numWebApps = this.webAppsService.approximateCount(project.projectKey);
        counts.numReports = this.reportsService.approximateCount(project.projectKey);
        counts.numSavedModels = this.savedModelsDAO.approximateCount(project.projectKey);
        counts.numManagedFolders = this.managedFolderDAO.approximateCount(project.projectKey);
        counts.numScenarios = this.scenariosService.approximateCount(project.projectKey);
        counts.numWikiArticles = this.articlesDAO.approximateCount(project.projectKey);
        counts.numStatisticsWorksheets = this.worksheetsService.approximateCount(project.projectKey);
        counts.numFlowZones = this.zonesDAO.approximateCount(project.projectKey);
        counts.numLabelingTasks = this.labelingTasksDAO.approximateCount(project.projectKey);
        counts.numKnowledgeBanks = this.retrievableKnowledgeDAO.approximateCount(project.projectKey);
        counts.numPromptStudios = this.promptStudioDAO.approximateCount(project.projectKey);
        for (AnalysisCoreParams.AnalysisListItem analysisHead : this.analysisCRUDService.listHeadsUnsafe(project.projectKey, null)) {
            ++counts.numAnalyses;
            counts.numModels += analysisHead.nbMLTasks;
        }
        counts.numTasks = this.countTasks(project);
        return counts;
    }

    private int countTasks(SerializedProject project) {
        int numTasks = 0;
        for (Checklist checklist : project.checklists.checklists) {
            for (Checklist.ChecklistItem item : checklist.items) {
                if (item.done) continue;
                ++numTasks;
            }
        }
        return numTasks;
    }

    private void pushToIndex(LuceneDocBuilder doc, LuceneIndexManager indexManager) throws InterruptedException {
        Preconditions.checkArgument((boolean)doc.hasId(), (Object)"id not specified");
        indexManager.addDocument(doc);
    }

    private void delete(ITaggingService.TaggableType type, String projectKey, String id) throws IOException, InterruptedException {
        if (type == null || id == null) {
            logger.warnV("Invalid parameters while trying to delete document : type=%s, projectKey=%s, id=%s", new Object[]{type, projectKey, id});
            return;
        }
        String objectKey = InternalDataCatalogHelper.objectKey(projectKey, type, id, null);
        this.deleteById(this.internalIndexManager, this.getIndexableType(type), objectKey);
        this.deleteDiscussionsForObject(new TaggableObjectsService.TaggableObjectRef(projectKey, type, id));
        if (type == ITaggingService.TaggableType.DATASET) {
            this.deleteColumnsForDataset(projectKey, id);
        }
        if (type == ITaggingService.TaggableType.RECIPE || type == ITaggingService.TaggableType.DATASET) {
            this.indexWholeProjectDebounced(projectKey);
        }
        if (type == ITaggingService.TaggableType.ANALYSIS || type == ITaggingService.TaggableType.DATASET) {
            this.deleteChartsForObjectId(projectKey, id);
        }
    }

    private void deleteColumnsForDataset(String projectKey, String datasetName) throws IOException, InterruptedException {
        this.deleteByQuery(this.columnIndexManager, this.storedColumnsForDatasetQuery(projectKey, datasetName));
    }

    private void deleteDiscussionsForObject(TaggableObjectsService.TaggableObjectRef tor) throws IOException, InterruptedException {
        this.deleteByQuery(this.internalIndexManager, this.storedDiscussionsForObjectQuery(tor));
    }

    private void deleteObjectsForProject(String projectKey) throws IOException, InterruptedException {
        this.deleteByQuery(this.internalIndexManager, this.storedObjectsForProjectQuery(projectKey));
    }

    private void deleteColumnsForProject(String projectKey) throws IOException, InterruptedException {
        this.deleteByQuery(this.columnIndexManager, this.storedColumnsForProjectQuery(projectKey));
    }

    private void deleteChartsForObjectId(String projectKey, String objectId) throws IOException, InterruptedException {
        this.deleteByQuery(this.internalIndexManager, this.storedChartsForObjectIdQuery(projectKey, objectId));
    }

    private class IndexationCache {
        Map<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo> creationAndUpdateInfoCache;
        Map<TaggableObjectsService.TaggableObjectRef, Collection<String>> contributorsCache;
        Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> discussionsCache;

        private IndexationCache() {
        }

        void fillForAllObjects(Collection<SerializedProject> projects) throws Exception {
            ArrayList<String> projectKeys = new ArrayList<String>(projects.size());
            for (SerializedProject project : projects) {
                projectKeys.add(project.projectKey);
            }
            logger.info((Object)"Reading timeline data");
            try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"catalog.indexAll.timelineRequests");){
                this.creationAndUpdateInfoCache = InternalCatalogIndexingQueueHandler.this.timelinesService.getCreationAndUpdateInfoForAllObjects(projectKeys);
                this.contributorsCache = InternalCatalogIndexingQueueHandler.this.timelinesService.getContributorsForAllObjects(projectKeys);
            }
            logger.info((Object)"Reading discussions data");
            tctx = DSSMetrics.timeCtx((String)"catalog.indexAll.discussionsRequests");
            try {
                this.discussionsCache = InternalCatalogIndexingQueueHandler.this.discussionsService.getAllDiscussions();
            }
            finally {
                if (tctx != null) {
                    tctx.close();
                }
            }
        }

        List<Discussion> getDiscussions(TaggableObjectsService.TaggableObjectRef tor) {
            ArrayList discussions = this.discussionsCache == null ? Lists.newArrayList() : (this.discussionsCache.get(tor) != null ? Lists.newArrayList((Iterable)this.discussionsCache.get(tor)) : Lists.newArrayList());
            return discussions;
        }

        List<String> getContributors(TaggableObjectsService.TaggableObjectRef tor) {
            ArrayList contributors;
            if (this.contributorsCache == null) {
                logger.warn((Object)"Cache not initialized");
                contributors = Lists.newArrayList();
            } else {
                contributors = this.contributorsCache.get(tor) != null ? Lists.newArrayList((Iterable)this.contributorsCache.get(tor)) : new ArrayList();
            }
            return contributors;
        }

        HeadWithVersioningInfo getCreationAndUpdateInfo(TaggableObjectsService.TaggableObjectRef tor) {
            HeadWithVersioningInfo head = this.creationAndUpdateInfoCache != null && this.creationAndUpdateInfoCache.containsKey(tor) ? this.creationAndUpdateInfoCache.get(tor) : null;
            return head;
        }

        void fillForObject(TaggableObjectsService.TaggableObjectRef tor) throws Exception {
            this.discussionsCache = new HashMap<TaggableObjectsService.TaggableObjectRef, List<Discussion>>();
            this.discussionsCache.put(tor, InternalCatalogIndexingQueueHandler.this.discussionsService.getForObject(tor));
            this.contributorsCache = new HashMap<TaggableObjectsService.TaggableObjectRef, Collection<String>>();
            if (StringUtils.isBlank((String)tor.workspaceKey)) {
                this.contributorsCache.put(tor, InternalCatalogIndexingQueueHandler.this.timelinesService.getContributorsForObject(tor));
                this.creationAndUpdateInfoCache = new HashMap<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo>();
                HeadWithVersioningInfo head = InternalCatalogIndexingQueueHandler.this.timelinesService.getCreationAndUpdateInfo(tor);
                if (head != null) {
                    this.creationAndUpdateInfoCache.put(tor, head);
                }
            }
        }

        void clear() {
            this.creationAndUpdateInfoCache = null;
            this.contributorsCache = null;
            this.discussionsCache = null;
        }
    }
}

