/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ServerApi;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.lang.Nullable;

public final class InternalOperationContextFactory {
    private final TimeoutSettings timeoutSettings;
    @Nullable
    private final ServerApi serverApi;

    public InternalOperationContextFactory(TimeoutSettings timeoutSettings, @Nullable ServerApi serverApi) {
        this.timeoutSettings = timeoutSettings;
        this.serverApi = serverApi;
    }

    OperationContext create() {
        return OperationContext.simpleOperationContext(this.timeoutSettings.connectionOnly(), this.serverApi);
    }

    OperationContext createMaintenanceContext() {
        return this.create().withTimeoutContext(TimeoutContext.createMaintenanceTimeoutContext(this.timeoutSettings));
    }
}

