/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Interactions
implements Processor {
    private static final long serialVersionUID = 1L;
    public final List<Interaction> interactions;

    public Interactions(List<Interaction> interactions) {
        this.interactions = interactions;
    }

    @Override
    public void process(RawObservation data) {
        for (Interaction i : this.interactions) {
            i.process(data);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Interactions(\n");
        for (Interaction i : this.interactions) {
            s.append("\t\t").append(i.toString()).append(",\n");
        }
        return s.append(")").toString();
    }

    public static interface Interaction
    extends Processor {
    }

    public static class CategoricalCategoricalInteraction
    implements Interaction {
        private static final long serialVersionUID = 1L;
        public final String column_1;
        public final String column_2;
        public final Set<StringPair> values;

        public CategoricalCategoricalInteraction(String column_1, String column_2, Set<StringPair> values) {
            this.column_1 = column_1;
            this.column_2 = column_2;
            this.values = values;
        }

        public String outName(StringPair p) {
            return this.outName(p.a, p.b);
        }

        public String outName(String a, String b) {
            return "interaction:" + this.column_1 + ":" + this.column_2 + ":" + a + ":" + b;
        }

        @Override
        public void process(RawObservation data) {
            StringPair p;
            String c1 = data.getAsString(this.column_1);
            String c2 = data.getAsString(this.column_2);
            if (c1 == null) {
                c1 = "N/A";
            }
            if (c2 == null) {
                c2 = "N/A";
            }
            if (this.values.contains(p = new StringPair(c1, c2))) {
                data.put(this.outName(p), 1.0);
            }
        }

        public String toString() {
            return "NumNum([" + this.column_1 + ", " + this.column_2 + "] in " + Arrays.toString(this.values.toArray()) + ")";
        }

        public static class StringPair
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public final String a;
            public final String b;

            public StringPair(String a, String b) {
                this.a = a;
                this.b = b;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                StringPair that = (StringPair)o;
                return this.a.equals(that.a) && this.b.equals(that.b);
            }

            public int hashCode() {
                return 31 * this.a.hashCode() + this.b.hashCode();
            }

            public String toString() {
                return "[" + this.a + ", " + this.b + "]";
            }
        }
    }

    public static class NumericalCategoricalInteraction
    implements Interaction {
        private static final long serialVersionUID = 1L;
        public final String num;
        public final String cat;
        public final Set<String> values;

        public NumericalCategoricalInteraction(String num, String cat, Set<String> values) {
            this.num = num;
            this.cat = cat;
            this.values = values;
        }

        public String outName(String level) {
            return "interaction:" + this.num + ":" + this.cat + ":" + level;
        }

        @Override
        public void process(RawObservation data) {
            Double x = data.getAsDouble(this.num);
            String level = data.getAsString(this.cat);
            if (level == null) {
                level = "N/A";
            }
            if (this.values.contains(level)) {
                data.put(this.outName(level), x);
            }
        }

        public String toString() {
            return "NumNum(" + this.num + ", " + this.cat + " in " + Arrays.toString(this.values.toArray()) + ")";
        }
    }

    public static class NumericalNumericalInteraction
    implements Interaction {
        private static final long serialVersionUID = 1L;
        public final String column_1;
        public final String column_2;
        public final boolean rescale;
        public final double shift;
        public final double invScale;
        public final String outName;

        public NumericalNumericalInteraction(String column_1, String column_2, boolean rescale, double shift, double invScale) {
            this.column_1 = column_1;
            this.column_2 = column_2;
            this.rescale = rescale;
            this.shift = shift;
            this.invScale = invScale;
            this.outName = "interaction:" + column_1 + ":" + column_2;
        }

        @Override
        public void process(RawObservation data) {
            Double x1 = data.getAsDouble(this.column_1);
            Double x2 = data.getAsDouble(this.column_2);
            if (x1 == null || x2 == null) {
                data.put(this.outName, null);
            } else {
                double prod = x1 * x2;
                if (this.rescale) {
                    prod = (prod - this.shift) * this.invScale;
                }
                data.put(this.outName, prod);
            }
        }

        public String toString() {
            return "NumNum(" + this.column_1 + ", " + this.column_2 + (this.rescale ? " rescaled" : "") + ")";
        }
    }
}

