/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh;

import com.dataiku.dip.DkuBackendInitializer;
import com.dataiku.dip.server.CountWriterFilter;
import com.dataiku.dip.server.EarlyCallTimingStartFilter;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.server.ApplicationStarter;
import com.dataiku.gh.server.controllers.DKUDispatcherServlet;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.util.EnumSet;
import java.util.EventListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class GHBackendInitializer
implements WebApplicationInitializer {
    public void onStartup(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        rootContext.register(new Class[]{RootContextConfiguration.class});
        GHSpring.registerServerServices(rootContext);
        AnnotationConfigWebApplicationContext dispatcherContext = new AnnotationConfigWebApplicationContext();
        dispatcherContext.setParent((ApplicationContext)rootContext);
        dispatcherContext.register(new Class[]{DispatcherServletConfiguration.class});
        GHSpring.registerServerControllers(dispatcherContext);
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)rootContext));
        servletContext.addListener((EventListener)((Object)new ApplicationStarter()));
        FilterRegistration.Dynamic filterConfig = servletContext.addFilter("EarlyCallTimingStartFilter", EarlyCallTimingStartFilter.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        filterConfig = servletContext.addFilter("CountWriterFilter", CountWriterFilter.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        filterConfig = servletContext.addFilter("CorsFilter", DelegatingFilterProxy.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/publicapi/*"});
        ServletRegistration.Dynamic servletConfig = servletContext.addServlet("dispatcher", (Servlet)new DKUDispatcherServlet((WebApplicationContext)dispatcherContext));
        servletConfig.setLoadOnStartup(1);
        servletConfig.addMapping(new String[]{"/"});
        servletConfig.setMultipartConfig(ServletUtils.getMultipartConfigElement((File)new File(ApplicationConfigurator.getBaseFolderF(), "tmp/upload-multipart"), (int)1000000));
    }

    @Configuration
    @Import(value={DkuBackendInitializer.RootContextConfiguration.class})
    @EnableAspectJAutoProxy
    public static class RootContextConfiguration {
    }

    @DkuBackendInitializer.NotInRootContext
    @Configuration
    @Import(value={DkuBackendInitializer.DispatcherServletConfiguration.class})
    public static class DispatcherServletConfiguration {
    }
}

