/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.user_config.SavedArtifactFilterConfiguration;
import com.dataiku.gh.core.models.user_config.UserConfiguration;
import com.dataiku.gh.core.services.user_config.IUserConfigurationService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserConfigurationController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IUserConfigurationService userConfigService;

    @AuditedCall(value={"msgType", "user-config-get-config"})
    @RequestMapping(value={"/api/user-config/get-config"}, method={RequestMethod.GET})
    @ResponseBody
    public UserConfiguration getUserConfiguration(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.userConfigService.getUserConfiguration(authCtx);
    }

    @AuditInline
    @RequestMapping(value={"/api/user-config/page-filter-config"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.USER_CONFIG_ADD_FILTER_CONFIG)
    @ResponseBody
    public UserConfiguration addFilterConfig(HttpServletRequest req, @RequestParam String pageId, @RequestParam SavedArtifactFilterConfiguration savedArtifactFilterConfiguration) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UserConfiguration userConfiguration = this.userConfigService.addPageFilter(authCtx, pageId, savedArtifactFilterConfiguration);
            this.auditTrailService.generic("user-config-add-filter-config").with("pageId", pageId).with("filterId", savedArtifactFilterConfiguration.id).emit();
            return userConfiguration;
        }
        catch (Exception e) {
            this.auditTrailService.failure("user-config-add-filter-config", (Throwable)e).emit();
            throw e;
        }
    }

    @RequestMapping(value={"/api/user-config/page-filter-config"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.USER_CONFIG_EDIT_FILTER_CONFIG)
    @ResponseBody
    public UserConfiguration editFilterConfig(HttpServletRequest req, @RequestParam String pageId, @RequestParam SavedArtifactFilterConfiguration savedArtifactFilterConfiguration) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UserConfiguration userConfiguration = this.userConfigService.editPageFilter(authCtx, pageId, savedArtifactFilterConfiguration);
            this.auditTrailService.generic("user-config-edit-filter-config").with("pageId", pageId).with("filterId", savedArtifactFilterConfiguration.id).emit();
            return userConfiguration;
        }
        catch (Exception e) {
            this.auditTrailService.failure("user-config-edit-filter-config", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "user-config-delete-filter-config", "pageId", "${pageId}", "filterId", "${savedArtifactFilterConfigurationId}"})
    @RequestMapping(value={"/api/user-config/page-filter-config"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.USER_CONFIG_DELETE_FILTER_CONFIG)
    @ResponseBody
    public void deleteFilterConfig(HttpServletRequest req, @RequestParam String pageId, @RequestParam String savedArtifactFilterConfigurationId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.userConfigService.deletePageFilter(authCtx, pageId, savedArtifactFilterConfigurationId);
    }
}

