/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.artifacts;

import com.dataiku.dip.logging.LoggableAPIResource;
import com.dataiku.gh.core.models.artifacts.ArtifactStatus;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflow;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.artifacts.Attachments;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.visitors.IArtifactVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@UIModel
public class Artifact
implements LoggableAPIResource {
    public String id;
    public BlueprintVersionId blueprintVersionId;
    public ArtifactStatus status = new ArtifactStatus();
    public ArtifactWorkflow workflow = new ArtifactWorkflow();
    public String name;
    public Map<String, Object> fields = new HashMap<String, Object>();
    public Attachments attachments = new Attachments();

    public void accept(IArtifactVisitor artifactVisitor) {
        this.fields.forEach((fieldId, fieldValue) -> artifactVisitor.visit(fieldValue));
        this.status.accept(artifactVisitor);
        this.attachments.accept(artifactVisitor);
        this.workflow.accept(artifactVisitor);
        artifactVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return Objects.equals(this.id, artifact.id) && Objects.equals(this.blueprintVersionId, artifact.blueprintVersionId) && Objects.equals(this.status, artifact.status) && Objects.equals(this.workflow, artifact.workflow) && Objects.equals(this.name, artifact.name) && Objects.equals(this.fields, artifact.fields) && Objects.equals(this.attachments, artifact.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.blueprintVersionId, this.status, this.workflow, this.name, this.fields, this.attachments);
    }

    public Map<String, Object> getLoggableIdentifiers() {
        return Collections.singletonMap("id", this.id);
    }

    @Nullable
    public String getCurrentOngoingWorkflowStepId(List<StepDefinition> stepDefinitions) {
        for (StepDefinition stepDefinition : stepDefinitions) {
            ArtifactWorkflowStep artifactWorkflowStep = this.workflow.steps.get(stepDefinition.id);
            if (artifactWorkflowStep == null || !artifactWorkflowStep.isOngoing()) continue;
            return stepDefinition.id;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public String getLegacyStepId(List<StepDefinition> stepDefinitions) {
        boolean allStepsAreNotStarted = stepDefinitions.stream().allMatch(stepDefinition -> {
            ArtifactWorkflowStep artifactWorkflowStep = this.workflow.steps.get(stepDefinition.id);
            return artifactWorkflowStep == null ? true : artifactWorkflowStep.isNotStarted();
        });
        if (allStepsAreNotStarted) {
            return null;
        }
        StepDefinition formerStepDefinition = null;
        for (StepDefinition stepDefinition2 : stepDefinitions) {
            ArtifactWorkflowStep artifactWorkflowStep = this.workflow.steps.get(stepDefinition2.id);
            if (artifactWorkflowStep == null || artifactWorkflowStep.isOngoing() || artifactWorkflowStep.isNotStarted()) {
                return stepDefinition2.id;
            }
            formerStepDefinition = stepDefinition2;
        }
        return formerStepDefinition != null ? formerStepDefinition.id : null;
    }

    public ArtifactWorkflowStep.StepStatus getStepStatus(String stepId) {
        return Optional.ofNullable(this.workflow.steps.get(stepId)).map(step -> step.status).orElse(ArtifactWorkflowStep.StepStatus.NOT_STARTED);
    }
}

