/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.search;

import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.search.ArtifactFilterFieldConditionType;
import com.dataiku.gh.core.models.search.FieldLogic;
import com.dataiku.gh.core.models.search.field_condition_types.NumberConditionType;
import com.dataiku.gh.core.models.search.field_condition_types.TextConditionType;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PolyJSON(value={@Mapping(value=BlueprintsArtifactFilter.class, type="blueprints"), @Mapping(value=BlueprintVersionsArtifactFilter.class, type="blueprintVersions"), @Mapping(value=ArtifactsArtifactFilter.class, type="artifacts"), @Mapping(value=ArtifactNameFilter.class, type="name"), @Mapping(value=FieldValueArtifactFilter.class, type="field"), @Mapping(value=ArtifactIdFilter.class, type="id-as-text"), @Mapping(value=TypedFieldValueArtifactFilter.class, type="typed-field"), @Mapping(value=ArchivedStatusArtifactFilter.class, type="archived"), @Mapping(value=WorkflowStepArtifactFilter.class, type="workflow-step"), @Mapping(value=SignoffStatusArtifactFilter.class, type="signoff"), @Mapping(value=OrArtifactFilter.class, type="or"), @Mapping(value=AndArtifactFilter.class, type="and"), @Mapping(value=TypedFieldOrArtifactFilter.class, type="typed-field-or"), @Mapping(value=DkuGovernOrFilter.class, type="dku-govern-or")})
public abstract class ArtifactFilter {
    @UINullable
    public boolean negateCondition = false;

    public abstract void accept(IArtifactFilterVisitor var1);

    public abstract String getType();

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactFilter that = (ArtifactFilter)o;
        return this.negateCondition == that.negateCondition;
    }

    public int hashCode() {
        return Objects.hashCode(this.negateCondition);
    }

    public String toString() {
        return "ArtifactFilter{negateCondition=" + this.negateCondition + "}";
    }

    public abstract QueryableArtifactFilter getQueryableArtifactFilter();

    public static interface IQueryableArtifactFilterVisitorEmptyDefaults
    extends IQueryableArtifactFilterVisitor {
        @Override
        default public void visit(BlueprintsArtifactFilter blueprintsArtifactFilter) {
        }

        @Override
        default public void visit(BlueprintVersionsArtifactFilter blueprintVersionArtifactFilter) {
        }

        @Override
        default public void visit(ArtifactsArtifactFilter artifactsArtifactFilter) {
        }

        @Override
        default public void visit(ArtifactNameFilter artifactNameFilter) {
        }

        @Override
        default public void visit(ArtifactIdFilter artifactIdFilter) {
        }

        @Override
        default public void visit(FieldValueArtifactFilter fieldValueArtifactFilter) {
        }

        @Override
        default public void visit(TypedFieldValueArtifactFilter typedFieldValueArtifactFilter) {
        }

        @Override
        default public void visit(ArchivedStatusArtifactFilter archivedStatusArtifactFilter) {
        }

        @Override
        default public void visit(WorkflowStepArtifactFilter workflowStepArtifactFilter) {
        }

        @Override
        default public void visit(SignoffStatusArtifactFilter signoffStatusArtifactFilter) {
        }

        @Override
        default public void visit(OrArtifactFilter orArtifactFilter) {
        }

        @Override
        default public void visit(AndArtifactFilter andArtifactFilter) {
        }
    }

    public static interface IQueryableArtifactFilterVisitor {
        public void visit(BlueprintsArtifactFilter var1);

        public void visit(BlueprintVersionsArtifactFilter var1);

        public void visit(ArtifactsArtifactFilter var1);

        public void visit(ArtifactNameFilter var1);

        public void visit(ArtifactIdFilter var1);

        public void visit(FieldValueArtifactFilter var1);

        public void visit(TypedFieldValueArtifactFilter var1);

        public void visit(ArchivedStatusArtifactFilter var1);

        public void visit(WorkflowStepArtifactFilter var1);

        public void visit(SignoffStatusArtifactFilter var1);

        public void visit(OrArtifactFilter var1);

        public void visit(AndArtifactFilter var1);
    }

    public static interface IArtifactFilterVisitor
    extends IQueryableArtifactFilterVisitorEmptyDefaults,
    FieldLogic.IFieldLogicVisitor {
        default public boolean shouldVisitChildren() {
            return true;
        }

        default public void visit(TypedFieldOrArtifactFilter typedFieldOrArtifactFilter) {
        }

        default public void visit(DkuGovernOrFilter dkuGovernOrFilter) {
        }
    }

    public static class DkuGovernOrFilter
    extends ArtifactFilter {
        public static final String TYPE = "dku-govern-or";
        public ArtifactFilter artifactFilter;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            if (visitor.shouldVisitChildren()) {
                this.artifactFilter.accept(visitor);
            }
            visitor.visit(this);
        }

        @Override
        public QueryableArtifactFilter getQueryableArtifactFilter() {
            QueryableArtifactFilter baseFilter = (QueryableArtifactFilter)JSON.deepCopy((Object)this.artifactFilter.getQueryableArtifactFilter());
            boolean resultNegateCondition = this.negateCondition ^ baseFilter.negateCondition;
            baseFilter.negateCondition = false;
            FieldLogic.ReferenceFieldLogic referenceFieldLogic = FieldLogic.ReferenceFieldLogic.build(baseFilter);
            TypedFieldValueArtifactFilter dkuFilter = TypedFieldValueArtifactFilter.build("dataiku_item", referenceFieldLogic);
            TypedFieldValueArtifactFilter governFilter = TypedFieldValueArtifactFilter.build("governed_by", referenceFieldLogic);
            QueryableArtifactFilter resultFilter = OrArtifactFilter.build(baseFilter, dkuFilter, governFilter).getQueryableArtifactFilter();
            resultFilter.negateCondition = resultNegateCondition;
            return resultFilter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DkuGovernOrFilter that = (DkuGovernOrFilter)o;
            return Objects.equals(this.artifactFilter, that.artifactFilter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.artifactFilter);
        }

        @Override
        public String toString() {
            return "DkuGovernOrFilter{artifactFilter=" + String.valueOf(this.artifactFilter) + "} " + super.toString();
        }
    }

    public static class TypedFieldOrArtifactFilter
    extends ArtifactFilter {
        public static final String TYPE = "typed-field-or";
        public String fieldId;
        @UINullable
        public TypedFieldValueArtifactFilter textFilter;
        @UINullable
        public TypedFieldValueArtifactFilter numberFilter;
        @UINullable
        public TypedFieldValueArtifactFilter categoryFilter;
        @UINullable
        public TypedFieldValueArtifactFilter dateFilter;
        @UINullable
        public TypedFieldValueArtifactFilter referenceFilter;
        @UINullable
        public TypedFieldValueArtifactFilter booleanFilter;
        @UINullable
        public FieldValueArtifactFilter plaintextFilter;

        public List<QueryableArtifactFilter> getAllFilters() {
            return Stream.of(this.textFilter, this.numberFilter, this.categoryFilter, this.dateFilter, this.referenceFilter, this.booleanFilter, this.plaintextFilter).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            if (visitor.shouldVisitChildren()) {
                this.getAllFilters().forEach(artifactFilter -> artifactFilter.accept(visitor));
            }
            visitor.visit(this);
        }

        @Override
        public QueryableArtifactFilter getQueryableArtifactFilter() {
            OrArtifactFilter resultFilter = OrArtifactFilter.build(this.getAllFilters());
            resultFilter.negateCondition = this.negateCondition;
            return resultFilter.getQueryableArtifactFilter();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TypedFieldOrArtifactFilter that = (TypedFieldOrArtifactFilter)o;
            return Objects.equals(this.fieldId, that.fieldId) && Objects.equals(this.textFilter, that.textFilter) && Objects.equals(this.numberFilter, that.numberFilter) && Objects.equals(this.categoryFilter, that.categoryFilter) && Objects.equals(this.dateFilter, that.dateFilter) && Objects.equals(this.referenceFilter, that.referenceFilter) && Objects.equals(this.booleanFilter, that.booleanFilter) && Objects.equals(this.plaintextFilter, that.plaintextFilter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fieldId, this.textFilter, this.numberFilter, this.categoryFilter, this.dateFilter, this.referenceFilter, this.booleanFilter, this.plaintextFilter);
        }

        @Override
        public String toString() {
            return "TypedFieldOrArtifactFilter{fieldId='" + this.fieldId + "', textFilter=" + String.valueOf(this.textFilter) + ", numberFilter=" + String.valueOf(this.numberFilter) + ", categoryFilter=" + String.valueOf(this.categoryFilter) + ", dateFilter=" + String.valueOf(this.dateFilter) + ", referenceFilter=" + String.valueOf(this.referenceFilter) + ", booleanFilter=" + String.valueOf(this.booleanFilter) + ", plaintextFilter=" + String.valueOf(this.plaintextFilter) + "} " + super.toString();
        }
    }

    public static class AndArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "and";
        public List<ArtifactFilter> artifactFilters = new ArrayList<ArtifactFilter>();

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public QueryableArtifactFilter getQueryableArtifactFilter() {
            if (this.artifactFilters.size() == 1) {
                QueryableArtifactFilter singleInnerFilter = (QueryableArtifactFilter)JSON.deepCopy((Object)this.artifactFilters.get(0).getQueryableArtifactFilter());
                singleInnerFilter.negateCondition = this.negateCondition ^ singleInnerFilter.negateCondition;
                return singleInnerFilter;
            }
            return this;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            if (visitor.shouldVisitChildren()) {
                this.artifactFilters.forEach(artifactFilter -> artifactFilter.accept(visitor));
            }
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static AndArtifactFilter build(ArtifactFilter ... filters) {
            return AndArtifactFilter.build(Arrays.asList(filters));
        }

        public static AndArtifactFilter build(Collection<? extends ArtifactFilter> filters) {
            AndArtifactFilter filter = new AndArtifactFilter();
            filter.artifactFilters.addAll(filters);
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AndArtifactFilter that = (AndArtifactFilter)o;
            return Objects.equals(this.artifactFilters, that.artifactFilters);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.artifactFilters);
        }

        @Override
        public String toString() {
            return "AndArtifactFilter{artifactFilters=" + String.valueOf(this.artifactFilters) + "} " + super.toString();
        }
    }

    public static class OrArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "or";
        public List<ArtifactFilter> artifactFilters = new ArrayList<ArtifactFilter>();

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public QueryableArtifactFilter getQueryableArtifactFilter() {
            if (this.artifactFilters.size() == 1) {
                QueryableArtifactFilter singleInnerFilter = (QueryableArtifactFilter)JSON.deepCopy((Object)this.artifactFilters.get(0).getQueryableArtifactFilter());
                singleInnerFilter.negateCondition = this.negateCondition ^ singleInnerFilter.negateCondition;
                return singleInnerFilter;
            }
            return this;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            if (visitor.shouldVisitChildren()) {
                this.artifactFilters.forEach(artifactFilter -> artifactFilter.accept(visitor));
            }
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static OrArtifactFilter build(ArtifactFilter ... filters) {
            return OrArtifactFilter.build(Arrays.asList(filters));
        }

        public static OrArtifactFilter build(Collection<? extends ArtifactFilter> filters) {
            OrArtifactFilter filter = new OrArtifactFilter();
            filter.artifactFilters.addAll(filters);
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OrArtifactFilter that = (OrArtifactFilter)o;
            return Objects.equals(this.artifactFilters, that.artifactFilters);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.artifactFilters);
        }

        @Override
        public String toString() {
            return "OrArtifactFilter{artifactFilters=" + String.valueOf(this.artifactFilters) + "} " + super.toString();
        }
    }

    public static class SignoffStatusArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "signoff";
        @UINullable
        public String stepId;
        @UINullable
        public boolean negateOperator;
        public Signoff.SignoffStatus status;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static SignoffStatusArtifactFilter build(String stepId, Signoff.SignoffStatus status, boolean negateOperator) {
            SignoffStatusArtifactFilter filter = new SignoffStatusArtifactFilter();
            filter.stepId = stepId;
            filter.status = status;
            filter.negateOperator = negateOperator;
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SignoffStatusArtifactFilter that = (SignoffStatusArtifactFilter)o;
            return this.negateOperator == that.negateOperator && Objects.equals(this.stepId, that.stepId) && this.status == that.status;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.stepId, this.negateOperator, this.status});
        }

        @Override
        public String toString() {
            return "SignoffStatusArtifactFilter{stepId='" + this.stepId + "', negateOperator=" + this.negateOperator + ", status=" + String.valueOf((Object)this.status) + "} " + super.toString();
        }
    }

    public static class WorkflowStepArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "workflow-step";
        @UINullable
        public String stepId;
        @UINullable
        public boolean negateOperator;
        public ArtifactWorkflowStep.StepStatus status;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static WorkflowStepArtifactFilter build(String stepId, ArtifactWorkflowStep.StepStatus status, boolean negateOperator) {
            WorkflowStepArtifactFilter filter = new WorkflowStepArtifactFilter();
            filter.stepId = stepId;
            filter.status = status;
            filter.negateOperator = negateOperator;
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            WorkflowStepArtifactFilter that = (WorkflowStepArtifactFilter)o;
            return this.negateOperator == that.negateOperator && Objects.equals(this.stepId, that.stepId) && this.status == that.status;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.stepId, this.negateOperator, this.status});
        }

        @Override
        public String toString() {
            return "WorkflowStepArtifactFilter{stepId='" + this.stepId + "', negateOperator=" + this.negateOperator + ", status=" + String.valueOf((Object)this.status) + "} " + super.toString();
        }
    }

    public static class ArchivedStatusArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "archived";
        public boolean isArchived;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static ArchivedStatusArtifactFilter build(boolean isArchived) {
            ArchivedStatusArtifactFilter filter = new ArchivedStatusArtifactFilter();
            filter.isArchived = isArchived;
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ArchivedStatusArtifactFilter that = (ArchivedStatusArtifactFilter)o;
            return this.isArchived == that.isArchived;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.isArchived);
        }

        @Override
        public String toString() {
            return "ArchivedStatusArtifactFilter{isArchived=" + this.isArchived + "} " + super.toString();
        }
    }

    public static class TypedFieldValueArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "typed-field";
        public String fieldId;
        public FieldLogic fieldLogic;
        @UINullable
        public FieldLogic.NumberFieldLogic cardinalityCondition = FieldLogic.NumberFieldLogic.build(NumberConditionType.GREATER_OR_EQUAL, 1.0, false);
        @UINullable
        public boolean negateOperator;

        public FieldType getFieldType() {
            return this.fieldLogic.getFieldType();
        }

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            if (this.fieldLogic != null) {
                this.fieldLogic.accept(visitor);
            }
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static TypedFieldValueArtifactFilter build(String fieldId, FieldLogic fieldLogic) {
            TypedFieldValueArtifactFilter filter = new TypedFieldValueArtifactFilter();
            filter.fieldId = fieldId;
            filter.fieldLogic = fieldLogic;
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TypedFieldValueArtifactFilter that = (TypedFieldValueArtifactFilter)o;
            return this.negateOperator == that.negateOperator && Objects.equals(this.fieldId, that.fieldId) && Objects.equals(this.fieldLogic, that.fieldLogic) && Objects.equals(this.cardinalityCondition, that.cardinalityCondition);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fieldId, this.fieldLogic, this.cardinalityCondition, this.negateOperator);
        }

        @Override
        public String toString() {
            return "TypedFieldValueArtifactFilter{fieldId='" + this.fieldId + "', fieldLogic=" + String.valueOf(this.fieldLogic) + ", cardinalityCondition=" + String.valueOf(this.cardinalityCondition) + ", negateOperator=" + this.negateOperator + "} " + super.toString();
        }
    }

    public static class FieldValueArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "field";
        public ArtifactFilterFieldConditionType conditionType;
        @UINullable
        public String condition;
        @UINullable
        public String fieldId;
        @UINullable
        public boolean caseSensitive = false;
        @UINullable
        public boolean canBeReference = true;
        @UINullable
        public boolean negateOperator;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static FieldValueArtifactFilter build(ArtifactFilterFieldConditionType conditionType, String condition, String fieldId, boolean negateCondition, boolean caseSensitive, boolean canBeReference) {
            FieldValueArtifactFilter filter = new FieldValueArtifactFilter();
            filter.conditionType = conditionType;
            filter.condition = condition;
            filter.fieldId = fieldId;
            filter.negateCondition = negateCondition;
            filter.caseSensitive = caseSensitive;
            filter.canBeReference = canBeReference;
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldValueArtifactFilter that = (FieldValueArtifactFilter)o;
            return this.caseSensitive == that.caseSensitive && this.canBeReference == that.canBeReference && this.negateOperator == that.negateOperator && this.conditionType == that.conditionType && Objects.equals(this.condition, that.condition) && Objects.equals(this.fieldId, that.fieldId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.conditionType, this.condition, this.fieldId, this.caseSensitive, this.canBeReference, this.negateOperator});
        }

        @Override
        public String toString() {
            return "FieldValueArtifactFilter{conditionType=" + String.valueOf((Object)this.conditionType) + ", condition='" + this.condition + "', fieldId='" + this.fieldId + "', caseSensitive=" + this.caseSensitive + ", canBeReference=" + this.canBeReference + ", negateOperator=" + this.negateOperator + "} " + super.toString();
        }
    }

    public static class ArtifactIdFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "id-as-text";
        public TextConditionType conditionType;
        public String condition;
        @UINullable
        public boolean caseSensitive = false;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static ArtifactIdFilter build(TextConditionType conditionType, String condition, boolean caseSensitive) {
            ArtifactIdFilter filter = new ArtifactIdFilter();
            filter.conditionType = conditionType;
            filter.condition = condition;
            filter.caseSensitive = caseSensitive;
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArtifactIdFilter)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ArtifactIdFilter that = (ArtifactIdFilter)o;
            return this.caseSensitive == that.caseSensitive && this.conditionType == that.conditionType && Objects.equals(this.condition, that.condition);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.conditionType, this.condition, this.caseSensitive});
        }

        @Override
        public String toString() {
            return "ArtifactNameFilter{conditionType=" + String.valueOf((Object)this.conditionType) + ", condition='" + this.condition + "', caseSensitive=" + this.caseSensitive + "} " + super.toString();
        }
    }

    public static class ArtifactNameFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "name";
        public TextConditionType conditionType;
        public String condition;
        @UINullable
        public boolean caseSensitive = false;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static ArtifactNameFilter build(TextConditionType conditionType, String condition, boolean caseSensitive) {
            ArtifactNameFilter filter = new ArtifactNameFilter();
            filter.conditionType = conditionType;
            filter.condition = condition;
            filter.caseSensitive = caseSensitive;
            return filter;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ArtifactNameFilter that = (ArtifactNameFilter)o;
            return this.caseSensitive == that.caseSensitive && this.conditionType == that.conditionType && Objects.equals(this.condition, that.condition);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.conditionType, this.condition, this.caseSensitive});
        }
    }

    public static class ArtifactsArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "artifacts";
        public List<String> artifactIds = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static ArtifactsArtifactFilter build(List<String> artifactIds, boolean negateCondition) {
            ArtifactsArtifactFilter source = new ArtifactsArtifactFilter();
            source.artifactIds = artifactIds;
            source.negateCondition = negateCondition;
            return source;
        }

        public static ArtifactsArtifactFilter build(List<String> artifactIds) {
            return ArtifactsArtifactFilter.build(artifactIds, false);
        }

        public static ArtifactsArtifactFilter build(String ... artifactIds) {
            return ArtifactsArtifactFilter.build(Arrays.asList(artifactIds));
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ArtifactsArtifactFilter that = (ArtifactsArtifactFilter)o;
            return Objects.equals(this.artifactIds, that.artifactIds);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.artifactIds);
        }

        @Override
        public String toString() {
            return "ArtifactsArtifactFilter{artifactIds=" + String.valueOf(this.artifactIds) + "} " + super.toString();
        }
    }

    public static class BlueprintVersionsArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "blueprintVersions";
        public List<BlueprintVersionId> blueprintVersionIds = new ArrayList<BlueprintVersionId>();

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static BlueprintVersionsArtifactFilter build(List<BlueprintVersionId> blueprintVersionIds) {
            BlueprintVersionsArtifactFilter source = new BlueprintVersionsArtifactFilter();
            source.blueprintVersionIds = blueprintVersionIds;
            return source;
        }

        public static BlueprintVersionsArtifactFilter build(BlueprintVersionId ... blueprintVersionIds) {
            return BlueprintVersionsArtifactFilter.build(Arrays.asList(blueprintVersionIds));
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BlueprintVersionsArtifactFilter that = (BlueprintVersionsArtifactFilter)o;
            return Objects.equals(this.blueprintVersionIds, that.blueprintVersionIds);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.blueprintVersionIds);
        }

        @Override
        public String toString() {
            return "BlueprintVersionsArtifactFilter{blueprintVersionIds=" + String.valueOf(this.blueprintVersionIds) + "} " + super.toString();
        }
    }

    public static class BlueprintsArtifactFilter
    extends QueryableArtifactFilter {
        public static final String TYPE = "blueprints";
        public List<String> blueprintIds = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public void accept(IArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void accept(IQueryableArtifactFilterVisitor visitor) {
            visitor.visit(this);
        }

        public static BlueprintsArtifactFilter build(List<String> blueprintIds) {
            BlueprintsArtifactFilter source = new BlueprintsArtifactFilter();
            source.blueprintIds = blueprintIds;
            return source;
        }

        public static BlueprintsArtifactFilter build(String ... blueprintIds) {
            return BlueprintsArtifactFilter.build(Arrays.asList(blueprintIds));
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BlueprintsArtifactFilter that = (BlueprintsArtifactFilter)o;
            return Objects.equals(this.blueprintIds, that.blueprintIds);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.blueprintIds);
        }

        @Override
        public String toString() {
            return "BlueprintsArtifactFilter{blueprintIds=" + String.valueOf(this.blueprintIds) + "} " + super.toString();
        }
    }

    public static abstract class QueryableArtifactFilter
    extends ArtifactFilter {
        @Override
        public QueryableArtifactFilter getQueryableArtifactFilter() {
            return this;
        }

        public abstract void accept(IQueryableArtifactFilterVisitor var1);

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            return "QueryableArtifactFilter{} " + super.toString();
        }
    }
}

