/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nullable;

public abstract class Migration {
    protected static final DKULogger logger = DKULogger.getLogger((String)"gh.admin.migration");
    private long migrationTimestamp;

    public final void execute(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles, List<MigrationFile> finallyMigrationFiles, @Nullable File providedObjectsFolder) throws IOException {
        this.migrationTimestamp = Instant.now().toEpochMilli();
        this.preRunSQLFiles(dbMigrationDAO, migrationFiles);
        this.runSQLFiles(dbMigrationDAO, migrationFiles);
        this.postRunSQLFiles(dbMigrationDAO, migrationFiles);
        this.updateProvidedSystemObjects(dbMigrationDAO, providedObjectsFolder);
        this.runSQLFiles(dbMigrationDAO, finallyMigrationFiles);
    }

    public boolean shouldPerformDbOptimizationAfterMigration() {
        return true;
    }

    protected final long getMigrationTimestamp() {
        return this.migrationTimestamp;
    }

    protected void preRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
    }

    protected final void runSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        for (MigrationFile fileToApply : migrationFiles) {
            dbMigrationDAO.runMigration(fileToApply);
            logger.infoV("Migration file executed successfully : %s", new Object[]{fileToApply.file});
        }
    }

    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
    }

    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
    }
}

