/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.config;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.configuration.DefaultAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfigurationWithResolvedParent;
import com.dataiku.gh.core.models.governance.AutoGovernanceAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfigurationSource;
import com.dataiku.gh.core.models.governance.AutoGovernanceEffectiveAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceScriptOutput;
import com.dataiku.gh.core.models.governance.AutoGovernanceStatus;
import com.dataiku.gh.core.models.governance.EffectiveGovernanceSettings;
import com.dataiku.gh.core.models.governance.InputGovernanceSettings;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.governance.IGovernancePermissionService;
import com.dataiku.gh.core.services.governance.config.IAdminAutoGovernanceConfigurationService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationService;
import com.dataiku.gh.core.services.governance.script.IAutoGovernanceScriptService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IAutomaticConfigurationValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoGovernanceConfigurationService
implements IAutoGovernanceConfigurationService,
IAdminAutoGovernanceConfigurationService {
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IAutoGovernanceConfigurationDataService autoGovernanceConfigurationDataService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IGovernancePermissionService governancePermissionService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IAutomaticConfigurationValidationService automaticConfigurationValidationService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IAutoGovernanceScriptService scriptGovernanceService;

    @Override
    @GHReadonlyTransaction
    public ArtifactAutoGovernanceConfigurationWithResolvedParent getAutoGovernanceConfigurationWithResolvedParent(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, false);
        this.validateFetchedConfigIsOnDataikuArtifact(dataikuItemToGovernEnrichedArtifact);
        return this.autoGovernanceConfigurationDataService.getAutoGovernanceConfigurationWithResolvedParent(dataikuItemToGovernEnrichedArtifact);
    }

    @Override
    @GHReadonlyTransaction
    public EffectiveGovernanceSettings getEffectiveConfigurationForArtifact(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EffectiveGovernanceSettings effectiveGovernanceSettings;
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, false);
        this.validateFetchedConfigIsOnDataikuArtifact(dataikuItemToGovernEnrichedArtifact);
        Pair<AutoGovernanceConfigurationSource, AutoGovernanceConfiguration> configForItem = this.autoGovernanceConfigurationDataService.getSelfConfiguration(dataikuItemToGovernEnrichedArtifact);
        if (((AutoGovernanceConfiguration)configForItem.getRight()).action == AutoGovernanceAction.RUN_SCRIPT) {
            AutoGovernanceScriptOutput scriptOutput = this.scriptGovernanceService.runScriptOnArtifactIfAdvancedLicense(dataikuItemToGovernEnrichedArtifact, this.licenseEnforcementService.isGovernBlueprintDesignerAllowed());
            effectiveGovernanceSettings = this.mapScriptOutputToEffectiveGovernanceSettings(dataikuItemToGovernEnrichedArtifact, scriptOutput);
        } else {
            effectiveGovernanceSettings = this.mapSimpleConfigToEffectiveGovernanceSettings(dataikuItemToGovernEnrichedArtifact, (AutoGovernanceConfiguration)configForItem.getRight());
        }
        return effectiveGovernanceSettings;
    }

    private Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> getAutoGovernanceConfigurationPair(EnrichedArtifact dataikuItemToGovernEnrichedArtifact) throws IOException {
        Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> configForItemChildren = null;
        if ((SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuItemToGovernEnrichedArtifact.blueprint.id) || SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(dataikuItemToGovernEnrichedArtifact.blueprint.id)) && (configForItemChildren = this.autoGovernanceConfigurationDataService.getResolvedArtifactAutoGovernConfiguration(dataikuItemToGovernEnrichedArtifact)) == null) {
            throw new IllegalStateException("No AutoGovernance configurations for children found, at least instance configuration should be present for artifactId=" + dataikuItemToGovernEnrichedArtifact.artifact.id);
        }
        return configForItemChildren;
    }

    @Override
    @GHReadonlyTransaction
    public InputGovernanceSettings getInputGovernanceConfiguration(String artifactId) throws IOException {
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        Pair<AutoGovernanceConfigurationSource, AutoGovernanceConfiguration> configForItem = this.autoGovernanceConfigurationDataService.getSelfConfiguration(dataikuItemToGovernEnrichedArtifact);
        if (((AutoGovernanceConfiguration)configForItem.getRight()).action == AutoGovernanceAction.RUN_SCRIPT) {
            AutoGovernanceScriptOutput scriptOutput = this.scriptGovernanceService.runScriptOnArtifactIfAdvancedLicense(dataikuItemToGovernEnrichedArtifact, this.licenseEnforcementService.isGovernBlueprintDesignerAllowed());
            return this.mapScriptOutputToInputGovernanceSettings(dataikuItemToGovernEnrichedArtifact.artifact, scriptOutput);
        }
        return this.mapSimpleConfigToInputGovernanceSettings(dataikuItemToGovernEnrichedArtifact.artifact, (AutoGovernanceConfiguration)configForItem.getRight());
    }

    @Override
    @GHWriteTransaction
    public void deleteConfigurationForArtifact(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, true);
        this.validateFetchedConfigIsOnEffectiveADataikuArtifact(dataikuItemToGovernEnrichedArtifact);
        this.checkUserCanDeleteGovernanceConfiguration(authCtx, artifactId);
        this.autoGovernanceConfigurationDataService.deleteDSSArtifactAutoGovernConfiguration(artifactId);
    }

    @Override
    @GHWriteTransaction
    public ArtifactAutoGovernanceConfigurationWithResolvedParent upsertConfigurationForArtifact(AuthCtx authCtx, ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration) throws IOException, DKUSecurityException {
        this.automaticConfigurationValidationService.validateArtifactAutoGovernanceConfiguration(artifactAutoGovernanceConfiguration, false);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((String)artifactAutoGovernanceConfiguration.artifactId), "Artifact AutoGovernConfiguration should contain a well-defined artifactId", new Object[0]);
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactAutoGovernanceConfiguration.artifactId);
        this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, true);
        this.validateFetchedConfigIsOnEffectiveADataikuArtifact(dataikuItemToGovernEnrichedArtifact);
        this.governancePermissionService.checkUserCanModifyGovernanceConfiguration(authCtx, artifactAutoGovernanceConfiguration);
        return this.autoGovernanceConfigurationDataService.upsertDSSArtifactAutoGovernConfiguration(artifactAutoGovernanceConfiguration);
    }

    private void checkUserCanDeleteGovernanceConfiguration(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        ArtifactAutoGovernanceConfiguration currentlyStoredConfiguration = this.autoGovernanceConfigurationDataService.getArtifactAutoGovernConfigurationOrNull(artifactId);
        if (currentlyStoredConfiguration == null) {
            return;
        }
        try (UserRolesCacheContext.ContextContainer ignored = UserRolesCacheContext.attachNewContext();){
            boolean hasAtLeastOneBPVInModelConfiguration;
            boolean hasAtLeastOneBPVInEachProjectConfiguration = currentlyStoredConfiguration instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration && this.governancePermissionService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_MODEL.blueprintId) && this.governancePermissionService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_BUNDLE.blueprintId) && this.governancePermissionService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId);
            boolean bl = hasAtLeastOneBPVInModelConfiguration = currentlyStoredConfiguration instanceof ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration && this.governancePermissionService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId);
            if (!hasAtLeastOneBPVInModelConfiguration && !hasAtLeastOneBPVInEachProjectConfiguration) {
                String levelOfArtifact = currentlyStoredConfiguration instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration ? "project" : (currentlyStoredConfiguration instanceof ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration ? "model" : "unknown");
                throw new UnauthorizedException("Permission denied: unable to delete AutoGovernance config for artifact: " + artifactId + " at level: " + levelOfArtifact, "autogovern-config-delete-denied");
            }
        }
    }

    private void checkUserGovernLicenseAndArtifactReadPermissions(AuthCtx authCtx, EnrichedArtifact dataikuItemToGovernEnrichedArtifact, boolean needsWriteGovern) throws IOException, DKUSecurityException {
        if (needsWriteGovern) {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        } else {
            this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        }
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, dataikuItemToGovernEnrichedArtifact);
        this.checkPermissionsService.checkArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, dataikuItemToGovernEnrichedArtifact.artifact.id);
    }

    @Override
    @GHReadonlyTransaction
    public ArtifactAutoGovernanceConfiguration.InstanceAutoGovernanceConfiguration getInstanceAutoGovernanceConfiguration(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        return this.autoGovernanceConfigurationDataService.getInstanceDefaultProjectAutoGovernConfiguration().instanceAutoGovernanceConfiguration;
    }

    @Override
    @GHReadonlyTransaction
    public DefaultAutoGovernanceConfiguration getInstanceDefaultAutoGovernConfiguration(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.permissionsService.checkMayManageGovern(authCtx);
        return this.autoGovernanceConfigurationDataService.getInstanceDefaultProjectAutoGovernConfiguration();
    }

    @Override
    @GHWriteTransaction
    public DefaultAutoGovernanceConfiguration upsertInstanceDefaultAutoGovernConfiguration(AuthCtx authCtx, DefaultAutoGovernanceConfiguration defaultAutoGovernanceConfiguration) throws IOException, DKUSecurityException {
        ArtifactAutoGovernanceConfiguration.InstanceAutoGovernanceConfiguration instanceDefaultAutoGovernanceConfiguration = defaultAutoGovernanceConfiguration.instanceAutoGovernanceConfiguration;
        this.permissionsService.checkMayManageGovern(authCtx);
        ValidatorUtils.validateThat(StringUtils.isBlank((String)instanceDefaultAutoGovernanceConfiguration.artifactId), "Instance AutoGovernConfiguration should contain a null artifactId", new Object[0]);
        this.automaticConfigurationValidationService.validateArtifactAutoGovernanceConfiguration(instanceDefaultAutoGovernanceConfiguration, true);
        return this.autoGovernanceConfigurationDataService.upsertInstanceAutoGovernConfiguration(defaultAutoGovernanceConfiguration);
    }

    private void validateFetchedConfigIsOnEffectiveADataikuArtifact(EnrichedArtifact artifact) {
        this.validateFetchedConfigBlueprintMatchesPossibleList(artifact.blueprint.id, List.of(SystemProvidedConstants.DATAIKU_PROJECT.blueprintId, SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId));
    }

    private void validateFetchedConfigIsOnDataikuArtifact(EnrichedArtifact artifact) {
        this.validateFetchedConfigBlueprintMatchesPossibleList(artifact.blueprint.id, List.of(SystemProvidedConstants.DATAIKU_PROJECT.blueprintId, SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId, SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.blueprintId, SystemProvidedConstants.DATAIKU_BUNDLE.blueprintId));
    }

    private void validateFetchedConfigBlueprintMatchesPossibleList(String artifactBlueprintId, List<String> blueprintListToMatch) {
        String expectedValues = String.join((CharSequence)" or ", blueprintListToMatch);
        ValidatorUtils.validateThat(blueprintListToMatch.contains(artifactBlueprintId), "AutoGovernConfiguration can't be fetched for an artifact other than '%s', given '%s", expectedValues, artifactBlueprintId);
    }

    private EffectiveGovernanceSettings mapScriptOutputToEffectiveGovernanceSettings(EnrichedArtifact ea, AutoGovernanceScriptOutput scriptOutput) throws IOException {
        Artifact artifact = ea.artifact;
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId) && scriptOutput.projectExistingArtifactId != null) {
            Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> configForItemChildren = this.getAutoGovernanceConfigurationPair(ea);
            EffectiveGovernanceSettings.ExistingProjectSettings existingProjectSettings = EffectiveGovernanceSettings.ExistingProjectSettings.build(scriptOutput.projectExistingArtifactId, scriptOutput.status, (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)configForItemChildren.getRight(), (AutoGovernanceConfigurationSource)((Object)configForItemChildren.getLeft()));
            existingProjectSettings.suggestedProjectAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)scriptOutput.childrenConfiguration;
            return existingProjectSettings;
        }
        BlueprintVersionId bvid = scriptOutput.blueprintVersionId;
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId)) {
            Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> configForItemChildren = this.getAutoGovernanceConfigurationPair(ea);
            EffectiveGovernanceSettings.ProjectSettings createProjectSettings = EffectiveGovernanceSettings.ProjectSettings.build(scriptOutput.action, scriptOutput.status, bvid, scriptOutput.projectBusinessInitiativeArtifactId, (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)configForItemChildren.getRight(), (AutoGovernanceConfigurationSource)((Object)configForItemChildren.getLeft()));
            createProjectSettings.suggestedProjectAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)scriptOutput.childrenConfiguration;
            return createProjectSettings;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(artifact.blueprintVersionId)) {
            Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> configForItemChildren = this.getAutoGovernanceConfigurationPair(ea);
            EffectiveGovernanceSettings.ModelSettings modelSettings = EffectiveGovernanceSettings.ModelSettings.build(scriptOutput.action, scriptOutput.status, bvid, (ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)configForItemChildren.getRight(), (AutoGovernanceConfigurationSource)((Object)configForItemChildren.getLeft()));
            modelSettings.suggestedModelAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)scriptOutput.childrenConfiguration;
            return modelSettings;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(artifact.blueprintVersionId)) {
            return EffectiveGovernanceSettings.ModelVersionSettings.build(scriptOutput.action, scriptOutput.status, bvid);
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(artifact.blueprintVersionId)) {
            return EffectiveGovernanceSettings.BundleSettings.build(scriptOutput.action, scriptOutput.status, bvid);
        }
        throw new ValidationException("Artifact is not governable:" + artifact.id);
    }

    private EffectiveGovernanceSettings mapSimpleConfigToEffectiveGovernanceSettings(EnrichedArtifact ea, AutoGovernanceConfiguration configuration) throws IOException {
        Artifact artifact = ea.artifact;
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId)) {
            Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> configForItemChildren = this.getAutoGovernanceConfigurationPair(ea);
            return EffectiveGovernanceSettings.ProjectSettings.build(AutoGovernanceEffectiveAction.mapFrom(configuration.action), configuration.status, configuration.blueprintVersionId, null, (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)configForItemChildren.getRight(), (AutoGovernanceConfigurationSource)((Object)configForItemChildren.getLeft()));
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(artifact.blueprintVersionId)) {
            Pair<AutoGovernanceConfigurationSource, ArtifactAutoGovernanceConfiguration> configForItemChildren = this.getAutoGovernanceConfigurationPair(ea);
            return EffectiveGovernanceSettings.ModelSettings.build(AutoGovernanceEffectiveAction.mapFrom(configuration.action), configuration.status, configuration.blueprintVersionId, (ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)configForItemChildren.getRight(), (AutoGovernanceConfigurationSource)((Object)configForItemChildren.getLeft()));
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(artifact.blueprintVersionId)) {
            return EffectiveGovernanceSettings.ModelVersionSettings.build(AutoGovernanceEffectiveAction.mapFrom(configuration.action), configuration.status, configuration.blueprintVersionId);
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(artifact.blueprintVersionId)) {
            return EffectiveGovernanceSettings.BundleSettings.build(AutoGovernanceEffectiveAction.mapFrom(configuration.action), configuration.status, configuration.blueprintVersionId);
        }
        throw new ValidationException("Artifact is not governable:" + artifact.id);
    }

    private InputGovernanceSettings mapScriptOutputToInputGovernanceSettings(Artifact artifact, AutoGovernanceScriptOutput scriptOutput) {
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId) && scriptOutput.projectExistingArtifactId != null && scriptOutput.status == AutoGovernanceStatus.AUTO) {
            InputGovernanceSettings.ExistingProjectSettings existingProjectSettings = InputGovernanceSettings.ExistingProjectSettings.build(scriptOutput.projectExistingArtifactId);
            existingProjectSettings.projectAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)scriptOutput.childrenConfiguration;
            return existingProjectSettings;
        }
        AutoGovernanceEffectiveAction action = scriptOutput.status == AutoGovernanceStatus.AUTO ? scriptOutput.action : AutoGovernanceEffectiveAction.DO_NOTHING;
        BlueprintVersionId bvid = scriptOutput.blueprintVersionId;
        Artifact prefillArtifact = scriptOutput.artifactPrefill;
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId)) {
            InputGovernanceSettings.ProjectSettings createProjectSettings = InputGovernanceSettings.ProjectSettings.build(action, bvid, scriptOutput.projectBusinessInitiativeArtifactId, prefillArtifact);
            createProjectSettings.projectAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)scriptOutput.childrenConfiguration;
            return createProjectSettings;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(artifact.blueprintVersionId)) {
            InputGovernanceSettings.ModelSettings modelSettings = InputGovernanceSettings.ModelSettings.build(action, bvid, prefillArtifact);
            modelSettings.modelAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)scriptOutput.childrenConfiguration;
            return modelSettings;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(artifact.blueprintVersionId)) {
            return InputGovernanceSettings.ModelVersionSettings.build(action, bvid, prefillArtifact);
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(artifact.blueprintVersionId)) {
            return InputGovernanceSettings.BundleSettings.build(action, bvid, prefillArtifact);
        }
        throw new ValidationException("Artifact is not governable:" + artifact.id);
    }

    private InputGovernanceSettings mapSimpleConfigToInputGovernanceSettings(Artifact artifact, AutoGovernanceConfiguration configuration) {
        AutoGovernanceEffectiveAction mappedAction;
        AutoGovernanceEffectiveAction autoGovernanceEffectiveAction = mappedAction = configuration.status == AutoGovernanceStatus.AUTO ? AutoGovernanceEffectiveAction.mapFrom(configuration.action) : AutoGovernanceEffectiveAction.DO_NOTHING;
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId)) {
            return InputGovernanceSettings.ProjectSettings.build(mappedAction, configuration.blueprintVersionId, null);
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(artifact.blueprintVersionId)) {
            return InputGovernanceSettings.ModelSettings.build(mappedAction, configuration.blueprintVersionId);
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(artifact.blueprintVersionId)) {
            return InputGovernanceSettings.ModelVersionSettings.build(mappedAction, configuration.blueprintVersionId);
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(artifact.blueprintVersionId)) {
            return InputGovernanceSettings.BundleSettings.build(mappedAction, configuration.blueprintVersionId);
        }
        throw new ValidationException("Artifact is not governable:" + artifact.id);
    }
}

