/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.python_execution.logical_hooks;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class LogicalHookException
extends ValidationException {
    private static final long serialVersionUID = -8942156893880138902L;

    public LogicalHookException(String message, String hookName, @Nullable EnrichedArtifact enrichedArtifact, Map<String, String> fieldMessages) {
        super(LogicalHookException.buildMessage(message, hookName, enrichedArtifact, fieldMessages));
    }

    public LogicalHookException(String message, String hookName, @Nullable EnrichedArtifact enrichedArtifact, Throwable e) {
        super(LogicalHookException.buildMessage(message, hookName, enrichedArtifact, null), e);
    }

    private static String buildMessage(String message, String hookName, @Nullable EnrichedArtifact enrichedArtifact, Map<String, String> fieldMessages) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot perform the action, an error occurred while executing the script: ").append(hookName);
        if (enrichedArtifact != null) {
            String blueprintVersionStr = StringUtils.equals((CharSequence)"bv.system.default", (CharSequence)enrichedArtifact.blueprintVersion.id.versionId) ? "Dataiku Standard" : (String)StringUtils.defaultIfBlank((CharSequence)enrichedArtifact.blueprintVersion.name, (CharSequence)"Unnamed");
            sb.append(" on ").append("item: ").append((String)StringUtils.defaultIfBlank((CharSequence)enrichedArtifact.artifact.name, (CharSequence)"Unnamed")).append(", ").append("item type: ").append((String)StringUtils.defaultIfBlank((CharSequence)enrichedArtifact.blueprint.name, (CharSequence)"Unnamed")).append(", ").append("template: ").append(blueprintVersionStr);
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            sb.append(". ").append(System.lineSeparator()).append(message);
        }
        if (fieldMessages != null && !fieldMessages.isEmpty()) {
            sb.append(System.lineSeparator());
            fieldMessages.forEach((fieldId, fieldMessage) -> sb.append((String)fieldId).append(": ").append((String)fieldMessage).append(System.lineSeparator()));
        }
        return sb.toString();
    }
}

