/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.models.roles.permissions.PermissionsItem;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.visitors.IBlueprintPermissionsVisitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class BlueprintPermissionsValidator
implements IBlueprintPermissionsVisitor {
    private final Set<String> roles = new HashSet<String>();
    private String blueprintId;

    @Override
    public void visit(BlueprintPermissions blueprintPermissions) {
        if (!IdentifiersUtils.isValidBlueprintId(blueprintPermissions.blueprintId)) {
            throw new ValidationException("Invalid blueprint ID: " + blueprintPermissions.blueprintId);
        }
        this.blueprintId = blueprintPermissions.blueprintId;
    }

    @Override
    public void visit(String roleId, PermissionsItem value) {
        this.roles.add(roleId);
    }

    public void validateReferences(IBlueprintDAO blueprintDAO, IRoleDAO roleDAO) throws IOException {
        if (!blueprintDAO.exists(this.blueprintId)) {
            throw new NotFoundException("Blueprint not found: " + this.blueprintId);
        }
        for (String roleId : this.roles) {
            if (roleDAO.exists(roleId)) continue;
            throw new ValidationException("Role " + roleId + " assigned in a rule of blueprint ID " + this.blueprintId + " doesn't exist");
        }
    }
}

