/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.time_series;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.time_series.TimeSeriesDatapoint;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QTimeSeries;
import com.dataiku.gh.core.storage.sql.model.QTimeSeriesHistory;
import com.dataiku.gh.core.storage.sql.time_series.TimeSeriesRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.storage.time_series.ITimeSeriesDAO;
import com.google.common.collect.Sets;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class TimeSeriesDAO
extends AbstractPostgreSQLClient
implements ITimeSeriesDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.time_series");
    @Autowired
    private TimeSeriesRowMapper timeSeriesRowMapper;
    @Autowired
    private IHistoryDataService historyDataService;

    private void create(Set<TimeSeriesDatapoint> dataPoints) throws IOException {
        if (CollectionUtils.isEmpty(dataPoints)) {
            return;
        }
        try {
            SQLInsertClause query = this.sqlQueryFactory.insert((RelationalPath)QTimeSeries.timeSeries);
            dataPoints.forEach(d -> ((SQLInsertClause)query.set(QTimeSeries.timeSeries.timeSeriesJson, QueryBuilderUtils.toJsonb(d))).addBatch());
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)query);
            this.insertHistoryRevisions(RevisionType.ADD, dataPoints);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private void save(Set<TimeSeriesDatapoint> dataPoints) throws IOException {
        if (CollectionUtils.isEmpty(dataPoints)) {
            return;
        }
        try {
            SQLUpdateClause query = this.sqlQueryFactory.update((RelationalPath)QTimeSeries.timeSeries);
            for (TimeSeriesDatapoint dataPoint : dataPoints) {
                ((SQLUpdateClause)((SQLUpdateClause)query.set(QTimeSeries.timeSeries.timeSeriesJson, QueryBuilderUtils.toJsonb(dataPoint))).where((Predicate)QTimeSeries.timeSeries.timeSeriesId.eq((Object)dataPoint.timeSeriesId).and((Predicate)QTimeSeries.timeSeries.timeSeriesTimestamp.eq((Object)OffsetDateTime.ofInstant(Instant.ofEpochMilli(dataPoint.timestamp), ZoneOffset.UTC))))).addBatch();
            }
            int[] updateResults = this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)query);
            if (IntStream.of(updateResults).anyMatch(updateResult -> updateResult != 1)) {
                throw new DataStoreIOException("Error updating the dataPoints");
            }
            this.insertHistoryRevisions(RevisionType.UPDATE, dataPoints);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void push(Set<TimeSeriesDatapoint> dataPoints, boolean upsert) throws IOException {
        if (CollectionUtils.isEmpty(dataPoints)) {
            return;
        }
        HashSet toCreate = Sets.newHashSet();
        HashSet toSave = Sets.newHashSet();
        Map<String, List<TimeSeriesDatapoint>> dataPointsMap = dataPoints.stream().collect(Collectors.groupingBy(point -> point.timeSeriesId));
        for (Map.Entry<String, List<TimeSeriesDatapoint>> idAndPoints : dataPointsMap.entrySet()) {
            List inputDataPointsSorted = idAndPoints.getValue().stream().sorted(Comparator.comparingLong(o -> o.timestamp)).collect(Collectors.toList());
            Instant minSearchTimestamp = Instant.ofEpochMilli(((TimeSeriesDatapoint)inputDataPointsSorted.get((int)0)).timestamp - 1L);
            Instant maxSearchTimestamp = Instant.ofEpochMilli(((TimeSeriesDatapoint)inputDataPointsSorted.get((int)(inputDataPointsSorted.size() - 1))).timestamp + 1L);
            List<TimeSeriesDatapoint> existingPoints = this.list(idAndPoints.getKey(), minSearchTimestamp, maxSearchTimestamp);
            List timestampUniqueNewOrModifiedDatapoints = inputDataPointsSorted.stream().filter(dp -> !existingPoints.contains(dp)).collect(Collectors.groupingBy(timeSeriesDatapoint -> timeSeriesDatapoint.timestamp)).values().stream().map(dpList -> {
                if (dpList.size() > 1) {
                    logger.warn((Object)("Trying to insert several data points with the same time series ID and timestamp, keeping only the last one: " + ((TimeSeriesDatapoint)dpList.get((int)0)).timeSeriesId + ", " + ((TimeSeriesDatapoint)dpList.get((int)0)).timestamp));
                }
                return (TimeSeriesDatapoint)dpList.get(dpList.size() - 1);
            }).collect(Collectors.toList());
            Map<Boolean, List<TimeSeriesDatapoint>> datapoints = timestampUniqueNewOrModifiedDatapoints.stream().collect(Collectors.groupingBy(dataPoint -> existingPoints.stream().anyMatch(existingPoint -> existingPoint.timestamp == dataPoint.timestamp)));
            List modifiedDataPoints = datapoints.getOrDefault(true, Collections.emptyList());
            if (!upsert && !CollectionUtils.isEmpty(modifiedDataPoints)) {
                throw new DataStoreIOException("Cannot modify time series data points when upsert=false: " + modifiedDataPoints.stream().map(point -> String.format("ts:%s, value:%s", point.timestamp, point.value)).collect(Collectors.joining(", ")));
            }
            toCreate.addAll(datapoints.getOrDefault(false, Collections.emptyList()));
            toSave.addAll(modifiedDataPoints);
        }
        this.create(toCreate);
        this.save(toSave);
    }

    @Override
    public List<TimeSeriesDatapoint> list(String timeSeriesId) throws IOException {
        return this.list(timeSeriesId, null, null);
    }

    @Override
    public List<TimeSeriesDatapoint> list(String timeSeriesId, @Nullable Instant timestampMin, @Nullable Instant timestampMax) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QTimeSeries.timeSeries.timeSeriesJson).from((Expression)QTimeSeries.timeSeries)).where((Predicate)QTimeSeries.timeSeries.timeSeriesId.eq((Object)timeSeriesId))).orderBy(new OrderSpecifier(Order.ASC, QTimeSeries.timeSeries.timeSeriesTimestamp));
            if (timestampMin != null) {
                query.where((Predicate)QTimeSeries.timeSeries.timeSeriesTimestamp.after((Comparable)OffsetDateTime.ofInstant(timestampMin, ZoneOffset.UTC)));
            }
            if (timestampMax != null) {
                query.where((Predicate)QTimeSeries.timeSeries.timeSeriesTimestamp.before((Comparable)OffsetDateTime.ofInstant(timestampMax, ZoneOffset.UTC)));
            }
            return this.querydslJdbcTemplate.query(query, this.timeSeriesRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void delete(String timeSeriesId) throws IOException {
        this.delete(timeSeriesId, null, null);
    }

    @Override
    public void delete(String timeSeriesId, @Nullable Instant timestampMin, @Nullable Instant timestampMax) throws IOException {
        try {
            this.insertHistoryRevisions(RevisionType.DELETE, this.list(timeSeriesId, timestampMin, timestampMax));
            SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QTimeSeries.timeSeries).where((Predicate)QTimeSeries.timeSeries.timeSeriesId.eq((Object)timeSeriesId));
            if (timestampMin != null) {
                query.where((Predicate)QTimeSeries.timeSeries.timeSeriesTimestamp.after((Comparable)OffsetDateTime.ofInstant(timestampMin, ZoneOffset.UTC)));
            }
            if (timestampMax != null) {
                query.where((Predicate)QTimeSeries.timeSeries.timeSeriesTimestamp.before((Comparable)OffsetDateTime.ofInstant(timestampMax, ZoneOffset.UTC)));
            }
            this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private void insertHistoryRevisions(RevisionType revisionType, Collection<TimeSeriesDatapoint> datapoints) throws IOException {
        if (CollectionUtils.isEmpty(datapoints)) {
            return;
        }
        SQLInsertClause insertHistory = this.sqlQueryFactory.insert((RelationalPath)QTimeSeriesHistory.timeSeriesHistory);
        for (TimeSeriesDatapoint datapoint : datapoints) {
            HistoryRevision historyRevision = this.historyDataService.createRevision(revisionType, EntityType.TIME_SERIES);
            ((SQLInsertClause)((SQLInsertClause)insertHistory.set(QTimeSeriesHistory.timeSeriesHistory._revisionJson, QueryBuilderUtils.toJsonb(historyRevision))).set(QTimeSeriesHistory.timeSeriesHistory.timeSeriesJson, QueryBuilderUtils.toJsonb(datapoint))).addBatch();
        }
        this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insertHistory);
    }
}

