/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.api;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.directory.NodesDirectoryService;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.dataiku.gh.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.gh.server.services.BackendTransactionService;
import com.dataiku.gh.server.services.GeneralSettingsService;
import com.dataiku.gh.server.services.GraphiteReportingService;
import com.dataiku.gh.server.services.LogsService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/admin"})
public class PublicApiAdminController
extends PublicAPIControllerBase {
    @Autowired
    private LogsService logsService;
    @Autowired
    private PublicAPIKeysService publicApiKeyService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private GraphiteReportingService graphiteReportingService;
    @Autowired
    private NodesDirectoryService nodesDirectoryService;

    @AuditedCall(value={"msgType", "publicapi-keys-list"})
    @RequestMapping(value={"/global-api-keys", "/globalAPIKeys"}, method={RequestMethod.GET})
    @ResponseBody
    public List<GlobalScopePublicAPIKey> listGlobalKeys(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List<GlobalScopePublicAPIKey> globalScopePublicAPIKeys = this.publicApiKeyService.listGlobalAPIKeys();
            globalScopePublicAPIKeys.forEach(GlobalScopePublicAPIKey::clearManagedKeyField);
            List<GlobalScopePublicAPIKey> list = globalScopePublicAPIKeys;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-key-get", "key", "${key}"})
    @RequestMapping(value={"/globalAPIKeys/{key:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public GlobalScopePublicAPIKey getGlobalKeyByKey(HttpServletRequest req, @PathVariable String key) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyFromKey(key);
            globalAPIKey.clearManagedKeyField();
            GlobalScopePublicAPIKey globalScopePublicAPIKey = globalAPIKey;
            return globalScopePublicAPIKey;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-key-get", "keyId", "${id}"})
    @RequestMapping(value={"/global-api-keys/{id:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public GlobalScopePublicAPIKey getGlobalKeyById(HttpServletRequest req, @PathVariable String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyById(id);
            globalAPIKey.clearManagedKeyField();
            GlobalScopePublicAPIKey globalScopePublicAPIKey = globalAPIKey;
            return globalScopePublicAPIKey;
        }
    }

    @AuditInline
    @RequestMapping(value={"/global-api-keys", "/globalAPIKeys"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_CREATE)
    public void createGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean forceKey) throws Exception {
        GlobalScopePublicAPIKey gsKey = (GlobalScopePublicAPIKey)((Object)this.getRequestBodyAs(req, GlobalScopePublicAPIKey.class));
        if (!forceKey) {
            this.require(gsKey.key == null, "You must not fill the 'key'");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            gsKey = this.publicApiKeyService.createGlobalAPIKey(gsKey);
            t.commit("Created new global public API key");
            gsKey.clearManagedKeyField();
            PublicApiAdminController.writeJSON((HttpServletResponse)resp, (Object)((Object)gsKey));
            this.auditTrailService.generic("publicapi-key-create").with("keyId", gsKey.id).with("isAdmin", gsKey.globalPermissions.isAdmin()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-create", (Throwable)e).emit();
            throw e;
        }
    }

    private void checkKeyInBody(GlobalScopePublicAPIKey newKey, GlobalScopePublicAPIKey oldKey) {
        if (!ApiKeyUtils.useHashedApiKeys()) {
            this.require(oldKey.key.equals(newKey.key), "Existing 'key' mismatch vs Body");
        }
    }

    @AuditInline
    @RequestMapping(value={"/globalAPIKeys/{key:.+}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_SAVE)
    @Deprecated
    public void updateGlobalKeyByKey(HttpServletRequest req, @PathVariable String key) throws Exception {
        GlobalScopePublicAPIKey gsKey = (GlobalScopePublicAPIKey)((Object)this.getRequestBodyAs(req, GlobalScopePublicAPIKey.class));
        this.require(gsKey.key != null, "No 'key' in body");
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyByIdWithSecret(gsKey.id);
            this.require(ApiKeyUtils.compareKeySecret((String)key, (String)globalAPIKey.getKey()), "'key' mismatch URI vs Body");
            this.checkKeyInBody(gsKey, globalAPIKey);
            this.publicApiKeyService.updateGlobalAPIKeyByKey(globalAPIKey.getKey(), gsKey);
            t.commit("Updated global public API key");
            this.auditTrailService.generic("publicapi-key-edit").with("keyId", gsKey.id).with("isAdmin", gsKey.globalPermissions.isAdmin()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/global-api-keys/{id:.+}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_SAVE)
    public void updateGlobalKeyById(HttpServletRequest req, @PathVariable String id) throws Exception {
        GlobalScopePublicAPIKey gsKey = (GlobalScopePublicAPIKey)((Object)this.getRequestBodyAs(req, GlobalScopePublicAPIKey.class));
        this.require(gsKey.id.equals(id), "'id' mismatch URI vs Body");
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyByIdWithSecret(id);
            this.checkKeyInBody(gsKey, globalAPIKey);
            this.publicApiKeyService.updateGlobalAPIKeyById(gsKey);
            t.commit("Updated global public API key");
            this.auditTrailService.generic("publicapi-key-edit").with("keyId", gsKey.id).with("isAdmin", gsKey.globalPermissions.isAdmin()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/globalAPIKeys/{key:.+}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_DELETE)
    @Deprecated
    public void deleteGlobalKeyByKey(HttpServletRequest req, @PathVariable String key) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.publicApiKeyService.deleteGlobalAPIKeyByKey(key);
            t.commit("Deleted global public API key");
            this.auditTrailService.generic("publicapi-key-delete").with("key", key).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-delete", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/global-api-keys/{id:.+}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_DELETE)
    public void deleteGlobalKeyById(HttpServletRequest req, @PathVariable String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.publicApiKeyService.deleteGlobalAPIKeyById(id);
            t.commit("Deleted global public API key");
            this.auditTrailService.generic("publicapi-key-delete").with("keyId", id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-delete", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-logs-get"})
    @RequestMapping(value={"/logs"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LogsService.LogDesc> listLogs(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.logsService.listLogs();
    }

    @AuditedCall(value={"msgType", "publicapi-logs-get"})
    @RequestMapping(value={"/logs/**"}, method={RequestMethod.GET})
    @ResponseBody
    public LogsService.LogDesc getLog(HttpServletRequest req) throws Exception {
        String urlPrefix = "/logs/";
        String logName = req.getServletPath();
        logName = logName.substring(logName.indexOf(urlPrefix) + urlPrefix.length());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        try {
            return this.logsService.getLogContent(logName);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Failed to load log file: " + logName), (Throwable)e);
            throw new NotFoundException("Failed to load log file: " + logName);
        }
    }

    @AuditedCall(value={"msgType", "publicapi-general-settings-get"})
    @RequestMapping(value={"/general-settings"}, method={RequestMethod.GET})
    @ResponseBody
    public GeneralSettingsDAO.GeneralSettings getGeneralSettings(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
            return generalSettings;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-general-settings-edit"})
    @RequestMapping(value={"/general-settings"}, method={RequestMethod.PUT})
    public void setGeneralSettings(HttpServletRequest req) throws Exception {
        GeneralSettingsDAO.GeneralSettings settings = (GeneralSettingsDAO.GeneralSettings)this.getRequestBodyAs(req, GeneralSettingsDAO.GeneralSettings.class);
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            GeneralSettingsChangedEvent changeEvent = this.generalSettingsService.save(t.getUser(), settings);
            t.commit("Saved general settings");
        }
        t = this.transactionService.beginRead();
        try {
            this.graphiteReportingService.restartReporterIfNeeded();
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "publicapi-nodes-directory-edit"})
    @RequestMapping(value={"/nodes-directory"}, method={RequestMethod.PUT})
    public void updateNodesDirectory(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        NodesDirectory directory = (NodesDirectory)this.getRequestBodyAs(req, NodesDirectory.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.nodesDirectoryService.saveNodesDirectory(directory);
            t.commit("Updated nodes directory");
        }
    }

    @AuditInline
    @RequestMapping(value={"/audit/custom/{customMsgType:.+}"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void logCustomAudit(HttpServletRequest req, @PathVariable String customMsgType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        JsonObject params = (JsonObject)JSON.parse((InputStream)req.getInputStream(), JsonObject.class);
        this.auditTrailService.generic("custom").with("customMsgType", customMsgType).with("customMsgParams", params).emit();
    }

    @AuditedCall(value={"msgType", "publicapi-invalidate-config-common-files-cache"})
    @RequestMapping(value={"/invalidate-config-common-files-cache"}, method={RequestMethod.POST})
    public void invalidateConfigCommonFilesCache() throws IOException {
        for (String commonFile : BackendTransactionService.DKU_CONFIG_COMMON_FILES) {
            this.transactionService.invalidateCache(RelFile.fromPath((String)commonFile));
        }
    }

    @AuditedCall(value={"msgType", "publicapi-invalidate-config-cache", "path", "${path}"})
    @RequestMapping(value={"/invalidate-config-cache"}, method={RequestMethod.POST})
    public void invalidateConfigCache(HttpServletRequest req, @RequestParam String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.transactionService.invalidateCache(RelFile.fromPath((String)path));
    }

    @AuditedCall(value={"msgType", "publicapi-get-node-type", "path", "${path}"})
    @RequestMapping(value={"/get-node-type"}, method={RequestMethod.GET})
    @ResponseBody
    public String getNodeType(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        return nodeType.name();
    }

    @AuditedCall(value={"msgType", "publicapi-get-node-id"})
    @RequestMapping(value={"/get-node-id"}, method={RequestMethod.GET})
    @ResponseBody
    public String getNodeId(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return DKUApp.getNodeId();
    }
}

