/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.IntervalParserUtils;
import io.delta.kernel.internal.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class TableConfig<T> {
    public static final TableConfig<Long> TOMBSTONE_RETENTION = new TableConfig<Long>("delta.deletedFileRetentionDuration", "interval 1 week", IntervalParserUtils::safeParseIntervalAsMillis, l -> l >= 0L, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", true);
    public static final TableConfig<Integer> CHECKPOINT_INTERVAL = new TableConfig<Integer>("delta.checkpointInterval", "10", Integer::valueOf, n -> n > 0, "needs to be a positive integer.", true);
    public static final TableConfig<Long> LOG_RETENTION = new TableConfig<Long>("delta.logRetentionDuration", "interval 30 days", IntervalParserUtils::safeParseIntervalAsMillis, l -> true, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", true);
    public static final TableConfig<Boolean> EXPIRED_LOG_CLEANUP_ENABLED = new TableConfig<Boolean>("delta.enableExpiredLogCleanup", "true", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Boolean> IN_COMMIT_TIMESTAMPS_ENABLED = new TableConfig<Boolean>("delta.enableInCommitTimestamps", "false", string -> Boolean.valueOf(string), bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Optional<Long>> IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION = new TableConfig<Optional>("delta.inCommitTimestampEnablementVersion", null, string -> Optional.ofNullable(string).map(Long::valueOf), optional -> true, "needs to be a long.", true);
    public static final TableConfig<Optional<Long>> IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP = new TableConfig<Optional>("delta.inCommitTimestampEnablementTimestamp", null, string -> Optional.ofNullable(string).map(Long::valueOf), optional -> true, "needs to be a long.", true);
    public static final TableConfig<Optional<String>> COORDINATED_COMMITS_COORDINATOR_NAME = new TableConfig<Optional>("delta.coordinatedCommits.commitCoordinator-preview", null, Optional::ofNullable, optional -> true, "The commit-coordinator name for this table. This is used to determine which implementation of commit-coordinator to use when committing to this table. If this property is not set, the table will be considered as file system table and commits will be done via atomically publishing the commit file.", true);
    public static final TableConfig<Map<String, String>> COORDINATED_COMMITS_COORDINATOR_CONF = new TableConfig<Map>("delta.coordinatedCommits.commitCoordinatorConf-preview", null, JsonUtils::parseJSONKeyValueMap, map -> true, "A string-to-string map of configuration properties for the coordinated commits-coordinator.", true);
    public static final TableConfig<Map<String, String>> COORDINATED_COMMITS_TABLE_CONF = new TableConfig<Map>("delta.coordinatedCommits.tableConf-preview", null, JsonUtils::parseJSONKeyValueMap, map -> true, "A string-to-string map of configuration properties for  describing the table to commit-coordinator.", true);
    public static final TableConfig<ColumnMapping.ColumnMappingMode> COLUMN_MAPPING_MODE = new TableConfig<ColumnMapping.ColumnMappingMode>("delta.columnMapping.mode", "none", ColumnMapping.ColumnMappingMode::fromTableConfig, columnMappingMode -> true, "Needs to be one of none, id, name.", true);
    public static final TableConfig<Long> COLUMN_MAPPING_MAX_COLUMN_ID = new TableConfig<Long>("delta.columnMapping.maxColumnId", "0", Long::valueOf, l -> l >= 0L, "", false);
    public static final TableConfig<Boolean> ICEBERG_COMPAT_V2_ENABLED = new TableConfig<Boolean>("delta.enableIcebergCompatV2", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    private static final Map<String, TableConfig<?>> VALID_PROPERTIES = Collections.unmodifiableMap(new HashMap<String, TableConfig<?>>(){
        {
            TableConfig.addConfig(this, (TableConfig)TOMBSTONE_RETENTION);
            TableConfig.addConfig(this, (TableConfig)CHECKPOINT_INTERVAL);
            TableConfig.addConfig(this, (TableConfig)IN_COMMIT_TIMESTAMPS_ENABLED);
            TableConfig.addConfig(this, (TableConfig)IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION);
            TableConfig.addConfig(this, (TableConfig)IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP);
            TableConfig.addConfig(this, (TableConfig)COORDINATED_COMMITS_COORDINATOR_NAME);
            TableConfig.addConfig(this, (TableConfig)COORDINATED_COMMITS_COORDINATOR_CONF);
            TableConfig.addConfig(this, (TableConfig)COORDINATED_COMMITS_TABLE_CONF);
            TableConfig.addConfig(this, (TableConfig)COLUMN_MAPPING_MODE);
            TableConfig.addConfig(this, (TableConfig)ICEBERG_COMPAT_V2_ENABLED);
            TableConfig.addConfig(this, (TableConfig)COLUMN_MAPPING_MAX_COLUMN_ID);
        }
    });
    private final String key;
    private final String defaultValue;
    private final Function<String, T> fromString;
    private final Predicate<T> validator;
    private final boolean editable;
    private final String helpMessage;

    public static Map<String, String> validateProperties(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey().toLowerCase(Locale.ROOT);
            String string2 = entry.getValue();
            if (string.startsWith("delta.") && VALID_PROPERTIES.containsKey(string)) {
                if ((string.equalsIgnoreCase(COLUMN_MAPPING_MODE.getKey()) || string.equalsIgnoreCase(ICEBERG_COMPAT_V2_ENABLED.getKey())) && !Boolean.getBoolean("ENABLE_COLUMN_MAPPING_TESTS")) {
                    throw DeltaErrors.unknownConfigurationException(entry.getKey());
                }
                TableConfig<?> tableConfig = VALID_PROPERTIES.get(string);
                if (tableConfig.editable) {
                    super.validate(string2);
                    hashMap.put(tableConfig.getKey(), string2);
                    continue;
                }
                throw DeltaErrors.cannotModifyTableProperty(entry.getKey());
            }
            throw DeltaErrors.unknownConfigurationException(entry.getKey());
        }
        return hashMap;
    }

    private static void addConfig(HashMap<String, TableConfig<?>> hashMap, TableConfig<?> tableConfig) {
        hashMap.put(tableConfig.getKey().toLowerCase(Locale.ROOT), tableConfig);
    }

    private TableConfig(String string, String string2, Function<String, T> function, Predicate<T> predicate, String string3, boolean bl) {
        this.key = string;
        this.defaultValue = string2;
        this.fromString = function;
        this.validator = predicate;
        this.helpMessage = string3;
        this.editable = bl;
    }

    public T fromMetadata(Metadata metadata) {
        return this.fromMetadata(metadata.getConfiguration());
    }

    public T fromMetadata(Map<String, String> map) {
        String string = map.getOrDefault(this.key, this.defaultValue);
        this.validate(string);
        return this.fromString.apply(string);
    }

    public String getKey() {
        return this.key;
    }

    private void validate(String string) {
        T t = this.fromString.apply(string);
        if (!this.validator.test(t)) {
            throw DeltaErrors.invalidConfigurationValueException(this.key, string, this.helpMessage);
        }
    }
}

