/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.CausalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PreprocessingParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MLSchemaComparator {
    public static List<InfoMessage> checkForTrain(String context, PreprocessingParams params, Schema toCheck) {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        String targetRoleName = params instanceof CausalPredictionPreprocessingParams ? "outcome" : "target";
        for (Map.Entry<String, FeaturePreprocessingParams> fp : params.per_feature.entrySet()) {
            SchemaColumn col;
            if (fp.getValue().role == FeaturePreprocessingParams.Role.REJECT || (col = toCheck.getColumn(fp.getKey())) != null) continue;
            if (fp.getValue().role == FeaturePreprocessingParams.Role.TARGET) {
                ret.add(InfoMessage.fatal((String)(context + ": " + targetRoleName + " column " + fp.getKey() + " is missing")));
                continue;
            }
            ret.add(InfoMessage.fatal((String)(context + ": column " + fp.getKey() + " is missing")));
        }
        return ret;
    }

    public static List<InfoMessage> checkForScore(ResolvedPreprocessingParams params, Schema toCheck) {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        List<FeaturePreprocessingParams.Role> skippableRoles = params.skippableRolesForScoring();
        String targetRoleName = params instanceof ResolvedCausalPredictionPreprocessingParams ? "outcome" : "target";
        for (Map.Entry<String, FeaturePreprocessingParams> fp : params.per_feature.entrySet()) {
            SchemaColumn col;
            if (fp.getValue().role == FeaturePreprocessingParams.Role.TARGET) {
                col = toCheck.getColumn(fp.getKey());
                if (col == null) continue;
                ret.add(InfoMessage.warning((String)("Dataset to score already contains " + targetRoleName + " " + col.getName())));
                continue;
            }
            if (skippableRoles.contains((Object)fp.getValue().role) || (col = toCheck.getColumn(fp.getKey())) != null) continue;
            ret.add(InfoMessage.fatal((String)("Missing column: " + fp.getKey())));
        }
        return ret;
    }
}

