/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipeParams;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.guess.DefaultPredictionGuesser;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.ClassificationModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.SingleThreadPusherToMemTable;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.mec.drift.DriftParams;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StandaloneEvaluationRecipeRunner
implements FlowRunnable,
RecipeRunner,
RecipeRunnerWithPayload {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private KernelsModelEvaluationStoresService modelEvaluationStoresService;
    @Autowired
    private VariablesService variablesService;
    private StandaloneEvaluationRecipePayloadParams desc;
    private ResourcesGatherer gatherer = new ResourcesGatherer();
    private AuthCtx authCtx;
    private final JobActivity activity;
    private final RecipeRunnableSubgraph subgraph;
    private final FlowRecipe recipe;
    private static DKULogger logger;

    public StandaloneEvaluationRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        activity.initStatus();
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (StandaloneEvaluationRecipePayloadParams)JSON.parse((String)payload, StandaloneEvaluationRecipePayloadParams.class);
    }

    @Override
    public void init() {
        SpringUtils.getInstance().autowire((Object)this.gatherer);
        this.authCtx = this.authCtxService.getAuthCtx();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() throws Exception {
        File file;
        FlowDataset referenceFDS;
        FlowDataset inputFDS = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getSingleSourceDatasetForRole("main");
        List<FlowDataset> referenceFDSs = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getSourceDatasetsForRole("reference");
        FlowDataset flowDataset = referenceFDS = referenceFDSs.isEmpty() ? null : referenceFDSs.get(0);
        if (inputFDS == null) {
            throw ErrorContext.iae((String)"Missing input dataset in standalone evaluation recipe");
        }
        Dataset inputDataset = inputFDS.getMandatory(this.datasetsDAO);
        Dataset referenceDataset = referenceFDS != null ? referenceFDS.getOrNull(this.datasetsDAO) : null;
        final String inputDatasetSmartName = inputDataset.getSmartName(this.recipe.getProjectKey());
        final String referenceDatasetSmartName = referenceDataset == null ? null : referenceDataset.getSmartName(this.recipe.getProjectKey());
        List<InfoMessage> customMetricsErrors = PredictionService.checkCustomMetricParams(this.desc.customEvaluationMetrics);
        if (!customMetricsErrors.isEmpty()) {
            throw new IllegalArgumentException(customMetricsErrors.get(0).toString());
        }
        VariablesContext vc = this.variablesService.getForProject(this.recipe.getProjectKey());
        Schema preparationOSchemaToUse = inputDataset.getSchema();
        SerializedRecipe.RecipeOutput evaluationStoreRole = this.recipe.getModel().getSingleOutput("main");
        AnyLoc evaluationStoreLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.getProjectKey(), evaluationStoreRole.ref);
        if (!this.desc.hasModel) {
            logger.info((Object)"No model was selected, only drift will be computed.");
            this.desc.dontComputePerformance = true;
            this.desc.classes = Lists.newArrayList();
            this.desc.probas = Lists.newArrayList();
            this.desc.isProbaAware = false;
        }
        switch (this.desc.predictionType) {
            case BINARY_CLASSIFICATION: {
                MetricParams.EvaluationMetric evaluationMetric = this.desc.metricParams.evaluationMetric = this.desc.isProbaAware ? MetricParams.EvaluationMetric.ROC_AUC : MetricParams.EvaluationMetric.ACCURACY;
                if (this.desc.metricParams.thresholdOptimizationMetric != null) break;
                this.desc.metricParams.thresholdOptimizationMetric = MetricParams.ThresholdOptimizationMetric.F1;
                break;
            }
            case MULTICLASS: {
                this.desc.metricParams.evaluationMetric = this.desc.isProbaAware ? MetricParams.EvaluationMetric.ROC_AUC : MetricParams.EvaluationMetric.ACCURACY;
                break;
            }
            case REGRESSION: {
                this.desc.metricParams.evaluationMetric = MetricParams.EvaluationMetric.R2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)this.desc.predictionType));
            }
        }
        List<Partition> inputPartitions = this.subgraph.getSourcePartitions(inputFDS);
        List<Partition> referencePartitions = referenceFDS != null ? this.subgraph.getSourcePartitions(referenceFDS) : null;
        KernelsModelEvaluationStoresService.ModelTypeAndParams modelTypeAndParams = new KernelsModelEvaluationStoresService.ModelTypeAndParams();
        modelTypeAndParams.type = this.desc.modelType;
        modelTypeAndParams.params = this.desc.modelParams;
        KernelsModelEvaluationStoresService.DataTypeAndParams datasetTypeAndParams = this.modelEvaluationStoresService.makeDataTypeAndParams(this.recipe.getProjectKey(), inputDataset, inputPartitions);
        KernelsModelEvaluationStoresService.DataTypeAndParams trainDataTypeAndParams = new KernelsModelEvaluationStoresService.DataTypeAndParams();
        trainDataTypeAndParams.type = this.desc.trainDataType;
        modelTypeAndParams.params = this.desc.trainDataParams;
        KernelsModelEvaluationStoresService.TabularEvaluationModelInfo evaluationModelInfo = new KernelsModelEvaluationStoresService.TabularEvaluationModelInfo();
        evaluationModelInfo.evaluationId = this.desc.evaluationId;
        evaluationModelInfo.name = this.desc.name;
        evaluationModelInfo.thresholdAutoOptimized = this.desc.autoOptimizeThreshold;
        evaluationModelInfo.activeClassifierThreshold = this.desc.activeClassifierThreshold;
        evaluationModelInfo.metricParams = this.desc.metricParams;
        evaluationModelInfo.predictionType = this.desc.predictionType;
        evaluationModelInfo.predictionVariable = this.desc.predictionVariable;
        evaluationModelInfo.targetVariable = this.desc.targetVariable;
        evaluationModelInfo.weightsVariable = this.desc.weightsVariable;
        evaluationModelInfo.outputProbabilities = this.desc.isProbaAware;
        evaluationModelInfo.limitSampling = this.desc.limitSampling;
        evaluationModelInfo.hasModel = this.desc.hasModel;
        evaluationModelInfo.hasTextDrift = this.desc.hasTextDrift;
        evaluationModelInfo.textDriftParams = this.desc.textDriftParams;
        evaluationModelInfo.evaluateRecipeParams = new KernelsModelEvaluationStoresService.EvaluateRecipeParams(this.desc.dontComputePerformance, this.desc.probas, this.desc.classes, this.desc.features, this.desc.isProbaAware);
        if (this.desc.isProbaAware && (this.desc.predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION || this.desc.predictionType == PredictionMLTask.PredictionType.MULTICLASS)) {
            evaluationModelInfo.probaColumns = Lists.newArrayList();
            for (SimpleKeyValue proba : this.desc.probas) {
                evaluationModelInfo.probaColumns.add(new TabularModelEvaluation.EvaluationModelInfoProba(evaluationModelInfo.probaColumns.size(), proba.value));
            }
        }
        SerializedDataset serializedReferenceDataset = referenceDataset == null ? null : referenceDataset.serialize();
        evaluationModelInfo.labels = EvaluationLabelsHelper.getEvaluationTimeLabels_T(this.recipe.getProjectKey(), null, inputDataset.serialize(), serializedReferenceDataset, this.desc.labels, inputPartitions, this.desc.treatDataDriftColumnHandling ? this.desc.dataDriftColumnHandling : null);
        ModelEvaluationStore mes = this.modelEvaluationStoresService.getMandatory(evaluationStoreLoc.getProjectKey(), evaluationStoreLoc.getId());
        TabularModelEvaluation modelEvaluation = this.modelEvaluationStoresService.setupTabularRun(mes, modelTypeAndParams, datasetTypeAndParams, trainDataTypeAndParams, evaluationModelInfo, referenceDatasetSmartName);
        final File evaluationStoreFolder = modelEvaluation.ref.getMainFolder();
        MemTable table = new MemTable();
        SingleThreadPusherToMemTable pusher = new SingleThreadPusherToMemTable(this.authCtx, inputDataset, table, false);
        DatasetSelectionToMemTable ret = new DatasetSelectionToMemTable();
        ret.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
        ret.maxRecords = 10000L;
        pusher.setDatasetSelection(ret);
        pusher.push();
        new TypeInferrer2().processForExplore(inputDataset.getFullName(), table, inputDataset.getSchema());
        PredictionMLTask.ClassicalPredictionMLTask task = new PredictionMLTask.ClassicalPredictionMLTask();
        task.backendType = MLTask.BackendType.PY_MEMORY;
        task.taskType = MLTask.MLTaskType.PREDICTION;
        task.predictionType = this.desc.predictionType;
        task.targetVariable = "__not_a_column__";
        DefaultPredictionGuesser guesser = new DefaultPredictionGuesser(task, table);
        HashMap features = Maps.newHashMap();
        for (Iterator<String> column : Lists.newArrayList(table.columnsList)) {
            void var31_31;
            if (evaluationModelInfo.probaColumns != null && evaluationModelInfo.probaColumns.stream().anyMatch(arg_0 -> StandaloneEvaluationRecipeRunner.lambda$run$0((MemColumn)((Object)column), arg_0)) || ((MemColumn)((Object)column)).getName().equals(this.desc.predictionVariable)) continue;
            FeaturePreprocessingParams featurePreprocessingParams = guesser.guessSingleFeature((MemColumn)((Object)column));
            if (((MemColumn)((Object)column)).getName().equals(this.desc.targetVariable)) {
                featurePreprocessingParams.role = FeaturePreprocessingParams.Role.TARGET;
            } else if (((MemColumn)((Object)column)).getName().equals(this.desc.weightsVariable)) {
                featurePreprocessingParams.role = FeaturePreprocessingParams.Role.WEIGHT;
            }
            FeaturePreprocessingParams guessOverride = null;
            for (FeaturePreprocessingParams feature : this.desc.features) {
                if (!((MemColumn)((Object)column)).getName().equals(feature.name)) continue;
                guessOverride = feature;
            }
            if (guessOverride != null) {
                if (guessOverride.type != null) {
                    switch (guessOverride.type) {
                        case NUMERIC: {
                            NumFeaturePreprocessingParams numFeaturePreprocessingParams = guesser.guessNumerical((MemColumn)((Object)column));
                            break;
                        }
                        case CATEGORY: {
                            CatFeaturePreprocessingParams catFeaturePreprocessingParams = guesser.guessCategorical((MemColumn)((Object)column));
                            break;
                        }
                        case TEXT: {
                            TextFeaturePreprocessingParams textFeaturePreprocessingParams = guesser.guessText((MemColumn)((Object)column));
                            textFeaturePreprocessingParams.role = FeaturePreprocessingParams.Role.INPUT;
                            textFeaturePreprocessingParams.autoReason = null;
                            break;
                        }
                        default: {
                            logger.warnV("Column %s has a feature type %s. Only Numeric, Categorical and Text are supported. It will be treated as Categorical.", new Object[]{((MemColumn)((Object)column)).getName(), guessOverride.type.name()});
                            CatFeaturePreprocessingParams catFeaturePreprocessingParams = guesser.guessCategorical((MemColumn)((Object)column));
                        }
                    }
                }
                if (guessOverride.role != null) {
                    var31_31.role = guessOverride.role;
                }
            }
            DriftParams.PerColumnDriftParam driftHandling = this.desc.dataDriftColumnHandling.get(((MemColumn)((Object)column)).getName());
            if (var31_31.type.equals((Object)FeaturePreprocessingParams.FeatureType.TEXT) && (this.desc.hasTextDrift || driftHandling != null && driftHandling.enabled && driftHandling.handling.equals((Object)DriftParams.ColumnHandling.TEXT))) {
                var31_31.role = FeaturePreprocessingParams.Role.INPUT;
                var31_31.autoReason = null;
            }
            features.put(((MemColumn)((Object)column)).getName(), var31_31);
        }
        ResolvedClassicalPredictionPreprocessingParams rppp = new ResolvedClassicalPredictionPreprocessingParams();
        rppp.per_feature = features;
        rppp.target_remapping = Lists.newArrayList();
        switch (this.desc.predictionType) {
            case BINARY_CLASSIFICATION: 
            case MULTICLASS: {
                if (this.desc.isProbaAware) {
                    for (SimpleKeyValue simpleKeyValue : this.desc.probas) {
                        rppp.target_remapping.add(new PredictionPreprocessingParams.MappingValue(simpleKeyValue.key, rppp.target_remapping.size(), 1));
                    }
                } else {
                    for (String string : this.desc.classes) {
                        rppp.target_remapping.add(new PredictionPreprocessingParams.MappingValue(string, rppp.target_remapping.size(), 1));
                    }
                }
                break;
            }
            case REGRESSION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)this.desc.predictionType));
            }
        }
        JSON.prettyToFile((Object)rppp, (File)new File(evaluationStoreFolder, "rpreprocessing_params.json"));
        PredictionModelIntrinsicPerf iperf = null;
        switch (this.desc.predictionType) {
            case BINARY_CLASSIFICATION: 
            case MULTICLASS: {
                iperf = new ClassificationModelIntrinsicPerf();
                iperf.probaAware = this.desc.isProbaAware;
                break;
            }
            case REGRESSION: {
                iperf = new RegressionModelIntrinsicPerf();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)this.desc.predictionType));
            }
        }
        if (this.desc.hasTextDrift) {
            if (this.desc.textDriftParams == null) {
                throw new IllegalArgumentException("The text drift params cannot be null with the text drift enabled. Please review your recipe configuration.");
            }
            if (this.desc.textDriftParams.embeddingModelId == null) {
                throw new IllegalArgumentException("No embedding model is selected, whereas the text drift is enabled. Please review your recipe configuration.");
            }
        }
        JSON.prettyToFile((Object)iperf, (File)new File(evaluationStoreFolder, "iperf.json"));
        FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.recipe.getProjectKey(), true, evaluationStoreFolder);
        try (final AutoDelete autoDelete = FlowJobUtils.getTmpFolder("evaluation-recipe", "pyrun");){
            JSON.prettyToFile((Object)this.desc, (File)new File((File)autoDelete, "desc.json"));
            JSON.prettyToFile((Object)preparationOSchemaToUse, (File)new File((File)autoDelete, "preparation_output_schema.json"));
            if (referenceDatasetSmartName != null) {
                JSON.prettyToFile((Object)referenceDataset.getSchema(), (File)new File((File)autoDelete, "reference_dataset_schema.json"));
            }
            JobContext.getCurrentActivitySummary().engineType = "PYTHON";
            AbstractPythonRecipeRunner runner = new AbstractPythonRecipeRunner(this.activity){

                @Override
                public void run() throws Exception {
                    FilesystemACLUtils.grantFSFullACLs(StandaloneEvaluationRecipeRunner.this.authCtx, this.projectKey, new File[]{autoDelete});
                    File additionalLogsDir = FlowJobUtils.getJobMadeDir("evaluation-recipe", "additional-logs");
                    File mainLogFile = FlowJobUtils.getJobTouchedFile("evaluation-recipe", "python.log");
                    StandaloneEvaluationRecipeParams params = this.recipe.getModel().getParamsAs(StandaloneEvaluationRecipeParams.class);
                    String envName = new CodeEnvSelector().selectForPythonRecipe(this.recipe.getProjectKey(), params.envSelection);
                    CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
                    ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), params.containerSelection);
                    logger.info((Object)("Run standalone evaluation in code env " + StringUtils.defaultIfBlank((String)envName, (String)"built-in") + " and container " + (containerConfig == null ? "local" : containerConfig.name)));
                    if (containerConfig == null) {
                        this.executeModule(envName, (File)autoDelete, "dataiku.doctor.evaluation.reg_standalone_evaluation_recipe", inputDatasetSmartName, new File((File)autoDelete, "desc.json").getAbsolutePath(), new File((File)autoDelete, "preparation_output_schema.json").getAbsolutePath(), evaluationStoreFolder.getAbsolutePath(), referenceDatasetSmartName == null ? "" : referenceDatasetSmartName, referenceDatasetSmartName == null ? "" : new File((File)autoDelete, "reference_dataset_schema.json").getAbsolutePath(), autoDelete.getAbsolutePath());
                    } else {
                        List<String> readableAndWritablePaths = Arrays.asList(evaluationStoreFolder.getAbsolutePath(), autoDelete.getAbsolutePath());
                        JsonObject payload = new JsonObject();
                        payload.addProperty("inputDatasetSmartName", inputDatasetSmartName);
                        if (referenceDatasetSmartName != null) {
                            payload.addProperty("referenceDatasetSmartName", referenceDatasetSmartName);
                        }
                        payload.addProperty("evaluationStoreFolder", evaluationStoreFolder.getAbsolutePath());
                        switch (containerConfig.type) {
                            case DOCKER: {
                                this.executeDockerCodeRecipe(codeEnvRef, containerConfig, evaluationStoreFolder, mainLogFile, autoDelete, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON, payload.toString(), Collections.emptyMap(), readableAndWritablePaths, readableAndWritablePaths);
                                break;
                            }
                            case KUBERNETES: {
                                this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, evaluationStoreFolder, mainLogFile, additionalLogsDir, autoDelete, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON, payload.toString(), Collections.emptyMap(), readableAndWritablePaths, readableAndWritablePaths, new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                                    @Override
                                    public InfoMessage.MessageCode codeForOOMKilled() {
                                        return RecipeCodes.ERR_RECIPE_ML_EVALUATION_K8S_OOM;
                                    }
                                });
                            }
                        }
                    }
                }

                @Override
                public void init() throws Exception {
                }
            };
            SpringUtils.getInstance().autowire((Object)runner);
            runner.init();
            runner.run();
            File diagnosticsFile = DKUFileUtils.getWithin((File)autoDelete, (String[])new String[]{"ml_diagnostics.json"});
            if (diagnosticsFile.exists()) {
                MLDiagnostics mlDiagnostics = ModelLikeId.parseJsonFile(diagnosticsFile, MLDiagnostics.class);
                mlDiagnostics.mergeIntoWarnings(this.activity.warnContext);
                FileUtils.copyFile((File)diagnosticsFile, (File)modelEvaluation.ref.getEvaluationFile("ml_diagnostics.json"));
            }
        }
        catch (Exception exception) {
            if (evaluationStoreFolder != null) {
                logger.warn((Object)"Fail to evaluate model, cleaning up evaluation store folder");
                DKUFileUtils.forceDelete((File)evaluationStoreFolder);
            }
            throw exception;
        }
        if (this.desc.predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION && this.desc.isProbaAware && this.desc.autoOptimizeThreshold && (file = new File(evaluationStoreFolder, "perf.json")).exists()) {
            BinaryClassificationModelPerf perf = (BinaryClassificationModelPerf)JSON.parseFile((File)file, BinaryClassificationModelPerf.class);
            File evaluationFile = new File(evaluationStoreFolder, "_evaluation.json");
            TabularModelEvaluation evaluation = (TabularModelEvaluation)JSON.parseFile((File)evaluationFile, TabularModelEvaluation.class);
            evaluation.activeClassifierThreshold = perf.usedThreshold;
            JSON.prettyToFile((Object)evaluation, (File)evaluationFile);
        }
        this.activity.getTargetStatus((String)evaluationStoreLoc.getFullName()).evaluationId = modelEvaluation.ref.evaluationId;
        if (referenceDataset != null && !this.desc.treatDriftFailureAsError && !modelEvaluation.ref.hasDataEvaluationMetrics()) {
            this.activity.warnContext.addWarning(WarningsContext.WarningType.DATA_DRIFT_COMPUTATION_ERROR, "Failed to compute input data drift", logger);
        }
        this.modelEvaluationStoresService.finaliseRun(modelEvaluation);
    }

    private static /* synthetic */ boolean lambda$run$0(MemColumn column, TabularModelEvaluation.EvaluationModelInfoProba probaCol) {
        return StringUtils.equals((String)probaCol.column, (String)column.getName());
    }

    static {
        DKUMLUtils.loadClasses();
        logger = DKULogger.getLogger((String)"dku.recipes.prediction.evaluation");
    }
}

