/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TimeseriesEvaluationForecasts {
    public Map<String, EvaluationForecasts> perTimeseries = new HashMap<String, EvaluationForecasts>();

    public static TimeseriesEvaluationForecasts keepFirstTimeseries(TimeseriesEvaluationForecasts fullForecasts) {
        if (fullForecasts.perTimeseries.isEmpty()) {
            return fullForecasts;
        }
        String firstKey = fullForecasts.perTimeseries.keySet().iterator().next();
        TimeseriesEvaluationForecasts oneForecast = new TimeseriesEvaluationForecasts();
        oneForecast.perTimeseries.put(firstKey, fullForecasts.perTimeseries.get(firstKey));
        return oneForecast;
    }

    public Map<String, List<FoldDateRange>> getTimeseriesFoldsDateRange() {
        TreeMap<String, List<FoldDateRange>> perForecastRanges = new TreeMap<String, List<FoldDateRange>>();
        for (String key : this.perTimeseries.keySet()) {
            ArrayList<FoldDateRange> foldDateRanges = new ArrayList<FoldDateRange>();
            EvaluationForecasts forecasts = this.perTimeseries.get(key);
            HashSet<Integer> folds = new HashSet<Integer>(forecasts.foldId);
            for (Integer fold : folds) {
                FoldDateRange range = new FoldDateRange();
                range.foldId = Integer.valueOf(fold + 1).toString();
                int firstIndex = forecasts.foldId.indexOf(fold);
                int lastIndex = forecasts.foldId.lastIndexOf(fold);
                range.startDate = forecasts.forecastTime.get(firstIndex);
                range.endDate = forecasts.forecastTime.get(lastIndex);
                foldDateRanges.add(range);
            }
            perForecastRanges.put(key, foldDateRanges);
        }
        return perForecastRanges;
    }

    public static class EvaluationForecasts {
        public List<String> groundTruthTime;
        public List<String> forecastTime;
        public List<Double> groundTruth;
        public List<Double> forecast;
        public List<Integer> foldId;
        public List<Integer> horizonStep;
        public List<Quantile> quantiles;
        public List<String> futureTime;
        public List<Double> futureForecast;
        public List<String> futureForecastContextTime;
        public List<Double> futureForecastContext;
    }

    public static class FoldDateRange {
        public String foldId;
        public String startDate;
        public String endDate;
    }

    public static class TimeseriesScenariosForecasts {
        public Map<String, TimeseriesScenariosForecasts> perScenarios;

        public static class ScenariosForecasts {
            public List<String> groundTruthTime;
            public List<String> groundTruth;
            public List<String> forecastTime;
            public List<Double> forecast;
            public List<Quantile> quantiles;
        }
    }

    public static class Quantile {
        public double quantile;
        public List<Double> forecast;
        public List<Double> futureForecast;
    }
}

