/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.cli.PluginInstaller;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class InstallPluginCommand
extends CLICommand {
    final String commandName = "install-plugin";

    @Override
    public Options opts() {
        Options opts = new Options();
        opts.addOption("u", false, "update an already installed plugin with a new version");
        DKU.addGlobalOptions(opts);
        return opts;
    }

    @Override
    public String usageString() {
        return "install-plugin plugin.zip [options]";
    }

    @Override
    public String description() {
        return "Install a plugin packaged as a zip into DSS";
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "install-plugin", true);
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing argument");
        }
        boolean isUpdate = cmdLine.hasOption("u");
        String zipPath = cmdLine.getArgs()[1];
        PluginInstaller.installFromZip(new File(zipPath), null, isUpdate, null);
        return 0;
    }
}

