/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;

public class CodeStudioBlockRegistry {
    private static final Map<String, CodeStudioBlockMeta> library = Maps.newLinkedHashMap();

    public static CodeStudioBlockMeta getMeta(CodeStudioBlock codeStudioBlock) {
        return CodeStudioBlockRegistry.getMeta(codeStudioBlock.type);
    }

    public static synchronized CodeStudioBlockMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        throw UnavailableDSSObjectException.fromObjectTypeAndType("code_studio_block", type);
    }

    public static boolean hasMeta(CodeStudioBlock codeStudioBlock) {
        return CodeStudioBlockRegistry.hasMeta(codeStudioBlock.type);
    }

    public static synchronized boolean hasMeta(String type) {
        return library.containsKey(type);
    }

    public static synchronized Iterable<CodeStudioBlockMeta> getAllMeta() {
        return new ArrayList<CodeStudioBlockMeta>(library.values());
    }

    public static synchronized void register(CodeStudioBlockMeta meta) {
        library.put(meta.getType(), meta);
    }

    public static synchronized void deregister(String type) {
        library.remove(type);
    }
}

