/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ManualRecipesDAO
extends AbstractStandardDAO<SerializedRecipe>
implements RecipesDAO {
    Map<String, String> payloads = Maps.newHashMap();
    Map<String, SerializedRecipe> recipes = Maps.newHashMap();

    public void register(String name, SerializedRecipe sr, String data) {
        this.payloads.put(name, data);
        this.recipes.put(name, sr);
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.RECIPE.toHumanReadableString();
    }

    @Override
    public SerializedRecipe getOrNull(String projectKey, String name) throws IOException {
        return this.recipes.get(name);
    }

    @Override
    public SerializedRecipe getOrNull_noTag(String projectKey, String name, boolean unsafe) throws IOException {
        return this.recipes.get(name);
    }

    @Override
    public SerializedRecipe getMandatory(String projectKey, String name) throws IOException {
        return this.recipes.get(name);
    }

    @Override
    public String getPayloadOrNull(String projectKey, String name) throws IOException {
        return this.payloads.get(name);
    }

    @Override
    public void save(String projectKey, String name, SerializedRecipe data, String payload) throws IOException {
    }

    @Override
    public void rename(String projectKey, String oldName, String newName) throws IOException {
    }

    @Override
    public void changeType(String projectKey, String recipeName, String newType) throws IOException {
    }

    @Override
    public void delete(String projectKey, String name) throws IOException {
    }

    @Override
    public List<SerializedRecipe> list(String projectKey) throws IOException {
        return this.recipes.values().stream().filter(recipe -> projectKey.equals(recipe.projectKey)).collect(Collectors.toList());
    }

    @Override
    public List<SerializedRecipe> listUnsafe(String projectKey) throws IOException {
        return this.list(projectKey);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        return this.recipes.size();
    }

    @Override
    public boolean exists(String projectKey, String id) throws IOException {
        return this.recipes.containsKey(id);
    }

    @Override
    public List<String> listUsedNames(String projectKey) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    protected List<SerializedRecipe> list_noTag(String projectKey, boolean unsafe) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        throw new NotImplementedException();
    }
}

