/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacollections;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.UIDataCollection;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.util.AnyLoc;
import java.util.Objects;
import javax.annotation.Nullable;

public class DataCollectionDataset
extends AbstractDataCollectionItem {
    public AnyLoc reference;
    public static final String TYPE = "dataset";
    @Nullable
    public Long dataCollectionAddedOn;

    public DataCollectionDataset() {
    }

    public DataCollectionDataset(AnyLoc reference, long addedOn) {
        this.reference = reference;
        this.dataCollectionAddedOn = addedOn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataCollectionDataset)) {
            return false;
        }
        DataCollectionDataset o = (DataCollectionDataset)obj;
        return this.reference.equals(o.reference);
    }

    public int hashCode() {
        return Objects.hash(this.reference, TYPE);
    }

    @Override
    public UIDataCollection.AbstractDataCollectionItemInfo summarize(AbstractDataCollectionItem.SummarizeContext context) {
        SerializedProject project = context.projects.get(this.reference.getProjectKey());
        SerializedDataset dataset = context.datasets.get(this.reference);
        ProjectsService.ObjectVisibility visibility = context.datasetVisibility.get(this.reference);
        if (project == null || dataset == null) {
            return null;
        }
        AnyLoc loc = new AnyLoc(dataset.projectKey, dataset.name);
        switch (visibility) {
            case READ: {
                long lastBuiltOn = context.lastBuildTimes.getOrDefault(this.reference.getFullName(), -1L);
                return new UIDataCollection.DatasetInfo(dataset, project, lastBuiltOn, context.datasetQualityStatuses.get(loc), context.emptyDescriptionColumnsCount.get(loc));
            }
            case DISCOVER: {
                return new UIDataCollection.DiscoverableDatasetInfo(dataset, project, context.datasetQualityStatuses.get(loc), context.emptyDescriptionColumnsCount.get(loc));
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected dataset visibility for " + String.valueOf(this.reference) + ": " + String.valueOf((Object)visibility));
    }

    @Override
    public AbstractDataCollectionItemRef.DatasetRef getRef() {
        return new AbstractDataCollectionItemRef.DatasetRef(this.reference.getProjectKey(), this.reference.getId());
    }
}

