/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.ColumnForComputation;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureContainer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.ErrorContext;
import java.util.List;
import java.util.Map;

public class EntityQueryGenerator {
    private final Map<String, Dataset> datasetsMap;
    private final Map<String, SQLUtils.SQLTable> sqlTablesMap;
    private final Map<Integer, String> viewNameByDataset;
    private final SQLDialect dialect;
    private final Dataset targetDataset;

    public EntityQueryGenerator(Map<String, Dataset> datasetsMap, Map<String, SQLUtils.SQLTable> sqlTablesMap, SQLDialect dialect, Map<Integer, String> viewNameByDataset, Dataset targetDataset) {
        this.datasetsMap = datasetsMap;
        this.sqlTablesMap = sqlTablesMap;
        this.viewNameByDataset = viewNameByDataset;
        this.dialect = dialect;
        this.targetDataset = targetDataset;
    }

    public String generateQuery(RelationshipGraph.Node node, List<FeatureContainer> entityFeatures) {
        SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
        ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
        int nodeId = node.getId();
        String datasetName = node.getDatasetName();
        Dataset dataset = null;
        if (!this.viewNameByDataset.containsKey(nodeId)) {
            this.checkInput(datasetName);
            this.checkColumnsValidity(datasetName, node.getColumnsForComputation());
            dataset = this.datasetsMap.get(datasetName);
        }
        if (node.isRoot()) {
            for (ColumnForComputation column : node.getColumnsForComputation()) {
                col = ebf.col(column.name);
                if (dataset != null && !dataset.isManaged()) {
                    col = ExpressionUtils.getAdjustedColumn(col, column.name, dataset, this.dialect);
                }
                queryBuilder.select(col, column.name);
            }
        } else {
            for (String columnName : node.getSchemaColumnNames()) {
                col = ebf.col(columnName);
                if (dataset != null && !dataset.isManaged()) {
                    col = ExpressionUtils.getAdjustedColumn(col, columnName, dataset, this.dialect);
                }
                queryBuilder.select(col, columnName);
            }
        }
        for (FeatureContainer entityFeature : entityFeatures) {
            ExpressionBuilder inputColumn = ebf.col(entityFeature.inputColumn);
            if (dataset != null && !dataset.isManaged()) {
                inputColumn = ExpressionUtils.getAdjustedColumn(inputColumn, entityFeature.inputColumn, dataset, this.dialect);
            }
            AutoFeatureGenerationRecipePayloadParams.Feature featureToApply = entityFeature.featureToApply;
            switch (featureToApply) {
                case MONTH_OF_YEAR: 
                case DAY_OF_MONTH: 
                case YEAR: 
                case DAY_OF_WEEK: 
                case HOUR_OF_DAY: 
                case WEEK_OF_YEAR: {
                    DatePart datePart = null;
                    switch (featureToApply) {
                        case MONTH_OF_YEAR: {
                            datePart = DatePart.MONTH_OF_YEAR;
                            break;
                        }
                        case DAY_OF_MONTH: {
                            datePart = DatePart.DAY_OF_MONTH;
                            break;
                        }
                        case YEAR: {
                            datePart = DatePart.YEAR;
                            break;
                        }
                        case DAY_OF_WEEK: {
                            datePart = DatePart.DAY_OF_WEEK;
                            break;
                        }
                        case HOUR_OF_DAY: {
                            datePart = DatePart.HOUR_OF_DAY;
                            break;
                        }
                        case WEEK_OF_YEAR: {
                            datePart = DatePart.WEEK_OF_YEAR;
                        }
                    }
                    if (entityFeature.inputColumnType == Type.DATEONLY) {
                        queryBuilder.select(inputColumn.dateonlyPart(datePart.name()).castToBigint(), entityFeature.alias);
                        break;
                    }
                    if (entityFeature.inputColumnType == Type.DATETIMENOTZ) {
                        queryBuilder.select(inputColumn.datetimenotzPart(datePart.name()).castToBigint(), entityFeature.alias);
                        break;
                    }
                    queryBuilder.select(inputColumn.datePart(datePart.name()).castToBigint(), entityFeature.alias);
                    break;
                }
                case CHARACTER_COUNT: {
                    queryBuilder.select(inputColumn.length(), entityFeature.alias);
                    break;
                }
                case WORD_COUNT: {
                    ExpressionBuilder cleanedInput;
                    if (this.dialect.regexSupport() == SQLDialect.RegexSupport.NONE) {
                        cleanedInput = inputColumn.replace("   ", " ").replace("  ", " ");
                    } else {
                        String pattern = "\\s+";
                        cleanedInput = inputColumn.regexpReplace(ebf.cst(pattern), " ");
                    }
                    ExpressionBuilder inputNoSpaces = cleanedInput.replace(" ", "");
                    ExpressionBuilder lengthDifference = cleanedInput.length().minus(inputNoSpaces.length());
                    queryBuilder.select(lengthDifference.plus(1), entityFeature.alias);
                }
            }
        }
        String tableName = this.viewNameByDataset.getOrDefault(nodeId, datasetName);
        SQLUtils.SQLTable table = this.sqlTablesMap.get(tableName);
        queryBuilder.from(table, null);
        if (node.isRoot()) {
            queryBuilder = QueryGenerationUtils.applyInsertIntoCasts(queryBuilder, this.dialect, this.targetDataset);
        }
        return queryBuilder.toSQL(this.dialect);
    }

    private void checkInput(String datasetName) {
        if (!this.datasetsMap.containsKey(datasetName)) {
            throw ErrorContext.iae((String)String.format("Failed to retrieve the input dataset '%s': dataset is null", datasetName));
        }
        if (!this.sqlTablesMap.containsKey(datasetName)) {
            throw ErrorContext.iae((String)String.format("Failed to retrieve the input SQL table '%s': table is null", datasetName));
        }
    }

    private void checkColumnsValidity(String datasetName, List<ColumnForComputation> selectedColumns) {
        Schema datasetSchema = this.datasetsMap.get(datasetName).getSchema();
        if (datasetSchema == null) {
            throw ErrorContext.iae((String)String.format("The schema of the dataset '%s' is empty'.", datasetName));
        }
        for (ColumnForComputation columnForComputation : selectedColumns) {
            if (datasetSchema.hasColumn(columnForComputation.name)) continue;
            throw ErrorContext.iae((String)String.format("The selected column '%s' does not belong to the schema of the dataset '%s'.", columnForComputation.name, datasetName));
        }
    }
}

