/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.Node;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.selectionexecutors.SelectionExecutor;
import com.dataiku.dip.shaker.types.GeoPoint;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.KDTree;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.KeyDuplicateException;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.KeySizeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class KDSelectionExecutor
extends SelectionExecutor {
    private final int nJoinValues;
    private final KDTree<Node> tree;
    private final double[] lowk;
    private final double[] uppk;
    private double[] thresholds;
    private static final Logger logger = Logger.getLogger((String)"dku.recipe.fuzzyjoin.builtin.selector.KDinstance");

    public KDSelectionExecutor(List<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc> matchDescs) {
        super(matchDescs);
        this.nJoinValues = matchDescs.size();
        this.tree = new KDTree(this.nJoinValues);
        this.lowk = new double[this.nJoinValues];
        this.uppk = new double[this.nJoinValues];
    }

    @Override
    public List<Node> addJoinValues(List<String> joinValues) {
        double[] signatures = this.computeSignatures(joinValues);
        Node node = new Node();
        try {
            this.tree.insert(signatures, (Object)node);
        }
        catch (KeySizeException e) {
            logger.error((Object)"Key size of KDTree is lower than number of join values", (Throwable)e);
        }
        catch (KeyDuplicateException e) {
            try {
                node = (Node)this.tree.search(signatures);
            }
            catch (KeySizeException keySizeException) {
                logger.error((Object)keySizeException);
            }
        }
        return Collections.singletonList(node);
    }

    @Override
    public List<Node> searchValidNodes(List<String> joinValues) {
        double[] signatures = this.computeSignatures(joinValues);
        this.computeThresholds(this.matchDesc);
        for (int i = 0; i < this.nJoinValues; ++i) {
            FuzzyJoinRecipePayloadParams.FuzzyMatchDesc matchDesc = (FuzzyJoinRecipePayloadParams.FuzzyMatchDesc)this.matchDesc.get(i);
            if (matchDesc.isRelative()) {
                this.lowk[i] = matchDesc.relativeTo == 0 ? signatures[i] * (1.0 - this.thresholds[i]) : signatures[i] / (1.0 + this.thresholds[i]);
                this.uppk[i] = matchDesc.relativeTo == 0 ? signatures[i] * (1.0 + this.thresholds[i]) : signatures[i] / (1.0 - this.thresholds[i]);
                continue;
            }
            this.lowk[i] = signatures[i] - this.thresholds[i];
            this.uppk[i] = signatures[i] + this.thresholds[i];
        }
        List<Node> nodes = new ArrayList<Node>();
        try {
            nodes = this.tree.range(this.lowk, this.uppk);
        }
        catch (KeySizeException e) {
            logger.info((Object)"Key size of KDTree is lower than number of join values", (Throwable)e);
        }
        return nodes;
    }

    private void computeThresholds(List<FuzzyJoinRecipePayloadParams.FuzzyMatchDesc> matchDescs) {
        this.thresholds = new double[this.nJoinValues];
        int i = 0;
        for (FuzzyJoinRecipePayloadParams.FuzzyMatchDesc matchDesc : matchDescs) {
            this.thresholds[i] = matchDesc.distanceType == FuzzyJoinRecipePayloadParams.DistanceType.GEO ? matchDesc.threshold / 6371.0 * 57.29577951308232 : matchDesc.threshold;
            ++i;
        }
    }

    private double[] computeSignatures(List<String> joinValues) {
        double[] signatures = new double[this.nJoinValues];
        for (int i = 0; i < this.nJoinValues; ++i) {
            FuzzyJoinRecipePayloadParams.DistanceType distanceType = ((FuzzyJoinRecipePayloadParams.FuzzyMatchDesc)this.matchDesc.get((int)i)).distanceType;
            if (joinValues.get(i) == null) {
                signatures[i] = 0.0;
                continue;
            }
            if (distanceType == FuzzyJoinRecipePayloadParams.DistanceType.LEVENSHTEIN || distanceType == FuzzyJoinRecipePayloadParams.DistanceType.HAMMING) {
                signatures[i] = this.computeSignatureEdit(joinValues.get(i));
                continue;
            }
            if (distanceType == FuzzyJoinRecipePayloadParams.DistanceType.EUCLIDEAN) {
                signatures[i] = this.computeSignatureEuclidean(joinValues.get(i));
                continue;
            }
            if (distanceType == FuzzyJoinRecipePayloadParams.DistanceType.GEO) {
                signatures[i] = this.computeSignatureGeo(joinValues.get(i));
                continue;
            }
            throw new IllegalStateException("Incorrect usage of KD Tree - can only be applied to certain distance functions");
        }
        return signatures;
    }

    private double computeSignatureEdit(String joinValue) {
        return joinValue.length();
    }

    private double computeSignatureEuclidean(String joinValue) {
        try {
            return Double.parseDouble(joinValue);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private double computeSignatureGeo(String joinValue) {
        GeoPoint.Coords loc = GeoPoint.convert(joinValue);
        return loc != null ? loc.longitude : 0.0;
    }
}

