/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedStreamEngineExecutor;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeBuiltinRunner;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.grouping.H2GroupingRecipeRunner;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.recipes.GroupingRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupingRecipeRunner
extends MultiEngineRecipeRunner
implements ContainerizedDSSEngineAble {
    @Autowired
    private GroupingRecipeService service;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private GroupingRecipePayloadParams params;
    private boolean isRunningInContainer = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.group");

    public GroupingRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD: " + payload));
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.recipe.getModel());
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    protected String generateSQL(SQLDialect dialect) throws Exception {
        return this.service.generateSQL(this.activity, dialect, false, this.params, false);
    }

    @Override
    protected void initBuiltinExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine) throws Exception {
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            ContainerizedStreamEngineExecutor containerizedRunner = new ContainerizedStreamEngineExecutor(this.recipe, this.activity, containerConfig);
            containerizedRunner.init(this.activity, Output.WriteMode.APPEND);
            this.executor = containerizedRunner;
        } else if (engine.queryBased) {
            H2GroupingRecipeRunner h2Runner = new H2GroupingRecipeRunner(this.activity, this.params);
            h2Runner.init();
            this.executor = h2Runner;
        } else {
            GroupingRecipeBuiltinRunner dssRunner = new GroupingRecipeBuiltinRunner(this.activity, this.params);
            dssRunner.init();
            this.executor = dssRunner;
        }
    }
}

