/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeUtils;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.text.StringNormalizer;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JoinRecipeService {
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TransactionService transactionService;
    protected static Logger logger = Logger.getLogger((String)"dku.recipe.join");

    public List<JoinRecipePayloadParams.MatchingCondition> suggestJoinConditions(SerializedRecipe sr, String payload) throws Exception {
        Schema schema2;
        FlowRecipe fr = new FlowRecipe(sr);
        JobActivity activity = new JobActivity(this.validationService.getSampleSubgraph(fr));
        JoinRecipePayloadParams params = new JoinRecipeHelper().loadParams(payload, sr);
        JoinRecipePayloadParams.JoinDesc join = (JoinRecipePayloadParams.JoinDesc)params.joins.get(params.joins.size() - 1);
        String datasetFullName1 = ((JoinRecipePayloadParams.InputDesc)params.virtualInputs.get((int)join.table1)).name;
        String datasetFullName2 = ((JoinRecipePayloadParams.InputDesc)params.virtualInputs.get((int)join.table2)).name;
        Dataset dataset1 = ServiceUtils.getDataset(activity, this.datasetsDAO, datasetFullName1);
        Dataset dataset2 = ServiceUtils.getDataset(activity, this.datasetsDAO, datasetFullName2);
        Schema schema1 = dataset1.getSchema();
        List<JoinRecipePayloadParams.MatchingCondition> suggestions = JoinRecipeService.computeSuggestions(join, schema1, schema2 = dataset2.getSchema(), true);
        if (suggestions.isEmpty()) {
            suggestions = JoinRecipeService.computeSuggestions(join, schema1, schema2, false);
        }
        return suggestions;
    }

    private static List<JoinRecipePayloadParams.MatchingCondition> computeSuggestions(JoinRecipePayloadParams.JoinDesc join, Schema schema1, Schema schema2, boolean strictTypeEquality) {
        return JoinRecipeService.computeSuggestions(join.table1, join.table2, schema1, schema2, strictTypeEquality);
    }

    public static List<JoinRecipePayloadParams.MatchingCondition> computeSuggestions(int table1, int table2, Schema schema1, Schema schema2, boolean strictTypeEquality) {
        ArrayList<JoinRecipePayloadParams.MatchingCondition> suggestions = new ArrayList<JoinRecipePayloadParams.MatchingCondition>();
        for (SchemaColumn col1 : schema1.columns) {
            List<SchemaColumn> col = JoinRecipeService.getColumnsRegardlessOfAccents(schema2, col1.getName());
            for (SchemaColumn col2 : col) {
                if (!JoinLikeRecipeUtils.sameType(col1, col2, strictTypeEquality)) continue;
                ColumnDesc cd1 = new ColumnDesc();
                cd1.name = col1.getName();
                cd1.table = table1;
                ColumnDesc cd2 = new ColumnDesc();
                cd2.name = col2.getName();
                cd2.table = table2;
                JoinRecipePayloadParams.MatchingCondition c2 = new JoinRecipePayloadParams.MatchingCondition();
                c2.column1 = cd1;
                c2.column2 = cd2;
                c2.type = JoinRecipePayloadParams.MatchingType.EQ;
                suggestions.add(c2);
                if (suggestions.size() < 5) continue;
                break;
            }
            if (suggestions.size() < 5) continue;
            break;
        }
        return suggestions;
    }

    private static void checkPreFilterDesc(int virtualInputIndex, JoinRecipePayloadParams params, JoinLikeRecipeUtils.InputReplacementTestResult ret, Schema newSchema) throws Exception {
        FilterDesc preFilter = ((JoinRecipePayloadParams.InputDesc)params.virtualInputs.get((int)virtualInputIndex)).preFilter;
        JoinLikeRecipeUtils.checkPreFilterDescUtil(ret, newSchema, preFilter);
    }

    private static List<SchemaColumn> getColumnsRegardlessOfAccents(Schema schema, String name) {
        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        if (name != null) {
            String normalizedLookupName = StringNormalizer.normalize((String)name.toLowerCase(Locale.ENGLISH));
            for (SchemaColumn col : schema.getColumns()) {
                String normalizedColName = StringNormalizer.normalize((String)col.getName().toLowerCase(Locale.ENGLISH));
                if (!StringUtils.equals((String)normalizedColName, (String)normalizedLookupName)) continue;
                schemaColumns.add(col);
            }
        }
        return schemaColumns;
    }

    public JoinLikeRecipeUtils.InputReplacementTestResult testVirtualInputReplacement(SerializedRecipe sr, String payload, int virtualInputIndex, SerializedDataset newInput) throws Exception {
        JoinRecipePayloadParams params;
        JoinRecipeHelper helper = new JoinRecipeHelper();
        try (Transaction t = this.transactionService.beginRead();){
            JobActivity activity = new JobActivity(this.validationService.getSampleSubgraph(new FlowRecipe(sr)));
            params = helper.loadParams(payload, sr);
            helper.initInputDatasets(activity, params, false, null, false);
        }
        JoinLikeRecipeUtils.InputReplacementTestResult ret = new JoinLikeRecipeUtils.InputReplacementTestResult();
        try {
            Schema newSchema = newInput.getSchema();
            if (JoinLikeRecipeUtils.checkSchemaEmptiness(newSchema)) {
                ret.warn("Dataset schema is empty");
                return ret;
            }
            JoinLikeRecipeUtils.checkJoinColumns(virtualInputIndex, params.joins, ret, newSchema);
            JoinLikeRecipeUtils.checkSelectedColumns(virtualInputIndex, params.getSelectedColumns(), ret, newSchema);
            JoinRecipeService.checkPreFilterDesc(virtualInputIndex, params, ret, newSchema);
        }
        catch (Exception e) {
            ret.warn("Failed to complete check: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }
}

