/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifier;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifiers;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotSchemaGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.PivotRecipeService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PivotRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private PivotRecipeService service;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    private PivotRecipePayloadParams params;
    private static Logger logger = Logger.getLogger((String)"dip.recipe.pivot.schema.computer");

    public PivotRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = this.service.loadParams(payload, this.recipe);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            if (this.params.schemaComputation == PivotRecipePayloadParams.SchemaComputation.ALWAYS) {
                throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_WITH_RECIPE_CONFIG, "Pivot recipe is in 'always recompute output schema' mode");
            }
            AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
            AnyLoc outputLoc = this.recipe.getSingleOutput("main").getLoc(this.recipe.projectKey);
            Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
            Dataset outputDataset = this.datasetAccessService.getMandatory(outputLoc);
            List<String> identifiers = this.params.buildIdentifierList(inputDataset.getSchema());
            PivotElementsModalitiesSnapshot pivotElementsModalitiesStrict = PivotRecipeSchemaComputer.getPivotElementsModalitiesIfUptodate(this.params, outputDataset.getSchema());
            if (pivotElementsModalitiesStrict != null) {
                VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
                SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine);
                boolean lowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
                Schema outputSchema = new PivotSchemaGenerator(this.params).generate(inputDataset.getSchema(), identifiers, pivotElementsModalitiesStrict.pivotElementsModalities, this.params.getModalityMaxLength(dialect), lowercaseColumns);
                outputSchema.metadata = JSON.toJsonObject((Object)pivotElementsModalitiesStrict);
                ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{outputSchema});
                return arrayList;
            }
            throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_WITH_RECIPE_CONFIG, "Modality lists stored in output schema are not up-to-date");
        }
    }

    public static PivotElementsModalitiesSnapshot retrievePivotElementsModalities(PivotRecipePayloadParams params, Schema outputSchema) {
        PivotElementsModalitiesSnapshot snapshot;
        JsonObject metadata = outputSchema.metadata;
        if (metadata == null) {
            logger.info((Object)"No metadata stored in schema");
            return null;
        }
        try {
            snapshot = (PivotElementsModalitiesSnapshot)JSON.parse((JsonElement)metadata, PivotElementsModalitiesSnapshot.class);
        }
        catch (JsonSyntaxException e) {
            logger.error((Object)"Failed to read modalities from schema metadata", (Throwable)e);
            return null;
        }
        PivotElementsModalitiesSnapshot ret = new PivotElementsModalitiesSnapshot();
        ret.engineType = snapshot.engineType;
        for (PivotElement pivot : params.pivots) {
            List<PivotedModality> found = null;
            for (PivotElementsModalitiesSnapshot.PivotElementsModalities stored : snapshot.pivotElementsModalities) {
                if (!pivot.isSameKeyColumnsDefinition(stored.pivotElement)) continue;
                found = stored.pivotedModalities;
            }
            ret.pivotElementsModalities.add(new PivotElementsModalitiesSnapshot.PivotElementsModalities(pivot, found));
        }
        return ret;
    }

    public static PivotElementsModalitiesSnapshot getPivotElementsModalitiesIfUptodate(PivotRecipePayloadParams params, Schema outputSchema) {
        PivotElementsModalitiesSnapshot snapshot;
        JsonObject metadata = outputSchema.metadata;
        if (metadata == null) {
            logger.info((Object)"No metadata stored in schema");
            return null;
        }
        try {
            snapshot = (PivotElementsModalitiesSnapshot)JSON.parse((JsonElement)metadata, PivotElementsModalitiesSnapshot.class);
        }
        catch (JsonSyntaxException e) {
            logger.error((Object)"Failed to read modalities from schema metadata", (Throwable)e);
            return null;
        }
        if (snapshot.pivotElementsModalities.size() != params.pivots.size()) {
            logger.info((Object)"Metadata from schema has different pivots");
            return null;
        }
        for (int i = 0; i < params.pivots.size(); ++i) {
            PivotElement stored;
            PivotElement current = params.pivots.get(i);
            if (current.isSameKeyDefinition(stored = snapshot.pivotElementsModalities.get((int)i).pivotElement)) continue;
            logger.info((Object)("Pivot referenced in metadata is different from current pivot : " + i));
            return null;
        }
        PivotElementsModalitiesSnapshot ret = new PivotElementsModalitiesSnapshot();
        ret.engineType = snapshot.engineType;
        ModalitySlugifier modalitySlugifier = ModalitySlugifiers.getSlugifier(params.modalitySlugification);
        for (int i = 0; i < params.pivots.size(); ++i) {
            List<PivotedModality> modalities = snapshot.pivotElementsModalities.get((int)i).pivotedModalities;
            PivotElement pivotElement = params.pivots.get(i);
            ret.pivotElementsModalities.add(new PivotElementsModalitiesSnapshot.PivotElementsModalities(pivotElement, PivotRecipeSchemaComputer.updateValueColumns(pivotElement, modalities, modalitySlugifier)));
        }
        return ret;
    }

    private static List<PivotedModality> updateValueColumns(PivotElement pivotElement, List<PivotedModality> modalities, ModalitySlugifier modalitySlugifier) {
        ArrayList ret = Lists.newArrayList();
        for (PivotedModality modality : modalities) {
            ret.add(PivotedModality.fromModalities(modality.keyValues, pivotElement, modalitySlugifier));
        }
        return ret;
    }
}

