/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.dataflow.exec.split.AbstractSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class RandomBasedSplitProcessorOutput
extends AbstractSplitProcessorOutput {
    private List<RandomizedOutput> outputs = new ArrayList<RandomizedOutput>();
    private long totalRecords;
    private long currentRecords;
    private Random random;
    static Logger logger = Logger.getLogger((String)"dku.recipes.split.randombased");

    void setTargetRecords() {
        RandomizedOutput output;
        if (this.outputs.isEmpty()) {
            return;
        }
        long cumulatedRecords = 0L;
        for (int i = 0; i <= this.outputs.size() - 2; ++i) {
            output = this.outputs.get(i);
            long targetRecords = output.share > 0.0f ? (long)Math.ceil(output.share * (float)this.totalRecords / 100.0f) : 0L;
            output.targetRecords = targetRecords;
            cumulatedRecords += targetRecords;
        }
        output = this.outputs.get(this.outputs.size() - 1);
        output.targetRecords = this.totalRecords - cumulatedRecords;
    }

    private RandomizedOutput drawAndUpdateOutputs() {
        float draw = this.random.nextFloat();
        RandomizedOutput resultOutput = null;
        float cumulatedShare = 0.0f;
        for (RandomizedOutput output : this.outputs) {
            if (this.totalRecords > this.currentRecords) {
                float currentShare = (float)(output.targetRecords - output.currentRecords) / (float)(this.totalRecords - this.currentRecords);
                if (draw >= cumulatedShare && draw < cumulatedShare + currentShare) {
                    resultOutput = output;
                }
                cumulatedShare += currentShare;
            } else if (output.currentRecords < output.targetRecords) {
                resultOutput = output;
            }
            if (resultOutput == null) continue;
            break;
        }
        if (resultOutput != null) {
            ++resultOutput.currentRecords;
        }
        ++this.currentRecords;
        return resultOutput;
    }

    public RandomBasedSplitProcessorOutput(long totalRecords, SplitRecipePayloadParams params) {
        this.totalRecords = totalRecords;
        this.random = new Random(params.seed);
        this.params = params;
    }

    public void addOutput(float share, ProcessorOutput output) {
        this.outputs.add(new RandomizedOutput(share, output));
    }

    @Override
    public void setDefaultOutput(ProcessorOutput output) {
        float totalShare = 0.0f;
        for (RandomizedOutput ro : this.outputs) {
            totalShare += ro.share;
        }
        if (totalShare < 100.0f) {
            float complementaryShare = 100.0f - totalShare;
            this.addOutput(complementaryShare, output);
        }
    }

    public void emitRow(Row row) throws Exception {
        this.enrichRowWithComputedColumns(row);
        RandomizedOutput ro = this.drawAndUpdateOutputs();
        if (ro != null && ro.output != null) {
            ro.output.emitRow(row);
        }
    }

    public void cancel() throws Exception {
        for (RandomizedOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.cancel();
        }
    }

    public void setMaxMemoryUsed(long size) {
        for (RandomizedOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.setMaxMemoryUsed(size);
        }
    }

    private static class RandomizedOutput {
        public float share;
        long targetRecords;
        long currentRecords = 0L;
        public ProcessorOutput output;

        RandomizedOutput(float share, ProcessorOutput output) {
            this.share = share;
            this.output = output;
        }
    }
}

