/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.dataflow.exec.split.AbstractSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class RandomColumnBasedSplitProcessorOutput
extends AbstractSplitProcessorOutput {
    private List<RandomizedColumnOutput> outputs = new ArrayList<RandomizedColumnOutput>();
    private List<Column> columns = new ArrayList<Column>();
    static Logger logger = Logger.getLogger((String)"dku.recipes.split.randomcolumnbased");

    public RandomColumnBasedSplitProcessorOutput(SplitRecipePayloadParams params) {
        this.params = params;
    }

    public void addOutput(float share, ProcessorOutput output) {
        this.outputs.add(new RandomizedColumnOutput(share, output));
    }

    public void addColumn(Column col) {
        this.columns.add(col);
    }

    @Override
    public void setDefaultOutput(ProcessorOutput output) {
        float totalShare = 0.0f;
        for (RandomizedColumnOutput ro : this.outputs) {
            totalShare += ro.share;
        }
        if (totalShare < 100.0f) {
            float complementaryShare = 100.0f - totalShare;
            this.addOutput(complementaryShare, output);
        }
    }

    private RandomizedColumnOutput findOutputFromHashRow(Row row) {
        StringBuilder toHash = new StringBuilder();
        for (Column col : this.columns) {
            String v = row.get(col);
            if (v == null) {
                v = "__dku_null__";
            }
            toHash.append(v);
        }
        String rowHash = DigestUtils.md5Hex((String)toHash.toString());
        String rowHashLastNDigits = rowHash.substring(rowHash.length() - 4);
        RandomizedColumnOutput resultOutput = null;
        float cumulatedShare = 0.0f;
        for (RandomizedColumnOutput output : this.outputs) {
            String cumulatedShareInfHex = SplitRecipeService.shareToHexString(cumulatedShare);
            String cumulatedShareSupHex = SplitRecipeService.shareToHexString(cumulatedShare + output.share);
            if (rowHashLastNDigits.compareTo(cumulatedShareInfHex) >= 0 && rowHashLastNDigits.compareTo(cumulatedShareSupHex) < 0) {
                resultOutput = output;
                break;
            }
            cumulatedShare += output.share;
        }
        return resultOutput;
    }

    public void emitRow(Row row) throws Exception {
        this.enrichRowWithComputedColumns(row);
        RandomizedColumnOutput rco = this.findOutputFromHashRow(this.rowCopy);
        if (rco != null && rco.output != null) {
            rco.output.emitRow(row);
        }
    }

    public void cancel() throws Exception {
        for (RandomizedColumnOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.cancel();
        }
    }

    public void setMaxMemoryUsed(long size) {
        for (RandomizedColumnOutput fo : this.outputs) {
            if (fo.output == null) continue;
            fo.output.setMaxMemoryUsed(size);
        }
    }

    private static class RandomizedColumnOutput {
        public float share;
        public ProcessorOutput output;

        RandomizedColumnOutput(float share, ProcessorOutput output) {
            this.share = share;
            this.output = output;
        }
    }
}

