/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.export.execution;

import com.dataiku.dip.dataflow.export.execution.FlowEnrichedExport;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.graphicsexport.execution.AlphanumComparator;
import com.dataiku.dip.graphicsexport.execution.GraphicsExportUtils;
import com.dataiku.dip.graphicsexport.execution.PdfMerger;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlowExportPostProcessor {
    private static final int MAX_FILENAME_LENGTH = 100;
    protected final FlowEnrichedExport export;
    private final File finalDirectory;
    private final File rawExportDirectory;
    private final File postProcessDirectory;

    public FlowExportPostProcessor(FlowEnrichedExport export, File rawExportDirectory, File postProcessDirectory, File finalDirectory) {
        this.export = export;
        this.rawExportDirectory = rawExportDirectory;
        this.postProcessDirectory = postProcessDirectory;
        this.finalDirectory = finalDirectory;
    }

    public File execute() throws Exception {
        if (ExportFormat.FileType.PDF.equals((Object)this.export.format.fileType)) {
            return this.postProcessPdfs();
        }
        return this.postProcessImages();
    }

    protected String getSuffix() {
        return "-flow";
    }

    protected Pattern getFilenamePattern() {
        return Pattern.compile("Flow(_Part-(?<xIndex>\\d+)-(?<yIndex>\\d+))?\\.\\w+");
    }

    private File postProcessPdfs() throws IOException {
        ArrayList<PdfMerger.PdfSource> sourcePdfs = new ArrayList<PdfMerger.PdfSource>();
        for (File file : this.listParts(this.rawExportDirectory)) {
            sourcePdfs.add(new PdfMerger.PdfSource(file, null));
        }
        sourcePdfs.sort(new AlphanumPdfSourceComparator());
        File mergedPdfFile = FlowExportPostProcessor.newUniqueFile(this.postProcessDirectory, this.filenameForFlow(this.export.projectKey) + ".pdf");
        new PdfMerger().merge(sourcePdfs, mergedPdfFile);
        File finalFile = new File(this.finalDirectory, mergedPdfFile.getName());
        FlowExportPostProcessor.move(mergedPdfFile, finalFile);
        return finalFile;
    }

    private File postProcessImages() throws IOException {
        File finalFile;
        List<File> rawDashboardFiles = this.listParts(this.rawExportDirectory);
        if (rawDashboardFiles.size() == 1) {
            File dashboardFile = rawDashboardFiles.get(0);
            String extension = GraphicsExportUtils.getFileExtension(dashboardFile.getName());
            finalFile = new File(this.finalDirectory, this.filenameForFlow(this.export.projectKey) + extension);
            FlowExportPostProcessor.move(dashboardFile, finalFile);
        } else {
            File postProcessDashboardDirectory = FlowExportPostProcessor.createIfMissing(new File(this.postProcessDirectory, this.filenameForFlow(this.export.projectKey)));
            for (File partFile : this.listParts(this.rawExportDirectory)) {
                FlowExportPostProcessor.move(partFile, FlowExportPostProcessor.newUniqueFile(postProcessDashboardDirectory, this.fileNameForPart(partFile.getName())));
            }
            finalFile = new File(this.finalDirectory, this.filenameForFlow(this.export.projectKey) + ".zip");
            ZipUnzipDir.zipDirectory(postProcessDashboardDirectory, finalFile);
        }
        return finalFile;
    }

    protected String fileNameForPart(String originalFileName) {
        int[] partIndex = this.getPartIndex(originalFileName);
        String partNumber = partIndex == null ? "" : "_Part-" + (partIndex[1] + 1) + "-" + (partIndex[0] + 1);
        String projectName = GraphicsExportUtils.sanitize(this.export.projectKey);
        if (projectName.length() + partNumber.length() + this.getSuffix().length() > 100) {
            projectName = projectName.substring(0, 100 - partNumber.length() - this.getSuffix().length());
        }
        return projectName + this.getSuffix() + partNumber + GraphicsExportUtils.getFileExtension(originalFileName);
    }

    protected int[] getPartIndex(String fileName) {
        Matcher matcher = this.getFilenamePattern().matcher(fileName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid flow filename: " + fileName);
        }
        String xIndexStr = matcher.group("xIndex");
        String yIndexStr = matcher.group("yIndex");
        if (xIndexStr == null || yIndexStr == null) {
            return null;
        }
        return new int[]{Integer.parseInt(xIndexStr), Integer.parseInt(yIndexStr)};
    }

    private List<File> listParts(File dashboardDirectory) {
        return GraphicsExportUtils.listFiles(dashboardDirectory, (FilenameFilter)new PatternFilenameFilter(this.getFilenamePattern()));
    }

    private static File newUniqueFile(File parent, String child) {
        return GraphicsExportUtils.makeUniqueFile(new File(parent, child));
    }

    private static File createIfMissing(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Unable to create directory " + String.valueOf(directory));
        }
        return directory;
    }

    private static void move(File srcFile, File destFile) throws IOException {
        Files.move(srcFile.toPath(), destFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    protected String filenameForFlow(String projectKey) {
        String project = GraphicsExportUtils.sanitize(projectKey);
        if (project.length() + this.getSuffix().length() > 100) {
            project = project.substring(0, 100 - this.getSuffix().length());
        }
        return project + this.getSuffix();
    }

    private static class AlphanumPdfSourceComparator
    implements Comparator<PdfMerger.PdfSource> {
        private AlphanumComparator alphanumComparator = new AlphanumComparator();

        private AlphanumPdfSourceComparator() {
        }

        @Override
        public int compare(PdfMerger.PdfSource o1, PdfMerger.PdfSource o2) {
            return this.alphanumComparator.compare(o1.file.getName(), o2.file.getName());
        }
    }
}

