/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NotImplementedException;

public class GraphUtils {
    public static FlowDataset getSingleSource(FlowRecipe recipe) {
        if (recipe.getPredecessors().size() != 1) {
            throw ErrorContext.iaef((String)"Recipe %s has %d source datasets, expected 1", (Object)recipe.getName(), (Object[])new Object[]{recipe.getPredecessors().size()});
        }
        return (FlowDataset)recipe.getPredecessors().get(0);
    }

    public static FlowComputable getSingleTargetAnyComputable(FlowRecipe recipe) {
        if (recipe.getSuccessors().size() != 1) {
            throw ErrorContext.iaef((String)"Recipe %s has %d outputs, expected 1", (Object)recipe.getName(), (Object[])new Object[]{recipe.getSuccessors().size()});
        }
        return (FlowComputable)recipe.getSuccessors().get(0);
    }

    public static FlowDataset getSingleTarget(FlowRecipe recipe) {
        if (recipe.getSuccessors().size() != 1) {
            throw ErrorContext.iaef((String)"Recipe %s has %d target datasets, expected 1", (Object)recipe.getName(), (Object[])new Object[]{recipe.getSuccessors().size()});
        }
        return (FlowDataset)recipe.getSuccessors().get(0);
    }

    public static String getProjectKey(RunnableSubgraph subgraph) {
        if (subgraph instanceof RecipeRunnableSubgraph) {
            return ((RecipeRunnableSubgraph)subgraph).getRecipe().getProjectKey();
        }
        throw new NotImplementedException();
    }
}

