/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.slave;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.ProfilingDAO;
import com.dataiku.dip.dataflow.AbstractJobKernelServlet;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunner;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.Model;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.code.hive.HiveInternalRunner;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.impala.ImpalaQueryInternalRunner;
import com.dataiku.dip.recipes.code.pig.PigInternalRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryInternalRunner;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.intercom.p.PubSubIntercomController;
import com.dataiku.dip.server.intercom.t.MachineLearningIntercomController;
import com.dataiku.dip.server.intercom.t.PermissionsIntercomController;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExprDeserializer;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SQLGenerationService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUProfiler;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.hproxy.model.PingResponse;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class KernelServlet
extends AbstractJobKernelServlet {
    protected KernelSession currentSession;
    private final DKUProfiler profiler = new DKUProfiler();
    private static final long serialVersionUID = 1L;
    private final String sharedSecret;
    private static final DKULogger logger;

    public KernelServlet(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    @Override
    protected RWTransactionRef getCurrentTransactionRef() {
        return this.currentSession.getTransactionRef();
    }

    @Override
    protected void setJobContext() {
        JobContext.setJob(this.currentSession.jobProjectKey, this.currentSession.jobId, this.currentSession.job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        long startTime = System.currentTimeMillis();
        String receivedSecretKey = req.getHeader("X-DKU-IPythonSharedSecret");
        String receivedApiKey = req.getHeader("X-DKU-APITicket");
        try {
            AbstractJobKernelServlet.AuthenticationType authenticationType;
            if (this.currentSession != null && this.currentSession.authenticates(receivedApiKey)) {
                logger.info((Object)"Connects using API ticket");
                authenticationType = AbstractJobKernelServlet.AuthenticationType.API_TICKET;
            } else {
                if (!StringUtils.isNotBlank((String)receivedSecretKey) || !StringUtils.equals((String)this.sharedSecret, (String)receivedSecretKey)) throw new NotAuthenticatedException("No or bad authentication", "no-authentication");
                logger.info((Object)"Connects using Shared secret");
                authenticationType = AbstractJobKernelServlet.AuthenticationType.SHARED_SECRET;
            }
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.equals("/ping")) {
                logger.debug((Object)("Received command : " + path));
            }
            switch (path) {
                case "/tintercom/ping": 
                case "/pintercom/ping": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    PingResponse pr = new PingResponse();
                    pr.ok = true;
                    this.writeJSON(resp, pr);
                    return;
                }
                case "/pintercom/start_session": {
                    this.assertCallFromBackend(path, authenticationType);
                    assert (this.currentSession == null);
                    String bodyData = IOUtils.toString((InputStream)req.getInputStream(), (String)"utf8");
                    Model.StartSessionQuery ssq = (Model.StartSessionQuery)JSON.parse((String)bodyData, Model.StartSessionQuery.class);
                    logger.info((Object)("Start Session:\n" + JSON.json((Object)ssq)));
                    this.currentSession = new KernelSession(ssq.jobProjectKey, ssq.jobId, ssq.jobTicketSecret, ssq.initiatorAuthContext, ssq.scenarioRun, ssq.stepRun);
                    SpringUtils.getInstance().autowire((Object)this.currentSession);
                    ProfilingDAO.ProfilerSettings profilerSettings = (ProfilingDAO.ProfilerSettings)((ProfilingDAO)((Object)SpringUtils.getBean(ProfilingDAO.class))).getProfilerSettings_AutoTXN();
                    DKUProfiler.ProfilerConfiguration profilerConfiguration = new DKUProfiler.ProfilerConfiguration();
                    profilerConfiguration.directory = new File(FlowJobUtils.jobFolder(false, this.currentSession.jobProjectKey, this.currentSession.jobId), "profiles");
                    profilerConfiguration.maxSizeMB = profilerSettings.maxSizeMB;
                    profilerConfiguration.jfrConfigName = profilerSettings.jfrConfigName;
                    this.profiler.setConfiguration(profilerConfiguration);
                    this.profiler.setEnabled(profilerSettings.jobProfilingEnabled);
                    return;
                }
                case "/pintercom/resolve_job": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.assertCallFromBackend(path, authenticationType);
                    assert (this.currentSession != null);
                    Model.ResolveResponse rr = this.currentSession.resolve();
                    this.writeJSON(resp, rr);
                    return;
                }
                case "/pintercom/run_fully": {
                    this.assertCallFromBackend(path, authenticationType);
                    String bodyData = IOUtils.toString((InputStream)req.getInputStream(), (String)"utf8");
                    Model.RunFullyQuery rfq = (Model.RunFullyQuery)JSON.parse((String)bodyData, Model.RunFullyQuery.class);
                    assert (this.currentSession != null);
                    boolean success = this.currentSession.runFully(rfq.skippedActivityIds, rfq.kernelPid);
                    Model.RunFullyResponse rfr = new Model.RunFullyResponse();
                    rfr.finalStatus = this.currentSession.job.getStatus();
                    rfr.success = success;
                    for (SerializedJobActivityStatus sjas : rfr.finalStatus.activities.values()) {
                        rfr.warningCount += sjas.getWarningsTotalCount();
                    }
                    this.profiler.setEnabled(false);
                    this.writeJSON(resp, rfr);
                    return;
                }
                case "/pintercom/stop_session": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.assertCallFromBackend(path, authenticationType);
                    assert (this.currentSession != null);
                    this.currentSession.close();
                    this.currentSession = null;
                    return;
                }
                case "/pintercom/abort_session": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.assertCallFromBackend(path, authenticationType);
                    assert (this.currentSession != null);
                    logger.warn((Object)"Received abort signal");
                    this.currentSession.notifyAbort();
                    return;
                }
                case "/tintercom/job/get-def": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.verifyCallFromChild(path, authenticationType);
                    this.writeJSON(resp, this.currentSession.def);
                    return;
                }
                case "/tintercom/variables/get-resolved-for-project": {
                    this.verifyCallFromChild(path, authenticationType);
                    this.currentSession.activateScenarioVariablesInThread();
                    String typed = StringUtils.defaultIfBlank((String)req.getParameter("typed"), (String)"false");
                    this.writeJSON(resp, this.currentSession.getResolvedProjectVariables(req.getParameter("projectKey"), Boolean.parseBoolean(typed)));
                    return;
                }
                case "/tintercom/sql/execute-partial-query-recipe": {
                    this.verifyCallFromChild(path, authenticationType);
                    String activityId = req.getParameter("activityId");
                    String outputDatasetFullname = req.getParameter("outputDataset");
                    String sqlQuery = req.getParameter("query");
                    String preQueriesStr = req.getParameter("preQueries");
                    String postQueriesStr = req.getParameter("postQueries");
                    ArrayList<String> preQueries = StringUtils.isNotBlank((String)preQueriesStr) ? (List)JSON.parse((String)preQueriesStr, (TypeToken)new TypeToken<ArrayList<String>>(){}) : new ArrayList<String>();
                    ArrayList<String> postQueries = StringUtils.isNotBlank((String)postQueriesStr) ? (List)JSON.parse((String)postQueriesStr, (TypeToken)new TypeToken<ArrayList<String>>(){}) : new ArrayList<String>();
                    boolean overwriteOutputSchema = Boolean.parseBoolean(req.getParameter("overwriteOutputSchema"));
                    boolean dropPartitionedOnSchemaMismatch = Boolean.parseBoolean(req.getParameter("dropPartitionedOnSchemaMismatch"));
                    logger.infoV("Executing a partial SQL query recipe for %s (write to %s)", new Object[]{activityId, outputDatasetFullname});
                    assert (this.currentSession != null);
                    assert (this.currentSession.getTransactionRef() != null);
                    ActivityRunner arunner = this.currentSession.getJobRunner().getActivityRunner(activityId);
                    SQLQueryInternalRunner irunner = new SQLQueryInternalRunner(arunner.getActivity(), overwriteOutputSchema, dropPartitionedOnSchemaMismatch);
                    arunner.registerAdditionalRunnable(irunner);
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(outputDatasetFullname);
                    JobContext.setJob(this.currentSession.jobProjectKey, this.currentSession.jobId, this.currentSession.job);
                    JobContext.setCurrentActivityInThread(arunner.getActivity());
                    this.currentSession.activateScenarioVariablesInThread();
                    logger.infoV("Executing a partial SQL query recipe for %s (write to %s)", new Object[]{activityId, outputDatasetFullname});
                    logger.info((Object)"Starting runner");
                    RWTransaction sessionTransaction = this.currentSession.getTransactionRef();
                    TransactionContext.attach((TransactionRef)sessionTransaction);
                    try {
                        QueryBunch bunch = new QueryBunch();
                        bunch.query = sqlQuery;
                        bunch.preQueries = preQueries;
                        bunch.postQueries = postQueries;
                        irunner.execute(loc, bunch);
                        return;
                    }
                    finally {
                        TransactionContext.detach((TransactionRef)sessionTransaction);
                    }
                }
                case "/tintercom/hive/execute-partial-recipe": {
                    this.verifyCallFromChild(path, authenticationType);
                    String activityId = req.getParameter("activityId");
                    assert (this.currentSession != null);
                    assert (this.currentSession.getTransactionRef() != null);
                    ActivityRunner arunner = this.currentSession.getJobRunner().getActivityRunner(activityId);
                    JobActivity activity = arunner.getActivity();
                    String hiveQuery = req.getParameter("query");
                    boolean overwriteOutputSchema = Boolean.parseBoolean(req.getParameter("overwriteOutputSchema"));
                    boolean dropPartitionedOnSchemaMismatch = Boolean.parseBoolean(req.getParameter("dropPartitionedOnSchemaMismatch"));
                    String metastoreHandlingStr = req.getParameter("metastoreHandling");
                    HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.currentSession.getAuthCtx(), ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getProjectKey()).getHiveSettings();
                    HiveRecipeMeta.HiveExecutionEngine metastoreHandling = StringUtils.isNotBlank((String)metastoreHandlingStr) ? HiveRecipeMeta.HiveExecutionEngine.valueOf(metastoreHandlingStr) : hiveSettings.engineCreationSettings.executionEngine;
                    boolean addDkuUdf = Boolean.parseBoolean(req.getParameter("addDkuUdf"));
                    String preQueriesStr = req.getParameter("preQueries");
                    String postQueriesStr = req.getParameter("postQueries");
                    String extraHiveConfStr = req.getParameter("extraHiveConf");
                    ArrayList preQueries = StringUtils.isNotBlank((String)preQueriesStr) ? (List)JSON.parse((String)preQueriesStr, (TypeToken)new TypeToken<ArrayList<String>>(){}) : new ArrayList();
                    ArrayList postQueries = StringUtils.isNotBlank((String)postQueriesStr) ? (List)JSON.parse((String)postQueriesStr, (TypeToken)new TypeToken<ArrayList<String>>(){}) : new ArrayList();
                    HashMap extraHiveConf = StringUtils.isNotBlank((String)extraHiveConfStr) ? (Map)JSON.parse((String)req.getParameter("extraHiveConf"), (TypeToken)new TypeToken<Map<String, String>>(){}) : new HashMap();
                    StringBuilder fullHiveQuery = new StringBuilder();
                    if (preQueries != null) {
                        for (String query : preQueries) {
                            fullHiveQuery.append(query);
                            fullHiveQuery.append("\n;\n");
                        }
                    }
                    fullHiveQuery.append(hiveQuery);
                    fullHiveQuery.append("\n;\n");
                    if (postQueries != null) {
                        for (String query : postQueries) {
                            fullHiveQuery.append(query);
                            fullHiveQuery.append("\n;\n");
                        }
                    }
                    if (extraHiveConf == null) {
                        extraHiveConf = Maps.newHashMap();
                    }
                    logger.infoV("Executing a partial Hive query recipe for %s", new Object[]{activityId});
                    HiveInternalRunner irunner = new HiveInternalRunner(activity, overwriteOutputSchema, dropPartitionedOnSchemaMismatch, metastoreHandling, extraHiveConf, addDkuUdf);
                    arunner.registerAdditionalRunnable(irunner);
                    JobContext.setJob(this.currentSession.jobProjectKey, this.currentSession.jobId, this.currentSession.job);
                    JobContext.setCurrentActivityInThread(arunner.getActivity());
                    this.currentSession.activateScenarioVariablesInThread();
                    logger.info((Object)"Starting runner");
                    RWTransaction sessionTransaction = this.currentSession.getTransactionRef();
                    TransactionContext.attach((TransactionRef)sessionTransaction);
                    try {
                        irunner.execute(fullHiveQuery.toString());
                        return;
                    }
                    finally {
                        TransactionContext.detach((TransactionRef)sessionTransaction);
                    }
                }
                case "/tintercom/impala/execute-partial-query-recipe": {
                    this.verifyCallFromChild(path, authenticationType);
                    String activityId = req.getParameter("activityId");
                    String outputDatasetFullname = req.getParameter("outputDataset");
                    String sqlQuery = req.getParameter("query");
                    String useStreamMode = req.getParameter("useStreamMode");
                    String preQueriesStr = req.getParameter("preQueries");
                    String postQueriesStr = req.getParameter("postQueries");
                    ArrayList<String> preQueries = StringUtils.isNotBlank((String)preQueriesStr) ? (List)JSON.parse((String)preQueriesStr, (TypeToken)new TypeToken<ArrayList<String>>(){}) : new ArrayList<String>();
                    ArrayList<String> postQueries = StringUtils.isNotBlank((String)postQueriesStr) ? (List)JSON.parse((String)postQueriesStr, (TypeToken)new TypeToken<ArrayList<String>>(){}) : new ArrayList<String>();
                    boolean overwriteOutputSchema = Boolean.parseBoolean(req.getParameter("overwriteOutputSchema"));
                    logger.infoV("Executing a partial Impala query recipe for %s (write to %s)", new Object[]{activityId, outputDatasetFullname});
                    assert (this.currentSession != null);
                    assert (this.currentSession.getTransactionRef() != null);
                    ActivityRunner arunner = this.currentSession.getJobRunner().getActivityRunner(activityId);
                    ImpalaQueryInternalRunner irunner = new ImpalaQueryInternalRunner(arunner.getActivity(), overwriteOutputSchema);
                    arunner.registerAdditionalRunnable(irunner);
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(outputDatasetFullname);
                    JobContext.setJob(this.currentSession.jobProjectKey, this.currentSession.jobId, this.currentSession.job);
                    JobContext.setCurrentActivityInThread(arunner.getActivity());
                    this.currentSession.activateScenarioVariablesInThread();
                    logger.infoV("Executing a partial Impala query recipe for %s (write to %s)", new Object[]{activityId, outputDatasetFullname});
                    logger.info((Object)"Starting runner");
                    RWTransaction sessionTransaction = this.currentSession.getTransactionRef();
                    TransactionContext.attach((TransactionRef)sessionTransaction);
                    try {
                        irunner.execute(loc, sqlQuery, preQueries, postQueries, useStreamMode == null || Boolean.parseBoolean(useStreamMode));
                        return;
                    }
                    finally {
                        TransactionContext.detach((TransactionRef)sessionTransaction);
                    }
                }
                case "/tintercom/pig/execute-partial-recipe": {
                    this.verifyCallFromChild(path, authenticationType);
                    String activityId = req.getParameter("activityId");
                    String pigScript = req.getParameter("script");
                    boolean overwriteOutputSchema = Boolean.parseBoolean(req.getParameter("overwriteOutputSchema"));
                    logger.infoV("Executing a partial pig recipe for %s", new Object[]{activityId});
                    assert (this.currentSession != null);
                    assert (this.currentSession.getTransactionRef() != null);
                    ActivityRunner arunner = this.currentSession.getJobRunner().getActivityRunner(activityId);
                    PigInternalRunner irunner = new PigInternalRunner(arunner.getActivity(), overwriteOutputSchema);
                    arunner.registerAdditionalRunnable(irunner);
                    JobContext.setJob(this.currentSession.jobProjectKey, this.currentSession.jobId, this.currentSession.job);
                    JobContext.setCurrentActivityInThread(arunner.getActivity());
                    this.currentSession.activateScenarioVariablesInThread();
                    logger.info((Object)"Starting runner");
                    RWTransaction sessionTransaction = this.currentSession.getTransactionRef();
                    TransactionContext.attach((TransactionRef)sessionTransaction);
                    try {
                        irunner.execute(pigScript);
                        return;
                    }
                    finally {
                        TransactionContext.detach((TransactionRef)sessionTransaction);
                    }
                }
                case "/tintercom/sql-generation/expr": {
                    SQLGenerationService.SQLTranslationResult res;
                    String ast = req.getParameter("ast");
                    String dialect = req.getParameter("dialect");
                    String connection = req.getParameter("connection");
                    logger.trace((Object)("Got object to translate: " + ast));
                    QueryAst.Expr expr = (QueryAst.Expr)JSON.parse((String)ast, QueryAst.Expr.class);
                    logger.trace((Object)("Parsed AST: " + JSON.json((Object)expr)));
                    SQLGenerationService sqlGenerationService = (SQLGenerationService)SpringUtils.getBean(SQLGenerationService.class);
                    SQLDialect sqlDialect = sqlGenerationService.getDialect(dialect, connection);
                    try {
                        res = sqlGenerationService.generateSQL(expr, sqlDialect);
                        logger.info((Object)("AST successfully translated inputSize=" + ast.length() + " outputSize=" + res.sql.length() + " dialect=" + sqlDialect.getId()));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to translate AST object=" + JSON.json((Object)expr)), (Throwable)e);
                        throw e;
                    }
                    this.writeJSON(resp, res);
                    return;
                }
                case "/tintercom/ml/available-container-configurations": {
                    this.verifyCallFromChild(path, authenticationType);
                    String containerType = req.getParameter("type");
                    ContainerExecRuntimeConfig.Container container = ContainerExecRuntimeConfig.Container.valueOf(containerType);
                    List<String> configurations = this.currentSession.findAvailableContainerConfigurations(container);
                    this.writeJSON(resp, configurations);
                    return;
                }
                case "/tintercom/ml/prediction/get-max-nb-timeseries-in-forecast-charts": {
                    this.verifyCallFromChild(path, authenticationType);
                    this.writeJSON(resp, ApplicationConfigurator.getParams().getIntParam("dku.ml.timeseries.maxNbTimeseriesInForecastCharts", Integer.valueOf(1000)));
                    return;
                }
                case "/tintercom/ml/prediction/get-max-columns-to-explain": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.verifyCallFromChild(path, authenticationType);
                    this.writeJSON(resp, ApplicationConfigurator.getParams().getIntParam("dku.ml.ufi.maxColumnsToExplain", Integer.valueOf(50)));
                    return;
                }
                case "/tintercom/containers/download-local-config": {
                    this.verifyCallFromChild(path, authenticationType);
                    String executionId = req.getParameter("executionId");
                    this.getExecution(executionId);
                    this.currentSession.downloadLocalConfig(resp, executionId, req.getHeader("X-DKU-ExecutionSecretId"));
                    return;
                }
                case "/tintercom/containers/poll-aborted": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.verifyCallFromChild(path, authenticationType);
                    this.writeJSON(resp, this.currentSession.pollAborted());
                    return;
                }
                case "/tintercom/forward-pubsub-from-cde": {
                    this.verifyCallFromChild(path, authenticationType);
                    String executionId = req.getParameter("executionId");
                    String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                    this.currentSession.ensureCDEOrigin(executionId, executionSecretId);
                    String bodyData = IOUtils.toString((InputStream)req.getInputStream(), (String)"utf8");
                    PubSubIntercomController.WrappedMessage wm = (PubSubIntercomController.WrappedMessage)JSON.parse((String)bodyData, PubSubIntercomController.WrappedMessage.class);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Received a wrapped pubsub message: " + bodyData));
                    }
                    DSSEvent event = (DSSEvent)JSON.parse((JsonElement)wm.payload, Class.forName(wm.clazz).asSubclass(DSSEvent.class));
                    this.currentSession.forwardPubSubEventToBackend(event);
                    return;
                }
                case "/tintercom/permissions/check-cluster-privilege": {
                    this.verifyCallFromChild(path, authenticationType);
                    String clusterId = req.getParameter("clusterId");
                    String privilege = req.getParameter("privilege");
                    ClusterSelector.checkClusterPrivilege(this.currentSession.getAuthCtx(), clusterId, Privileges.ClusterLevelPrivilegeType.valueOf(privilege));
                    return;
                }
                case "/tintercom/permissions/has-plugin-privilege": {
                    this.verifyCallFromChild(path, authenticationType);
                    String pluginId = req.getParameter("pluginId");
                    String privilege = req.getParameter("privilege");
                    boolean ok = PluginSettingsResolver.hasPluginPrivilege(this.currentSession.getAuthCtx(), pluginId, Privileges.PluginLevelPrivilegeType.valueOf(privilege));
                    this.writeJSON(resp, new PermissionsIntercomController.PermissionCheckResult(ok));
                    return;
                }
                case "/tintercom/permissions/has-plugin-preset-privilege": {
                    this.verifyCallFromChild(path, authenticationType);
                    String pluginId = req.getParameter("pluginId");
                    String projectKey = req.getParameter("projectKey");
                    String parameterSetId = req.getParameter("parameterSetId");
                    String presetName = req.getParameter("presetName");
                    String privilege = req.getParameter("privilege");
                    boolean ok = PluginSettingsResolver.hasPluginPresetPrivilege(this.currentSession.getAuthCtx(), pluginId, projectKey, presetName, parameterSetId, Privileges.PluginPresetLevelPrivilegeType.valueOf(privilege));
                    this.writeJSON(resp, new PermissionsIntercomController.PermissionCheckResult(ok));
                    return;
                }
                case "/tintercom/permissions/has-plugin-parameter-set-privilege": {
                    this.verifyCallFromChild(path, authenticationType);
                    String pluginId = req.getParameter("pluginId");
                    String parameterSetName = req.getParameter("parameterSetName");
                    String privilege = req.getParameter("privilege");
                    boolean ok = PluginSettingsResolver.hasPluginParameterSetPrivilege(this.currentSession.getAuthCtx(), pluginId, parameterSetName, Privileges.PluginParameterSetLevelPrivilegeType.valueOf(privilege));
                    this.writeJSON(resp, new PermissionsIntercomController.PermissionCheckResult(ok));
                    return;
                }
                case "/tintercom/ml/get-model-folders-info": {
                    this.verifyCallFromChild(path, authenticationType);
                    FullModelId fmi = FullModelId.parse(req.getParameter("fmi"));
                    this.writeJSON(resp, MachineLearningIntercomController.ModelFoldersInfo.fromFullModelId(fmi));
                    return;
                }
                case "/tintercom/ml/get-model-partitions-fmis": {
                    this.verifyCallFromChild(path, authenticationType);
                    FullModelId fmi = FullModelId.parse(req.getParameter("fmi"));
                    this.writeJSON(resp, fmi.getPartitionsFmiStrings());
                    return;
                }
                case "/tintercom/ml/get-model-type-info": {
                    this.verifyCallFromChild(path, authenticationType);
                    FullModelId fmi = FullModelId.parse(req.getParameter("fmi"));
                    this.writeJSON(resp, MachineLearningIntercomController.ModelTypeInfo.fromFullModelId(fmi));
                    return;
                }
                default: {
                    this.baseCommandService(this.currentSession, path, authenticationType, req, resp);
                    return;
                }
            }
        }
        catch (AbstractJobKernelServlet.AuthenticationTypeException e) {
            resp.sendError(403);
            return;
        }
        catch (Throwable e) {
            this.sendError(resp, e);
            return;
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (!path.equals("/ping")) {
                logger.debug((Object)("Command " + path + " processed in " + (endTime - startTime) + "ms"));
            }
        }
    }

    static {
        DKUtils.forceInit(ExprDeserializer.class);
        DKUtils.forceInit(CustomMetricResult.class);
        logger = DKULogger.getLogger((String)"dku.jobs");
    }
}

