/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class RowValueAccessorFactory {
    private static final Boolean booleanMeaning = new Boolean();
    private static final LongMeaning longMeaning = new LongMeaning();
    private static final DoubleMeaning doubleMeaning = new DoubleMeaning();
    private static final Date dateMeaning = new Date();
    private static final DateOnly dateOnlyMeaning = new DateOnly();
    private static final DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();

    public static ValueReader getReader(@Nonnull SchemaColumn schemaColumn, final Column factoryColumn) {
        Type type = schemaColumn.getType();
        if (type.isNumeric() && type.isInteger()) {
            return new ValueReader(){

                @Override
                public Object read(Row row) {
                    String s = row.get(factoryColumn);
                    if (StringUtils.isBlank((String)s)) {
                        return null;
                    }
                    return longMeaning.longValue(s);
                }

                @Override
                public Class<?> resultClass() {
                    return Long.class;
                }
            };
        }
        if (type.isNumeric() && !type.isInteger()) {
            return new ValueReader(){

                @Override
                public Object read(Row row) {
                    String s = row.get(factoryColumn);
                    if (StringUtils.isBlank((String)s)) {
                        return null;
                    }
                    return doubleMeaning.doubleValue(s);
                }

                @Override
                public Class<?> resultClass() {
                    return Double.class;
                }
            };
        }
        if (type == Type.BOOLEAN) {
            return new ValueReader(){

                @Override
                public Object read(Row row) {
                    String s = row.get(factoryColumn);
                    if (StringUtils.isBlank((String)s)) {
                        return null;
                    }
                    return booleanMeaning.parse(s);
                }

                @Override
                public Class<?> resultClass() {
                    return java.lang.Boolean.class;
                }
            };
        }
        return new ValueReader(){

            @Override
            public Object read(Row row) {
                return row.get(factoryColumn);
            }

            @Override
            public Class<?> resultClass() {
                return String.class;
            }
        };
    }

    public static ValueWriter getWriter(SchemaColumn schemaColumn, final Column factoryColumn) {
        Type type = schemaColumn.getType();
        if (type.isNumeric() && type.isInteger()) {
            return new ValueWriter(){

                @Override
                public void write(Row row, Object val) {
                    row.put(factoryColumn, ((Long)val).longValue());
                }
            };
        }
        if (type.isNumeric() && !type.isInteger()) {
            return new ValueWriter(){

                @Override
                public void write(Row row, Object val) {
                    row.put(factoryColumn, ((Double)val).doubleValue());
                }
            };
        }
        if (type == Type.BOOLEAN) {
            return new ValueWriter(){

                @Override
                public void write(Row row, Object val) {
                    row.put(factoryColumn, ((java.lang.Boolean)val).booleanValue());
                }
            };
        }
        return new ValueWriter(){

            @Override
            public void write(Row row, Object val) {
                row.put(factoryColumn, (String)val);
            }
        };
    }

    public static Comparator<Object> getComparator(SchemaColumn schemaColumn, Column factoryColumn, final boolean ascending, RowsComparator.NullsOrdering nullsOrdering) {
        boolean nullsFirst = nullsOrdering == RowsComparator.NullsOrdering.AUTO || nullsOrdering == RowsComparator.NullsOrdering.NULLS_FIRST && ascending || nullsOrdering == RowsComparator.NullsOrdering.NULLS_LAST && !ascending;
        final int notNullToNull = nullsFirst ? 1 : -1;
        Type type = schemaColumn.getType();
        if (type.isNumeric() && type.isInteger()) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    int cmp;
                    boolean emptyB;
                    boolean emptyA = a == null;
                    boolean bl = emptyB = b == null;
                    if (emptyA && emptyB) {
                        cmp = 0;
                    } else if (emptyA && !emptyB) {
                        cmp = -notNullToNull;
                    } else if (!emptyA && emptyB) {
                        cmp = notNullToNull;
                    } else {
                        long lB;
                        assert (a != null);
                        assert (b != null);
                        long lA = (Long)a;
                        cmp = lA < (lB = ((Long)b).longValue()) ? -1 : (lA > lB ? 1 : 0);
                    }
                    return ascending ? cmp : -cmp;
                }
            };
        }
        if (type.isNumeric() && !type.isInteger()) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    int cmp;
                    boolean emptyB;
                    boolean emptyA = a == null;
                    boolean bl = emptyB = b == null;
                    if (emptyA && emptyB) {
                        cmp = 0;
                    } else if (emptyA && !emptyB) {
                        cmp = -notNullToNull;
                    } else if (!emptyA && emptyB) {
                        cmp = notNullToNull;
                    } else {
                        double diff;
                        assert (a != null);
                        assert (b != null);
                        double dA = (Double)a;
                        double dB = (Double)b;
                        boolean nanA = Double.isNaN(dA);
                        boolean nanB = Double.isNaN(dB);
                        cmp = nanA && nanB ? 0 : (nanA && !nanB ? -notNullToNull : (!nanA && nanB ? notNullToNull : ((diff = dA - dB) > 0.0 ? 1 : (diff < 0.0 ? -1 : 0))));
                    }
                    return ascending ? cmp : -cmp;
                }
            };
        }
        if (type == Type.BOOLEAN) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    int cmp;
                    boolean emptyB;
                    boolean emptyA = a == null;
                    boolean bl = emptyB = b == null;
                    if (emptyA && emptyB) {
                        cmp = 0;
                    } else if (emptyA && !emptyB) {
                        cmp = -notNullToNull;
                    } else if (!emptyA && emptyB) {
                        cmp = notNullToNull;
                    } else {
                        assert (a != null);
                        assert (b != null);
                        boolean bA = (java.lang.Boolean)a;
                        boolean bB = (java.lang.Boolean)b;
                        cmp = bA && bB ? 0 : (bA && !bB ? 1 : (!bA && bB ? -1 : 0));
                    }
                    return ascending ? cmp : -cmp;
                }
            };
        }
        if (type == Type.DATE) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    int cmp;
                    boolean emptyB;
                    boolean emptyA = a == null;
                    boolean bl = emptyB = b == null;
                    if (emptyA && emptyB) {
                        cmp = 0;
                    } else if (emptyA) {
                        cmp = -notNullToNull;
                    } else if (emptyB) {
                        cmp = notNullToNull;
                    } else {
                        long msseB;
                        long msseA;
                        long diff;
                        String sA = (String)a;
                        String sB = (String)b;
                        assert (sA != null);
                        assert (sB != null);
                        cmp = sA.endsWith("Z") && sB.endsWith("Z") ? sA.compareTo(sB) : ((diff = (msseA = dateMeaning.msSinceEpoch(sA)) - (msseB = dateMeaning.msSinceEpoch(sB))) > 0L ? 1 : (diff < 0L ? -1 : 0));
                    }
                    return ascending ? cmp : -cmp;
                }
            };
        }
        if (type == Type.DATEONLY) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    int cmp;
                    boolean emptyB;
                    boolean emptyA = a == null;
                    boolean bl = emptyB = b == null;
                    if (emptyA && emptyB) {
                        cmp = 0;
                    } else if (emptyA) {
                        cmp = -notNullToNull;
                    } else if (emptyB) {
                        cmp = notNullToNull;
                    } else {
                        long msseB;
                        long msseA;
                        long diff;
                        String sA = (String)a;
                        String sB = (String)b;
                        assert (sA != null);
                        assert (sB != null);
                        cmp = sA.endsWith("Z") && sB.endsWith("Z") ? sA.compareTo(sB) : ((diff = (msseA = dateOnlyMeaning.msSinceEpoch(sA)) - (msseB = dateOnlyMeaning.msSinceEpoch(sB))) > 0L ? 1 : (diff < 0L ? -1 : 0));
                    }
                    return ascending ? cmp : -cmp;
                }
            };
        }
        if (type == Type.DATETIMENOTZ) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    int cmp;
                    boolean emptyB;
                    boolean emptyA = a == null;
                    boolean bl = emptyB = b == null;
                    if (emptyA && emptyB) {
                        cmp = 0;
                    } else if (emptyA) {
                        cmp = -notNullToNull;
                    } else if (emptyB) {
                        cmp = notNullToNull;
                    } else {
                        long msseB;
                        long msseA;
                        long diff;
                        String sA = (String)a;
                        String sB = (String)b;
                        assert (sA != null);
                        assert (sB != null);
                        cmp = sA.endsWith("Z") && sB.endsWith("Z") ? sA.compareTo(sB) : ((diff = (msseA = datetimeNoTzMeaning.msSinceEpoch(sA)) - (msseB = datetimeNoTzMeaning.msSinceEpoch(sB))) > 0L ? 1 : (diff < 0L ? -1 : 0));
                    }
                    return ascending ? cmp : -cmp;
                }
            };
        }
        return new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                int cmp;
                boolean emptyB;
                boolean emptyA = a == null;
                boolean bl = emptyB = b == null;
                if (emptyA && emptyB) {
                    cmp = 0;
                } else if (emptyA && !emptyB) {
                    cmp = -notNullToNull;
                } else if (!emptyA && emptyB) {
                    cmp = notNullToNull;
                } else {
                    String sA = (String)a;
                    String sB = (String)b;
                    assert (sA != null);
                    cmp = sA.compareTo(sB);
                }
                return ascending ? cmp : -cmp;
            }
        };
    }

    public static interface ValueWriter {
        public void write(Row var1, Object var2);
    }

    public static interface ValueReader {
        public Object read(Row var1);

        public Class<?> resultClass();
    }
}

