/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.util.MurmurHash3;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dip.warnings.WithWarningsContext;

public class ColumnSamplingProcessorOutput
extends FilteringProcessorOutput
implements WithWarningsContext {
    private Column cd;
    private WarningsContext wc;
    private final int seed;
    private final String column;
    private final ColumnFactory cf;
    private final long threshold;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sampling.column");

    public ColumnSamplingProcessorOutput(ProcessorOutput downstream, ColumnFactory cf, String column, double proba, int seed) {
        super(downstream);
        this.threshold = (long)(proba * 2.147483648E9);
        this.column = column;
        this.cf = cf;
        this.seed = seed;
    }

    public void emitRow(Row row) throws Exception {
        String v;
        if (this.cd == null) {
            this.cd = this.cf.getColumn(this.column);
            if (this.cd == null) {
                if (this.wc != null) {
                    this.wc.addWarning(WarningsContext.WarningType.SAMPLING_BAD_COLUMN, "Column does not exist: " + this.column, logger);
                }
                return;
            }
        }
        if ((v = row.get(this.cd)) == null || v.isEmpty()) {
            return;
        }
        long hashValue = Math.abs(MurmurHash3.murmurhash3_x86_32(v, 0, v.length(), this.seed));
        if (hashValue < this.threshold) {
            this.downstream.emitRow(row);
        }
    }

    public void setWarningsContext(WarningsContext wc) {
        this.wc = wc;
    }
}

