/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DirectoryAwareFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.SCPDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import java.io.IOException;

public class SCPDatasetHandler
extends DirectoryAwareFSDatasetHandler<BuiltinFSDatasets.SCPDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler {
    public SCPDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, CodedException, DKUSecurityException {
        String providerPath = path == null ? ((BuiltinFSDatasets.SCPDatasetConfig)this.resolvedConfig).path : path;
        FSProvider provider = FSProviderFactory.getProvider("SCP", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    protected DSSConnection getConnection() throws IOException, DKUSecurityException {
        return ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((BuiltinFSDatasets.SCPDatasetConfig)this.resolvedConfig).connection, SSHConnection.class);
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.SCP_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new SCPDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }
}

