/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.HiveQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class PartitionedHiveQueryDatasetHandler
extends PartitionedSQLQueryDatasetHandler
implements HiveQueryDatasetHandler {
    public PartitionedHiveQueryDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
    }

    @Override
    public String getResolvedHiveSchema(boolean databaseIsMandatory) {
        String database = null;
        try {
            AbstractSQLConnection connection = this.getDSSConnection();
            if (connection instanceof MetastoreDBBasedConnection) {
                database = ((MetastoreDBBasedConnection)((Object)connection)).getDatabaseName();
            }
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException("Failed to get connection data", e);
        }
        if (databaseIsMandatory && StringUtils.isBlank((String)database)) {
            throw ErrorContext.iae((String)("Could not determine Hive database for dataset " + this.dataset.getFullName() + ", please check config"));
        }
        return database == null ? null : database.toLowerCase(Locale.ENGLISH);
    }
}

