/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.bigquery;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryJdbcConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.BigQueryUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.bigquery.BigQueryNativeClient;
import com.dataiku.dip.sql.bigquery.RetryingWriter;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableId;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class BigQuerySQLTableOutput
implements Output,
CanShareSQLConnection {
    private final AbstractSQLTableDatasetHandler handler;
    private final Partition targetPartition;
    private final WarningsContext warningsContext;
    private final Map<String, Object> dimensionValues = new HashMap<String, Object>();
    private CanShareSQLConnection.SQLConnectionShare connShare;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    public BigQuerySQLTableOutput(AbstractSQLTableDatasetHandler handler, Partition targetPartition, WarningsContext warningsContext) {
        Dataset dataset = handler.getDataset();
        assert (DatasetInspector.isBigQuery(dataset.getType()));
        if (dataset.getSchema() == null) {
            String errorPattern = "Cannot write to a BigQuerySQLTable dataset with no schema: %s";
            throw ErrorContext.iaef((String)errorPattern, (Object)dataset.getName(), (Object[])new Object[0]);
        }
        String datasetMode = handler.getResolvedAbstractConfig().mode;
        if (!"table".equals(datasetMode)) {
            String errorPattern = "Cannot write to a BigQuery dataset in '%s' mode: %s";
            throw ErrorContext.iaef((String)errorPattern, (Object)datasetMode, (Object[])new Object[]{dataset.getName()});
        }
        this.handler = handler;
        this.targetPartition = targetPartition;
        this.warningsContext = warningsContext;
        if (targetPartition != null) {
            assert (targetPartition.getScheme() == null || targetPartition.getScheme().equals((Object)dataset.getPartitioningSchema()));
            for (String dimensionName : dataset.getPartitioningSchema().getDimensionNames()) {
                DimensionValue dimensionValue = (DimensionValue)targetPartition.getDimensionValues().get(dimensionName);
                if (dimensionValue == null) {
                    this.dimensionValues.put(dimensionName, JSONObject.NULL);
                    continue;
                }
                SchemaColumn partitionColumn = dataset.getSchema().getColumn(dimensionName);
                if (partitionColumn == null) {
                    String errorPattern = "Dataset '%s' does not contain the partitioning column: %s";
                    String error = String.format(errorPattern, dataset.getName(), dimensionName);
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, error);
                }
                Type partitionColumnType = partitionColumn.getType();
                Object value = ExpressionUtils.getStringForDimensionValue(dimensionValue, partitionColumnType);
                if (partitionColumn.getType() == Type.DATETIMENOTZ && ((String)value).length() >= 19) {
                    value = ((String)value).substring(0, 10) + "T" + ((String)value).substring(11);
                }
                this.dimensionValues.put(dimensionName, this.convertValueToJSONValue((String)value, partitionColumn));
            }
        }
    }

    @Override
    public void shareSQLConnection(CanShareSQLConnection.SQLConnectionShare connShare) {
        this.connShare = connShare;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        try {
            CanShareSQLConnection.SQLConnectionShare connShareToUse = this.connShare == null ? new CanShareSQLConnection.SQLConnectionShare(this.handler.getConnectionData()) : this.connShare;
            return new BigQuerySQLTableOutputWriter(mode, connShareToUse);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private Object convertValueToJSONValue(String value, SchemaColumn column) {
        return switch (column.getType()) {
            case Type.ARRAY -> {
                if (StringUtils.isBlank((String)value)) {
                    yield new JSONArray();
                }
                yield new JSONArray(value);
            }
            case Type.MAP, Type.OBJECT -> {
                if (StringUtils.isBlank((String)value)) {
                    yield JSONObject.NULL;
                }
                yield new JSONObject(value);
            }
            default -> value == null ? JSONObject.NULL : value;
        };
    }

    private class BigQuerySQLTableOutputWriter
    extends OutputWriter {
        private final StorageTypeVerifier storageTypeVerifier = new StorageTypeVerifier();
        private final Output.WriteMode mode;
        private final CanShareSQLConnection.SQLConnectionShare connShare;
        private SQLConnectionProvider.SQLConnectionWrapper conn;
        private BigQueryNativeClient bigQueryClient;
        private RetryingWriter writer;
        private RetryingWriter.JSONArrayWorker writerWorker;
        private AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior writeJDBCBadDataBehavior;
        private StorageTypeVerifier.DataTypeMismatchBehavior dataTypeMismatchBehavior;
        private int appendBatchSize;
        private JSONArray jsonObjectBuffer;
        private long offset;
        private long numRowsEmitted;
        private long numRowsFailed;
        private long numRowsWithFailedCells;
        private List<SchemaColumn> schemaColumns;
        private List<Column> columns;

        public BigQuerySQLTableOutputWriter(Output.WriteMode mode, CanShareSQLConnection.SQLConnectionShare connShare) throws SQLException {
            this.mode = mode;
            this.connShare = connShare;
        }

        public void init(ColumnFactory columnFactory) throws Exception {
            AuthCtx authCtx = BigQuerySQLTableOutput.this.handler.getAuthCtx();
            Dataset dataset = BigQuerySQLTableOutput.this.handler.getDataset();
            Schema schema = dataset.getSchema();
            AbstractSQLDatasetHandler.AbstractSQLConfig config = BigQuerySQLTableOutput.this.handler.getResolvedAbstractConfig();
            SQLConnectionProvider.SQLConnectionData connData = this.connShare.getConnectionData();
            this.conn = this.connShare.take(authCtx, dataset.getProjectKey());
            BigQueryJdbcConnection rawConn = this.getRawConnectionIfBuiltinDriver();
            if (rawConn != null) {
                this.bigQueryClient = rawConn.getBigQueryClient();
            } else {
                BigQueryConnection bigQueryConn = (BigQueryConnection)connData.getConnection();
                this.bigQueryClient = bigQueryConn.getClient(authCtx, dataset.getProjectKey());
            }
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)config.schema), (Object)"No Schema has been specified in the dataset settings. Schema is mandatory for BigQuery and corresponds to the BigQuery's dataset ID.");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)config.table), (Object)"No table name has been specified in the dataset settings.");
            SQLDialect dialect = connData.getDialect();
            boolean dropPartitionedTableOnSchemaMismatch = false;
            if (this.mode == Output.WriteMode.OVERWRITE) {
                messages = new InfoMessage.InfoMessages();
                dialect.dropAndRecreateTableOrPartition(authCtx, connData, this.conn, dataset, BigQuerySQLTableOutput.this.targetPartition, dropPartitionedTableOnSchemaMismatch, messages);
                if (!messages.isEmpty()) {
                    BigQuerySQLTableOutput.this.warningsContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                }
            } else {
                messages = new InfoMessage.InfoMessages();
                dialect.createTableIfNeeded(authCtx, connData, this.conn, dataset, dropPartitionedTableOnSchemaMismatch, messages);
                if (!messages.isEmpty()) {
                    BigQuerySQLTableOutput.this.warningsContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                }
            }
            SQLUtils.executePreWriteStatements(connData, this.conn, dataset);
            BigQueryUtils.checkPartitioningConsistency(authCtx, connData.getConnection(), config, dataset.getPartitioningSchema());
            String project = StringUtils.defaultIfBlank((String)config.catalog, (String)this.bigQueryClient.getProjectId());
            TableId tableId = TableId.of((String)project, (String)config.schema, (String)config.table);
            this.writer = this.bigQueryClient.createRetryingWriter(tableId);
            this.writerWorker = this.writer.createJSONArrayWorker();
            this.appendBatchSize = config.writeInsertBatchSize;
            this.writeJDBCBadDataBehavior = config.writeJDBCBadDataBehavior;
            this.dataTypeMismatchBehavior = this.writeJDBCBadDataBehavior == AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.ERROR ? StorageTypeVerifier.DataTypeMismatchBehavior.ERROR : StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;
            this.jsonObjectBuffer = new JSONArray(this.appendBatchSize);
            this.numRowsWithFailedCells = 0L;
            this.numRowsFailed = 0L;
            this.numRowsEmitted = 0L;
            this.offset = 0L;
            this.schemaColumns = schema.getColumns().stream().filter(sc -> !BigQuerySQLTableOutput.this.dimensionValues.containsKey(sc.getName())).collect(Collectors.toList());
            this.columns = this.schemaColumns.stream().map(sc -> columnFactory.column(sc.getName())).collect(Collectors.toList());
        }

        public void emitRow(Row row) throws Exception {
            boolean allTypesOk = true;
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<String, Object> dimension : BigQuerySQLTableOutput.this.dimensionValues.entrySet()) {
                jsonObject.put(dimension.getKey(), dimension.getValue());
            }
            for (int i = 0; i < this.schemaColumns.size(); ++i) {
                SchemaColumn schemaColumn = this.schemaColumns.get(i);
                Column column = this.columns.get(i);
                Object value = row.get(column);
                if (!StringUtils.isBlank((String)value)) {
                    if ((value = this.storageTypeVerifier.verify((String)value, schemaColumn, this.dataTypeMismatchBehavior, BigQuerySQLTableOutput.this.warningsContext, null, true)) == null) {
                        allTypesOk = false;
                        if (this.writeJDBCBadDataBehavior == AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.DISCARD_ROW) {
                            ++this.numRowsFailed;
                            break;
                        }
                    } else {
                        value = StorageTypeVerifier.normalize((String)value, schemaColumn);
                    }
                    if (value != null && schemaColumn.getType() == Type.DATETIMENOTZ && ((String)value).length() >= 19) {
                        value = ((String)value).substring(0, 10) + "T" + ((String)value).substring(11);
                    }
                }
                jsonObject.put(schemaColumn.getName(), BigQuerySQLTableOutput.this.convertValueToJSONValue((String)value, schemaColumn));
            }
            if (allTypesOk || this.writeJDBCBadDataBehavior == AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.DISCARD_CELL) {
                this.jsonObjectBuffer.put((Object)jsonObject);
                if (this.jsonObjectBuffer.length() >= this.appendBatchSize) {
                    this.flushJSONObjectBuffer();
                }
                if (!allTypesOk) {
                    ++this.numRowsWithFailedCells;
                }
            }
            ++this.numRowsEmitted;
            if (this.numRowsEmitted % 10000L == 0L) {
                this.logStatus();
            }
        }

        public void lastRowEmitted() throws Exception {
            boolean failure = false;
            try {
                if (this.numRowsEmitted % 10000L != 0L) {
                    this.logStatus();
                }
                logger.info((Object)"Last row emitted");
                this.flushJSONObjectBuffer();
                this.writerWorker.finalizeStream();
                this.writer.commit(this.writerWorker);
                SQLConnectionProvider.SQLConnectionData connData = this.connShare.getConnectionData();
                SQLUtils.executePostWriteStatements(connData, this.conn, BigQuerySQLTableOutput.this.handler.getDataset());
                logger.info((Object)"Write stream committed");
            }
            catch (Throwable t) {
                failure = true;
                throw t;
            }
            finally {
                this.cleanup(failure);
            }
        }

        private void flushJSONObjectBuffer() throws Exception {
            if (this.jsonObjectBuffer.isEmpty()) {
                return;
            }
            this.writerWorker.append(this.jsonObjectBuffer, this.offset);
            this.offset += (long)this.jsonObjectBuffer.length();
            this.jsonObjectBuffer.clear();
        }

        private void logStatus() {
            String message = "Written rows=%d failedRows=%d rowsWithFailedCells=%d";
            logger.infoV(message, new Object[]{this.numRowsEmitted, this.numRowsFailed, this.numRowsWithFailedCells});
        }

        public void cancel() throws SQLException {
            this.cleanup(true);
            logger.info((Object)"Write stream cancelled");
        }

        private void cleanup(boolean failure) throws SQLException {
            if (this.writerWorker != null) {
                this.writerWorker.close();
            }
            if (this.conn != null) {
                if (this.getRawConnectionIfBuiltinDriver() == null && this.bigQueryClient != null) {
                    this.bigQueryClient.close();
                }
                this.connShare.give(failure);
                this.conn = null;
            }
        }

        public long writtenBytes() {
            return -1L;
        }

        private BigQueryJdbcConnection getRawConnectionIfBuiltinDriver() {
            Connection rawConn = this.conn.getConnectionUnsafe(true);
            return rawConn instanceof BigQueryJdbcConnection ? (BigQueryJdbcConnection)rawConn : null;
        }
    }
}

